/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.mail;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.mail.internal.MailFilterInformation;
import de.rcenvironment.core.mail.internal.PasswordObfuscationHelper;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.File;
import java.io.IOException;
import jodd.mail.EmailAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SMTPServerConfiguration {
    public static final String CONFIGURATION_PATH = "smtpServer";
    public static final String IMPLICIT_ENCRYPTION = "implicit";
    public static final String EXPLICIT_ENCRYPTION = "explicit";
    public static final String CONFIG_KEY_HOST = "host";
    public static final String CONFIG_KEY_PORT = "port";
    public static final String CONFIG_KEY_USERNAME = "username";
    public static final String CONFIG_KEY_PASSWORD = "password";
    public static final String CONFIG_KEY_SENDER = "sender";
    public static final String CONFIG_KEY_ENCRYPTION = "encryption";
    private static final int LARGEST_ALLOWED_PORT_NUMBER = 65535;
    private static final String EXTRAS_MAIL_FILTER = "extras" + File.separatorChar + "mail" + File.separatorChar + "filter.json";
    private static Log log = LogFactory.getLog(SMTPServerConfiguration.class);
    private String host;
    private int port;
    private String encryption;
    private String username;
    private String password;
    private EmailAddress sender;
    private MailFilterInformation filter;

    public SMTPServerConfiguration(ConfigurationSegment configurationSegment, MailFilterInformation filter) {
        if (configurationSegment != null) {
            this.host = configurationSegment.getString(CONFIG_KEY_HOST);
            this.port = configurationSegment.getInteger(CONFIG_KEY_PORT, Integer.valueOf(0));
            this.username = configurationSegment.getString(CONFIG_KEY_USERNAME);
            this.password = configurationSegment.getString(CONFIG_KEY_PASSWORD);
            this.password = PasswordObfuscationHelper.deobfuscate(this.password);
            this.encryption = configurationSegment.getString(CONFIG_KEY_ENCRYPTION);
            String senderAsString = configurationSegment.getString(CONFIG_KEY_SENDER);
            if (senderAsString != null) {
                this.sender = new EmailAddress(senderAsString);
            }
        }
        this.filter = filter;
    }

    public boolean isValid() throws ConfigurationException {
        if (this.host == null || this.host.isEmpty()) {
            throw new ConfigurationException("You need to specify the host.");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new ConfigurationException("Invalid port number.");
        }
        if (this.username == null || this.username.isEmpty()) {
            throw new ConfigurationException("You need to specify the user you want to use for authenticating.");
        }
        if (this.filter != null && this.host.matches(this.filter.getHostRegex()) && !this.username.matches(this.filter.getUsernameRegex())) {
            throw new ConfigurationException(this.filter.getErrorMessage());
        }
        if (this.password == null || this.password.isEmpty()) {
            throw new ConfigurationException("You need to specify the password you want to use for authenticating.");
        }
        if (this.sender == null || !this.sender.isValid()) {
            throw new ConfigurationException("You need to specify a valid email address as a sender address.");
        }
        if (this.encryption == null || !EXPLICIT_ENCRYPTION.equals(this.encryption) && !IMPLICIT_ENCRYPTION.equals(this.encryption)) {
            throw new ConfigurationException("You need to specify if you want to use explicit or implicit encryption.");
        }
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public EmailAddress getSender() {
        return this.sender;
    }

    public String getSenderAsString() {
        return this.sender.getInternetAddress().toString();
    }

    public static MailFilterInformation getMailFilterInformation(ConfigurationService configurationService) {
        File installationDataRoot = configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT);
        File filterFile = new File(installationDataRoot, EXTRAS_MAIL_FILTER);
        if (filterFile != null && filterFile.exists()) {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            try {
                return (MailFilterInformation)mapper.readValue(filterFile, MailFilterInformation.class);
            }
            catch (IOException e) {
                log.error((Object)"IOException while reading the MailFilterInformation from the file.", (Throwable)e);
                return null;
            }
        }
        log.debug((Object)"Cannot find a file to read the MailFilterInformation from.");
        return null;
    }
}

