Feature: UplinkTests

@Uplink01
Scenario: Simple check of uplink connection reestablished after restart of client

    Given instance "Uplink, Client1" using the default build
    And configured network connections "Client1-[upl]->Uplink [autoStart autoRetry]"
    
    And starting all instances
    And waiting for 5 seconds
    And the visible uplink network of "Client1" should consist of "Uplink"

    When scheduling an instance restart of "Client1" after 1 seconds
    And waiting for 30 seconds

    Then the visible uplink network of "Client1" should consist of "Uplink"
    And waiting for 5 seconds
    And stopping instances "Uplink, Client1"

@Uplink02
Scenario: Autoconnect after startup with uplink server started before clients
    Given instance "Uplink, Client1, Client2" using the default build
    And configured network connections "Client1-[upl]->Uplink [autoStart autoRetry], Client2-[upl]->Uplink [autoStart autoRetry]"
    
    When starting instance "Uplink"
    #And waiting for 45 seconds
    And starting instances "Client1, Client2"
    #And waiting for 45 seconds
    And adding tool "common/TestTool" to "Client1"
    And waiting for 15 seconds
    And executing command "components set-auth common/TestTool public" on "Client1"
    And waiting for 5 seconds
    
    Then the visible uplink network of "Client1" should consist of "Uplink"
    And the visible uplink network of "Client2" should consist of "Uplink"
    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping all instances
    And the log output of all instances should indicate a clean shutdown with no warnings or errors

@Uplink03
Scenario: Autoconnect after startup with clients started before uplink sever
    Given instance "Uplink, Client1, Client2" using the default build
    And configured network connections "Client1-[upl]->Uplink [autoStart autoRetry], Client2-[upl]->Uplink [autoStart autoRetry]"

    And starting instances "Client1, Client2"
    #And waiting for 45 seconds
    When starting instance "Uplink"
    And adding tool "common/TestTool" to "Client1"
    And waiting for 15 seconds
    And executing command "components set-auth common/TestTool public" on "Client1"
    And waiting for 5 seconds
    
    Then the visible uplink network of "Client1" should consist of "Uplink"
    And the visible uplink network of "Client2" should consist of "Uplink"
    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping all instances
    And the log output of all instances should indicate a clean shutdown with no warnings or errors

@Uplink04
Scenario: Autoconnect after shutdown and restart of uplink server
    Given instance "Uplink, Client1, Client2" using the default build
    And configured network connections "Client1-[upl]->Uplink [autoStart autoRetry], Client2-[upl]->Uplink [autoStart autoRetry]"

    When starting instance "Uplink"
    #And waiting for 45 seconds
    And starting instances "Client1, Client2"
    #And waiting for 45 seconds
    And adding tool "common/TestTool" to "Client1"
    And waiting for 15 seconds
    And executing command "components set-auth common/TestTool public" on "Client1"
    And waiting for 5 seconds
    
    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping instance "Uplink"
    #And waiting for 15 seconds
    
    Then  instances "Uplink" should be stopped
    And starting instance "Uplink"
    #And waiting for 45 seconds
    And the visible uplink network of "Client1" should consist of "Uplink"
    And the visible uplink network of "Client2" should consist of "Uplink"
    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping all instances
    And the log output of all instances should indicate a clean shutdown with no warnings or errors

@Uplink05
Scenario: Autoconnect after shutdown and restart of one client (which uses a tool of another client)
    Given instance "Uplink, Client1, Client2" using the default build
    And configured network connections "Client1-[upl]->Uplink [autoStart autoRetry], Client2-[upl]->Uplink [autoStart autoRetry]"

    When starting instance "Uplink"
    #And waiting for 45 seconds
    And starting instances "Client1, Client2"
    #And waiting for 45 seconds
    And adding tool "common/TestTool" to "Client1"
    And waiting for 15 seconds
    And executing command "components set-auth common/TestTool public" on "Client1"

    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping instance "Client2"
    #And waiting for 15 seconds
    
    Then  instance "Client2" should be stopped
    And starting instance "Client2"
    #And waiting for 45 seconds
    And the visible uplink network of "Client2" should consist of "Uplink"
    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping all instances
    And the log output of all instances should indicate a clean shutdown with no warnings or errors

@Uplink06
Scenario: Autoconnect after shutdown and restart of one client (which provides a tool for another client)
    Given instance "Uplink, Client1, Client2" using the default build
    And configured network connections "Client1-[upl]->Uplink [autoStart autoRetry], Client2-[upl]->Uplink [autoStart autoRetry]"

    When starting instance "Uplink"
    #And waiting for 45 seconds
    And starting instances "Client1, Client2"
    #And waiting for 45 seconds
    And adding tool "common/TestTool" to "Client1"
    And waiting for 15 seconds
    And executing command "components set-auth common/TestTool public" on "Client1"

    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping instance "Client1"
    #And waiting for 15 seconds
    
    Then  instance "Client1" should be stopped
    And starting instance "Client1"
    And waiting for 15 seconds
    And the visible uplink network of "Client1" should consist of "Uplink"
    And instance "Client2" should see these components:
        | Client1 (via userName/Client1_) | common/TestTool | local |

    And stopping all instances
    And the log output of all instances should indicate a clean shutdown with no warnings or errors

