/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.gui.utils.common.configuration.VariableNameVerifyListener;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WizardPropertyEditDialog
extends Dialog {
    private static final int COMMENT_TEXTFIELD_WIDTH = 180;
    private static final int COMMENT_TEXTFIELD_HEIGHT = 50;
    private Text keyText;
    private Text displayNameText;
    private Map<String, String> config;
    private String title;
    private Text defaultValueText;
    private Text commentText;
    private List<String> allPropertyNames;
    private String oldPropertyName;
    private List<String> allPropertyDisplayNames;
    private Object oldPropertyDisplayName;

    public WizardPropertyEditDialog(Shell parentShell, String title, Map<String, String> config, List<String> allPropertyNames, List<String> allPropertyDisplayNames) {
        super(parentShell);
        this.config = config;
        this.oldPropertyName = config.get("propertyKey");
        this.oldPropertyDisplayName = config.get("propertyDisplayName");
        this.title = title;
        this.allPropertyNames = allPropertyNames;
        this.allPropertyDisplayNames = allPropertyDisplayNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 2;
        container.setLayoutData((Object)g);
        this.createPropertySettings(container);
        this.updateInitValues();
        return container;
    }

    private void updateInitValues() {
        if (this.config.get("propertyKey") != null) {
            this.keyText.setText(this.config.get("propertyKey"));
        }
        if (this.config.get("propertyDisplayName") != null) {
            this.displayNameText.setText(this.config.get("propertyDisplayName"));
        }
        if (this.config.get("propertyDefaultValue") != null) {
            this.defaultValueText.setText(this.config.get("propertyDefaultValue"));
        }
        if (this.config.get("propertyCommentKey") != null) {
            this.commentText.setText(this.config.get("propertyCommentKey"));
        }
    }

    protected void createPropertySettings(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Composite propertyContainer = new Composite(container, 0);
        propertyContainer.setLayout((Layout)new GridLayout(3, true));
        Label keyLabel = new Label(propertyContainer, 0);
        keyLabel.setText(Messages.keyColon);
        this.keyText = new Text(propertyContainer, 2048);
        GridData textGridData = new GridData(768);
        textGridData.horizontalSpan = 2;
        this.keyText.setLayoutData((Object)textGridData);
        this.keyText.addListener(25, (Listener)new VariableNameVerifyListener(false));
        Label displayName = new Label(propertyContainer, 0);
        displayName.setText(Messages.displayNameColon);
        this.displayNameText = new Text(propertyContainer, 2048);
        GridData displayGridData = new GridData(768);
        displayGridData.horizontalSpan = 2;
        this.displayNameText.setLayoutData((Object)displayGridData);
        Label defaultValueLabel = new Label(propertyContainer, 0);
        defaultValueLabel.setText(Messages.defaultValueColon);
        this.defaultValueText = new Text(propertyContainer, 2048);
        GridData defaultValueData = new GridData(768);
        defaultValueData.horizontalSpan = 2;
        this.defaultValueText.setLayoutData((Object)defaultValueData);
        Label commentLabel = new Label(propertyContainer, 0);
        commentLabel.setText(Messages.commentColon);
        this.commentText = new Text(propertyContainer, 2562);
        GridData commentData = new GridData(768);
        commentData.horizontalSpan = 2;
        commentData.widthHint = 180;
        commentData.heightHint = 50;
        this.commentText.setLayoutData((Object)commentData);
    }

    private void saveAllConfig() {
        this.config.put("propertyKey", this.keyText.getText());
        this.config.put("propertyDisplayName", this.displayNameText.getText());
        this.config.put("propertyDefaultValue", this.defaultValueText.getText());
        this.config.put("propertyCommentKey", this.commentText.getText());
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.validateInput();
        this.installListeners();
    }

    private void installListeners() {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                WizardPropertyEditDialog.this.saveAllConfig();
                WizardPropertyEditDialog.this.validateInput();
            }
        };
        this.keyText.addModifyListener(ml);
        this.keyText.addListener(25, (Listener)new VariableNameVerifyListener(true));
        this.displayNameText.addModifyListener(ml);
        this.defaultValueText.addModifyListener(ml);
        this.commentText.addModifyListener(ml);
    }

    protected void validateInput() {
        boolean isValid = true;
        if (this.keyText.getText() == null || this.keyText.getText().isEmpty()) {
            isValid = false;
        }
        if (this.allPropertyNames != null && this.allPropertyNames.contains(this.keyText.getText()) && (this.oldPropertyName == null || !this.oldPropertyName.equals(this.keyText.getText()))) {
            isValid = false;
        }
        if (this.allPropertyDisplayNames != null && this.allPropertyDisplayNames.contains(this.displayNameText.getText()) && (this.oldPropertyDisplayName == null || !this.oldPropertyDisplayName.equals(this.displayNameText.getText()))) {
            isValid = false;
        }
        if (this.displayNameText.getText() == null || this.displayNameText.getText().isEmpty()) {
            isValid = false;
        }
        this.getButton(0).setEnabled(isValid);
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

