/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration;

import de.rcenvironment.core.component.integration.ConfigurationMapMigration;
import de.rcenvironment.core.component.integration.internal.ToolIntegrationServiceImpl;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.impl.ToolIntegrationConstants;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class ConfigurationMap {
    private final Map<String, Object> rawConfigurationMap;

    ConfigurationMap(Map<String, Object> rawConfigurationMap) {
        this.rawConfigurationMap = rawConfigurationMap;
    }

    public static ConfigurationMap fromMap(Map<String, Object> configurationMap) {
        return new ConfigurationMap(configurationMap);
    }

    public void applyMigration(ConfigurationMapMigration migration) {
        migration.migrate(this.rawConfigurationMap);
    }

    public String getToolName() {
        return (String)this.rawConfigurationMap.get("toolName");
    }

    public String getToolVersion() {
        Map<String, String> firstLaunchSettings = this.getFirstLaunchSettings();
        return firstLaunchSettings.get("version");
    }

    private Map<String, String> getFirstLaunchSettings() {
        List allLaunchSettings = (List)this.rawConfigurationMap.get("launchSettings");
        Map firstLaunchSettings = (Map)allLaunchSettings.get(0);
        return firstLaunchSettings;
    }

    public String getGroupName() {
        return (String)this.rawConfigurationMap.get("groupName");
    }

    public List<Map<String, String>> getStaticInputs() {
        return this.rawConfigurationMap.getOrDefault("inputs", new LinkedList());
    }

    public boolean containsStaticInputs() {
        return this.rawConfigurationMap.containsKey("inputs");
    }

    public boolean containsDynamicInputs() {
        return this.rawConfigurationMap.containsKey("dynamicInputs");
    }

    public List<Map<String, Object>> getDynamicInputs() {
        return (List)this.rawConfigurationMap.get("dynamicInputs");
    }

    public List<Map<String, String>> getStaticOutputs() {
        return (List)this.rawConfigurationMap.get("outputs");
    }

    public List<Map<String, Object>> getDynamicOutputs() {
        return (List)this.rawConfigurationMap.get(ToolIntegrationConstants.KEY_ENDPOINT_DYNAMIC_OUTPUTS);
    }

    public String getExecutionCountLimit() {
        Map<String, String> firstLaunchSettings = this.getFirstLaunchSettings();
        String newExecutionCountLimit = firstLaunchSettings.get("limitInstallationInstances");
        if (newExecutionCountLimit != null) {
            return newExecutionCountLimit;
        }
        return firstLaunchSettings.get("limitInstalltionInstances");
    }

    public String getMaxParallelCount() {
        return this.getFirstLaunchSettings().get("limitInstallationInstancesNumber");
    }

    public Optional<Boolean> isActive() {
        return Optional.ofNullable((Boolean)this.rawConfigurationMap.get("isActive"));
    }

    public String getIconPath() {
        return (String)this.rawConfigurationMap.get("toolIconPath");
    }

    public Long getIconModificationDate() {
        return (Long)this.rawConfigurationMap.get("iconModified");
    }

    public String getIconHash() {
        return (String)this.rawConfigurationMap.get("iconHash");
    }

    public Boolean shouldUploadIcon() {
        return (Boolean)this.rawConfigurationMap.get("uploadIcon");
    }

    public void setIconHash(String md5Hash) {
        this.rawConfigurationMap.put("iconHash", md5Hash);
    }

    public void setIconModificationDate(long lastModified) {
        this.rawConfigurationMap.put("iconModified", lastModified);
    }

    public void doNotUploadIcon() {
        this.rawConfigurationMap.remove("uploadIcon");
    }

    public void setIconPath(String path) {
        this.rawConfigurationMap.put("toolIconPath", path);
    }

    public ConfigurationDefinition generateConfiguration(ToolIntegrationServiceImpl toolIntegrationServiceImpl) {
        LinkedList<Object> configuration = new LinkedList<Object>();
        LinkedList<Object> configurationMetadata = new LinkedList<Object>();
        this.readConfigurationWithMetaDataToLists(configuration, configurationMetadata);
        Map<String, String> readOnlyConfiguration = this.createReadOnlyConfiguration();
        return ComponentConfigurationModelFactory.createConfigurationDefinition(configuration, new LinkedList(), configurationMetadata, readOnlyConfiguration);
    }

    private void readConfigurationWithMetaDataToLists(List<Object> configuration, List<Object> configurationMetadata) {
        Map properties = (Map)this.rawConfigurationMap.get("toolProperties");
        if (properties != null) {
            for (String groupKey : properties.keySet()) {
                Map group = (Map)properties.get(groupKey);
                String configFileName = null;
                if (group.get("propertyCreateConfigFile") != null && ((Boolean)group.get("propertyCreateConfigFile")).booleanValue()) {
                    configFileName = (String)group.get("propertyConfigFilename");
                }
                for (String propertyOrConfigfile : group.keySet()) {
                    int i = 0;
                    if (group.get(propertyOrConfigfile) instanceof String || group.get(propertyOrConfigfile) instanceof Boolean) continue;
                    Map property = (Map)group.get(propertyOrConfigfile);
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("key", (String)property.get("propertyKey"));
                    config.put("defaultValue", (String)property.get("propertyDefaultValue"));
                    configuration.add(config);
                    HashMap<String, String> configMetadata = new HashMap<String, String>();
                    configMetadata.put("guiName", (String)property.get("propertyDisplayName"));
                    configMetadata.put("comment", (String)property.get("propertyCommentKey"));
                    if (configFileName != null) {
                        configMetadata.put("propertyConfigFilename", configFileName);
                    }
                    configMetadata.put("guiGroupPosition", groupKey);
                    configMetadata.put("guiPosition", "" + i++);
                    configMetadata.put("key", (String)property.get("propertyKey"));
                    configurationMetadata.add(configMetadata);
                }
            }
        }
        HashMap<String, String> historyConfig = new HashMap<String, String>();
        historyConfig.put("key", "storeComponentHistoryData");
        historyConfig.put("defaultValue", "false");
        configuration.add(historyConfig);
    }

    private Map<String, String> createReadOnlyConfiguration() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (String key : this.rawConfigurationMap.keySet()) {
            Object value = this.rawConfigurationMap.get(key);
            if (value instanceof String) {
                configuration.put(key, (String)value);
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            configuration.put(key, ((Boolean)value).toString());
        }
        configuration.put("rootWorkingDirectory", this.getFirstLaunchSettings().get("rootWorkingDirectory"));
        configuration.put("toolDirectory", this.getFirstLaunchSettings().get("toolDirectory"));
        return configuration;
    }

    public boolean hasIntegrationVersion() {
        return this.rawConfigurationMap.containsKey("toolIntegrationVersion");
    }

    public void setIntegrationVersion(int currentToolintegrationVersion) {
        this.rawConfigurationMap.put("toolIntegrationVersion", 1);
    }

    public boolean containsDocFilePath() {
        return this.rawConfigurationMap.get("documentationFilePath") != null;
    }

    public String getDocFilePath() {
        return (String)this.rawConfigurationMap.get("documentationFilePath");
    }

    public void setDocFilePath(String path) {
        this.rawConfigurationMap.put("documentationFilePath", path);
    }

    public Map<String, Object> getShallowClone() {
        TreeMap<String, Object> returnValue = new TreeMap<String, Object>();
        returnValue.putAll(this.rawConfigurationMap);
        return returnValue;
    }
}

