/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log.provenance.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import de.rcenvironment.core.log.provenance.Data;
import de.rcenvironment.core.log.provenance.ExecutionLocation;
import de.rcenvironment.core.log.provenance.ExecutionScript;
import de.rcenvironment.core.log.provenance.NodeConfiguration;
import de.rcenvironment.core.log.provenance.PlaceholderAssignment;
import de.rcenvironment.core.log.provenance.ProvenanceService;
import de.rcenvironment.core.log.provenance.RunToolProcess;
import de.rcenvironment.core.log.provenance.RunWorkflowNodeProcess;
import de.rcenvironment.core.log.provenance.RunWorkflowProcess;
import de.rcenvironment.core.log.provenance.WorkflowExecutionComment;
import de.rcenvironment.core.log.provenance.WorkflowExecutionName;
import de.rcenvironment.core.log.provenance.WorkflowNode;
import de.rcenvironment.core.log.provenance.internal.ProvenanceWriter;
import de.rcenvironment.core.log.provenance.internal.RunToolTemplateInput;
import de.rcenvironment.core.log.provenance.internal.RunWorkflowNodeTemplateInput;
import de.rcenvironment.core.log.provenance.internal.RunWorkflowTemplateInput;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.ProvFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class ProvenanceServiceImpl
implements ProvenanceService {
    public static String userName = "user.name";
    private static String provenance = "provenance";

    @Activate
    public void activate() {
    }

    @Deactivate
    public void deactivate() {
    }

    @Override
    public RunWorkflowProcess onRunWorkflow(WorkflowExecutionName name, WorkflowExecutionComment comment, PlaceholderAssignment assignment, ExecutionLocation controllerLocation, ExecutionLocation ... locations) {
        RunWorkflowProcess process = new RunWorkflowProcess();
        process.setPlaceholderAssignment(assignment);
        RunWorkflowTemplateInput in = process.getTemplateInput();
        in.setEntityIDWorkflow(UUID.randomUUID().toString());
        in.setAttributeWorkflowWorkflowName(name.getName());
        in.setAttributeWorkflowWorkflowComment(comment.getComment());
        in.setBundleIDRunWorkflowBundle(UUID.randomUUID().toString());
        ArrayList<String> componentLocations = new ArrayList<String>();
        ExecutionLocation[] executionLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionLocation l = executionLocationArray[n2];
            componentLocations.add(l.getLocation());
            ++n2;
        }
        in.setEntityIDComponentLocation(componentLocations);
        ArrayList<String> placeholderAssignments = new ArrayList<String>();
        for (String value : assignment.getPlaceholderAssignment().values()) {
            placeholderAssignments.add(value);
        }
        in.setEntityIDPlaceholderAssignment(placeholderAssignments);
        ArrayList<String> nodeBundels = new ArrayList<String>();
        in.setBundleIDRunWorkflowNodeBundle(nodeBundels);
        in.setActivityIDRunWorkflow(UUID.randomUUID().toString());
        ArrayList<String> nodeRuns = new ArrayList<String>();
        in.setActivityIDRunWorkflowNode(nodeRuns);
        in.setAgentIDUser("111111111AgeentIDUser11111111111");
        in.setAttributeUserUsername(System.getProperty(userName));
        in.setAgentIDRce("222222222AgentIDRCE22222222");
        in.setAttributeRceRceVersion("10.2.1");
        return process;
    }

    @Override
    public RunWorkflowNodeProcess onRunWorkflowNode(RunWorkflowProcess startingWorkflowProcess, ExecutionLocation executionLocation, ExecutionScript executionScript, WorkflowNode node) {
        RunWorkflowNodeProcess returnValue = new RunWorkflowNodeProcess();
        String runWorkflowNodeBundleId = UUID.randomUUID().toString();
        startingWorkflowProcess.addRunWorkflowNodeBundleId(runWorkflowNodeBundleId);
        String runWorkflowNodeActivityID = "___ActivityIDInsideNodeTemplate___" + UUID.randomUUID().toString();
        startingWorkflowProcess.addRunWorkflowNodeActivityID(runWorkflowNodeActivityID);
        ProvFactory pf3 = InteropFramework.defaultFactory;
        ProvenanceWriter provenanceWriterObject = new ProvenanceWriter(pf3);
        RunWorkflowNodeTemplateInput in = new RunWorkflowNodeTemplateInput();
        in.setBundleIDRunWorkflowNodeBundle(runWorkflowNodeBundleId);
        in.setEntityIDWorkflowNode(node.getIdentifier());
        in.setEntityIDNodeConfiguration("__someconfiguration__" + UUID.randomUUID().toString());
        in.setEntityIDPreScript("someprescript" + UUID.randomUUID().toString());
        in.setEntityIDPostScript("somepostscript" + UUID.randomUUID().toString());
        in.setEntityIDExecutionScript(executionScript.getContent());
        in.setEntityIDLocation(executionLocation.getLocation());
        in.setEntityIDPlaceholderAssignment("someassignment" + UUID.randomUUID().toString());
        if (node.hasUnderlyingTool()) {
            String runToolBundleID = UUID.randomUUID().toString();
            in.setBundleIDRunToolBundle(runToolBundleID);
            returnValue.setRunToolBundleID(runToolBundleID);
        } else {
            in.setBundleIDRunToolBundle(UUID.randomUUID().toString());
        }
        in.setActivityIDRunWorkflowNode(runWorkflowNodeActivityID);
        in.setActivityIDRunTool("0011");
        in.setAgentIDUser(startingWorkflowProcess.getAgentIDUser());
        in.setAttributeUserUsername(System.getProperty(userName));
        in.setAgentIDRce(startingWorkflowProcess.getAgentIDRce());
        in.setAttributeRceRceVersion("10.2.1");
        String templatePath = Paths.get(SystemUtils.getUserHome().getAbsolutePath(), provenance, "templates", "runWorkflowNode_templateCorrected.provn").toAbsolutePath().toString();
        String targetPath = this.getRunWorkflowNodeTargetPath();
        provenanceWriterObject.writeProvenanceRunWorkflowNode(in, templatePath, targetPath);
        try {
            this.removeUnusedTemplateSnippets(targetPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public RunToolProcessBuilderImpl onRunTool(RunWorkflowNodeProcess startingNode, NodeConfiguration configuration) {
        ProvFactory pf3 = InteropFramework.defaultFactory;
        ProvenanceWriter provenanceWriterObject = new ProvenanceWriter(pf3);
        RunToolTemplateInput in = new RunToolTemplateInput();
        in.setBundleIDRunToolBundle(UUID.randomUUID().toString());
        in.setEntityIDEndpoint0("0001");
        in.setEntityIDData0("0002");
        in.setEntityIDData0("0003");
        in.setAttributeData0Type("Directory");
        in.setEntityIDData1("0004");
        in.setAttributeData1Type("Directory");
        in.setActivityIDRunTool("0005");
        in.setAgentIDUser(System.getProperty(userName));
        in.setAttributeUserUsername(System.getProperty(userName));
        in.setAgentIDTool(UUID.randomUUID().toString());
        in.setAttributeToolToolName("ToolABC");
        in.setAttributeToolToolVersion("1");
        in.setAttributeToolToolRevision("1.2");
        in.setAttributeToolToolLocation("Server123");
        in.setAgentIDRce("0008");
        in.setAttributeRceRceVersion("10.2");
        provenanceWriterObject.writeProvenanceRunTool(in, "runtTool_templateCorrectedCommented.provn", "C:\\users\\wein_al\\Desktop\\provenance\\provenanceUsingRunToolTemplate.provn");
        return null;
    }

    @Override
    public void onWorkflowFinished(RunWorkflowProcess finishedWorkflow) {
        ProvFactory pf = InteropFramework.defaultFactory;
        ProvenanceWriter provenanceWriter = new ProvenanceWriter(pf);
        RunWorkflowTemplateInput in = finishedWorkflow.getTemplateInput();
        String templatePath = Paths.get(SystemUtils.getUserHome().getAbsolutePath(), provenance, "templates", "runWorkflow_templateCorrected.provn").toAbsolutePath().toString();
        String targetPath = this.getRunWorkflowTargetPath();
        provenanceWriter.writeProvenanceRunWorkflow(in, templatePath, targetPath);
        try {
            this.removeUnusedTemplateSnippets(targetPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getRunWorkflowTargetPath() {
        return this.getTargetPath("runWorkflow");
    }

    private String getRunWorkflowNodeTargetPath() {
        return this.getTargetPath("runWorkflowNode");
    }

    private String getTargetPath(String prefix) {
        int counter = 0;
        String dir;
        String path;
        while (new File(path = String.valueOf(dir = Paths.get(SystemUtils.getUserHome().getAbsolutePath(), provenance).toString()) + File.separator + prefix + counter + ".json").exists()) {
            ++counter;
        }
        return path;
    }

    protected OutputStream getOutputStream() {
        return null;
    }

    protected InputStream getRunWorkflowTemplate() {
        return this.getClass().getResourceAsStream("runWorkflow.template");
    }

    protected InputStream getRunWorkflowNodeTemplate() {
        return this.getClass().getResourceAsStream("runWorkflowNode.template");
    }

    protected InputStream getRunToolTemplate() {
        return this.getClass().getResourceAsStream("runTool.template");
    }

    private void removeUnusedTemplateSnippets(String pathOldDirtyFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(new File(pathOldDirtyFile));
        ArrayList<String> nodesToBeDeletedLater = new ArrayList<String>();
        ProvenanceServiceImpl.deleteNodesWithWrongId(rootNode, nodesToBeDeletedLater);
        ProvenanceServiceImpl.deleteListOfNodes(rootNode, nodesToBeDeletedLater);
        ProvenanceServiceImpl.deleteEmptyNodes(rootNode);
        String cleanedJSON = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileWriter fw = new FileWriter(pathOldDirtyFile, false);){
            fw.write(cleanedJSON);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void deleteNodesWithWrongId(JsonNode node, List<String> nodesToBeDeletedLater) throws IOException {
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            JsonNode value = (JsonNode)field.getValue();
            for (String key2 : Lists.newArrayList((Iterator)value.fieldNames())) {
                if (!key2.contains("var:")) continue;
                ((ObjectNode)value).remove(key2);
            }
            for (Map.Entry field2 : Lists.newArrayList((Iterator)value.fields())) {
                JsonNode value2 = (JsonNode)field2.getValue();
                if (!(!value2.isContainerNode() & value2.asText().contains("var:"))) continue;
                nodesToBeDeletedLater.add((String)field.getKey());
            }
            if (!value.isContainerNode()) continue;
            ProvenanceServiceImpl.deleteNodesWithWrongId(value, nodesToBeDeletedLater);
        }
    }

    private static void deleteListOfNodes(JsonNode node, List<String> listOfNodeKeys) throws IOException {
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            JsonNode value = (JsonNode)field.getValue();
            for (String key2 : Lists.newArrayList((Iterator)value.fieldNames())) {
                if (!listOfNodeKeys.contains(key2)) continue;
                ((ObjectNode)value).remove(key2);
            }
            if (!value.isContainerNode()) continue;
            ProvenanceServiceImpl.deleteListOfNodes(value, listOfNodeKeys);
        }
    }

    public static void deleteEmptyNodes(JsonNode node) {
        Iterator it = node.iterator();
        while (it.hasNext()) {
            JsonNode child = (JsonNode)it.next();
            if (child.isObject() && child.isEmpty(null)) {
                it.remove();
                continue;
            }
            ProvenanceServiceImpl.deleteEmptyNodes(child);
        }
    }

    public class RunToolProcessBuilderImpl
    implements ProvenanceService.RunToolProcessBuilder {
        @Override
        public <T> ProvenanceService.RunToolProcessBuilder withInput(String inputIdentifier, Data<T> value) {
            return null;
        }

        @Override
        public <T> ProvenanceService.RunToolProcessBuilder withOutput(String outputIdentifier, Data<T> value) {
            return null;
        }

        @Override
        public RunToolProcess build() {
            return null;
        }
    }
}

