/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log.provenance;

import de.rcenvironment.core.log.provenance.Entity;
import java.io.File;
import java.util.Optional;

public final class Data<T>
implements Entity {
    private final Optional<String> displayName;
    private final T payload;

    private Data(Optional<String> displayName, T payload) {
        this.displayName = displayName;
        this.payload = payload;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.displayName.hashCode();
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (!this.displayName.equals(other.displayName)) {
            return false;
        }
        return this.payload.equals(other.payload);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.valueOf(this.getClass().getSimpleName()) + "(");
        if (this.displayName.isPresent()) {
            builder.append("displayName=\"" + this.displayName.get() + "\"");
        }
        builder.append("payload=" + this.payload + ")");
        return builder.toString();
    }

    /* synthetic */ Data(Optional optional, Object object, Data data) {
        this(optional, object);
    }

    public static class Builder {
        private String displayName;

        public Builder withDisplayName(String displayNameParam) {
            this.displayName = displayNameParam;
            return this;
        }

        public Data<String> stringData(String payload) {
            return this.buildNewInstance(payload);
        }

        public Data<Integer> intData(int payload) {
            return this.buildNewInstance(payload);
        }

        public Data<Float> floatData(float payload) {
            return this.buildNewInstance(Float.valueOf(payload));
        }

        public Data<File> fileData(File file) {
            return this.buildNewInstance(file);
        }

        public Data<File> directory(File file) {
            return this.buildNewInstance(file);
        }

        private <T> Data<T> buildNewInstance(T payload) {
            if (payload == null) {
                throw new IllegalArgumentException("payload must not be null");
            }
            return new Data(Optional.ofNullable(this.displayName), payload, null);
        }
    }
}

