/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.provenance.api.ProvenanceEventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class ProvenanceFacade {
    private final Optional<ProvenanceEventListener> service;
    private final Map<String, String> displayNamesByComponentExecutionId = new HashMap<String, String>();
    private WorkflowExecutionContext executionContext;

    ProvenanceFacade(ProvenanceEventListener service) {
        this.service = Optional.ofNullable(service);
    }

    public void onWorkflowStart(WorkflowDescription workflowDescription) {
        this.service.ifPresent(actualService -> actualService.workflowRunStarted(this.executionContext.getExecutionIdentifier(), workflowDescription.getFileName(), workflowDescription.getControllerNode().getAssociatedDisplayName(), workflowDescription.getAdditionalInformation()));
    }

    public void onWorkflowFinish() {
        this.service.ifPresent(actualService -> actualService.workflowRunFinished(this.executionContext.getExecutionIdentifier()));
    }

    public synchronized void onComponentInit(String executionId, String displayName) {
        this.displayNamesByComponentExecutionId.put(executionId, displayName.replace(' ', '_'));
    }
}

