/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.execution.api.BatchedConsoleRowsProcessor;
import de.rcenvironment.core.component.execution.api.BatchingConsoleRowsForwarder;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.internal.ConsoleRowFormatter;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionStorageBridge;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentsConsoleLogFileWriter {
    private static final int WAIT_INTERVAL_FLUSHED_AND_DISPOSED = 60;
    private static final String UNDERSCORE = "_";
    private static final String ALLOWED_CHARACTERS = "[^a-zA-Z0-9.-]";
    private final WorkflowExecutionStorageBridge wfDataManagementStorage;
    private AtomicReference<BatchingConsoleRowsForwarder> errorWorkflowConsoleRowWriter = new AtomicReference();
    private final Map<String, BatchingConsoleRowsForwarder> completeConsoleRowWriters = Collections.synchronizedMap(new HashMap());
    private final Map<String, BatchingConsoleRowsForwarder> errorConsoleRowWriters = Collections.synchronizedMap(new HashMap());
    private AtomicReference<CountDownLatch> logFilesFlushedAndDisposedLatch = new AtomicReference();

    protected ComponentsConsoleLogFileWriter(WorkflowExecutionStorageBridge wfDataManagementStorage) {
        this.wfDataManagementStorage = wfDataManagementStorage;
    }

    protected void initializeWorkflowLogFile() throws IOException {
        this.errorWorkflowConsoleRowWriter.set(new BatchingConsoleRowsForwarder((BatchedConsoleRowsProcessor)new BatchedWorkflowErrorLogFileWriter("")));
        this.logFilesFlushedAndDisposedLatch.set(new CountDownLatch(1));
    }

    protected void initializeComponentLogFile(String compExeId) throws IOException {
        this.logFilesFlushedAndDisposedLatch.set(new CountDownLatch((int)this.logFilesFlushedAndDisposedLatch.get().getCount() + 2));
        this.completeConsoleRowWriters.put(compExeId, new BatchingConsoleRowsForwarder((BatchedConsoleRowsProcessor)new ComponentCompleteLogFileWriter(compExeId)));
        this.errorConsoleRowWriters.put(compExeId, new BatchingConsoleRowsForwarder((BatchedConsoleRowsProcessor)new ComponentErrorLogFileWriter(compExeId)));
    }

    protected void addComponentConsoleRow(ConsoleRow consoleRow) {
        if (this.completeConsoleRowWriters.containsKey(consoleRow.getComponentIdentifier())) {
            this.completeConsoleRowWriters.get(consoleRow.getComponentIdentifier()).onConsoleRow(consoleRow);
        } else {
            LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Failed to add console row to component's complete log file: %s", (Object[])new Object[]{consoleRow.getPayload()}));
        }
        if (consoleRow.getType() == ConsoleRow.Type.TOOL_ERROR || consoleRow.getType() == ConsoleRow.Type.COMPONENT_ERROR || consoleRow.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT) {
            if (this.errorConsoleRowWriters.containsKey(consoleRow.getComponentIdentifier())) {
                this.errorConsoleRowWriters.get(consoleRow.getComponentIdentifier()).onConsoleRow(consoleRow);
            } else {
                LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Failed to add console row to component's error log file: %s", (Object[])new Object[]{consoleRow.getPayload()}));
            }
            this.errorWorkflowConsoleRowWriter.get().onConsoleRow(consoleRow);
        }
    }

    protected void addWorkflowConsoleRow(ConsoleRow consoleRow) {
        this.errorWorkflowConsoleRowWriter.get().onConsoleRow(consoleRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushAndDisposeLogFiles() {
        for (BatchingConsoleRowsForwarder writer : this.completeConsoleRowWriters.values()) {
            writer.onConsoleRow(null);
        }
        for (BatchingConsoleRowsForwarder writer : this.errorConsoleRowWriters.values()) {
            writer.onConsoleRow(null);
        }
        this.errorWorkflowConsoleRowWriter.get().onConsoleRow(null);
        try {
            boolean terminated;
            ComponentsConsoleLogFileWriter componentsConsoleLogFileWriter = this;
            synchronized (componentsConsoleLogFileWriter) {
                terminated = this.logFilesFlushedAndDisposedLatch.get().await(60L, TimeUnit.SECONDS);
            }
            if (!terminated) {
                LogFactory.getLog(this.getClass()).error((Object)"Time out exceeded while waiting for log files to be written");
            }
        }
        catch (InterruptedException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Failed to wait log files to be written", (Throwable)e);
        }
    }

    protected abstract class AbstractBatchedComponentLogFileWriter
    extends AbstractBatchedLogFileWriter {
        protected AbstractBatchedComponentLogFileWriter(String exeId) throws IOException {
            super(exeId);
        }

        @Override
        protected boolean isTriggerForWritingLogFileToDM(ConsoleRow consoleRow) {
            return consoleRow.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT && consoleRow.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.COMPONENT_LOG_FINISHED.name());
        }

        protected void logErrorOnWritingToDMFailure(ComponentExecutionException e, ConsoleRow consoleRow) {
            this.log.error((Object)StringUtils.format((String)"Failed to store log file in data management - workflow '%s' (%s): %s", (Object[])new Object[]{consoleRow.getWorkflowName(), consoleRow.getWorkflowIdentifier(), this.logFile.getName()}), (Throwable)e);
        }
    }

    protected abstract class AbstractBatchedLogFileWriter
    implements BatchedConsoleRowsProcessor {
        protected static final String FAILED_TO_STORE_LOG_FILE_IN_DM = "Failed to store log file in data management - workflow '%s' (%s): %s";
        private static final String FAILED_TO_CREATE_TEMPORARY_LOG_FILE = "Failed to create temporary log file: ";
        private static final String FAILED_TO_CLEAR_TEMPORARY_LOG_FILE = "Failed to clear temporary log file: ";
        private static final String FAILED_TO_DELETE_TEMPORARY_LOG_FILE = "Failed to delete temporary log file: ";
        protected final Log log = LogFactory.getLog(this.getClass());
        protected final ConsoleRowFormatter consoleRowFormatter = new ConsoleRowFormatter();
        protected File logFile;
        private volatile boolean logFileDisposed = false;
        private final TempFileService tempFileService = TempFileServiceAccess.getInstance();
        private final String exeId;

        protected AbstractBatchedLogFileWriter(String exeId) throws IOException {
            this.logFile = this.tempFileService.createTempFileFromPattern("*");
            this.exeId = exeId;
        }

        public void processConsoleRows(ConsoleRow[] consoleRows) {
            if (this.logFileDisposed) {
                this.log.debug((Object)StringUtils.format((String)"Log file '%s' already disposed; ignored %d incoming console row(s)", (Object[])new Object[]{this.logFile.getName(), consoleRows.length}));
                return;
            }
            ArrayList<String> logFileEntries = new ArrayList<String>();
            ConsoleRow[] consoleRowArray = consoleRows;
            int n = consoleRows.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleRow consoleRow = consoleRowArray[n2];
                if (consoleRow == null) {
                    if (FileUtils.sizeOf((File)this.logFile) != 0L) {
                        this.printLogFileNotEmptyError(this.logFile);
                    }
                    this.disposeLogFile();
                    return;
                }
                if (this.isTriggerForWritingLogFileToDM(consoleRow)) {
                    this.writeConsoleRowsToFile(logFileEntries);
                    if (FileUtils.sizeOf((File)this.logFile) > 0L) {
                        this.writeVersionToFile();
                        this.storeLogFileInDataManagement(consoleRow);
                        this.clearLogFile();
                        logFileEntries.clear();
                    }
                } else if (this.isMatchingConsoleRow(consoleRow)) {
                    logFileEntries.add(this.formatConsoleRow(consoleRow));
                }
                ++n2;
            }
            this.writeConsoleRowsToFile(logFileEntries);
        }

        protected abstract boolean isTriggerForWritingLogFileToDM(ConsoleRow var1);

        protected boolean isMatchingConsoleRow(ConsoleRow consoleRow) {
            return consoleRow.getType() != ConsoleRow.Type.LIFE_CYCLE_EVENT;
        }

        protected abstract String formatConsoleRow(ConsoleRow var1);

        protected abstract String getFileFormatVersion();

        private void printLogFileNotEmptyError(File file) {
            String fileContent = "[not available]";
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream inputStream = new FileInputStream(this.logFile);){
                    fileContent = IOUtils.toString((InputStream)inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.debug((Object)StringUtils.format((String)"Failed to get content of log file %s; cause: &s", (Object[])new Object[]{this.logFile.getAbsolutePath(), e.toString()}));
            }
            this.log.error((Object)StringUtils.format((String)"Request to dispose non-empty log file (related to %s), means that the content get lost as it it was not stored to the data management before; file: %s; size: %d, content: %s", (Object[])new Object[]{this.exeId, file.getAbsolutePath(), FileUtils.sizeOf((File)file), fileContent}));
        }

        private void writeConsoleRowsToFile(List<String> logFileEntries) {
            try {
                FileUtils.writeLines((File)this.logFile, logFileEntries, (boolean)true);
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to add a console log row to the log file: " + this.logFile), (Throwable)e);
            }
        }

        private void writeVersionToFile() {
            try {
                FileUtils.writeStringToFile((File)this.logFile, (String)StringUtils.format((String)"[Log file format version: %s]\n", (Object[])new Object[]{this.getFileFormatVersion()}), (boolean)true);
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to add a console log row to the log file: " + this.logFile), (Throwable)e);
            }
        }

        private void disposeLogFile() {
            try {
                this.tempFileService.disposeManagedTempDirOrFile(this.logFile);
            }
            catch (IOException e) {
                this.log.error((Object)(FAILED_TO_DELETE_TEMPORARY_LOG_FILE + this.logFile.getAbsolutePath()), (Throwable)e);
            }
            this.logFileDisposed = true;
            ((CountDownLatch)ComponentsConsoleLogFileWriter.this.logFilesFlushedAndDisposedLatch.get()).countDown();
        }

        protected abstract void storeLogFileInDataManagement(ConsoleRow var1);

        private void clearLogFile() {
            block13: {
                try {
                    FileUtils.writeStringToFile((File)this.logFile, (String)"", (boolean)false);
                }
                catch (IOException e) {
                    this.log.error((Object)(FAILED_TO_CLEAR_TEMPORARY_LOG_FILE + this.logFile.getAbsolutePath()), (Throwable)e);
                    try {
                        try {
                            this.tempFileService.disposeManagedTempDirOrFile(this.logFile);
                        }
                        catch (IOException iOException) {
                            this.log.error((Object)(FAILED_TO_DELETE_TEMPORARY_LOG_FILE + this.logFile.getAbsolutePath()), (Throwable)e);
                            try {
                                this.logFile = this.tempFileService.createTempFileFromPattern("*");
                            }
                            catch (IOException iOException2) {
                                this.log.error((Object)(FAILED_TO_CREATE_TEMPORARY_LOG_FILE + this.logFile.getAbsolutePath()), (Throwable)e);
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.logFile = this.tempFileService.createTempFileFromPattern("*");
                        }
                        catch (IOException iOException) {
                            this.log.error((Object)(FAILED_TO_CREATE_TEMPORARY_LOG_FILE + this.logFile.getAbsolutePath()), (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        this.logFile = this.tempFileService.createTempFileFromPattern("*");
                    }
                    catch (IOException iOException) {
                        this.log.error((Object)(FAILED_TO_CREATE_TEMPORARY_LOG_FILE + this.logFile.getAbsolutePath()), (Throwable)e);
                    }
                }
            }
        }
    }

    protected class BatchedWorkflowErrorLogFileWriter
    extends AbstractBatchedLogFileWriter {
        private static final String VERSION = "1.1";

        protected BatchedWorkflowErrorLogFileWriter(String exeId) throws IOException {
            super(exeId);
        }

        @Override
        protected void storeLogFileInDataManagement(ConsoleRow triggerConsoleRow) {
            try {
                String logFileName = StringUtils.format((String)"%s-err.log", (Object[])new Object[]{triggerConsoleRow.getWorkflowName().replaceAll(ComponentsConsoleLogFileWriter.ALLOWED_CHARACTERS, ComponentsConsoleLogFileWriter.UNDERSCORE)});
                ComponentsConsoleLogFileWriter.this.wfDataManagementStorage.addWorkflowErrorLog(this.logFile, logFileName);
            }
            catch (WorkflowExecutionException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to store log file in data management - workflow '%s' (%s): %s", (Object[])new Object[]{triggerConsoleRow.getWorkflowName(), triggerConsoleRow.getWorkflowIdentifier(), this.logFile.getName()}), (Throwable)e);
            }
        }

        @Override
        protected boolean isTriggerForWritingLogFileToDM(ConsoleRow consoleRow) {
            return consoleRow.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT && consoleRow.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.WORKFLOW_LOG_FINISHED.name());
        }

        @Override
        protected String formatConsoleRow(ConsoleRow consoleRow) {
            return this.consoleRowFormatter.toWorkflowErrorLogFileFormat(consoleRow);
        }

        @Override
        protected String getFileFormatVersion() {
            return VERSION;
        }
    }

    protected class ComponentCompleteLogFileWriter
    extends AbstractBatchedComponentLogFileWriter {
        private static final String VERSION = "1.0";

        protected ComponentCompleteLogFileWriter(String exeId) throws IOException {
            super(exeId);
        }

        @Override
        protected void storeLogFileInDataManagement(ConsoleRow triggerConsoleRow) {
            try {
                String[] payload = StringUtils.splitAndUnescape((String)triggerConsoleRow.getPayload());
                String logFileName = StringUtils.format((String)"%s-%s_compl.log", (Object[])new Object[]{triggerConsoleRow.getComponentName().replaceAll(ComponentsConsoleLogFileWriter.ALLOWED_CHARACTERS, ComponentsConsoleLogFileWriter.UNDERSCORE), payload[2]});
                ComponentsConsoleLogFileWriter.this.wfDataManagementStorage.addComponentCompleteLog(this.logFile, logFileName, payload[1]);
            }
            catch (ComponentExecutionException e) {
                this.logErrorOnWritingToDMFailure(e, triggerConsoleRow);
            }
        }

        @Override
        protected String formatConsoleRow(ConsoleRow consoleRow) {
            return this.consoleRowFormatter.toComponentCompleteLogFileFormat(consoleRow);
        }

        @Override
        protected String getFileFormatVersion() {
            return VERSION;
        }
    }

    protected class ComponentErrorLogFileWriter
    extends AbstractBatchedComponentLogFileWriter {
        private static final String VERSION = "1.0";

        protected ComponentErrorLogFileWriter(String exeId) throws IOException {
            super(exeId);
        }

        @Override
        protected void storeLogFileInDataManagement(ConsoleRow triggerConsoleRow) {
            try {
                String[] payload = StringUtils.splitAndUnescape((String)triggerConsoleRow.getPayload());
                String logFileName = StringUtils.format((String)"%s-%s_err.log", (Object[])new Object[]{triggerConsoleRow.getComponentName().replaceAll(ComponentsConsoleLogFileWriter.ALLOWED_CHARACTERS, ComponentsConsoleLogFileWriter.UNDERSCORE), payload[2]});
                ComponentsConsoleLogFileWriter.this.wfDataManagementStorage.addComponentErrorLog(this.logFile, logFileName, payload[1]);
            }
            catch (ComponentExecutionException e) {
                this.logErrorOnWritingToDMFailure(e, triggerConsoleRow);
            }
        }

        @Override
        protected String formatConsoleRow(ConsoleRow consoleRow) {
            return this.consoleRowFormatter.toComponentErrorLogFileFormat(consoleRow);
        }

        @Override
        protected String getFileFormatVersion() {
            return VERSION;
        }
    }
}

