/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.EndpointDatumDispatchService;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipient;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDatumImpl;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.provenance.api.ProvenanceEventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypedDatumToOutputWriter {
    private static final Log LOG = LogFactory.getLog(TypedDatumToOutputWriter.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled(TypedDatumToOutputWriter.class);
    private static EndpointDatumDispatchService endpointDatumDispatcher;
    private ComponentExecutionContext compExeCtx;

    @Deprecated
    public TypedDatumToOutputWriter() {
    }

    protected TypedDatumToOutputWriter(ComponentExecutionRelatedInstances compExeRelatedInstances) {
        this.compExeCtx = compExeRelatedInstances.compExeCtx;
    }

    protected void writeTypedDatumToOutput(String outputName, TypedDatum datumToSend) {
        this.writeTypedDatumToOutput(outputName, datumToSend, null);
    }

    protected void writeTypedDatumToOutput(String outputName, TypedDatum datumToSend, Long outputDmId) {
        this.writeTypedDatumToCertainConnectedOutputs(outputName, datumToSend, null, null, outputDmId);
    }

    protected void writeTypedDatumToOutputConsideringOnlyCertainInputs(String outputName, TypedDatum datumToSend, String inputCompExeId, String inputName) {
        this.writeTypedDatumToCertainConnectedOutputs(outputName, datumToSend, inputCompExeId, inputName, null);
    }

    private void writeTypedDatumToCertainConnectedOutputs(String outputName, TypedDatum datumToSend, String inputCompExeId, String inputName, Long outputDmId) {
        Map<String, List<EndpointDatumRecipient>> endpointDatumRecipients = this.compExeCtx.getEndpointDatumRecipients();
        for (EndpointDatumRecipient epRecipient : (List)endpointDatumRecipients.getOrDefault(outputName, new LinkedList())) {
            ProvenanceEventListener provenanceService = (ProvenanceEventListener)ServiceRegistry.createAccessFor((Object)this).getService(ProvenanceEventListener.class);
            if (provenanceService != null) {
                provenanceService.datumForwarded(this.compExeCtx.getExecutionIdentifier(), outputName, epRecipient.getInputsComponentExecutionIdentifier(), epRecipient.getInputName(), datumToSend);
            }
            if (!this.considerRecipient(epRecipient, inputCompExeId, inputName)) continue;
            EndpointDatumImpl endpointDatum = new EndpointDatumImpl();
            endpointDatum.setEndpointDatumRecipient(epRecipient);
            endpointDatum.setOutputsComponentExecutionIdentifier(this.compExeCtx.getExecutionIdentifier());
            endpointDatum.setOutputsNodeId(this.compExeCtx.getNodeId());
            endpointDatum.setWorkflowExecutionIdentifier(this.compExeCtx.getWorkflowExecutionIdentifier());
            endpointDatum.setWorkflowNodeId(this.compExeCtx.getWorkflowNodeId());
            endpointDatum.setDataManagementId(outputDmId);
            endpointDatum.setValue(datumToSend);
            endpointDatumDispatcher.dispatchEndpointDatum(endpointDatum);
            if (!VERBOSE_LOGGING) continue;
            LOG.debug((Object)StringUtils.format((String)"Sent at %s@%s: %s (-> %s@%s)", (Object[])new Object[]{outputName, this.compExeCtx.getInstanceName(), datumToSend, epRecipient.getInputName(), epRecipient.getInputsComponentInstanceName()}));
        }
    }

    private boolean considerRecipient(EndpointDatumRecipient epRecipient, String inputCompExeId, String inputName) {
        return inputCompExeId == null || epRecipient.getInputName().equals(inputName) && epRecipient.getInputsComponentExecutionIdentifier().equals(inputCompExeId);
    }

    protected void bindEndpointDatumDispatcher(EndpointDatumDispatchService newService) {
        endpointDatumDispatcher = newService;
    }
}

