/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;

public final class ComponentExecutionUtils {
    protected static final int WAIT_UNIL_RETRY_MSEC = 10000;
    protected static final int MAX_RETRIES = 5;
    protected static int waitUntilRetryMsec = 10000;
    private static final int THOUSAND = 1000;

    private ComponentExecutionUtils() {
    }

    protected static boolean isManualOutputVerificationRequired(ConfigurationDescription configDesc) {
        return Boolean.valueOf(configDesc.getComponentConfigurationDefinition().getReadOnlyConfiguration().getValue("requiresOutputApproval")) != false && Boolean.valueOf(configDesc.getConfigurationValue("isImitationMode")) == false;
    }

    protected static void logCallbackSuccessAfterFailure(Log log, String logMessage, int failureCount) {
        if (failureCount > 0) {
            log.debug((Object)StringUtils.format((String)(String.valueOf(logMessage) + " succeeded after %d retries"), (Object[])new Object[]{failureCount}));
        }
    }

    protected static void waitForRetryAfterCallbackFailure(Log log, int failureCount, String logMessage, String cause) {
        int waitInterval = waitUntilRetryMsec * failureCount;
        String message = StringUtils.format((String)(String.valueOf(logMessage) + ", retrying in %ds"), (Object[])new Object[]{waitInterval / 1000});
        log.warn((Object)StringUtils.format((String)"%s; failure count is %d (threshold: %d); cause: %s", (Object[])new Object[]{message, failureCount, 5, cause}));
        try {
            Thread.sleep(waitInterval);
        }
        catch (InterruptedException e1) {
            log.error((Object)StringUtils.format((String)"Waiting for retry (%s) was interrupted: %s", (Object[])new Object[]{logMessage, e1.toString()}));
        }
    }

    protected static void logCallbackFailureAfterRetriesExceeded(Log log, String logMessage, Exception e) {
        log.error((Object)(String.valueOf(logMessage) + "; maximum number of failures (" + 5 + ") exceeded; last cause: " + e.toString()));
    }

    protected static String getStringWithInfoAboutComponentAndWorkflowUpperCase(ComponentExecutionContext compExeCtx) {
        return StringUtils.format((String)"Component '%s' (%s) of workflow '%s' (%s)", (Object[])new Object[]{compExeCtx.getInstanceName(), compExeCtx.getExecutionIdentifier(), compExeCtx.getWorkflowInstanceName(), compExeCtx.getWorkflowExecutionIdentifier()});
    }

    protected static String getStringWithInfoAboutComponentAndWorkflowLowerCase(ComponentExecutionContext compExeCtx) {
        return StringUtils.format((String)"component '%s' (%s) of workflow '%s' (%s)", (Object[])new Object[]{compExeCtx.getInstanceName(), compExeCtx.getExecutionIdentifier(), compExeCtx.getWorkflowInstanceName(), compExeCtx.getWorkflowExecutionIdentifier()});
    }
}

