/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log.provenance.internal;

import de.rcenvironment.core.log.provenance.internal.RunToolTemplateInput;
import de.rcenvironment.core.log.provenance.internal.RunWorkflowNodeTemplateInput;
import de.rcenvironment.core.log.provenance.internal.RunWorkflowTemplateInput;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.template.expander.Bindings;
import org.openprovenance.prov.template.expander.Expand;

public class ProvenanceWriter {
    private ProvFactory pf;
    private Namespace nameSpaceObject = new Namespace();
    private String var;
    private String rceId;
    private String agentIDUser;
    private String attributeUserUsername;
    private String agentIDRce;
    private String attributeRceRceVersion;

    public ProvenanceWriter(ProvFactory pf) {
        this.pf = pf;
        this.var = "var";
        this.rceId = "rceId";
        this.agentIDUser = "agent_ID_user";
        this.attributeUserUsername = "attribute_user_username";
        this.agentIDRce = "agent_ID_rce";
        this.attributeRceRceVersion = "attribute_rce_rceVersion";
        this.nameSpaceObject.addKnownNamespaces();
        this.nameSpaceObject.register("bnode", "http://openprovenance.org/provtoolbox/bnode/");
        this.nameSpaceObject.register("pre_0", "http://orcid.org/");
        this.nameSpaceObject.register("tmpl", "http://openprovenance.org/tmpl#");
        this.nameSpaceObject.register(this.var, "http://openprovenance.org/var#");
        this.nameSpaceObject.register("ex", "http://example.com/#");
        this.nameSpaceObject.register("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.nameSpaceObject.register("vargen", "http://openprovenance.org/vargen#");
        this.nameSpaceObject.register("uuid", "urn:uuid:");
        this.nameSpaceObject.register("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.nameSpaceObject.register(this.rceId, "https://namespace.dlr.de/prov/rce#");
    }

    public void createProvenance(String templatePath, Bindings bn, String provenancePath) {
        InteropFramework intF = new InteropFramework();
        Document docIn = intF.readDocumentFromFile(templatePath);
        Expand ex = new Expand(this.pf, false, false);
        Document provenanceDocument = ex.expander(docIn, bn);
        intF.writeDocument(provenancePath, provenanceDocument);
    }

    public void writeProvenanceRunTool(RunToolTemplateInput in, String pathTemplate, String pathResultingProvFile) {
        Namespace ns = this.nameSpaceObject;
        Bindings bn = new Bindings(this.pf);
        bn.addVariable(ns.qualifiedName(this.var, "bundle_ID_runToolBundle", this.pf), ns.qualifiedName(this.rceId, in.getBundleIDRunToolBundle(), this.pf));
        QualifiedName varEndpointV0ID = ns.qualifiedName(this.var, "entity_ID_endpoint0", this.pf);
        QualifiedName varEndpointV0IDValue0 = ns.qualifiedName(this.rceId, in.getEntityIDData0(), this.pf);
        bn.addVariable(varEndpointV0ID, varEndpointV0IDValue0);
        QualifiedName varEndpointV1ID = ns.qualifiedName(this.var, "entity_ID_endpoint1", this.pf);
        QualifiedName varEndpointV1IDValue0 = ns.qualifiedName(this.rceId, in.getEntityIDEndpoint1(), this.pf);
        bn.addVariable(varEndpointV1ID, varEndpointV1IDValue0);
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_data0", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDData0(), this.pf));
        bn.addAttribute("attribute_data0_type", in.getAttributeData0Type());
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_data1", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDData1(), this.pf));
        bn.addAttribute("attribute_data1_type", in.getAttributeData1Type());
        bn.addVariable(ns.qualifiedName(this.var, "activity_ID_runTool", this.pf), ns.qualifiedName(this.rceId, in.getActivityIDRunTool(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, this.agentIDUser, this.pf), ns.qualifiedName(this.rceId, in.getAgentIDUser(), this.pf));
        bn.addAttribute(this.attributeUserUsername, in.getAttributeUserUsername());
        bn.addVariable(ns.qualifiedName(this.var, "agent_ID_tool", this.pf), ns.qualifiedName(this.rceId, in.getAgentIDTool(), this.pf));
        bn.addAttribute("attribute_tool_toolName", in.getAttributeToolToolName());
        bn.addAttribute("attribute_tool_toolVersion", in.getAttributeToolToolVersion());
        bn.addAttribute("attribute_tool_toolRevision", in.getAttributeToolToolRevision());
        bn.addAttribute("attribute_tool_toolLocation", in.getAttributeToolToolLocation());
        bn.addVariable(ns.qualifiedName(this.var, this.agentIDRce, this.pf), ns.qualifiedName(this.rceId, in.getAgentIDRce(), this.pf));
        bn.addAttribute(this.attributeRceRceVersion, in.getAttributeRceRceVersion());
        this.createProvenance(pathTemplate, bn, pathResultingProvFile);
    }

    public void writeProvenanceRunWorkflow(RunWorkflowTemplateInput in, String pathTemplate, String pathResultingProvFile) {
        Namespace ns = this.nameSpaceObject;
        ns.addKnownNamespaces();
        ns.register("bnode", "http://openprovenance.org/provtoolbox/bnode/");
        ns.register("pre_0", "http://orcid.org/");
        ns.register("tmpl", "http://openprovenance.org/tmpl#");
        ns.register(this.var, "http://openprovenance.org/var#");
        ns.register("ex", "http://example.com/#");
        ns.register("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.register("vargen", "http://openprovenance.org/vargen#");
        ns.register("uuid", "urn:uuid:");
        ns.register("xsd", "http://www.w3.org/2001/XMLSchema#");
        ns.register(this.rceId, "https://namespace.dlr.de/prov/rce#");
        Bindings bn = new Bindings(this.pf);
        bn.addVariable(ns.qualifiedName(this.var, "bundle_ID_runWorkflowBundle", this.pf), ns.qualifiedName(this.rceId, in.getBundleIDRunWorkflowBundle(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_workflow", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDWorkflow(), this.pf));
        bn.addAttribute("attribute_workflow_workflowName", in.getAttributeWorkflowWorkflowName());
        bn.addAttribute("attribute_workflow_workflowComment", in.getAttributeWorkflowWorkflowComment());
        for (String s : in.getEntityIDComponentLocation()) {
            bn.addVariable(ns.qualifiedName(this.var, "entity_ID_componentLocation", this.pf), ns.qualifiedName(this.rceId, s, this.pf));
        }
        for (String s : in.getEntityIDPlaceholderAssignment()) {
            bn.addVariable(ns.qualifiedName(this.var, "entity_ID_placeholderAssignment", this.pf), ns.qualifiedName(this.rceId, s, this.pf));
        }
        for (String s : in.getBundleIDRunWorkflowNodeBundle()) {
            bn.addVariable(ns.qualifiedName(this.var, "bundle_ID_runWorkflowNodeBundle", this.pf), ns.qualifiedName(this.rceId, s, this.pf));
        }
        bn.addVariable(ns.qualifiedName(this.var, "activity_ID_runWorkflow", this.pf), ns.qualifiedName(this.rceId, in.getActivityIDRunWorkflow(), this.pf));
        for (String s : in.getActivityIDRunWorkflowNode()) {
            bn.addVariable(ns.qualifiedName(this.var, "activity_ID_runWorkflowNode", this.pf), ns.qualifiedName(this.rceId, s, this.pf));
        }
        bn.addVariable(ns.qualifiedName(this.var, this.agentIDUser, this.pf), ns.qualifiedName(this.rceId, in.getAgentIDUser(), this.pf));
        bn.addAttribute(this.attributeUserUsername, in.getAttributeUserUsername());
        bn.addVariable(ns.qualifiedName(this.var, this.agentIDRce, this.pf), ns.qualifiedName(this.rceId, in.getAgentIDRce(), this.pf));
        bn.addAttribute(this.attributeRceRceVersion, in.getAttributeRceRceVersion());
        this.createProvenance(pathTemplate, bn, pathResultingProvFile);
    }

    public void writeProvenanceRunWorkflowNode(RunWorkflowNodeTemplateInput in, String pathTemplate, String pathResultingProvFile) {
        Namespace ns = new Namespace();
        ns = this.nameSpaceObject;
        ns.register("role", "https://namespace.dlr.de/prov/rce/role#");
        Bindings bn = new Bindings(this.pf);
        bn.addVariable(ns.qualifiedName(this.var, "bundle_ID_runWorkflowNodeBundle", this.pf), ns.qualifiedName(this.rceId, in.getBundleIDRunWorkflowNodeBundle(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_workflowNode", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDWorkflowNode(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_nodeConfiguration", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDNodeConfiguration(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_preScript", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDPreScript(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_postScript", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDPostScript(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_executionScript", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDExecutionScript(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_location", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDLocation(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "entity_ID_placeholderAssignment", this.pf), ns.qualifiedName(this.rceId, in.getEntityIDPlaceholderAssignment(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "bundle_ID_runToolBundle", this.pf), ns.qualifiedName(this.rceId, in.getBundleIDRunToolBundle(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "activity_ID_runWorkflowNode", this.pf), ns.qualifiedName(this.rceId, in.getActivityIDRunWorkflowNode(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, "activity_ID_runTool", this.pf), ns.qualifiedName(this.rceId, in.getActivityIDRunTool(), this.pf));
        bn.addVariable(ns.qualifiedName(this.var, this.agentIDUser, this.pf), ns.qualifiedName(this.rceId, in.getAgentIDUser(), this.pf));
        bn.addAttribute(this.attributeUserUsername, in.getAttributeUserUsername());
        bn.addVariable(ns.qualifiedName(this.var, this.agentIDRce, this.pf), ns.qualifiedName(this.rceId, in.getAgentIDRce(), this.pf));
        bn.addAttribute(this.attributeRceRceVersion, in.getAttributeRceRceVersion());
        this.createProvenance(pathTemplate, bn, pathResultingProvFile);
    }
}

