/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log.provenance;

import de.rcenvironment.core.log.provenance.Entity;
import de.rcenvironment.core.log.provenance.NodeConfiguration;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;

public final class WorkflowNode
implements Entity {
    private final String identifier;
    private final NodeConfiguration nodeConfiguration;
    private final Optional<String> underlyingToolId;

    private WorkflowNode(String location, NodeConfiguration nodeConfiguration) {
        this.identifier = location;
        this.nodeConfiguration = nodeConfiguration;
        this.underlyingToolId = Optional.empty();
    }

    public static WorkflowNode newInstance(String identifier, NodeConfiguration nodeConfiguration) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (nodeConfiguration == null) {
            throw new IllegalArgumentException("nodeConfiguration must not be null");
        }
        return new WorkflowNode(identifier, nodeConfiguration);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.nodeConfiguration.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkflowNode other = (WorkflowNode)obj;
        if (!this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.nodeConfiguration.equals(other.nodeConfiguration);
    }

    public String toString() {
        return StringUtils.format((String)"%s(identifier=\"%s\")", (Object[])new Object[]{this.getClass().getSimpleName(), this.identifier});
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasUnderlyingTool() {
        return this.underlyingToolId.isPresent();
    }
}

