/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PrimitiveMemberChecker {
    public static boolean isPrimitiveArgument(AccessibleObject member, int i) throws ArrayIndexOutOfBoundsException, UnsupportedOperationException {
        Class<?>[] types;
        if (member instanceof Constructor) {
            types = ((Constructor)member).getParameterTypes();
        } else if (member instanceof Method) {
            types = ((Method)member).getParameterTypes();
        } else if (member instanceof Field) {
            types = new Class[]{((Field)member).getType()};
        } else {
            throw new UnsupportedOperationException("Unsupported member type: " + member.getClass());
        }
        if (i >= types.length) {
            throw new ArrayIndexOutOfBoundsException("Index i > types array length " + types.length + " for member " + member);
        }
        return types[i].isPrimitive();
    }
}

