/*
 * Decompiled with CFR 0.152.
 */
package nu.psnet.quickimage.widgets;

import java.util.ArrayList;
import nu.psnet.quickimage.core.ImageHolder;
import nu.psnet.quickimage.core.ImageOrganizer;
import nu.psnet.quickimage.core.QManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class QuickImageCanvas
extends Canvas {
    private Image originalImage;
    private Image workingImage;
    private Image backImage;
    private Composite parent;
    private int clientw;
    private int clienth;
    private int imgx;
    private int imgy;
    private int imgw;
    private int imgh;
    private int scrolly;
    private int scrollx;
    private int mousex;
    private int mousey = 1;
    private Color COLOR_WIDGET_BACKGROUND;
    private boolean listenForMouseMovement = false;
    private Cursor handOpen;
    private Cursor handClosed;
    private double zoomScale = 1.0;
    private QManager manager;

    public QuickImageCanvas(QManager manager, Composite parent, int style) {
        super(parent, style | 0x800 | 0x40000 | 0x200 | 0x100);
        this.manager = manager;
        this.COLOR_WIDGET_BACKGROUND = this.getDisplay().getSystemColor(1);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                QuickImageCanvas.this.updateScrollbarPosition();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                QuickImageCanvas.this.eventMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                QuickImageCanvas.this.eventMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                QuickImageCanvas.this.listenForMouseMovement = false;
                QuickImageCanvas.this.setCursor(QuickImageCanvas.this.handOpen);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (QuickImageCanvas.this.listenForMouseMovement) {
                    QuickImageCanvas.this.followMouse(e);
                }
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                QuickImageCanvas.this.paint(event.gc);
            }
        });
        this.getHorizontalBar().setEnabled(true);
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QuickImageCanvas.this.updateHorizontalScroll((ScrollBar)event.widget);
            }
        });
        this.getVerticalBar().setEnabled(true);
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QuickImageCanvas.this.updateVerticalScroll((ScrollBar)event.widget);
            }
        });
        this.parent = parent;
    }

    private void eventMouseDown(MouseEvent e) {
        this.listenForMouseMovement = true;
        this.mousex = e.x;
        this.mousey = e.y;
        this.setCursor(this.handClosed);
        if (this.manager.getImageOrganizer().getActiveView() == 0) {
            this.manager.getImageOrganizer().selectHolder(e.x, e.y);
            this.manager.getStatusCanvas().updateWithCurrent();
            this.manager.getImageEditor().setPartName(this.manager.getImageOrganizer().getCurrent().getDisplayName());
            this.redraw();
        }
    }

    private void eventMouseDoubleClick(MouseEvent e) {
        if (!this.manager.getImageOrganizer().isSingle()) {
            if (this.manager.getImageOrganizer().getActiveView() == 1) {
                this.manager.getImageOrganizer().getCurrent().getFullsize().dispose();
                this.manager.getImageEditor().toggleView();
            } else if (this.manager.getImageOrganizer().selectHolder(e.x, e.y)) {
                this.manager.getImageEditor().toggleView();
            }
        }
        this.manager.getStatusCanvas().updateWithCurrent();
    }

    public void setIconsPath(String path) {
        this.handOpen = new Cursor((Device)this.getDisplay(), new ImageData(String.valueOf(path) + "cursor_hand_open.gif"), 10, 0);
        this.handClosed = new Cursor((Device)this.getDisplay(), new ImageData(String.valueOf(path) + "cursor_hand_closed.gif"), 10, 0);
        this.setCursor(this.handOpen);
    }

    private void followMouse(MouseEvent e) {
        if (this.clientw < this.imgw) {
            int mouseDiffX = this.mousex - e.x;
            this.mousex = e.x;
            this.imgx -= mouseDiffX;
            this.getHorizontalBar().setSelection(this.getHorizontalBar().getSelection() + mouseDiffX);
            int minx = this.clientw - this.imgw;
            int maxx = 0;
            if (this.imgx < minx) {
                this.imgx = minx;
            }
            if (this.imgx > maxx) {
                this.imgx = maxx;
            }
            this.scrollx = this.getHorizontalBar().getSelection();
        }
        if (this.clienth < this.imgh) {
            int mouseDiffY = this.mousey - e.y;
            this.mousey = e.y;
            this.imgy -= mouseDiffY;
            this.getVerticalBar().setSelection(this.getVerticalBar().getSelection() + mouseDiffY);
            int miny = this.clienth - this.imgh;
            int maxy = 0;
            if (this.imgy < miny) {
                this.imgy = miny;
            }
            if (this.imgy > maxy) {
                this.imgy = maxy;
            }
            this.scrolly = this.getVerticalBar().getSelection();
        }
        this.redraw();
    }

    void paint(GC gc) {
        if (this.backImage != null) {
            this.backImage.dispose();
        }
        this.backImage = new Image((Device)this.getDisplay(), this.clientw, this.clienth);
        GC backGC = new GC((Drawable)this.backImage);
        backGC.setBackground(this.COLOR_WIDGET_BACKGROUND);
        backGC.setClipping(this.getClientArea());
        backGC.fillRectangle(this.getClientArea());
        ImageOrganizer organizer = this.manager.getImageOrganizer();
        if (this.manager.getImageOrganizer().getActiveView() == 1) {
            backGC.drawImage(this.workingImage, this.imgx, this.imgy);
        } else {
            Point thumbDim = organizer.getThumbWidth();
            int cols = this.clientw / organizer.getThumbWidth().x;
            if (cols < 1) {
                cols = 1;
            }
            int rows = organizer.getCount() / cols;
            if (organizer.getCount() > rows * cols) {
                ++rows;
            }
            ArrayList<ImageHolder> holders = organizer.getHolders();
            int index = 0;
            int i = 0;
            while (i < rows) {
                if (this.imgy + i * thumbDim.x > this.clienth) break;
                int k = 0;
                while (k < cols) {
                    if (index == organizer.getCount()) break;
                    holders.get(index).drawThumb(backGC, k * thumbDim.x, this.imgy + i * thumbDim.y);
                    ++index;
                    ++k;
                }
                ++i;
            }
        }
        gc.drawImage(this.backImage, 0, 0);
        backGC.dispose();
    }

    private void updateScrollVisibility() {
        this.getHorizontalBar().setVisible(this.clientw < this.imgw);
        this.getVerticalBar().setVisible(this.clienth < this.imgh);
    }

    private void updateVerticalScroll(ScrollBar bar) {
        this.imgy -= bar.getSelection() - this.scrolly;
        this.scrolly = bar.getSelection();
        this.redraw();
    }

    private void updateHorizontalScroll(ScrollBar bar) {
        this.imgx -= bar.getSelection() - this.scrollx;
        this.scrollx = bar.getSelection();
        this.redraw();
    }

    public void zoomFit() {
        this.zoomScale = 1.0;
        double scaleHeight = 0.0;
        double scaleWidth = this.originalImage.getBounds().width - this.getClientArea().width;
        scaleHeight = this.originalImage.getBounds().height - this.getClientArea().height;
        if (scaleWidth > 0.0) {
            scaleWidth /= (double)this.originalImage.getBounds().width;
        }
        if (scaleHeight > 0.0) {
            scaleHeight /= (double)this.originalImage.getBounds().height;
        }
        if (scaleWidth > scaleHeight && scaleWidth > 0.0) {
            this.zoomScale = 1.0 - scaleWidth;
        } else if (scaleHeight > scaleWidth && scaleHeight > 0.0) {
            this.zoomScale = 1.0 - scaleHeight;
        }
        if (this.zoomScale < 0.001) {
            this.zoomScale = 0.001;
        }
        this.onZoom();
    }

    public void zoomIn() {
        if (this.zoomScale < 1.0) {
            this.zoomScale *= 2.0;
        } else {
            this.zoomScale += 0.5;
            if (this.zoomScale > 4.0) {
                this.zoomScale = 4.0;
            }
        }
        this.onZoom();
    }

    public void zoomOut() {
        if (this.zoomScale <= 1.0) {
            if (this.zoomScale > 0.001) {
                this.zoomScale /= 2.0;
            }
        } else {
            this.zoomScale -= 0.5;
        }
        this.onZoom();
    }

    public void zoomOriginal() {
        this.zoomScale = 1.0;
        this.onZoom();
    }

    private void onZoom() {
        int w = (int)((double)this.originalImage.getBounds().width * this.zoomScale);
        int h = (int)((double)this.originalImage.getBounds().height * this.zoomScale);
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        ImageData imageData = this.originalImage.getImageData().scaledTo(w, h);
        if (this.workingImage != null && !this.workingImage.isDisposed()) {
            this.workingImage.dispose();
        }
        this.workingImage = new Image((Device)this.getDisplay(), imageData);
        this.updateScrollbarPosition();
    }

    public void updateThumbData() {
        this.updateScrollbarPosition();
    }

    public void updateFullsizeData() {
        this.disposeImages();
        this.zoomScale = 1.0;
        this.originalImage = this.manager.getImageOrganizer().getCurrent().getFullsize();
        this.workingImage = new Image((Device)this.getDisplay(), this.originalImage.getImageData());
        this.updateScrollbarPosition();
    }

    public void rotate() {
        ImageData originalData = this.workingImage.getImageData();
        PaletteData originalPalette = originalData.palette;
        PaletteData tmpPalette = originalPalette.isDirect ? new PaletteData(originalPalette.redMask, originalPalette.greenMask, originalPalette.blueMask) : new PaletteData(originalPalette.getRGBs());
        ImageData tmpData = new ImageData(originalData.height, originalData.width, originalData.depth, tmpPalette);
        tmpData.transparentPixel = originalData.transparentPixel;
        int i = 0;
        while (i < originalData.width) {
            int k = 0;
            while (k < originalData.height) {
                tmpData.setPixel(k, originalData.width - 1 - i, originalData.getPixel(i, k));
                ++k;
            }
            ++i;
        }
        if (this.workingImage != null) {
            this.workingImage.dispose();
        }
        this.workingImage = new Image((Device)this.getDisplay(), tmpData);
        this.updateScrollbarPosition();
    }

    private void updateScrollbarPosition() {
        this.clientw = this.getClientArea().width;
        this.clienth = this.getClientArea().height;
        if (this.clientw < 1) {
            this.clientw = 1;
        }
        if (this.clienth < 1) {
            this.clienth = 1;
        }
        if (this.manager.getImageOrganizer().getActiveView() == 1) {
            this.imgh = this.workingImage.getBounds().height;
            this.imgw = this.workingImage.getBounds().width;
        } else {
            ImageOrganizer organizer = this.manager.getImageOrganizer();
            int cols = this.clientw / organizer.getThumbWidth().x;
            if (cols < 1) {
                cols = 1;
            }
            int rows = organizer.getCount() / cols;
            if (organizer.getCount() > rows * cols) {
                ++rows;
            }
            this.imgh = organizer.getThumbWidth().y * rows;
            this.imgw = this.clientw / organizer.getThumbWidth().x;
        }
        this.updateScrollVisibility();
        this.getVerticalBar().setSelection(0);
        this.getHorizontalBar().setSelection(0);
        this.imgx = this.clientw / 2 - this.imgw / 2;
        this.imgy = this.clienth / 2 - this.imgh / 2;
        if (this.imgx < 0) {
            this.imgx = 0;
        }
        if (this.imgy < 0) {
            this.imgy = 0;
        }
        this.scrollx = this.getHorizontalBar().getSelection();
        this.scrolly = this.getVerticalBar().getSelection();
        ScrollBar vertical = this.getVerticalBar();
        vertical.setMaximum(this.imgh);
        vertical.setThumb(Math.min(this.clienth, this.imgh));
        vertical.setIncrement(40);
        vertical.setPageIncrement(this.clienth);
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setMaximum(this.imgw);
        horizontal.setThumb(Math.min(this.clientw, this.imgw));
        horizontal.setIncrement(40);
        horizontal.setPageIncrement(this.clientw);
        this.redraw();
    }

    private void disposeImages() {
        if (this.originalImage != null && !this.originalImage.isDisposed()) {
            this.originalImage.dispose();
        }
        if (this.workingImage != null && !this.workingImage.isDisposed()) {
            this.workingImage.dispose();
        }
        if (this.backImage != null && !this.backImage.isDisposed()) {
            this.backImage.dispose();
        }
    }

    public void dispose() {
        this.disposeImages();
        super.dispose();
    }
}

