/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.instancemanagement.internal;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.instancemanagement.InstanceConfigurationOperationSequence;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.instancemanagement.InstanceStatus;
import de.rcenvironment.core.instancemanagement.internal.ConfigFilesCollection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationSshConnection;
import de.rcenvironment.core.instancemanagement.internal.ConfigurationUplinkConnection;
import de.rcenvironment.core.instancemanagement.internal.DeploymentOperationsImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationException;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationOperationDescriptor;
import de.rcenvironment.core.instancemanagement.internal.InstanceConfigurationOperationSequenceImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationException;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationsImpl;
import de.rcenvironment.core.instancemanagement.internal.InstanceOperationsUtils;
import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.OSFamily;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.AbstractTextOutputReceiver;
import de.rcenvironment.core.utils.incubator.FileSystemOperations;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindrot.jbcrypt.BCrypt;

public class InstanceManagementServiceImpl
implements InstanceManagementService {
    private static final String FROM_INSTANCE = " from instance ";
    private static final String UTF_8 = "utf-8";
    private static final String PASSWORD_FILE_IMPORT_SUBDIRECTORY = "import/uplink-pws";
    private static final String PROBLEM_WITH_PROFILE_VERSION_FILE = "Problem with profile-version-file: ";
    private static final String COMMAND_ARGUMENTS_FILE_NAME = String.valueOf(File.separator) + "commandArguments";
    private static final String DEFAULT_DOWNLOAD_URL_PATTERN = "https://software.dlr.de/updates/rce/10.x/products/standard/*/zip/";
    private static final String DEFAULT_DOWNLOAD_FILENAME_PATTERN_WINDOWS = "rce-*-standard-win32.x86_64.zip";
    private static final String DEFAULT_DOWNLOAD_FILENAME_PATTERN_LINUX = "rce-*-standard-linux.x86_64.zip";
    private static final String INSTANCE_MANAGEMENT_DISABLED = "Local instance management is disabled due to missing or invalid configuration: ";
    private static final String ON_INSTANCE = " on instance ";
    private static final String ZIP = ".zip";
    private static final String SLASH = "/";
    private static final String TO = " to ";
    private static final String INDENT = "- ";
    private static final String TEMPLATES = "templates";
    private static final String VERSION = ".version";
    private static final Pattern VALID_IDS_REGEXP_PATTERN = Pattern.compile("[a-zA-Z0-9-_\\.]+");
    private static final Pattern VALID_PATH_REGEXP_PATTERN = Pattern.compile("[a-zA-Z0-9-_\\./]+");
    private static final String GENERIC_PLACEHOLDER_STRING = "*";
    private static final String CONFIGURATION_SUBTREE_PATH = "instanceManagement";
    private static final String CONFIGURATION_FILENAME = "configuration.json";
    private static final String COMPONENTS_FILENAME = "configuration" + File.separator + "components.json";
    private static final int MAX_INSTALLATION_ROOT_PATH_LENGTH = 30;
    private static final String DATA_ROOT_DIRECTORY_PROPERTY = "dataRootDirectory";
    private static final String INSTALLATIONS_ROOT_DIR_PROPERTY = "installationsRootDirectory";
    private static final String INSTALLATIONS_ROOT_DIR_DEFAULT_SUBDIR_PATH = "inst";
    private static final String SUCCESS = " was successful.";
    private static final String TO_INSTANCE = " to instance ";
    private static final String OF_INSTANCE = " of instance ";
    private static final int[][] MAYOR_TO_PROFILE_VERSION = new int[][]{{8, 1}, {9, 2}};
    private File dataRootDir;
    private File installationsRootDir;
    private File profilesRootDir;
    private File templatesRootDir;
    private File downloadsCacheDir;
    private volatile boolean hasValidLocalConfiguration = false;
    private volatile boolean hasValidDownloadConfiguration = false;
    private volatile boolean instanceManagementStarted = false;
    private String reasonInstanceManagementNotStarted = "";
    private ConcurrentHashMap<String, InstanceStatus> profileIdToInstanceStatusMap = new ConcurrentHashMap();
    private ConfigurationService configurationService;
    private PersistentSettingsService persistentSettingsService;
    private final InstanceOperationsImpl instanceOperations = new InstanceOperationsImpl();
    private final DeploymentOperationsImpl deploymentOperations = new DeploymentOperationsImpl();
    private final Map<String, InstanceConfigurationImpl> instanceConfigurationsByInstanceId = new HashMap<String, InstanceConfigurationImpl>();
    private TempFileService tfs;
    private String downloadSourceFolderUrlPattern;
    private String downloadFilenamePattern;
    private final TextOutputReceiver fallbackUserOutputReceiver;
    private final Log log = LogFactory.getLog(this.getClass());

    public InstanceManagementServiceImpl() {
        this.fallbackUserOutputReceiver = new AbstractTextOutputReceiver(){

            public void addOutput(String line) {
                InstanceManagementServiceImpl.this.log.info((Object)"Operation progress: ");
            }
        };
    }

    public void activate() {
        this.tfs = TempFileServiceAccess.getInstance();
        this.hasValidLocalConfiguration = false;
        this.hasValidDownloadConfiguration = false;
        ConfigurationSegment configuration = this.configurationService.getConfigurationSegment(CONFIGURATION_SUBTREE_PATH);
        if (!configuration.isPresentInCurrentConfiguration()) {
            this.log.debug((Object)"No 'instanceManagement' configuration segment found, disabling instance management");
            this.reasonInstanceManagementNotStarted = "No 'instanceManagement' configuration segment found in configuration.json";
            return;
        }
        try {
            this.applyConfiguration(configuration);
            if (this.hasValidLocalConfiguration) {
                this.initProfileIdToInstanceStatusMap();
                this.instanceManagementStarted = true;
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Error while configuring " + this.getClass().getSimpleName()), (Throwable)e);
            this.reasonInstanceManagementNotStarted = INSTANCE_MANAGEMENT_DISABLED + e.getMessage();
        }
    }

    @Override
    public boolean isInstanceManagementStarted() {
        return this.instanceManagementStarted;
    }

    @Override
    public String getReasonInstanceManagementNotStarted() {
        return this.reasonInstanceManagementNotStarted;
    }

    public void deactivate() {
        this.hasValidLocalConfiguration = false;
        this.hasValidDownloadConfiguration = false;
    }

    @Override
    public void setupInstallationFromUrlQualifier(String installationId, String urlQualifier, InstanceManagementService.InstallationPolicy installationPolicy, TextOutputReceiver userOutputReceiver, long timeout) throws IOException {
        this.validateInstallationId(installationId);
        this.validatePath(urlQualifier);
        this.validateConfiguration(true, true);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        this.deploymentOperations.setUserOutputReceiver(userOutputReceiver);
        if (this.isInstallationRunning(installationId)) {
            throw new IOException("Cannot replace installation " + installationId + " because instances are currently running using this installation. Stop the " + "instannces or try the \"im reinstall\" command instead.");
        }
        switch (installationPolicy) {
            case IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT: {
                this.installIfVersionIsDifferent(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            case FORCE_NEW_DOWNLOAD_AND_REINSTALL: {
                this.forceDownloadAndReinstall(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            case FORCE_REINSTALL: {
                this.forceReinstall(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            case ONLY_INSTALL_IF_NOT_PRESENT: {
                this.installIfNotPresent(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            default: {
                throw new IOException("Not supported yet: " + (Object)((Object)installationPolicy));
            }
        }
    }

    @Override
    public void reinstallFromUrlQualifier(String installationId, String urlQualifier, InstanceManagementService.InstallationPolicy installationPolicy, TextOutputReceiver userOutputReceiver, long timeout) throws IOException {
        this.validateInstallationId(installationId);
        this.validatePath(urlQualifier);
        this.validateConfiguration(true, true);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        this.deploymentOperations.setUserOutputReceiver(userOutputReceiver);
        List<String> instancesForInstallation = this.getInstancesRunningInstallation(installationId);
        if (!instancesForInstallation.isEmpty()) {
            this.stopInstance(instancesForInstallation, userOutputReceiver, timeout);
        }
        switch (installationPolicy) {
            case IF_PRESENT_CHECK_VERSION_AND_REINSTALL_IF_DIFFERENT: {
                this.installIfVersionIsDifferent(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            case FORCE_NEW_DOWNLOAD_AND_REINSTALL: {
                this.forceDownloadAndReinstall(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            case FORCE_REINSTALL: {
                this.forceReinstall(installationId, urlQualifier, userOutputReceiver, (int)timeout);
                break;
            }
            default: {
                throw new IOException("Not supported yet: " + (Object)((Object)installationPolicy));
            }
        }
        if (!instancesForInstallation.isEmpty()) {
            this.startInstance(installationId, instancesForInstallation, userOutputReceiver, timeout, false, null);
        }
    }

    @Override
    public boolean isSpecialInstallationId(String input) {
        return ":self".equals(input) || input.startsWith("local:");
    }

    @Override
    public InstanceConfigurationOperationSequence newConfigurationOperationSequence() {
        return new InstanceConfigurationOperationSequenceImpl();
    }

    @Override
    public void applyInstanceConfigurationOperations(String instanceId, InstanceConfigurationOperationSequence changeSequence, TextOutputReceiver userOutputReceiver) throws InstanceConfigurationException, IOException {
        this.validateConfiguration(true, false);
        ConfigFilesCollection configFiles = this.createConfigFilesCollection(instanceId);
        List<InstanceConfigurationOperationDescriptor> changeEntries = ((InstanceConfigurationOperationSequenceImpl)changeSequence).getConfigurationSteps();
        if (changeEntries.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one configuration step to perform");
        }
        InstanceConfigurationOperationDescriptor firstEntry = changeEntries.get(0);
        if (firstEntry.getFlag().equals("--set-rce-version")) {
            if (!this.profileVersionFileExists(instanceId)) {
                String rceVersion = (String)firstEntry.getSingleParameter();
                int profileVersion = this.convertRCEVersionToProfileVersion(rceVersion);
                userOutputReceiver.addOutput("Setting rce-version of instance " + instanceId + TO + rceVersion);
                this.writeProfileVersionFile(instanceId, profileVersion);
            } else {
                throw new InstanceConfigurationException("It is not possible to set the profile version of an allready existing instance.");
            }
        }
        int profileVersion = this.determineProfileVersion(instanceId);
        this.createConfigurationFileIfMissing(configFiles.getConfigurationFile());
        if (profileVersion >= 2) {
            this.createConfigurationFileIfMissing(configFiles.getComponentsFile());
        }
        if (!configFiles.getConfigurationFile().exists()) {
            throw new InstanceConfigurationException(String.valueOf(configFiles.getConfigurationFile().getName()) + " is missing. Is this profile already created?");
        }
        if (!configFiles.getComponentsFile().exists() && profileVersion >= 2) {
            throw new InstanceConfigurationException(String.valueOf(configFiles.getComponentsFile().getName()) + " is missing. Is this profile already created?");
        }
        switch (firstEntry.getFlag()) {
            case "--reset": {
                this.writeEmptyConfigFile(configFiles.getConfigurationFile());
                if (profileVersion >= 2) {
                    this.writeEmptyConfigFile(configFiles.getComponentsFile());
                }
                this.addProfileVersionInformationUnlessPresent(instanceId);
                userOutputReceiver.addOutput("Resetting the configuration of instance " + instanceId);
                break;
            }
            case "--apply-template": {
                File templateConfigurationFile;
                Object templateParameter = firstEntry.getSingleParameter();
                userOutputReceiver.addOutput("Replacing configuration of instance " + instanceId + " with template " + templateParameter);
                if (templateParameter instanceof String) {
                    templateConfigurationFile = this.resolveAndCheckTemplateDir(firstEntry.getSingleParameter() + SLASH + CONFIGURATION_FILENAME);
                } else if (templateParameter instanceof File) {
                    templateConfigurationFile = (File)templateParameter;
                } else {
                    throw new IllegalArgumentException();
                }
                Path src = templateConfigurationFile.toPath();
                Files.copy(src, configFiles.getConfigurationFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.addProfileVersionInformationUnlessPresent(instanceId);
                break;
            }
            case "--wipe": {
                if (this.resolveRelativePathWithinProfileDirectory(instanceId, "").exists()) {
                    FileUtils.deleteDirectory((File)new File(this.profilesRootDir, instanceId));
                }
                this.createConfigurationFileIfMissing(configFiles.getConfigurationFile());
                if (profileVersion >= 2) {
                    this.createConfigurationFileIfMissing(configFiles.getComponentsFile());
                }
                userOutputReceiver.addOutput("Wiping the configuration of instance " + instanceId);
            }
        }
        this.applyChangeEntries(changeEntries, configFiles, instanceId, userOutputReceiver);
    }

    private int convertRCEVersionToProfileVersion(String rceVersion) throws InstanceConfigurationException {
        int mayorVersion;
        String[] rceVersionParts = rceVersion.split("\\.");
        try {
            mayorVersion = Integer.parseInt(rceVersionParts[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InstanceConfigurationException(String.valueOf(rceVersion) + "is not a valid RCE-Version.");
        }
        int profileVersion = 0;
        int i = 0;
        while (i < MAYOR_TO_PROFILE_VERSION.length) {
            if (MAYOR_TO_PROFILE_VERSION[i][0] > mayorVersion) break;
            profileVersion = MAYOR_TO_PROFILE_VERSION[i][1];
            ++i;
        }
        return profileVersion;
    }

    private void createConfigurationFileIfMissing(File file) throws InstanceConfigurationException {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                this.writeEmptyConfigFile(file);
            }
        }
        catch (IOException e) {
            throw new InstanceConfigurationException("Problem with " + file.getName() + ": " + e.getMessage());
        }
    }

    private ConfigFilesCollection createConfigFilesCollection(String instanceId) {
        File configuration = this.resolveRelativePathWithinProfileDirectory(instanceId, CONFIGURATION_FILENAME);
        File components = this.resolveRelativePathWithinProfileDirectory(instanceId, COMPONENTS_FILENAME);
        return new ConfigFilesCollection(configuration, components);
    }

    private void applyChangeEntries(List<InstanceConfigurationOperationDescriptor> changeEntries, ConfigFilesCollection configFiles, String instanceId, TextOutputReceiver userOutputReceiver) throws InstanceConfigurationException {
        InstanceConfigurationImpl configOperations = this.prepareConfigOperations(configFiles, instanceId);
        boolean isFirstCommand = true;
        for (InstanceConfigurationOperationDescriptor entry : changeEntries) {
            Object[] parameters = entry.getParameters();
            switch (entry.getFlag()) {
                case "--set-name": {
                    configOperations.setInstanceName((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Setting instance name of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-relay-option": {
                    if (!Boolean.TRUE.equals(entry.getSingleParameter()) && !Boolean.FALSE.equals(entry.getSingleParameter())) {
                        throw new InstanceConfigurationException("The parameter of the --set-relay-option sub-command must be a boolean value, but is a " + entry.getSingleParameter().getClass());
                    }
                    configOperations.setRelayFlag((Boolean)entry.getSingleParameter());
                    userOutputReceiver.addOutput("The relay flag of instance " + instanceId + " is set to " + entry.getSingleParameter());
                    break;
                }
                case "--set-comment": {
                    String entryString = (String)entry.getSingleParameter();
                    configOperations.setInstanceComment(entryString);
                    userOutputReceiver.addOutput("Setting comment field  of instance " + instanceId + TO + entryString);
                    break;
                }
                case "--add-connection": {
                    ConfigurationConnection connectionData = (ConfigurationConnection)entry.getSingleParameter();
                    configOperations.addConnection(connectionData);
                    userOutputReceiver.addOutput("Adding connection " + connectionData.getConnectionName() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-connection": {
                    configOperations.removeConnection((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removing connection " + entry.getSingleParameter() + FROM_INSTANCE + instanceId);
                    break;
                }
                case "--add-server-port": {
                    if (parameters.length != 3) {
                        throw new IllegalArgumentException("Wrong number of parameters.");
                    }
                    String serverPortName = (String)parameters[0];
                    String serverPortIp = (String)parameters[1];
                    Integer serverPortNumber = (Integer)parameters[2];
                    configOperations.addServerPort(serverPortName, serverPortIp, serverPortNumber);
                    userOutputReceiver.addOutput("Adding server port " + serverPortName + TO_INSTANCE + instanceId + SUCCESS);
                    break;
                }
                case "--disable-ssh-server": {
                    configOperations.disableSshServer();
                    userOutputReceiver.addOutput("Disabling ssh server of instance " + instanceId);
                    break;
                }
                case "--set-workflow-host-option": {
                    configOperations.setWorkflowHostFlag((Boolean)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set workflow host flag of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-custom-node-id": {
                    configOperations.setCustomNodeId((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set custom node id of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-tempdir-path": {
                    configOperations.setTempDirectory((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Setting temp directory of instance " + instanceId);
                    break;
                }
                case "--enable-im-ssh-access": {
                    configOperations.enableImSshAccess((Integer)entry.getSingleParameter(), this.getHashedPassphrase());
                    userOutputReceiver.addOutput("Configuring ssh access for IM on instance" + instanceId);
                    break;
                }
                case "--configure-ssh-server": {
                    configOperations.enableSshServer();
                    configOperations.setSshServerIP((String)parameters[0]);
                    configOperations.setSshServerPort((Integer)parameters[1]);
                    break;
                }
                case "--add-ssh-account": {
                    configOperations.addSshAccount((String)parameters[0], (String)parameters[1], (Boolean)parameters[2], (String)parameters[3]);
                    break;
                }
                case "--remove-ssh-account": {
                    configOperations.removeSshAccount((String)entry.getSingleParameter());
                    break;
                }
                case "--set-ip-filter-option": {
                    configOperations.setIpFilterFlag((Boolean)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set ip filter flag of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-rce-version": {
                    if (isFirstCommand) break;
                    throw new InstanceConfigurationException("Setting the profile version must take place *before* applying any other configuration commands");
                }
                case "--reset": 
                case "--apply-template": 
                case "--wipe": {
                    configOperations = this.applytemplate(configFiles, instanceId, isFirstCommand);
                    break;
                }
                case "--set-request-timeout": {
                    configOperations.setRequestTimeout((Long)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set request timeout of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--set-forwarding-timeout": {
                    configOperations.setForwardingTimeout((Long)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Set forwarding timeout of instance " + instanceId + TO + entry.getSingleParameter());
                    break;
                }
                case "--add-allowed-inbound-ip": {
                    configOperations.addAllowedIp((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Added allowed IP " + entry.getSingleParameter() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-allowed-inbound-ip": {
                    configOperations.removeAllowedIp((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removed allowed IP " + entry.getSingleParameter() + " from " + instanceId);
                    break;
                }
                case "--add-ssh-connection": {
                    ConfigurationSshConnection sshConnectionData = (ConfigurationSshConnection)entry.getSingleParameter();
                    configOperations.addSshConnection(sshConnectionData);
                    userOutputReceiver.addOutput("Adding SSH connection " + sshConnectionData.getName() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-ssh-connection": {
                    configOperations.removeSshConnection((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removing SSH connection " + entry.getSingleParameter() + FROM_INSTANCE + instanceId);
                    break;
                }
                case "--add-uplink-connection": {
                    ConfigurationUplinkConnection uplinkConnectionData = (ConfigurationUplinkConnection)entry.getSingleParameter();
                    configOperations.addUplinkConnection(uplinkConnectionData);
                    this.preparePasswordImport(instanceId, uplinkConnectionData);
                    userOutputReceiver.addOutput("Adding uplink connection " + uplinkConnectionData.getId() + TO_INSTANCE + instanceId);
                    break;
                }
                case "--remove-uplink-connection": {
                    configOperations.removeUplinkConnection((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Removing uplink connection " + entry.getSingleParameter() + FROM_INSTANCE + instanceId);
                    break;
                }
                case "--publish-component": {
                    configOperations.publishComponent((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Published component " + entry.getSingleParameter() + ON_INSTANCE + instanceId);
                    break;
                }
                case "--unpublish-component": {
                    configOperations.unPublishComponent((String)entry.getSingleParameter());
                    userOutputReceiver.addOutput("Unpublished component " + entry.getSingleParameter() + ON_INSTANCE + instanceId);
                    break;
                }
                case "--set-background-monitoring": {
                    String id = (String)entry.getParameters()[0];
                    int interval = (Integer)entry.getParameters()[1];
                    configOperations.setBackgroundMonitoring(id, interval);
                    userOutputReceiver.addOutput("Setting background monitoring interval for instance" + instanceId + TO + interval);
                    break;
                }
                default: {
                    throw new InstanceConfigurationException("Unhandled configuration change request: " + entry.getFlag());
                }
            }
            isFirstCommand = false;
        }
        configOperations.update();
        userOutputReceiver.addOutput("Updated the configuration file of instance " + instanceId);
    }

    private InstanceConfigurationImpl applytemplate(ConfigFilesCollection configFiles, String instanceId, boolean isFirstCommand) throws InstanceConfigurationException {
        if (!isFirstCommand) {
            throw new InstanceConfigurationException("Wiping/Resetting the configuration or applying a template must take place *before* applying any other configuration commands");
        }
        int profileVersion = this.determineProfileVersion(instanceId);
        InstanceConfigurationImpl configOperations = new InstanceConfigurationImpl(configFiles, profileVersion);
        this.instanceConfigurationsByInstanceId.put(instanceId, configOperations);
        return configOperations;
    }

    private void preparePasswordImport(String instanceId, ConfigurationUplinkConnection uplinkConnectionData) {
        if (uplinkConnectionData.getPassword() != null) {
            File standardImportDirectory = this.resolveRelativePathWithinProfileDirectory(instanceId, PASSWORD_FILE_IMPORT_SUBDIRECTORY);
            if (!standardImportDirectory.isDirectory()) {
                standardImportDirectory.mkdirs();
            }
            File passwordFile = new File(standardImportDirectory, uplinkConnectionData.getId());
            try {
                FileUtils.writeStringToFile((File)passwordFile, (String)uplinkConnectionData.getPassword(), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                this.log.warn((Object)"Could not create password import file. ", (Throwable)e);
            }
        }
    }

    private InstanceConfigurationImpl prepareConfigOperations(ConfigFilesCollection configFiles, String instanceId) throws InstanceConfigurationException {
        InstanceConfigurationImpl configOperations;
        if (this.instanceConfigurationsByInstanceId.get(instanceId) == null) {
            int profileVersion = this.determineProfileVersion(instanceId);
            configOperations = new InstanceConfigurationImpl(configFiles, profileVersion);
            this.instanceConfigurationsByInstanceId.put(instanceId, configOperations);
        } else {
            configOperations = this.instanceConfigurationsByInstanceId.get(instanceId);
        }
        return configOperations;
    }

    private void writeEmptyConfigFile(File config) throws FileNotFoundException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter writer = new PrintWriter(config);){
            writer.println("{");
            writer.println("}");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addProfileVersionInformationUnlessPresent(String instanceId) throws IOException {
        File versionInfoFile = this.resolveRelativePathWithinProfileDirectory(instanceId, "internal" + File.separator + "profile.version");
        if (!versionInfoFile.exists()) {
            FileUtils.write((File)versionInfoFile, (CharSequence)Profile.PROFILE_VERSION_NUMBER.toString());
        }
        if (!versionInfoFile.isFile()) {
            throw new IOException("Profile version file " + versionInfoFile.getAbsolutePath() + " could not be written");
        }
    }

    private String getHashedPassphrase() {
        String passphrase = this.persistentSettingsService.readStringValue("im_master_passphrase");
        if (passphrase == null) {
            passphrase = RandomStringUtils.randomAlphanumeric((int)10);
            this.persistentSettingsService.saveStringValue("im_master_passphrase", passphrase);
        }
        return BCrypt.hashpw((String)passphrase, (String)BCrypt.gensalt((int)10));
    }

    @Override
    public File resolveRelativePathWithinProfileDirectory(String instanceId, String relativePath) {
        return new File(new File(this.profilesRootDir, instanceId).getAbsoluteFile(), relativePath);
    }

    @Override
    public void startInstance(String installationId, List<String> instanceIdList, TextOutputReceiver userOutputReceiver, long timeout, boolean startWithGui, String commandArguments) throws InstanceOperationException, IOException {
        File installationDir;
        instanceIdList = new ArrayList<String>(instanceIdList);
        if (installationId == null || installationId.isEmpty() || instanceIdList.isEmpty()) {
            throw new IOException("Malformed command: either no installation id or instance id defined.");
        }
        if (":self".equals(installationId)) {
            installationDir = new File(this.getIMMasterInstallationPathAsInstallationId());
        } else if (installationId.startsWith("local:")) {
            installationDir = new File(installationId.substring("local:".length()));
        } else {
            File possibleInstallation = new File(this.installationsRootDir + SLASH + installationId);
            if (!possibleInstallation.exists()) {
                throw new IOException("Installation with id: " + installationId + " does not exist");
            }
            this.validateInstallationId(installationId);
            installationDir = this.resolveAndCheckInstallationDir(installationId);
        }
        if (!installationDir.isDirectory()) {
            throw new IOException("Resolved the given installation id to directory \"" + installationDir.getAbsolutePath() + "\", but it does not exist");
        }
        this.validateInstanceId(instanceIdList, false);
        this.validateConfiguration(true, false);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        for (String s : new ArrayList<String>(instanceIdList)) {
            if (!this.isInstanceRunning(s)) continue;
            instanceIdList.remove(s);
            userOutputReceiver.addOutput("Profile with id: " + s + " is already running.");
        }
        List<File> profileDirList = this.resolveAndCheckProfileDirList(instanceIdList);
        this.writeCommandArgumentsToProfile(profileDirList, commandArguments);
        this.setInstanceStatusInMap(profileDirList, installationId, InstanceStatus.InstanceState.STARTING);
        this.writeInstallationIdToFile(installationId, profileDirList, userOutputReceiver);
        try {
            this.instanceOperations.startInstanceUsingInstallation(profileDirList, installationDir, this.profileIdToInstanceStatusMap, timeout, userOutputReceiver, startWithGui);
        }
        catch (InstanceOperationException e) {
            throw new IOException("An error occured on the startup process of some instances. Aborted with message: " + e.getMessage());
        }
    }

    @Override
    public void stopInstance(List<String> instanceIdList, TextOutputReceiver userOutputReceiver, long timeout) throws InstanceOperationException, IOException {
        if (instanceIdList == null || instanceIdList.isEmpty()) {
            userOutputReceiver.addOutput("No instance to stop defined.. aborting.");
            return;
        }
        instanceIdList = new ArrayList<String>(instanceIdList);
        this.validateInstanceId(instanceIdList, true);
        this.validateConfiguration(true, false);
        userOutputReceiver = this.ensureUserOutputReceiverDefined(userOutputReceiver);
        List<File> profileDirList = this.resolveAndCheckProfileDirList(instanceIdList);
        for (File profile : new ArrayList<File>(profileDirList)) {
            if (this.isInstanceRunning(profile.getName())) continue;
            userOutputReceiver.addOutput("Instance with id: " + profile.getName() + " is currently not running.");
            profileDirList.remove(profile);
        }
        if (profileDirList.isEmpty()) {
            return;
        }
        this.setInstanceStatusInMap(profileDirList, "no installation", InstanceStatus.InstanceState.NOTRUNNING);
        try {
            try {
                this.instanceOperations.shutdownInstance(profileDirList, timeout, userOutputReceiver);
            }
            catch (IOException e) {
                this.checkAndRemoveInstanceLock(profileDirList, instanceIdList, e);
                this.checkAndRemoveInstanceLock(profileDirList, instanceIdList, null);
                this.removeInstallationFileIfProfileIsNotRunning(this.resolveAndCheckProfileDirList(instanceIdList));
            }
        }
        finally {
            this.checkAndRemoveInstanceLock(profileDirList, instanceIdList, null);
            this.removeInstallationFileIfProfileIsNotRunning(this.resolveAndCheckProfileDirList(instanceIdList));
        }
    }

    private void writeCommandArgumentsToProfile(List<File> profileDirList, String commandArguments) throws IOException {
        for (File profile : profileDirList) {
            String argumentsToWrite;
            if (commandArguments == null) {
                if (this.instanceOperations.hasCommandArgumentsFile(profile)) continue;
                argumentsToWrite = "";
            } else {
                argumentsToWrite = commandArguments;
            }
            this.instanceOperations.writeCommandArguments(profile, argumentsToWrite);
        }
    }

    private int determineProfileVersion(String profileName) throws InstanceConfigurationException {
        int version;
        try {
            version = this.readProfileVersion(profileName);
        }
        catch (IOException iOException) {
            version = Profile.PROFILE_VERSION_NUMBER;
            this.writeProfileVersionFile(profileName, version);
        }
        return version;
    }

    private void writeProfileVersionFile(String profileName, int version) throws InstanceConfigurationException {
        File profileVersionFile = this.getProfileVersionFile(profileName);
        profileVersionFile.getParentFile().mkdirs();
        try {
            profileVersionFile.createNewFile();
        }
        catch (IOException e) {
            throw new InstanceConfigurationException("Can not create profile-version-file: " + e.getMessage());
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (PrintWriter writer = new PrintWriter(profileVersionFile);){
                writer.print(version);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (FileNotFoundException e) {
            throw new InstanceConfigurationException("Can not write profile-version to the new created file: " + e.getMessage());
        }
    }

    private int readProfileVersion(String profileName) throws InstanceConfigurationException, IOException {
        File profileVersionFile = this.getProfileVersionFile(profileName);
        if (profileVersionFile.exists()) {
            String value;
            try {
                value = FileUtils.readFileToString((File)profileVersionFile);
            }
            catch (IOException e) {
                throw new InstanceConfigurationException(PROBLEM_WITH_PROFILE_VERSION_FILE + e.getMessage());
            }
            return Integer.parseInt(value);
        }
        throw new IOException("Profile version file does not exist");
    }

    private boolean profileVersionFileExists(String profileName) {
        File profileVersionFile = this.getProfileVersionFile(profileName);
        return profileVersionFile.exists();
    }

    private File getProfileVersionFile(String profileName) {
        return new File(this.profilesRootDir, String.valueOf(profileName) + File.separator + "internal" + File.separator + "profile.version");
    }

    private void removeInstallationFileIfProfileIsNotRunning(List<File> profileDirList) throws IOException {
        for (File profile : profileDirList) {
            if (this.isInstanceRunning(profile.getName()) || !profile.isDirectory()) continue;
            File[] fileArray = profile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean success;
                File file = fileArray[n2];
                if (file.getName().equals("installation") && !(success = file.delete())) {
                    throw new IOException("Failed to delete installation id.");
                }
                ++n2;
            }
        }
    }

    private void checkAndRemoveInstanceLock(List<File> profileDirList, List<String> instanceIdList, IOException e) throws IOException {
        for (File profile : new ArrayList<File>(profileDirList)) {
            if (this.isInstanceRunning(profile.getName())) continue;
            profileDirList.remove(profile);
            if (!profile.isDirectory()) continue;
            File[] fileArray = profile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals("instance.lock")) {
                    boolean success = file.delete();
                    if (e != null && !success) {
                        throw new IOException("Failed to delete instance.lock file.", e);
                    }
                    if (!success) {
                        throw new IOException("Failed to delete instance.lock file.");
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isInstanceRunning(String instanceId) throws IOException {
        this.validateConfiguration(true, false);
        File profileDir = this.resolveAndCheckProfileDir(instanceId);
        return InstanceOperationsUtils.isProfileLocked(profileDir);
    }

    private boolean isInstallationRunning(String installationId) throws IOException {
        for (Map.Entry<String, InstanceStatus> entry : this.profileIdToInstanceStatusMap.entrySet()) {
            if (!entry.getValue().getInstallation().equals(installationId) || !this.isInstanceRunning(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private List<String> getInstancesRunningInstallation(String installationId) throws IOException {
        ArrayList<String> instances = new ArrayList<String>();
        for (Map.Entry<String, InstanceStatus> entry : this.profileIdToInstanceStatusMap.entrySet()) {
            if (!entry.getValue().getInstallation().equals(installationId) || !this.isInstanceRunning(entry.getKey())) continue;
            instances.add(entry.getKey());
        }
        return instances;
    }

    protected void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    protected void bindPersistentSettingsService(PersistentSettingsService newService) {
        this.persistentSettingsService = newService;
    }

    @Override
    public void listInstanceManagementInformation(String scope, TextOutputReceiver userOutputReceiver) throws IOException {
        if ("all".equals(scope)) {
            this.listInstances(userOutputReceiver);
            this.listInstallations(userOutputReceiver);
            this.listTemplates(userOutputReceiver);
        } else if ("instances".equals(scope)) {
            this.listInstances(userOutputReceiver);
        } else if ("installations".equals(scope)) {
            this.listInstallations(userOutputReceiver);
        } else if (TEMPLATES.equals(scope)) {
            this.listTemplates(userOutputReceiver);
        }
    }

    @Override
    public void disposeInstance(String instanceId, TextOutputReceiver outputReceiver) throws IOException {
        if (this.profilesRootDir == null) {
            throw new IOException("Failed to dispose instance. Instances' root directory not defined.");
        }
        File[] fileArray = this.profilesRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File instanceFile = fileArray[n2];
            if (instanceFile.isDirectory() && instanceId.equals(instanceFile.getName())) {
                File[] fileArray2 = instanceFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileInInstanceFolder = fileArray2[n4];
                    if (fileInInstanceFolder.getName().equals("instance.lock")) {
                        throw new IOException("Instance with ID " + instanceId + " currently in use. " + "To stop it use 'im stop " + instanceId + "'.");
                    }
                    ++n4;
                }
                FileSystemOperations.deleteSandboxDirectory((File)instanceFile);
                return;
            }
            ++n2;
        }
        throw new IOException("Instance with ID " + instanceId + " not found.");
    }

    @Override
    public void showInstanceManagementInformation(TextOutputReceiver outputReceiver) {
        if (this.profilesRootDir != null) {
            outputReceiver.addOutput("Instances' root directory: " + this.profilesRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Instances' root directory not defined.");
        }
        if (this.installationsRootDir != null) {
            outputReceiver.addOutput("Installations' root directory: " + this.installationsRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Installations' root directory not defined.");
        }
        if (this.templatesRootDir != null) {
            outputReceiver.addOutput("Templates' root directory: " + this.templatesRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Templates' root directory not defined.");
        }
        if (this.dataRootDir != null) {
            outputReceiver.addOutput("Data root directory: " + this.dataRootDir.getAbsolutePath());
        } else {
            outputReceiver.addOutput("Data root directory not defined.");
        }
        if (this.downloadsCacheDir != null) {
            outputReceiver.addOutput("Download cache directory: " + this.downloadsCacheDir.getAbsolutePath());
            if (this.downloadsCacheDir.listFiles().length > 0) {
                outputReceiver.addOutput("Downloads cached: ");
                File[] fileArray = this.downloadsCacheDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File cachedDownloadFile = fileArray[n2];
                    outputReceiver.addOutput(INDENT + cachedDownloadFile.getName().replace(ZIP, ""));
                    ++n2;
                }
            } else {
                outputReceiver.addOutput("No download cached.");
            }
        } else {
            outputReceiver.addOutput("Download cache directory not defined.");
        }
    }

    @Override
    public void startAllInstances(String installationId, TextOutputReceiver userOutputReceiver, long timeout, String commandArguments) throws InstanceOperationException, IOException {
        ArrayList<String> instanceIdList = new ArrayList<String>();
        try {
            this.addProfiles(this.profilesRootDir.toPath(), instanceIdList);
        }
        catch (IOException e) {
            throw new InstanceOperationException("Failed to add profile. Aborted with message: " + e.getMessage());
        }
        this.startInstance(installationId, instanceIdList, userOutputReceiver, timeout, false, commandArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllInstances(String installationId, TextOutputReceiver userOutputReceiver, long timeout) throws InstanceOperationException, IOException {
        ArrayList<String> instanceIdList = new ArrayList<String>();
        if (!installationId.isEmpty()) {
            ConcurrentHashMap<String, InstanceStatus> concurrentHashMap = this.profileIdToInstanceStatusMap;
            synchronized (concurrentHashMap) {
                for (Map.Entry<String, InstanceStatus> entry : this.profileIdToInstanceStatusMap.entrySet()) {
                    if (!entry.getValue().getInstallation().equals(installationId)) continue;
                    instanceIdList.add(entry.getKey());
                }
            }
        }
        try {
            this.addProfiles(this.profilesRootDir.toPath(), instanceIdList);
        }
        catch (IOException e) {
            throw new InstanceOperationException("Failed to add profile. Aborted with message: " + e.getMessage());
        }
        this.stopInstance(instanceIdList, userOutputReceiver, timeout);
    }

    protected File getProfilesRootDir() {
        return this.profilesRootDir;
    }

    protected void setProfilesRootDir(File file) {
        this.profilesRootDir = file;
    }

    protected void validateLocalConfig() {
        this.hasValidLocalConfiguration = true;
    }

    private String getSourceFolderUrl(String urlQualifier) {
        if (urlQualifier.matches(".?[0-9]+\\.x/.+")) {
            String[] urlParts = urlQualifier.split(SLASH);
            String newDownloadSourceFolderUrlPattern = this.downloadSourceFolderUrlPattern.replaceFirst("[0-9]+\\.x", urlParts[0]);
            String newUrlQualifier = urlQualifier.substring(urlParts[0].length() + 1);
            return newDownloadSourceFolderUrlPattern.replace(GENERIC_PLACEHOLDER_STRING, newUrlQualifier);
        }
        return this.downloadSourceFolderUrlPattern.replace(GENERIC_PLACEHOLDER_STRING, urlQualifier);
    }

    protected String fetchVersionInformationFromDownloadSourceFolder(String urlQualifier, int timeout) throws IOException {
        this.validateConfiguration(false, true);
        File tempVersionFile = this.tfs.createTempFileFromPattern("versionfile-*.tmp");
        String versionFileUrl = String.valueOf(this.getSourceFolderUrl(urlQualifier)) + "VERSION";
        this.log.debug((Object)("Fetching remote version information from " + versionFileUrl));
        this.deploymentOperations.downloadFile(versionFileUrl, tempVersionFile, true, false, timeout);
        return FileUtils.readFileToString((File)tempVersionFile).trim();
    }

    protected void downloadInstallationPackage(String urlQualifier, String version, File localFile, int timeout) throws IOException {
        this.validateConfiguration(false, true);
        String remoteFileUrl = String.valueOf(this.getSourceFolderUrl(urlQualifier)) + this.downloadFilenamePattern.replace(GENERIC_PLACEHOLDER_STRING, version);
        this.log.debug((Object)("Downloading installation package from '" + remoteFileUrl + "' to local file '" + localFile.getAbsolutePath() + "'"));
        this.deploymentOperations.downloadFile(remoteFileUrl, localFile, true, true, timeout);
    }

    private void applyConfiguration(ConfigurationSegment configuration) throws IOException {
        try {
            this.hasValidLocalConfiguration = false;
            this.dataRootDir = this.getConfiguredDirectory(configuration, DATA_ROOT_DIRECTORY_PROPERTY);
            if (this.dataRootDir == null) {
                throw new IOException("No data root directory specified (option 'dataRootDirectory')");
            }
            this.installationsRootDir = this.getConfiguredDirectory(configuration, INSTALLATIONS_ROOT_DIR_PROPERTY);
            if (this.installationsRootDir == null) {
                this.installationsRootDir = new File(this.dataRootDir, INSTALLATIONS_ROOT_DIR_DEFAULT_SUBDIR_PATH);
            }
            this.templatesRootDir = new File(this.dataRootDir, TEMPLATES);
            this.profilesRootDir = new File(this.dataRootDir, "profiles");
            this.downloadsCacheDir = new File(this.dataRootDir, "downloads");
            if (this.installationsRootDir.equals(this.templatesRootDir) || this.installationsRootDir.equals(this.profilesRootDir) || this.templatesRootDir.equals(this.profilesRootDir)) {
                throw new IOException("Two or more configured directory are equal, but they must be unique");
            }
            if (this.installationsRootDir.getPath().length() > 30) {
                String errorMessage = String.format("The configured IM installation root path (%s) is too long; the maxium allowed length is %d characters. Change or set the installationsRootDirectory option to change it.", this.installationsRootDir.getPath(), 30);
                throw new IOException(errorMessage);
            }
            this.prepareAndValidateDirectory(DATA_ROOT_DIRECTORY_PROPERTY, this.dataRootDir);
            this.prepareAndValidateDirectory(INSTALLATIONS_ROOT_DIR_PROPERTY, this.installationsRootDir);
            this.prepareAndValidateDirectory(TEMPLATES, this.templatesRootDir);
            this.prepareAndValidateDirectory("profiles", this.profilesRootDir);
            this.prepareAndValidateDirectory("downloads", this.downloadsCacheDir);
            this.hasValidLocalConfiguration = true;
        }
        catch (IOException e) {
            this.log.error((Object)("Disabling local instance management due to missing or invalid configuration: " + e.getMessage()));
            this.reasonInstanceManagementNotStarted = INSTANCE_MANAGEMENT_DISABLED + e.getMessage();
        }
        this.downloadSourceFolderUrlPattern = configuration.getString("downloadSourceFolderUrlPattern", DEFAULT_DOWNLOAD_URL_PATTERN);
        if (this.downloadSourceFolderUrlPattern.length() > 0 && !this.downloadSourceFolderUrlPattern.endsWith(SLASH)) {
            this.downloadSourceFolderUrlPattern = String.valueOf(this.downloadSourceFolderUrlPattern) + SLASH;
        }
        String defaultFilenamePattern = OSFamily.isWindows() ? DEFAULT_DOWNLOAD_FILENAME_PATTERN_WINDOWS : DEFAULT_DOWNLOAD_FILENAME_PATTERN_LINUX;
        this.downloadFilenamePattern = configuration.getString("downloadFilenamePattern", defaultFilenamePattern);
        try {
            this.hasValidDownloadConfiguration = false;
            if (this.downloadSourceFolderUrlPattern.isEmpty()) {
                throw new IOException("Parameter 'downloadSourceFolderUrlPattern' has not been defined, but is required");
            }
            if (this.downloadFilenamePattern.isEmpty()) {
                throw new IOException("Parameter 'downloadFilenamePattern' has not been defined, but is required");
            }
            this.hasValidDownloadConfiguration = true;
        }
        catch (IOException e) {
            this.log.error((Object)("Error in instance management download configuration: " + e.getMessage()));
            this.reasonInstanceManagementNotStarted = INSTANCE_MANAGEMENT_DISABLED + e.getMessage();
        }
    }

    private File forceFetchingProductZip(String urlQualifier, String remoteVersion, int timeout) throws IOException {
        File downloadFile = new File(this.downloadsCacheDir, String.valueOf(remoteVersion) + ZIP);
        int i = 1;
        while (downloadFile.exists()) {
            String newFilePath = String.valueOf(downloadFile.getAbsolutePath().replace(downloadFile.getName(), "")) + remoteVersion + "(" + i++ + ")" + ZIP;
            downloadFile = new File(newFilePath);
        }
        this.downloadInstallationPackage(urlQualifier, remoteVersion, downloadFile, timeout);
        return downloadFile;
    }

    private String fetchVersionInformation(TextOutputReceiver userOutputReceiver, String urlQualifier, int timeout) throws IOException {
        userOutputReceiver.addOutput("Fetching remote version information");
        return this.fetchVersionInformationFromDownloadSourceFolder(urlQualifier, timeout);
    }

    private File fetchProductZipIfNecessary(String urlQualifier, String remoteVersion, int timeout) throws IOException {
        File downloadFile = new File(this.downloadsCacheDir, String.valueOf(remoteVersion) + ZIP);
        if (downloadFile.exists()) {
            this.log.info((Object)("Version " + remoteVersion + " is already present in downloads cache, not downloading"));
        } else {
            this.downloadInstallationPackage(urlQualifier, remoteVersion, downloadFile, timeout);
        }
        return downloadFile;
    }

    private void forceDownloadAndReinstall(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver, int timeout) throws IOException {
        String version = this.fetchVersionInformation(userOutputReceiver, urlQualifier, timeout);
        this.reinstall(installationId, version, urlQualifier, userOutputReceiver, true, timeout);
    }

    private void forceReinstall(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver, int timeout) throws IOException {
        String version = this.fetchVersionInformation(userOutputReceiver, urlQualifier, timeout);
        this.log.info((Object)StringUtils.format((String)"Identified version of remote installation package '%s': %s", (Object[])new Object[]{urlQualifier, version}));
        this.reinstall(installationId, version, urlQualifier, userOutputReceiver, false, timeout);
    }

    private void installIfNotPresent(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver, int timeout) throws IOException {
        File installationDir = new File(this.installationsRootDir, installationId);
        if (installationDir.exists()) {
            userOutputReceiver.addOutput("Installation with ID " + installationId + " already exists.");
        } else {
            this.installIfVersionIsDifferent(installationId, urlQualifier, userOutputReceiver, timeout);
        }
    }

    private void installIfVersionIsDifferent(String installationId, String urlQualifier, TextOutputReceiver userOutputReceiver, int timeout) throws IOException {
        String newVersion = this.fetchVersionInformation(userOutputReceiver, urlQualifier, timeout);
        this.log.info((Object)StringUtils.format((String)"Identified version of remote installation package '%s': %s", (Object[])new Object[]{urlQualifier, newVersion}));
        String oldVersion = this.getVersionOfInstallation(installationId);
        if (newVersion.isEmpty()) {
            throw new IOException("Unable to find new version");
        }
        if (newVersion.equals(oldVersion)) {
            userOutputReceiver.addOutput("Remote and installed version are the same; no change required");
            return;
        }
        this.reinstall(installationId, newVersion, urlQualifier, userOutputReceiver, false, timeout);
    }

    private void reinstall(String installationId, String version, String urlQualifier, TextOutputReceiver userOutputReceiver, boolean force, int timeout) throws IOException {
        File zipFile;
        if (force) {
            this.log.info((Object)"Reinstalling with 'force new download' option set");
            zipFile = this.forceFetchingProductZip(urlQualifier, version, timeout);
        } else {
            zipFile = this.fetchProductZipIfNecessary(urlQualifier, version, timeout);
        }
        File installationDir = new File(this.installationsRootDir, installationId);
        if (installationDir.exists()) {
            userOutputReceiver.addOutput("Deleting old installation " + installationId);
            this.deploymentOperations.deleteInstallation(installationDir);
        }
        userOutputReceiver.addOutput("Setting up new installation " + installationId);
        this.deploymentOperations.installFromProductZip(zipFile, installationDir);
        this.log.debug((Object)("Writing version information for installation " + installationId));
        this.storeVersionOfInstallation(installationId, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listInstances(TextOutputReceiver userOutputReceiver) throws IOException {
        if (this.profilesRootDir == null) {
            userOutputReceiver.addOutput("Instances' root directory not defined.");
            return;
        }
        Object[] files = this.profilesRootDir.listFiles();
        if (files.length == 0) {
            userOutputReceiver.addOutput("No instances found.");
            return;
        }
        userOutputReceiver.addOutput("Instances: ");
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object instanceFile = objectArray[n2];
            if (((File)instanceFile).isDirectory()) {
                String runningState = "Not running";
                ConcurrentHashMap<String, InstanceStatus> concurrentHashMap = this.profileIdToInstanceStatusMap;
                synchronized (concurrentHashMap) {
                    InstanceStatus status = this.profileIdToInstanceStatusMap.get(((File)instanceFile).getName());
                    if (status != null) {
                        String installationName = status.getInstallation();
                        switch (status.getInstanceState()) {
                            case NOTRUNNING: {
                                break;
                            }
                            case STARTING: {
                                runningState = "Starting (" + installationName + ")";
                                break;
                            }
                            case RUNNING: {
                                runningState = "Running (" + installationName + ")";
                                break;
                            }
                            default: {
                                runningState = "unknown State";
                            }
                        }
                    }
                }
                userOutputReceiver.addOutput(INDENT + ((File)instanceFile).getName() + " (" + runningState + ")");
            }
            ++n2;
        }
    }

    private void listInstallations(TextOutputReceiver userOutputReceiver) throws IOException {
        if (this.installationsRootDir == null) {
            userOutputReceiver.addOutput("Installations' root directory not defined.");
            return;
        }
        Object[] files = this.installationsRootDir.listFiles();
        if (files.length == 0) {
            userOutputReceiver.addOutput("No installations found.");
            return;
        }
        userOutputReceiver.addOutput("Installations: ");
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object installationFile = objectArray[n2];
            if (((File)installationFile).isFile() && ((File)installationFile).getName().endsWith(VERSION)) {
                String installationsId = ((File)installationFile).getName().replace(VERSION, "");
                String version = FileUtils.readFileToString((File)installationFile);
                userOutputReceiver.addOutput(INDENT + installationsId + " (" + version + ")");
            }
            ++n2;
        }
    }

    private void listTemplates(TextOutputReceiver userOutputReceiver) {
        if (this.templatesRootDir == null) {
            userOutputReceiver.addOutput("Templates' root directory not defined.");
            return;
        }
        Object[] files = this.templatesRootDir.listFiles();
        if (files.length == 0) {
            userOutputReceiver.addOutput("No templates found.");
            return;
        }
        userOutputReceiver.addOutput("Templates: ");
        Arrays.sort(files);
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object templateFile = objectArray[n2];
            if (((File)templateFile).isDirectory()) {
                userOutputReceiver.addOutput(INDENT + ((File)templateFile).getName());
            }
            ++n2;
        }
    }

    private String getVersionOfInstallation(String installationId) throws IOException {
        File installationVersionFile = new File(this.installationsRootDir, String.valueOf(installationId) + VERSION);
        String oldVersion = installationVersionFile.exists() ? FileUtils.readFileToString((File)installationVersionFile) : "";
        return oldVersion;
    }

    private void storeVersionOfInstallation(String installationId, String versionString) throws IOException {
        File installationVersionFile = new File(this.installationsRootDir, String.valueOf(installationId) + VERSION);
        FileUtils.writeStringToFile((File)installationVersionFile, (String)versionString);
    }

    private List<File> resolveAndCheckProfileDirList(List<String> instanceIdList) throws IOException {
        ArrayList<File> dirList = new ArrayList<File>();
        for (String instanceId : instanceIdList) {
            dirList.add(this.resolveAndCheckProfileDir(instanceId));
        }
        return dirList;
    }

    private File resolveAndCheckInstallationDir(String installationId) throws IOException {
        File installationDir = new File(this.installationsRootDir, installationId);
        if (!installationDir.exists()) {
            throw new IOException("The installation directory " + installationId + " does not exist.");
        }
        this.prepareAndValidateDirectory("installation " + installationId, installationDir);
        return installationDir;
    }

    private File resolveAndCheckProfileDir(String instanceId) throws IOException {
        File profileDir = new File(this.profilesRootDir, instanceId);
        this.prepareAndValidateDirectory("profile " + instanceId, profileDir);
        return profileDir;
    }

    private File resolveAndCheckTemplateDir(String templateId) throws IOException {
        File templateDir = new File(this.templatesRootDir, templateId);
        return templateDir;
    }

    private void prepareAndValidateDirectory(String id, File dir) throws IOException {
        dir.mkdirs();
        String absolutePath = dir.getAbsolutePath();
        if (!dir.isDirectory()) {
            throw new IOException("The configured path '" + id + "' ('" + absolutePath + "') could not be created");
        }
        if (absolutePath.contains("\"")) {
            throw new IOException("The directory path '" + absolutePath + "' contains illegal characters");
        }
        this.log.debug((Object)("Set up directory '" + id + "' at " + absolutePath));
    }

    private TextOutputReceiver ensureUserOutputReceiverDefined(TextOutputReceiver userOutputReceiver) {
        if (userOutputReceiver != null) {
            return userOutputReceiver;
        }
        return this.fallbackUserOutputReceiver;
    }

    private void validateConfiguration(boolean validateLocalConfig, boolean validateDownloadConfig) throws IOException {
        if (validateLocalConfig && !this.hasValidLocalConfiguration) {
            throw new IOException("The instance management service is disabled or has no valid local configuration - cannot execute the requested operation");
        }
        if (validateDownloadConfig && !this.hasValidDownloadConfiguration) {
            throw new IOException("The instance management service is disabled or has no valid download configuration - cannot execute the requested operation");
        }
    }

    private <T> boolean isUnique(Collection<T> idList) {
        LinkedHashSet<T> duplicateIdList = new LinkedHashSet<T>();
        HashSet<T> uniqueIdList = new HashSet<T>();
        for (T t : idList) {
            if (uniqueIdList.add(t)) continue;
            duplicateIdList.add(t);
        }
        return duplicateIdList.isEmpty();
    }

    private boolean isIdValid(String id) {
        return VALID_IDS_REGEXP_PATTERN.matcher(id).matches();
    }

    private boolean isPathValid(String path) {
        return VALID_PATH_REGEXP_PATTERN.matcher(path).matches();
    }

    private boolean isProfilePresent(String id) {
        File possibleProfile = new File(this.profilesRootDir + SLASH + id);
        return possibleProfile.exists();
    }

    private void validateInstallationId(String id) throws IOException {
        if (!this.isIdValid(id)) {
            throw new IOException("Malformed id: " + id);
        }
    }

    private void validatePath(String path) throws IOException {
        if (!this.isPathValid(path)) {
            throw new IOException("Malformed path: " + path);
        }
    }

    private void validateInstanceId(List<String> idList, boolean forShutdown) throws IOException {
        if (!this.isUnique(idList)) {
            throw new IOException("Malformed command: multiple instances with identical id");
        }
        for (String id : idList) {
            if (!this.isIdValid(id)) {
                throw new IOException("Malformed id: " + id);
            }
            if (!forShutdown || this.isProfilePresent(id)) continue;
            throw new IOException("Malformed command: tried to shutdown instance, which doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProfileIdToInstanceStatusMap() throws IOException {
        File[] fileArray = this.profilesRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File instanceFile = fileArray[n2];
            if (instanceFile.isDirectory()) {
                File[] fileArray2 = instanceFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileInProfile = fileArray2[n4];
                    if (fileInProfile.getName().equals("installation")) {
                        Throwable throwable = null;
                        Object var10_11 = null;
                        try (BufferedReader br = new BufferedReader(new FileReader(fileInProfile));){
                            String installation = br.readLine();
                            String instance = instanceFile.getName();
                            InstanceStatus.InstanceState state = this.isInstanceRunning(instance) ? InstanceStatus.InstanceState.RUNNING : InstanceStatus.InstanceState.NOTRUNNING;
                            ConcurrentHashMap<String, InstanceStatus> concurrentHashMap = this.profileIdToInstanceStatusMap;
                            synchronized (concurrentHashMap) {
                                this.profileIdToInstanceStatusMap.put(instance, new InstanceStatus(installation, state));
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstanceToMap(List<String> instanceIds, String installationId, InstanceStatus.InstanceState instanceState) {
        for (String instanceId : instanceIds) {
            ConcurrentHashMap<String, InstanceStatus> concurrentHashMap = this.profileIdToInstanceStatusMap;
            synchronized (concurrentHashMap) {
                this.profileIdToInstanceStatusMap.put(instanceId, new InstanceStatus(installationId, instanceState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstanceStatusInMap(List<File> profileDirList, String installationId, InstanceStatus.InstanceState instanceState) {
        for (File profile : profileDirList) {
            ConcurrentHashMap<String, InstanceStatus> concurrentHashMap = this.profileIdToInstanceStatusMap;
            synchronized (concurrentHashMap) {
                InstanceStatus instanceStatus = this.profileIdToInstanceStatusMap.get(profile.getName());
                if (instanceStatus != null) {
                    instanceStatus.setInstallation(installationId);
                    instanceStatus.setInstanceState(instanceState);
                } else {
                    this.profileIdToInstanceStatusMap.put(profile.getName(), new InstanceStatus(installationId, instanceState));
                }
            }
        }
    }

    private void addProfiles(Path directory, Collection<String> all) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(directory);){
            for (Path child : ds) {
                all.add(child.getFileName().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File getConfiguredDirectory(ConfigurationSegment configuration, String id) throws IOException {
        String configuredPath = configuration.getString(id);
        this.log.debug((Object)("Configuration value for property '" + id + "': " + configuredPath));
        if (configuredPath != null && !configuredPath.trim().isEmpty()) {
            return new File(configuredPath).getAbsoluteFile();
        }
        return null;
    }

    private void writeInstallationIdToFile(String installationId, List<File> profileDirList, TextOutputReceiver userOutputReceiver) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        for (File profile : profileDirList) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(profile.getAbsolutePath()) + SLASH + "installation"), UTF_8));){
                writer.write(installationId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeCommandOnInstance(String instanceId, String command, TextOutputReceiver userOutputReceiver) throws JSchException, SshParameterException, IOException, InterruptedException {
        Objects.requireNonNull(instanceId);
        if (!this.isInstanceRunning(instanceId)) {
            userOutputReceiver.addOutput("Cannot execute command on instance " + instanceId + " because it is not running.");
            return;
        }
        Logger logger = JschSessionFactory.createDelegateLogger((Log)this.log);
        Integer port = null;
        try {
            port = this.getSshPortForInstance(instanceId);
        }
        catch (InstanceConfigurationException e) {
            throw new IOException((Throwable)((Object)e));
        }
        String ip = null;
        try {
            ip = this.getSshIpForInstance(instanceId);
        }
        catch (InstanceConfigurationException e) {
            throw new IOException((Throwable)((Object)e));
        }
        String passphrase = this.persistentSettingsService.readStringValue("im_master_passphrase");
        if (passphrase != null && port != null && ip != null) {
            Session session;
            block19: {
                session = JschSessionFactory.setupSession((String)ip, (int)port, (String)"im_master", null, (String)passphrase, (Logger)logger);
                JSchRCECommandLineExecutor rceExecutor = new JSchRCECommandLineExecutor(session);
                rceExecutor.start(command);
                Throwable throwable = null;
                Object var11_14 = null;
                try {
                    InputStream stdoutStream = rceExecutor.getStdout();
                    try {
                        try (InputStream stderrStream = rceExecutor.getStderr();){
                            TextStreamWatcher stdoutWatcher = TextStreamWatcherFactory.create((InputStream)stdoutStream, (TextOutputReceiver[])new TextOutputReceiver[]{userOutputReceiver});
                            TextStreamWatcher stderrWatcher = TextStreamWatcherFactory.create((InputStream)stderrStream, (TextOutputReceiver[])new TextOutputReceiver[]{userOutputReceiver});
                            stdoutWatcher.start();
                            stderrWatcher.start();
                            rceExecutor.waitForTermination();
                            stdoutWatcher.waitForTermination();
                            stderrWatcher.waitForTermination();
                        }
                        if (stdoutStream == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            session.disconnect();
            userOutputReceiver.addOutput("Finished executing command " + command + ON_INSTANCE + instanceId);
            return;
        }
        userOutputReceiver.addOutput("Could not retrieve password and/or port for instance " + instanceId + ".");
    }

    private Integer getSshPortForInstance(String instanceId) throws IOException, InstanceConfigurationException {
        InstanceConfigurationImpl configOperations;
        if (this.instanceConfigurationsByInstanceId.get(instanceId) == null) {
            ConfigFilesCollection configFiles = this.createConfigFilesCollection(instanceId);
            if (!configFiles.getConfigurationFile().exists()) {
                this.log.warn((Object)("No config file for instance " + instanceId + " exists."));
                return null;
            }
            int profileVersion = this.determineProfileVersion(instanceId);
            configOperations = new InstanceConfigurationImpl(configFiles, profileVersion);
            this.instanceConfigurationsByInstanceId.put(instanceId, configOperations);
        } else {
            configOperations = this.instanceConfigurationsByInstanceId.get(instanceId);
        }
        return configOperations.getSshServerPort();
    }

    private String getSshIpForInstance(String instanceId) throws InstanceConfigurationException {
        InstanceConfigurationImpl configOperations;
        if (this.instanceConfigurationsByInstanceId.get(instanceId) == null) {
            ConfigFilesCollection configFiles = this.createConfigFilesCollection(instanceId);
            if (!configFiles.getConfigurationFile().exists()) {
                this.log.warn((Object)("No config file for instance " + instanceId + " exists."));
                return null;
            }
            int profileVersion = this.determineProfileVersion(instanceId);
            configOperations = new InstanceConfigurationImpl(configFiles, profileVersion);
            this.instanceConfigurationsByInstanceId.put(instanceId, configOperations);
        } else {
            configOperations = this.instanceConfigurationsByInstanceId.get(instanceId);
        }
        return configOperations.getSshServerIp();
    }

    private String getIMMasterInstallationPathAsInstallationId() throws IOException {
        String runningIMInstallationPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        runningIMInstallationPath = runningIMInstallationPath.substring(0, runningIMInstallationPath.lastIndexOf(SLASH));
        runningIMInstallationPath = runningIMInstallationPath.substring(0, runningIMInstallationPath.lastIndexOf(SLASH));
        try {
            runningIMInstallationPath = URLDecoder.decode(runningIMInstallationPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("Failed to decode installation path");
        }
        if (runningIMInstallationPath == null || runningIMInstallationPath.isEmpty()) {
            throw new IOException("Installation path of IM master instance is either null or empty");
        }
        return runningIMInstallationPath;
    }
}

