/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class PersistentSettingsServiceImpl
implements PersistentSettingsService {
    private static final String STORAGE_FILENAME = "settings.json";
    private static final String ERROR_MSG_SAVE = "Could not save persistent settings: ";
    private static final String ERROR_MSG_LOAD = "Could not find persistent settings file. It will be created: ";
    private static final Log LOGGER = LogFactory.getLog(PersistentSettingsServiceImpl.class);
    private ConfigurationService configurationService;
    private File storageDirectory;
    private Map<String, String> store;
    private Set<String> alreadyBackupedFiles = new HashSet<String>();

    @Override
    public synchronized void saveStringValue(String key, String value) {
        this.saveStringValue(key, value, STORAGE_FILENAME);
    }

    private void saveStore(String filename) {
        this.saveAnyMapInGivenStore(this.store, filename);
    }

    @Override
    public synchronized String readStringValue(String key) {
        return this.readStringValue(key, STORAGE_FILENAME);
    }

    private Map<String, String> readStore(String filename) {
        HashMap<String, String> result = new HashMap<String, String>();
        File storeFile = new File(this.storageDirectory, filename);
        if (!storeFile.exists()) {
            try {
                storeFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Could not create new persistent settings file: ", (Throwable)e);
            }
        }
        JsonFactory f = new JsonFactory();
        try {
            JsonParser jp = f.createParser(new File(this.storageDirectory, filename));
            jp.nextToken();
            while (jp.hasCurrentToken() && jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = jp.getCurrentName();
                if (jp.nextToken() == JsonToken.END_OBJECT) break;
                result.put(fieldname, jp.getText());
            }
            jp.close();
        }
        catch (IOException e) {
            result = null;
            LOGGER.warn((Object)"Could not find persistent settings file. It will be created: (This is normal if RCE is starting for the first time) :", (Throwable)e);
        }
        return result;
    }

    @Override
    public synchronized void saveStringValue(String key, String value, String filename) {
        if (this.store != null) {
            this.store.put(key, value);
        } else {
            this.store = this.readStore(filename);
            if (this.store == null) {
                this.store = new HashMap<String, String>();
            }
            this.store.put(key, value);
        }
        this.saveStore(filename);
    }

    @Override
    public synchronized String readStringValue(String key, String filename) {
        this.store = this.readStore(filename);
        if (this.store != null && this.store.containsKey(key)) {
            return this.store.get(key);
        }
        return null;
    }

    @Override
    public synchronized void delete(String key) {
        this.delete(key, STORAGE_FILENAME);
    }

    @Override
    public synchronized void delete(String key, String filename) {
        this.store = this.readStore(filename);
        if (this.store != null) {
            this.store.remove(key);
        }
        this.saveStore(filename);
    }

    protected void activate(BundleContext context) {
        if (this.storageDirectory == null) {
            this.storageDirectory = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA);
            if (!this.storageDirectory.exists()) {
                throw new RuntimeException("Unexpected state: Persistent settings path should exist at this point: " + this.storageDirectory);
            }
        }
        this.alreadyBackupedFiles = new HashSet<String>();
    }

    @Override
    public synchronized Map<String, List<String>> readMapWithStringList(String filename) {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        File f = null;
        f = new File(this.storageDirectory, filename);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        Map<String, List<String>> result = new HashMap<String, List<String>>();
        if (f.exists()) {
            try {
                result = (Map)mapper.readValue(f, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
            }
            catch (IOException e) {
                LOGGER.error((Object)ERROR_MSG_SAVE, (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public synchronized void saveMapWithStringList(Map<String, List<String>> map, String filename) {
        this.saveAnyMapInGivenStore(map, filename);
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    protected void setStorageDirectory(String path) {
        this.storageDirectory = new File(path);
    }

    private void saveAnyMapInGivenStore(Map content, String filenameOfStore) {
        File f = new File(this.storageDirectory, filenameOfStore);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            try {
                File backupFile = new File(this.storageDirectory, String.valueOf(filenameOfStore) + ".bak");
                if (!this.alreadyBackupedFiles.contains(f.getAbsolutePath())) {
                    FileUtils.copyFile((File)f, (File)backupFile);
                    this.alreadyBackupedFiles.add(f.getAbsolutePath());
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"PersistentSettingsService: Could not rename storage file to backup file", (Throwable)e);
            }
        }
        try {
            JsonGenerator jsonGenerator = new JsonFactory().createGenerator(f, JsonEncoding.UTF8);
            JsonUtils.getDefaultObjectMapper().writeValue(jsonGenerator, (Object)content);
        }
        catch (IOException e) {
            LOGGER.error((Object)ERROR_MSG_SAVE, (Throwable)e);
        }
    }
}

