/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class OSHISystemIntegrationAdapter
implements SystemIntegrationAdapter {
    private static final int WAITING_TIME_IN_MS = 1000;
    private static final int MSEC_TO_SEC_FACTOR = 1000;
    private static final long BYTES_TO_MIB_FACTOR = 0x100000L;
    private SystemInfo sysInfo = new SystemInfo();
    private CentralProcessor processor = this.sysInfo.getHardware().getProcessor();
    private OperatingSystem os = this.sysInfo.getOperatingSystem();
    private long cachedTotalSystemRam = this.convertBytesToMiB(this.sysInfo.getHardware().getMemory().getTotal());
    private int selfJavaPid = this.sysInfo.getOperatingSystem().getProcessId();
    private int selfLauncherPid = this.sysInfo.getOperatingSystem().getProcess(this.selfJavaPid).getParentProcessID();
    private volatile double totalCPUUsage = 0.0;
    private ConcurrentHashMap<Integer, Double> cpuUsagePerTask = new ConcurrentHashMap();

    @Override
    public boolean isProvidingActualSystemData() {
        return true;
    }

    @Override
    public long getCachedTotalSystemRam() {
        return this.cachedTotalSystemRam;
    }

    @Override
    public boolean areSelfPidsAndProcessStatesAvailable() {
        return true;
    }

    @Override
    public long getSelfJavaPid() {
        return this.selfJavaPid;
    }

    @Override
    public String getSelfJavaProcessName() {
        return this.os.getProcess(this.selfJavaPid).getName();
    }

    @Override
    public long getSelfLauncherPid() {
        return this.selfLauncherPid;
    }

    @Override
    public String getSelfLauncherProcessName() {
        return this.os.getProcess(this.selfLauncherPid).getName();
    }

    @Override
    public double getTotalCPUUsage() throws OperatingSystemException {
        ConcurrencyUtils.getAsyncTaskService().execute("Calculate total CPU usage", () -> {
            long[] prevTicks = this.processor.getSystemCpuLoadTicks();
            Util.sleep((long)1000L);
            this.totalCPUUsage = this.processor.getSystemCpuLoadBetweenTicks(prevTicks);
        });
        return this.totalCPUUsage;
    }

    @Override
    public double getProcessCPUUsage(Long pid) throws OperatingSystemException {
        Integer processId = Math.toIntExact(pid);
        ConcurrencyUtils.getAsyncTaskService().execute("Calculate CPU usage for pid " + processId, () -> {
            OSProcess process = this.os.getProcess(processId.intValue());
            int cpuNumber = this.processor.getLogicalProcessorCount();
            long previousTime = process.getKernelTime() + process.getUserTime();
            Util.sleep((long)1000L);
            process = this.os.getProcess(Math.toIntExact(pid));
            long currentTime = process.getKernelTime() + process.getUserTime();
            long timeDifference = currentTime - previousTime;
            this.cpuUsagePerTask.put(processId, (double)timeDifference / 1000.0 / (double)cpuNumber);
        });
        return this.cpuUsagePerTask.getOrDefault(processId, 0.0);
    }

    @Override
    public double getReportedCPUIdle() throws OperatingSystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTotalSystemRAM() throws OperatingSystemException {
        return this.getCachedTotalSystemRam();
    }

    @Override
    public long getProcessRAMUsage(Long pid) throws OperatingSystemException {
        OSProcess p;
        if (pid != null && (p = this.os.getProcess(Math.toIntExact(pid))) != null) {
            return p.getResidentSetSize();
        }
        throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
    }

    @Override
    public long getTotalUsedRAM() throws OperatingSystemException {
        return this.getCachedTotalSystemRam() - this.convertBytesToMiB(this.sysInfo.getHardware().getMemory().getAvailable());
    }

    @Override
    public long getFreeRAM() throws OperatingSystemException {
        return this.convertBytesToMiB(this.sysInfo.getHardware().getMemory().getAvailable());
    }

    @Override
    public double getTotalUsedRAMPercentage() throws OperatingSystemException {
        return (double)this.getTotalUsedRAM() / (double)this.getCachedTotalSystemRam();
    }

    @Override
    public double getProcessRAMPercentage(Long pid) throws OperatingSystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Long, String> getProcesses() throws OperatingSystemException {
        HashMap<Long, String> procMap = new HashMap<Long, String>();
        OSProcess[] oSProcessArray = this.sysInfo.getOperatingSystem().getProcesses();
        int n = oSProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            OSProcess process = oSProcessArray[n2];
            procMap.put(Integer.toUnsignedLong(process.getProcessID()), process.getName());
            ++n2;
        }
        return procMap;
    }

    @Override
    public Map<Long, String> getChildProcessesAndIds(Long ppid) throws OperatingSystemException {
        HashMap<Long, String> childMap = new HashMap<Long, String>();
        if (ppid != null) {
            for (ProcessInformation p : this.getFullChildProcessInformation(ppid)) {
                childMap.put(p.getPid(), p.getName());
            }
        }
        return childMap;
    }

    @Override
    public List<ProcessInformation> getFullChildProcessInformation(long pid) throws OperatingSystemException {
        ArrayList<ProcessInformation> children = new ArrayList<ProcessInformation>();
        OSProcess[] oSProcessArray = this.sysInfo.getOperatingSystem().getChildProcesses(Math.toIntExact(pid), 0, null);
        int n = oSProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            OSProcess process = oSProcessArray[n2];
            ProcessInformation p = new ProcessInformation(process.getProcessID(), process.getName(), this.getFullChildProcessInformation(process.getProcessID()), this.getProcessCPUUsage(Long.valueOf(process.getProcessID())), this.getProcessRAMUsage(Long.valueOf(process.getProcessID())));
            children.add(p);
            ++n2;
        }
        return children;
    }

    private long convertBytesToMiB(long valueInByte) {
        return valueInByte / 0x100000L;
    }
}

