/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.executor.properties;

import de.rcenvironment.core.gui.utils.common.EditorsHelper;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.legacy.FileEncodingUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.ui.PartInitException;

public abstract class AbstractEditScriptRunnable
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(AbstractEditScriptRunnable.class);
    private File tempFile;

    @Override
    public void run() {
        try {
            this.tempFile = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename(this.getScriptName());
            if (this.getScript() != null) {
                FileEncodingUtils.saveUnicodeStringToFile((String)this.getScript(), (File)this.tempFile);
            }
            EditorsHelper.openExternalFileInEditor((File)this.tempFile, (Runnable[])new Runnable[]{new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractEditScriptRunnable.this.setScript(FileEncodingUtils.loadUnicodeStringFromFile((File)AbstractEditScriptRunnable.this.tempFile));
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e);
                    }
                }
            }});
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (PartInitException e) {
            LOGGER.error((Object)e);
        }
    }

    public void update(String script) {
        try {
            String current = FileEncodingUtils.loadUnicodeStringFromFile((File)this.tempFile);
            if (!current.equals(script)) {
                FileEncodingUtils.saveUnicodeStringToFile((String)script, (File)this.tempFile);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    protected abstract String getScriptName();

    protected abstract void setScript(String var1);

    protected abstract String getScript();
}

