/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.joiner.gui;

import de.rcenvironment.components.joiner.gui.JoinerAddOrRemoveDynamicEndpointsCommand;
import de.rcenvironment.components.joiner.gui.JoinerEditDynamicEndpointCommand;
import de.rcenvironment.components.joiner.gui.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.EndpointHandlingHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.DefaultEndpointPropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class JoinerInputSection
extends DefaultEndpointPropertySection {
    private static final int MINIMUM_SIZE_CONTROLS = 70;
    private static final int MINIMUM_INPUT_COUNT = 2;
    private static final int MAXIMUM_INPUT_COUNT = 100;
    private Combo dataTypeCombo;
    private Spinner inputCountSpinner;
    private final List<DataType> dataTypesInCombo = new ArrayList<DataType>();
    private final EndpointSelectionPane inputPane = new EndpointSelectionPane(Messages.inputs, EndpointType.INPUT, null, new String[]{"toJoin"}, new String[0], (WorkflowNodeCommand.Executor)this, true);
    private final EndpointSelectionPane outputPane = new EndpointSelectionPane(Messages.outputs, EndpointType.OUTPUT, null, new String[0], new String[]{"Joined"}, (WorkflowNodeCommand.Executor)this, true);
    private boolean disableSectionRefresh = false;

    public JoinerInputSection() {
        this.setPanes(new EndpointSelectionPane[]{this.inputPane, this.outputPane});
    }

    public void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        Section section = aTabbedPropertySheetPage.getWidgetFactory().createSection(this.endpointsComposite, 256);
        section.setText(Messages.joinerConfig);
        GridData sectionData = new GridData(768);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite configurationComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite((Composite)section);
        configurationComposite.setLayout((Layout)new GridLayout(2, false));
        GridData cCompData = new GridData();
        cCompData.horizontalSpan = 2;
        configurationComposite.setLayoutData((Object)cCompData);
        Label dataTypeLabel = new Label(configurationComposite, 0);
        dataTypeLabel.setText(Messages.inputType);
        this.dataTypeCombo = new Combo(configurationComposite, 8);
        this.dataTypeCombo.setData("property.control", (Object)"datatype");
        GridData gridData = new GridData();
        gridData.widthHint = 70;
        this.dataTypeCombo.setLayoutData((Object)gridData);
        this.dataTypeCombo.addSelectionListener((SelectionListener)new DataTypeChangedListener());
        Label inputCountLabel = new Label(configurationComposite, 0);
        inputCountLabel.setText(Messages.inputCount);
        this.inputCountSpinner = new Spinner(configurationComposite, 2048);
        this.inputCountSpinner.setData("property.control", (Object)"inputCount");
        this.inputCountSpinner.setMinimum(2);
        this.inputCountSpinner.setMaximum(100);
        this.inputCountSpinner.addSelectionListener((SelectionListener)new InputCountChangedListener());
        section.moveAbove(this.inputPane.getControl());
        section.setClient((Control)configurationComposite);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.dataTypeCombo.getItemCount() == 0) {
            for (DataType dataType : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDefinition("toJoin").getPossibleDataTypes()) {
                this.dataTypeCombo.add(dataType.getDisplayName());
                this.dataTypesInCombo.add(dataType);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("de.rcenvironment.rce.component.endpoint.ComponentDescriptionsEndpoint") && !this.disableSectionRefresh) {
            this.refreshSection();
        }
    }

    protected WorkflowNodePropertySection.Synchronizer createSynchronizer() {
        return new JoinerWidgetsSynchronizer();
    }

    protected WorkflowNodePropertySection.Updater createUpdater() {
        return new JoinerConfigrationWidgetsUpdater();
    }

    private class DataTypeChangedListener
    implements SelectionListener {
        private DataTypeChangedListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            DataType newDataType = (DataType)JoinerInputSection.this.dataTypesInCombo.get(JoinerInputSection.this.dataTypeCombo.getSelectionIndex());
            EndpointDescription oldInput = JoinerInputSection.this.getConfiguration().getInputDescriptionsManager().getEndpointDescription("Input 001");
            EndpointDescription oldOutput = JoinerInputSection.this.getConfiguration().getOutputDescriptionsManager().getEndpointDescription("Joined");
            if (EndpointHandlingHelper.editEndpointDataType((EndpointType)EndpointType.INPUT, (EndpointDescription)oldInput, (DataType)newDataType) && EndpointHandlingHelper.editEndpointDataType((EndpointType)EndpointType.OUTPUT, (EndpointDescription)oldOutput, (DataType)newDataType)) {
                JoinerInputSection.this.disableSectionRefresh = true;
                JoinerInputSection.this.execute(new JoinerEditDynamicEndpointCommand(newDataType));
                JoinerInputSection.this.disableSectionRefresh = false;
                JoinerInputSection.this.refreshSection();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }

    private class InputCountChangedListener
    implements SelectionListener {
        private InputCountChangedListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            int newCount = JoinerInputSection.this.inputCountSpinner.getSelection();
            if (newCount != JoinerInputSection.this.getInputs().size()) {
                JoinerInputSection.this.disableSectionRefresh = true;
                JoinerInputSection.this.execute(new JoinerAddOrRemoveDynamicEndpointsCommand(newCount));
                JoinerInputSection.this.disableSectionRefresh = false;
                JoinerInputSection.this.refreshSection();
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private class JoinerConfigrationWidgetsUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        private JoinerConfigrationWidgetsUpdater() {
            super((WorkflowNodePropertySection)JoinerInputSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("datatype") && newValue != null) {
                JoinerInputSection.this.dataTypeCombo.select(JoinerInputSection.this.dataTypesInCombo.indexOf(DataType.valueOf((String)newValue)));
            } else {
                super.updateControl(control, propertyName, newValue, oldValue);
            }
        }
    }

    private class JoinerWidgetsSynchronizer
    extends WorkflowNodePropertySection.DefaultSynchronizer {
        private JoinerWidgetsSynchronizer() {
            super((WorkflowNodePropertySection)JoinerInputSection.this);
        }

        protected void handlePropertyChange(Control control, String key, String newValue, String oldValue) {
            if (key.equals("datatype")) {
                JoinerInputSection.this.dataTypeCombo.select(JoinerInputSection.this.dataTypesInCombo.indexOf(DataType.valueOf((String)newValue)));
                JoinerInputSection.this.inputPane.refresh();
                JoinerInputSection.this.outputPane.refresh();
                return;
            }
            if (key.equals("inputCount")) {
                JoinerInputSection.this.inputPane.refresh();
            }
            super.handlePropertyChange(control, key, newValue, oldValue);
        }
    }
}

