/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.WritableConfigurationSegment;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.api.SshAccountConfigurationService;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mindrot.jbcrypt.BCrypt;

public class SshAccountConfigurationServiceImpl
implements SshAccountConfigurationService {
    private static final String CONFIGURATION_PATH_SEPARATOR = "/";
    private static final String MAIN_SSH_CONFIGURATION_PATH = "sshServer";
    private static final String SSH_ACCOUNTS_SUB_CONFIGURATION_PATH = "accounts";
    private static final String ACCOUNT_ROLES_RA_SUB_CONFIGURATION_PATH = "roles/remote access";
    private static final String FIELD_NAME_PASSWORD = "password";
    private static final String FIELD_NAME_ENABLED = "enabled";
    private static final String FIELD_NAME_PW_HASH = "passwordHash";
    private static final String FIELD_NAME_ROLE = "role";
    private static final String DEFAULT_RA_ROLE_COMMAND_PATTERN = "ra .+";
    private static final String EXPECTED_RA_ROLE_ALLOWED_COMMAND_PATTERN_REGEXP = "help|exit|(ra .+)";
    private static final String VALID_ACCOUNT_NAME_REGEXP = "^[a-zA-Z][a-zA-Z0-9_\\-]*$";
    private static final String VALID_ACCOUNT_NAME_VIOLATION_MESSAGE = "The login name must begin with a letter, followed by letters, digits, or the characters \"_\" and \"-\".";
    private static final int MAX_LOGIN_NAME_LENGTH = 20;
    private static final String LOGIN_NAME_TOO_LONG_MESSAGE = "The login name must not be longer than 20 characters";
    private ConfigurationService configurationService;
    private SshConfiguration sshConfiguration;
    private SshAuthenticationManager sshAuthenticationManager;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public String verifyExpectedStateForConfigurationEditing() {
        if (!this.configurationService.isUsingIntendedProfileDirectory()) {
            return "This configuration mode does not seem to run in the intended profile directory  - is the profile being used by another RCE instance?\n\nIntended profile location: " + this.configurationService.getOriginalProfileDirectory().getAbsolutePath();
        }
        if (this.configurationService.isUsingDefaultConfigurationValues()) {
            return "The current configuration file is either invalid, or there was an error creating it. Please check the file for errors. If the file does not exist, make sure you have write access to the containing directory.\n\nIntended configuration file location: " + this.configurationService.getProfileConfigurationFile().getAbsolutePath();
        }
        ConfigurationSegment sshConfigurationSegment = this.loadSshConfigurationSegment();
        try {
            this.readAsParsedConfigurationData(sshConfigurationSegment);
        }
        catch (ConfigurationException e) {
            return "Error reading SSH account data: " + e.getMessage();
        }
        if (!sshConfigurationSegment.isPresentInCurrentConfiguration()) {
            return null;
        }
        return null;
    }

    @Override
    public SortedMap<String, SshAccount> getAllAccountsByLoginName() throws ConfigurationException {
        return this.sshAuthenticationManager.getAllAcountsByLoginName();
    }

    @Override
    public SshAccount getAccount(String account) {
        return this.sshAuthenticationManager.getAccountByLoginName(account, true);
    }

    @Override
    public void createAccount(String loginName, String password) throws ConfigurationException {
        if (StringUtils.isNullorEmpty((String)loginName)) {
            throw new ConfigurationException("The login name must not be empty!");
        }
        if (this.getAccount(loginName) != null) {
            throw new ConfigurationException("An account with this login name already exists.");
        }
        this.validateLoginName(loginName);
        if (StringUtils.isNullorEmpty((String)password)) {
            throw new ConfigurationException("The password must not be empty!");
        }
        String passwordHash = this.generatePasswordHash(password);
        WritableConfigurationSegment accountsSegment = this.getWritableConfigurationSegmentForAccountsList();
        try {
            WritableConfigurationSegment accountElement = accountsSegment.createElement(loginName);
            accountElement.setString(FIELD_NAME_PW_HASH, passwordHash);
            accountElement.setString(FIELD_NAME_ROLE, "remote_access_user");
            accountElement.setBoolean(FIELD_NAME_ENABLED, true);
        }
        catch (ConfigurationException e) {
            this.log.error((Object)"Failed to add SSH account", (Throwable)e);
            throw new ConfigurationException("Failed to add the new account; most likely, there is already an account with that login name");
        }
        this.writeConfigurationChanges();
        this.log.debug((Object)StringUtils.format((String)"Created SSH account '%s' (using password hash authentication)", (Object[])new Object[]{loginName}));
    }

    @Override
    public void updatePasswordHash(String loginName, String plainTextPassword) throws ConfigurationException {
        WritableConfigurationSegment accountSegment = this.getWritableSegmentForAccount(loginName);
        accountSegment.setString(FIELD_NAME_PW_HASH, this.generatePasswordHash(plainTextPassword));
        if (accountSegment.getString(FIELD_NAME_PASSWORD) != null) {
            accountSegment.setString(FIELD_NAME_PASSWORD, null);
        }
        this.writeConfigurationChanges();
        this.log.debug((Object)StringUtils.format((String)"Updated password hash for SSH account '%s'", (Object[])new Object[]{loginName}));
    }

    @Override
    public void updateRole(String loginName, String role) throws ConfigurationException {
        WritableConfigurationSegment accountSegment = this.getWritableSegmentForAccount(loginName);
        accountSegment.setString(FIELD_NAME_ROLE, role);
        this.writeConfigurationChanges();
        this.log.debug((Object)StringUtils.format((String)"Set role for SSH account '%s' to '%s'", (Object[])new Object[]{loginName, role}));
    }

    @Override
    public void setAccountEnabled(String loginName, boolean enabled) throws ConfigurationException {
        WritableConfigurationSegment accountSegment = this.getWritableSegmentForAccount(loginName);
        accountSegment.setBoolean(FIELD_NAME_ENABLED, enabled);
        this.writeConfigurationChanges();
        this.log.debug((Object)StringUtils.format((String)"Set SSH account '%s' to enabled=%s", (Object[])new Object[]{loginName, enabled}));
    }

    @Override
    public void deleteAccount(String loginName) throws ConfigurationException {
        WritableConfigurationSegment accountsSegment = this.getWritableConfigurationSegmentForAccountsList();
        if (!accountsSegment.deleteElement(loginName)) {
            throw new ConfigurationException("Internal consistency error: Requested account deletion, but no matching configuration node was found");
        }
        this.writeConfigurationChanges();
        this.log.debug((Object)StringUtils.format((String)"SSH account '%s' deleted", (Object[])new Object[]{loginName}));
    }

    @Override
    public String generatePasswordHash(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)10));
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    protected ConfigurationSegment loadSshConfigurationSegment() {
        return this.configurationService.getConfigurationSegment(MAIN_SSH_CONFIGURATION_PATH);
    }

    private void readAsParsedConfigurationData(ConfigurationSegment sshConfigurationSegment) throws ConfigurationException {
        try {
            this.sshConfiguration = new SshConfiguration(sshConfigurationSegment);
            this.sshAuthenticationManager = new SshAuthenticationManager(this.sshConfiguration);
        }
        catch (ConfigurationException | IOException e) {
            throw new ConfigurationException("Error reading SSH configuration data: " + e.getMessage());
        }
    }

    private void reloadConfiguration() throws ConfigurationException {
        this.readAsParsedConfigurationData(this.loadSshConfigurationSegment());
    }

    private WritableConfigurationSegment getWritableConfigurationSegmentAndWrapErrors(String path) throws ConfigurationException {
        WritableConfigurationSegment segment;
        try {
            segment = this.configurationService.getOrCreateWritableConfigurationSegment(path);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Failed to access configuration data: " + e.getMessage());
        }
        return segment;
    }

    private WritableConfigurationSegment getWritableConfigurationSegmentForAccountsList() throws ConfigurationException {
        WritableConfigurationSegment accountsSegment = this.getWritableConfigurationSegmentAndWrapErrors("sshServer/accounts");
        return accountsSegment;
    }

    private WritableConfigurationSegment getWritableSegmentForAccount(String loginName) throws ConfigurationException {
        WritableConfigurationSegment accountSegment = this.getWritableConfigurationSegmentAndWrapErrors("sshServer/accounts/" + loginName);
        return accountSegment;
    }

    private void writeConfigurationChanges() throws ConfigurationException {
        try {
            try {
                this.configurationService.writeConfigurationChanges();
            }
            catch (IOException e) {
                throw new ConfigurationException("There was an error writing the configuration changes to the profile folder: " + e.getMessage());
            }
        }
        finally {
            this.reloadConfiguration();
        }
    }

    private void validateLoginName(String loginName) throws ConfigurationException {
        if (!loginName.matches(VALID_ACCOUNT_NAME_REGEXP)) {
            throw new ConfigurationException(VALID_ACCOUNT_NAME_VIOLATION_MESSAGE);
        }
        if (loginName.length() > 20) {
            throw new ConfigurationException(LOGIN_NAME_TOO_LONG_MESSAGE);
        }
    }
}

