/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.embedded.ssh.api.SshAccountConfigurationService;
import de.rcenvironment.toolkit.utils.common.IdGenerator;
import de.rcenvironment.toolkit.utils.common.IdGeneratorType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class KeyToolCommandPlugin
implements CommandPlugin {
    private static final String SUBCMD_SSH_PW = "ssh-pw";
    private static final String SUBCMD_UPLINK_PW = "uplink-pw";
    private static final String MAIN_CMD = "keytool";
    private static final int GENERATED_PASSWORD_LENGTH = 14;
    @Reference
    private SshAccountConfigurationService sshAccountService;

    public MainCommandDescription[] getCommands() {
        MainCommandDescription keytoolCommands = new MainCommandDescription(MAIN_CMD, "commands for ssh passwords", "commands for ssh passwords", new SubCommandDescription[]{new SubCommandDescription(SUBCMD_SSH_PW, "generates a password for an SSH or Uplink connection, and the corresponding server entry", this::performGenerateSshOrUplinkPw), new SubCommandDescription(SUBCMD_UPLINK_PW, "generates a password for an SSH or Uplink connection, and the corresponding server entry", this::performGenerateSshOrUplinkPw)});
        return new MainCommandDescription[]{keytoolCommands};
    }

    private void performGenerateSshOrUplinkPw(CommandContext context) {
        String password = IdGenerator.createRandomBase64UrlString((int)28, (IdGeneratorType)IdGeneratorType.SECURE);
        password = password.replaceAll("[-_]", "").substring(0, 14);
        context.println((Object)"The generated password (keep this confidential):");
        context.println((Object)password);
        context.println((Object)"The password hash (send this to the server's administrator):");
        context.println((Object)this.sshAccountService.generatePasswordHash(password));
    }
}

