/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSessionService;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.embedded.ssh.api.EmbeddedSshServerControl;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.embedded.ssh.internal.CustomSshCommandFactory;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ShellFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class EmbeddedSshServerImpl
implements EmbeddedSshServerControl {
    private static final String HOST_KEY_STORAGE_FILE_NAME = "ssh_host_key.dat";
    private ConfigurationService configurationService;
    private CommandExecutionService commandExecutionService;
    private SshConfiguration sshConfiguration;
    private File hostKeyStorageDirectory;
    private ScpContextManager scpContextManager;
    private ServerSideUplinkSessionService uplinkSessionService;
    private SshServer sshd;
    private boolean sshServerActive = false;
    private boolean sshServerRunning = false;
    private final Map<String, String> announcedVersionEntries = new HashMap<String, String>();
    private final Log logger = LogFactory.getLog(this.getClass());

    @Activate
    public void activate() {
        if (!CommandLineArguments.isConfigurationShellRequested()) {
            ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("sshServer");
            try {
                this.sshConfiguration = new SshConfiguration(configurationSegment);
            }
            catch (ConfigurationException | IOException e) {
                this.sshConfiguration = new SshConfiguration();
                this.logger.error((Object)e.getMessage());
            }
            this.hostKeyStorageDirectory = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA);
            ConcurrencyUtils.getAsyncTaskService().execute("Embedded SSH server startup", this::performStartup);
        }
    }

    public void mockActivateAndStart(SshConfiguration configuration, File hostKeyStorageDir, ServerSideUplinkSessionService serverSideUplinkSessionService) {
        this.sshConfiguration = configuration;
        this.hostKeyStorageDirectory = hostKeyStorageDir;
        this.uplinkSessionService = serverSideUplinkSessionService;
        this.performStartup();
    }

    public boolean isRunning() {
        return this.sshServerRunning;
    }

    @Deactivate
    public void deactivate() {
        this.performShutdown();
    }

    @Override
    public synchronized void setAnnouncedVersionOrProperty(String key, String value) {
        this.announcedVersionEntries.put(key, value);
        if (this.sshServerActive) {
            this.updateServerBannerWithAnnouncementData();
        }
    }

    private synchronized void performStartup() {
        this.sshServerActive = this.getActivationSettingFromConfig(this.sshConfiguration);
        if (this.sshServerActive) {
            SshAuthenticationManager authenticationManager = new SshAuthenticationManager(this.sshConfiguration);
            this.sshd = SshServer.setUpDefaultServer();
            this.updateServerBannerWithAnnouncementData();
            this.sshd.setPasswordAuthenticator((PasswordAuthenticator)authenticationManager);
            this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)authenticationManager);
            Path hostKeyFilePath = new File(this.hostKeyStorageDirectory, HOST_KEY_STORAGE_FILE_NAME).getAbsoluteFile().toPath();
            this.logger.debug((Object)("Using SSH server key storage " + hostKeyFilePath));
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(hostKeyFilePath));
            this.sshd.setHost(this.sshConfiguration.getHost());
            this.sshd.setPort(this.sshConfiguration.getPort());
            this.logger.debug((Object)("Configuring SSH session idle timeout of " + this.sshConfiguration.getIdleTimeoutSeconds() + " seconds"));
            this.sshd.getProperties().put("idle-timeout", TimeUnit.SECONDS.toMillis(this.sshConfiguration.getIdleTimeoutSeconds().intValue()));
            this.sshd.setShellFactory((ShellFactory)new CustomSshCommandFactory(authenticationManager, this.scpContextManager, this.commandExecutionService, this.uplinkSessionService, this.sshConfiguration));
            this.sshd.setCommandFactory((CommandFactory)new CustomSshCommandFactory(authenticationManager, this.scpContextManager, this.commandExecutionService, this.uplinkSessionService, this.sshConfiguration));
            try {
                this.sshd.start();
                this.logger.info((Object)StringUtils.format((String)"SSH server started on port %s (bound to IP %s)", (Object[])new Object[]{this.sshConfiguration.getPort(), this.sshConfiguration.getHost()}));
                this.sshServerRunning = true;
            }
            catch (IOException e) {
                this.logger.error((Object)StringUtils.format((String)"Failed to start embedded SSH server on port %s (attempted to bind to IP address %s)", (Object[])new Object[]{this.sshConfiguration.getPort(), this.sshConfiguration.getHost()}), (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"Not running an SSH server as there is either no SSH configuration at all, or the \"enabled\" property is not \"true\", or the configuration data (including account settings) has errors");
        }
    }

    private synchronized void performShutdown() {
        this.sshServerActive = false;
        this.sshServerRunning = false;
        if (this.sshd != null) {
            try {
                this.sshd.stop(true);
                this.logger.debug((Object)"Embedded SSH server shut down");
            }
            catch (IOException e) {
                this.logger.error((Object)"Exception during shutdown of embedded SSH server", (Throwable)e);
            }
        }
    }

    private void updateServerBannerWithAnnouncementData() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RCE");
        for (Map.Entry<String, String> entry : this.announcedVersionEntries.entrySet()) {
            buffer.append(" ");
            buffer.append(entry.getKey());
            buffer.append("/");
            buffer.append(entry.getValue());
        }
        this.sshd.getProperties().put("server-identification", buffer.toString());
    }

    private boolean getActivationSettingFromConfig(SshConfiguration currentConfig) {
        boolean result = false;
        if (currentConfig != null && currentConfig.isEnabled()) {
            result = currentConfig.validateConfiguration(this.logger);
        }
        return result;
    }

    @Reference
    protected void bindScpContextManager(ScpContextManager newInstance) {
        this.scpContextManager = newInstance;
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    @Reference
    protected void bindCommandExecutionService(CommandExecutionService newInstance) {
        this.commandExecutionService = newInstance;
    }

    @Reference
    protected void bindServerSideUplinkSessionService(ServerSideUplinkSessionService newInstance) {
        this.uplinkSessionService = newInstance;
    }
}

