/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.AbstractWorkflowLabelCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowLabelCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowPropertySection;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.utils.common.OSFamily;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkflowLabelPropertySection
extends WorkflowPropertySection
implements WorkflowLabelCommand.Executor {
    private static final int HORIZONTAL_SPACING = 20;
    private static final int COLORSELECTOROFFSET_X = 50;
    private static final int COLORSELECTOROFFSET_Y = 200;
    private static final int ALPHA_TEXT_WIDTH = 25;
    private static final String TABS = "     ";
    private static final int MAX_255 = 255;
    private static final int MAX_100 = 100;
    private static final double SCALE_TO_PERCENT_FACTOR = 2.55;
    private static final String COLOR = "Color:";
    private WorkflowLabel label;
    private StyledText headerTextField;
    private StyledText textfield;
    private Button[] labelPositionButtons;
    private Button[] headerAlignmentButtons;
    private Button[] textAlignmentButtons;
    private WorkflowLabel.LabelPosition[] values;
    private Label headerColorPreviewLabel;
    private Label textColorPreviewLabel;
    private Spinner headerSizeSpinner;
    private Spinner textSizeSpinner;
    private Label bgColorPreviewLabel;
    private Scale bgAlphaScale;
    private Text bgAlphaValueText;
    private Button bgBorderButton;
    private EditValueCommand editTextCommand;
    private EditValueCommand editTransparencyCommand;
    private final Updater updater = this.createUpdater();
    private final Synchronizer synchronizer = this.createSynchronizer();
    private final SynchronizerAdapter synchronizerAdapter = new SynchronizerAdapter();

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object firstSelectionElement = ((IStructuredSelection)selection).getFirstElement();
        WorkflowLabelPart workflowLabelPart = (WorkflowLabelPart)firstSelectionElement;
        WorkflowLabel workflowLabel = (WorkflowLabel)workflowLabelPart.getModel();
        if (this.getPart() == null || !this.getPart().equals(part) || this.label == null || !this.label.equals(workflowLabel)) {
            super.setInput(part, selection);
            this.setWorkflowLabelBase(workflowLabel);
            this.updateLabelPositionSelection(this.label.getLabelPosition());
            this.updateAlignmentButtonsSelection(this.headerAlignmentButtons, this.label.getHeaderAlignmentType());
            this.updateAlignmentButtonsSelection(this.textAlignmentButtons, this.label.getTextAlignmentType());
            if (this.headerTextField != null && !this.headerTextField.isDisposed()) {
                this.headerTextField.setText(workflowLabel.getHeaderText());
                this.headerTextField.setSelection(this.headerTextField.getText().length());
                this.headerColorPreviewLabel.setBackground(WorkflowLabelPropertySection.createColor(this.label.getColorHeader()));
                this.headerSizeSpinner.setSelection(this.label.getHeaderTextSize());
                this.headerAlignmentButtons[this.label.getHeaderAlignmentType().ordinal()].setSelection(true);
            }
            if (this.textfield != null && !this.textfield.isDisposed()) {
                this.textfield.setText(workflowLabel.getText());
                this.textColorPreviewLabel.setBackground(WorkflowLabelPropertySection.createColor(this.label.getColorText()));
                this.textSizeSpinner.setSelection(this.label.getTextSize());
                this.textAlignmentButtons[this.label.getTextAlignmentType().ordinal()].setSelection(true);
                this.bgColorPreviewLabel.setBackground(WorkflowLabelPropertySection.createColor(this.label.getColorBackground()));
                this.bgAlphaScale.setSelection(this.label.getAlphaDisplay());
                this.bgAlphaValueText.setText("" + (int)Math.ceil((double)this.label.getAlphaDisplay() / 2.55));
                this.bgBorderButton.setSelection(this.label.hasBorder());
            }
        }
    }

    private static Color createColor(int[] color) {
        return new Color((Device)Display.getCurrent(), color[0], color[1], color[2]);
    }

    private void setWorkflowLabelBase(WorkflowLabel workflowLabel) {
        this.label = workflowLabel;
        this.initializeModelBindingBase();
    }

    protected final Updater getUpdater() {
        return this.updater;
    }

    protected Updater createUpdater() {
        return new DefaultUpdater();
    }

    protected Synchronizer createSynchronizer() {
        return new DefaultSynchronizer();
    }

    public void dispose() {
        this.tearDownModelBindingBase();
        super.dispose();
    }

    private void initializeModelBindingBase() {
        this.label.addPropertyChangeListener((PropertyChangeListener)this.synchronizerAdapter);
    }

    private void tearDownModelBindingBase() {
        this.label.removePropertyChangeListener((PropertyChangeListener)this.synchronizerAdapter);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        GridData mGridData = new GridData(1808);
        mGridData.grabExcessHorizontalSpace = true;
        mGridData.grabExcessVerticalSpace = true;
        mGridData.horizontalAlignment = 4;
        parent.setLayoutData((Object)mGridData);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createHeaderSection(aTabbedPropertySheetPage, parent);
        this.createBackgroundSection(aTabbedPropertySheetPage, parent);
        Composite composite = new Composite(parent, 0);
        GridData cData = new GridData();
        cData.horizontalSpan = 2;
        cData.grabExcessHorizontalSpace = false;
        cData.grabExcessVerticalSpace = true;
        cData.horizontalAlignment = 4;
        cData.verticalAlignment = 4;
        composite.setLayoutData((Object)cData);
        GridLayout mainLayout = new GridLayout(4, false);
        mainLayout.marginTop = 0;
        mainLayout.marginLeft = 0;
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        composite.setLayout((Layout)mainLayout);
        this.createTextSection(aTabbedPropertySheetPage, composite);
        this.createPositionSection(aTabbedPropertySheetPage, composite);
    }

    private void createHeaderSection(TabbedPropertySheetPage tabbedPropertySheetPage, Composite parent) {
        Section headerPropertiesSection = tabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        GridData hGridData = new GridData(1808);
        hGridData.horizontalSpan = 1;
        hGridData.grabExcessHorizontalSpace = true;
        hGridData.grabExcessVerticalSpace = false;
        headerPropertiesSection.setLayoutData((Object)hGridData);
        headerPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        headerPropertiesSection.setText("Header");
        Composite headerPropertiesComposite = tabbedPropertySheetPage.getWidgetFactory().createComposite((Composite)headerPropertiesSection);
        GridData hPGridData = new GridData(772);
        hPGridData.horizontalSpan = 2;
        headerPropertiesComposite.setLayout((Layout)new GridLayout(4, false));
        headerPropertiesComposite.setLayoutData((Object)hPGridData);
        headerPropertiesSection.setClient((Control)headerPropertiesComposite);
        this.headerTextField = new StyledText(headerPropertiesComposite, 2052);
        GridData headerTextData = new GridData(772);
        this.headerTextField.setLayoutData((Object)headerTextData);
        this.headerTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String oldValue = WorkflowLabelPropertySection.this.label.getHeaderText();
                String newValue = WorkflowLabelPropertySection.this.headerTextField.getText();
                if (!newValue.equals(oldValue)) {
                    int position = WorkflowLabelPropertySection.this.headerTextField.getCaretOffset();
                    if (WorkflowLabelPropertySection.this.editTextCommand == null) {
                        WorkflowLabelPropertySection.this.editTextCommand = WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.HEADER_TEXT, oldValue), new Value(Value.ValueType.HEADER_TEXT, newValue));
                    } else {
                        WorkflowLabelPropertySection.this.editTextCommand.setNewValue(new Value(Value.ValueType.HEADER_TEXT, newValue));
                    }
                    WorkflowLabelPropertySection.this.headerTextField.setCaretOffset(position);
                }
            }
        });
        this.headerTextField.addKeyListener((KeyListener)new TextKeyListener());
        this.headerTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
            }

            public void focusLost(FocusEvent arg0) {
                WorkflowLabelPropertySection.this.editTextCommand = null;
                WorkflowLabelPropertySection.this.headerTextField.setSelection(0);
            }
        });
        Composite textColorSizePropertiesComposite = new Composite(headerPropertiesComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 20;
        textColorSizePropertiesComposite.setLayout((Layout)gridLayout);
        textColorSizePropertiesComposite.setBackground(Display.getDefault().getSystemColor(1));
        GridData g2 = new GridData();
        g2.horizontalSpan = 1;
        textColorSizePropertiesComposite.setLayoutData((Object)g2);
        Composite textColorComposite = new Composite(textColorSizePropertiesComposite, 0);
        textColorComposite.setLayout((Layout)new GridLayout(2, false));
        textColorComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label textColorLabel = new Label(textColorComposite, 0);
        textColorLabel.setText(COLOR);
        textColorLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.headerColorPreviewLabel = new Label(textColorComposite, 2048);
        this.headerColorPreviewLabel.setText(TABS);
        this.headerColorPreviewLabel.addMouseListener((MouseListener)new ColorMouseListener(Value.ValueType.COLOR_HEADER));
        Composite textSizeComposite = new Composite(textColorSizePropertiesComposite, 0);
        textSizeComposite.setLayout((Layout)new GridLayout(2, false));
        textSizeComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label textSizeLabel = new Label(textSizeComposite, 0);
        textSizeLabel.setText("Size:");
        textSizeLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.headerSizeSpinner = new Spinner(textSizeComposite, 2048);
        this.headerSizeSpinner.setMinimum(1);
        this.headerSizeSpinner.setMaximum(99);
        this.headerSizeSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int oldValue = WorkflowLabelPropertySection.this.label.getHeaderTextSize();
                int newValue = WorkflowLabelPropertySection.this.headerSizeSpinner.getSelection();
                if (newValue != oldValue) {
                    WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.HEADER_SIZE, oldValue), new Value(Value.ValueType.HEADER_SIZE, newValue));
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.headerAlignmentButtons = new Button[3];
        this.addHeaderAlignmentGroup(headerPropertiesComposite);
    }

    private void createTextSection(TabbedPropertySheetPage tabbedPropertySheetPage, Composite parent) {
        Section textPropertiesSection = tabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        GridData tGridData = new GridData(1808);
        tGridData.horizontalSpan = 3;
        tGridData.grabExcessHorizontalSpace = true;
        tGridData.grabExcessVerticalSpace = true;
        textPropertiesSection.setLayoutData((Object)tGridData);
        textPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        textPropertiesSection.setText("Text");
        Composite textPropertiesComposite = tabbedPropertySheetPage.getWidgetFactory().createComposite((Composite)textPropertiesSection, 0);
        GridData tPGridData = new GridData(1808);
        tPGridData.horizontalSpan = 1;
        tPGridData.grabExcessHorizontalSpace = true;
        tPGridData.grabExcessVerticalSpace = true;
        tPGridData.horizontalAlignment = 4;
        tPGridData.verticalAlignment = 4;
        textPropertiesComposite.setLayoutData((Object)tPGridData);
        textPropertiesComposite.setLayout((Layout)new GridLayout(3, false));
        textPropertiesSection.setClient((Control)textPropertiesComposite);
        this.textfield = new StyledText(textPropertiesComposite, 2626);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.grabExcessVerticalSpace = true;
        textData.horizontalAlignment = 4;
        textData.verticalAlignment = 4;
        textData.minimumWidth = 1;
        textData.widthHint = 1;
        textData.heightHint = 1;
        textData.minimumHeight = 1;
        this.textfield.setLayoutData((Object)textData);
        this.textfield.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String oldValue = WorkflowLabelPropertySection.this.label.getText();
                String newValue = WorkflowLabelPropertySection.this.textfield.getText();
                if (!newValue.equals(oldValue)) {
                    int position = WorkflowLabelPropertySection.this.textfield.getCaretOffset();
                    if (WorkflowLabelPropertySection.this.editTextCommand == null) {
                        WorkflowLabelPropertySection.this.editTextCommand = WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.TEXT, oldValue), new Value(Value.ValueType.TEXT, newValue));
                    } else {
                        WorkflowLabelPropertySection.this.editTextCommand.setNewValue(new Value(Value.ValueType.TEXT, newValue));
                    }
                    WorkflowLabelPropertySection.this.textfield.setCaretOffset(position);
                }
            }
        });
        this.textfield.addKeyListener((KeyListener)new TextKeyListener());
        this.textfield.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                WorkflowLabelPropertySection.this.editTextCommand = null;
                WorkflowLabelPropertySection.this.textfield.setSelection(0);
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        Composite textColorSizePropertiesComposite = new Composite(textPropertiesComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 20;
        textColorSizePropertiesComposite.setLayout((Layout)gridLayout);
        textColorSizePropertiesComposite.setBackground(Display.getDefault().getSystemColor(1));
        GridData g2 = new GridData();
        g2.horizontalSpan = 1;
        g2.verticalAlignment = 1;
        textColorSizePropertiesComposite.setLayoutData((Object)g2);
        Composite textColorComposite = new Composite(textColorSizePropertiesComposite, 0);
        textColorComposite.setLayout((Layout)new GridLayout(2, false));
        textColorComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label textColorLabel = new Label(textColorComposite, 0);
        textColorLabel.setText(COLOR);
        textColorLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.textColorPreviewLabel = new Label(textColorComposite, 2048);
        this.textColorPreviewLabel.setText(TABS);
        this.textColorPreviewLabel.addMouseListener((MouseListener)new ColorMouseListener(Value.ValueType.COLOR_TEXT));
        Composite textSizeComposite = new Composite(textColorSizePropertiesComposite, 0);
        textSizeComposite.setLayout((Layout)new GridLayout(2, false));
        textSizeComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label textSizeLabel = new Label(textSizeComposite, 0);
        textSizeLabel.setText("Size:");
        textSizeLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.textSizeSpinner = new Spinner(textSizeComposite, 2048);
        this.textSizeSpinner.setMinimum(1);
        this.textSizeSpinner.setMaximum(99);
        this.textSizeSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int oldValue = WorkflowLabelPropertySection.this.label.getTextSize();
                int newValue = WorkflowLabelPropertySection.this.textSizeSpinner.getSelection();
                if (newValue != oldValue) {
                    WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.TEXT_SIZE, oldValue), new Value(Value.ValueType.TEXT_SIZE, newValue));
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.textAlignmentButtons = new Button[3];
        this.addTextAlignmentGroup(textPropertiesComposite);
    }

    private void createBackgroundSection(TabbedPropertySheetPage tabbedPropertySheetPage, Composite parent) {
        Section bgPropertiesSection = tabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        bgPropertiesSection.setText("Background");
        GridData sGridData = new GridData();
        sGridData.horizontalSpan = 1;
        sGridData.horizontalAlignment = 128;
        sGridData.verticalAlignment = 32;
        bgPropertiesSection.setLayoutData((Object)sGridData);
        Composite bgPropertiesComposite = tabbedPropertySheetPage.getWidgetFactory().createComposite((Composite)bgPropertiesSection);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 20;
        bgPropertiesComposite.setLayout((Layout)gridLayout);
        bgPropertiesComposite.setLayoutData((Object)new GridData(3856));
        bgPropertiesSection.setClient((Control)bgPropertiesComposite);
        Composite bgColorComposite = new Composite(bgPropertiesComposite, 0);
        bgColorComposite.setLayout((Layout)new GridLayout(2, false));
        bgColorComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label bgColorLabel = new Label(bgColorComposite, 0);
        bgColorLabel.setText(COLOR);
        bgColorLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.bgColorPreviewLabel = new Label(bgColorComposite, 2048);
        this.bgColorPreviewLabel.setText(TABS);
        this.bgColorPreviewLabel.addMouseListener((MouseListener)new ColorMouseListener(Value.ValueType.COLOR_BACKGROUND));
        Composite bgAlphaComposite = new Composite(bgPropertiesComposite, 0);
        bgAlphaComposite.setLayout((Layout)new GridLayout(3, false));
        bgAlphaComposite.setBackground(Display.getDefault().getSystemColor(1));
        Label bgAlphaLabel = new Label(bgAlphaComposite, 0);
        bgAlphaLabel.setText("Transparency:");
        bgAlphaLabel.setBackground(Display.getDefault().getSystemColor(1));
        this.bgAlphaScale = new Scale(bgAlphaComposite, 256);
        this.bgAlphaScale.setMaximum(255);
        this.bgAlphaScale.setMinimum(0);
        this.bgAlphaScale.setBackground(Display.getDefault().getSystemColor(1));
        this.bgAlphaScale.addSelectionListener((SelectionListener)new AplhaSelectionListener());
        this.bgAlphaScale.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                WorkflowLabelPropertySection.this.editTransparencyCommand = null;
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.bgAlphaValueText = new Text(bgAlphaComposite, 0);
        this.bgAlphaValueText.setEditable(false);
        this.bgAlphaValueText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.bgAlphaValueText, 2));
        this.bgAlphaValueText.addModifyListener((ModifyListener)new AlphaValueListener());
        GridData alphaData = new GridData();
        alphaData.widthHint = 25;
        this.bgAlphaValueText.setLayoutData((Object)alphaData);
        this.bgAlphaValueText.setBackground(Display.getDefault().getSystemColor(1));
        this.bgBorderButton = new Button(bgPropertiesComposite, 32);
        this.bgBorderButton.setText("Border");
        this.bgBorderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                boolean oldValue = WorkflowLabelPropertySection.this.label.hasBorder();
                boolean newValue = WorkflowLabelPropertySection.this.bgBorderButton.getSelection();
                if (newValue != oldValue) {
                    WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.BORDER, oldValue), new Value(Value.ValueType.BORDER, newValue));
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    private void createPositionSection(TabbedPropertySheetPage tabbedPropertySheetPage, Composite parent) {
        int[] horizontalAlignment;
        Section positionSection = tabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        GridData positionGridData = new GridData(1040);
        positionGridData.horizontalAlignment = 3;
        positionGridData.grabExcessHorizontalSpace = false;
        positionGridData.grabExcessVerticalSpace = true;
        positionSection.setLayoutData((Object)positionGridData);
        positionSection.setLayout((Layout)new FillLayout());
        positionSection.setText("Text Position");
        Composite positionPropertiesComposite = tabbedPropertySheetPage.getWidgetFactory().createComposite((Composite)positionSection);
        positionPropertiesComposite.setLayout((Layout)new GridLayout(1, false));
        positionSection.setClient((Control)positionPropertiesComposite);
        Group positionGroup = new Group(positionPropertiesComposite, 4);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        positionGroup.setLayout((Layout)gridLayout);
        GridData groupGridData = new GridData();
        groupGridData.verticalAlignment = 1;
        groupGridData.grabExcessHorizontalSpace = true;
        positionGroup.setLayoutData((Object)groupGridData);
        int[] verticalAlignment = horizontalAlignment = new int[]{1, 2, 3};
        this.labelPositionButtons = new Button[9];
        this.values = WorkflowLabel.LabelPosition.values();
        int buttonIndex = 0;
        int j = 0;
        while (j < verticalAlignment.length) {
            int i = 0;
            while (i < horizontalAlignment.length) {
                this.labelPositionButtons[buttonIndex] = new Button((Composite)positionGroup, 16);
                GridData gridData = new GridData(horizontalAlignment[i], verticalAlignment[j], true, true, 1, 1);
                this.labelPositionButtons[buttonIndex].setLayoutData((Object)gridData);
                this.labelPositionButtons[buttonIndex].addSelectionListener((SelectionListener)new PositionSelectionListener(this.values[buttonIndex]));
                ++buttonIndex;
                ++i;
            }
            ++j;
        }
    }

    private void addHeaderAlignmentGroup(Composite parent) {
        Group alignmentGroup = new Group(parent, 4);
        alignmentGroup.setText(Messages.textAlignment);
        alignmentGroup.setLayout((Layout)new GridLayout(3, true));
        Button leftAlignment = new Button((Composite)alignmentGroup, 16400);
        leftAlignment.setLayoutData((Object)new GridData(16384, 4, true, true, 1, 1));
        leftAlignment.addSelectionListener((SelectionListener)new TextAlignmentSelectionListener(Value.ValueType.HEADER_ALIGNMENT, WorkflowLabel.TextAlignmentType.LEFT));
        this.headerAlignmentButtons[0] = leftAlignment;
        Button centerAlignment = new Button((Composite)alignmentGroup, 0x1000010);
        centerAlignment.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 1, 1));
        centerAlignment.addSelectionListener((SelectionListener)new TextAlignmentSelectionListener(Value.ValueType.HEADER_ALIGNMENT, WorkflowLabel.TextAlignmentType.CENTER));
        this.headerAlignmentButtons[1] = centerAlignment;
        Button rightAlignment = new Button((Composite)alignmentGroup, 131088);
        rightAlignment.setLayoutData((Object)new GridData(131072, 4, true, true, 1, 1));
        rightAlignment.addSelectionListener((SelectionListener)new TextAlignmentSelectionListener(Value.ValueType.HEADER_ALIGNMENT, WorkflowLabel.TextAlignmentType.RIGHT));
        this.headerAlignmentButtons[2] = rightAlignment;
    }

    private void addTextAlignmentGroup(Composite parent) {
        Group alignmentGroup = new Group(parent, 4);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        alignmentGroup.setText(Messages.textAlignment);
        alignmentGroup.setLayoutData((Object)gridData);
        alignmentGroup.setLayout((Layout)new GridLayout(3, true));
        Button leftAlignment = new Button((Composite)alignmentGroup, 16400);
        leftAlignment.setLayoutData((Object)new GridData(16384, 4, true, true, 1, 1));
        leftAlignment.addSelectionListener((SelectionListener)new TextAlignmentSelectionListener(Value.ValueType.TEXT_ALIGNMENT, WorkflowLabel.TextAlignmentType.LEFT));
        this.textAlignmentButtons[0] = leftAlignment;
        Button centerAlignment = new Button((Composite)alignmentGroup, 0x1000010);
        centerAlignment.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 1, 1));
        centerAlignment.addSelectionListener((SelectionListener)new TextAlignmentSelectionListener(Value.ValueType.TEXT_ALIGNMENT, WorkflowLabel.TextAlignmentType.CENTER));
        this.textAlignmentButtons[1] = centerAlignment;
        Button rightAlignment = new Button((Composite)alignmentGroup, 131088);
        rightAlignment.setLayoutData((Object)new GridData(131072, 4, true, true, 1, 1));
        rightAlignment.addSelectionListener((SelectionListener)new TextAlignmentSelectionListener(Value.ValueType.TEXT_ALIGNMENT, WorkflowLabel.TextAlignmentType.RIGHT));
        this.textAlignmentButtons[2] = rightAlignment;
    }

    private void updateLabelPositionSelection(WorkflowLabel.LabelPosition labelPosition) {
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i].equals((Object)labelPosition)) {
                this.labelPositionButtons[i].setSelection(true);
            } else {
                this.labelPositionButtons[i].setSelection(false);
            }
            ++i;
        }
    }

    private void updateAlignmentButtonsSelection(Button[] buttonList, WorkflowLabel.TextAlignmentType textAlignmentType) {
        if (buttonList == null) {
            return;
        }
        switch (textAlignmentType) {
            case LEFT: {
                buttonList[0].setSelection(true);
                buttonList[1].setSelection(false);
                buttonList[2].setSelection(false);
                break;
            }
            case CENTER: {
                buttonList[0].setSelection(false);
                buttonList[1].setSelection(true);
                buttonList[2].setSelection(false);
                break;
            }
            case RIGHT: {
                buttonList[0].setSelection(false);
                buttonList[1].setSelection(false);
                buttonList[2].setSelection(true);
                break;
            }
        }
    }

    protected EditValueCommand editProperty(Value oldValue, Value newValue) {
        EditValueCommand command = new EditValueCommand(oldValue, newValue);
        this.execute(command);
        return command;
    }

    private void updateContent() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                int location;
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.headerTextField)) {
                    location = WorkflowLabelPropertySection.this.headerTextField.getCaretOffset();
                    WorkflowLabelPropertySection.this.headerTextField.setText(WorkflowLabelPropertySection.this.label.getHeaderText());
                    WorkflowLabelPropertySection.this.headerTextField.setSelection(location);
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.textfield)) {
                    location = WorkflowLabelPropertySection.this.textfield.getCaretOffset();
                    WorkflowLabelPropertySection.this.textfield.setText(WorkflowLabelPropertySection.this.label.getText());
                    WorkflowLabelPropertySection.this.textfield.setSelection(location);
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.headerColorPreviewLabel)) {
                    WorkflowLabelPropertySection.this.headerColorPreviewLabel.setBackground(new Color(null, WorkflowLabelPropertySection.this.label.getColorHeader()[0], WorkflowLabelPropertySection.this.label.getColorHeader()[1], WorkflowLabelPropertySection.this.label.getColorHeader()[2]));
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.textColorPreviewLabel)) {
                    WorkflowLabelPropertySection.this.textColorPreviewLabel.setBackground(new Color(null, WorkflowLabelPropertySection.this.label.getColorText()[0], WorkflowLabelPropertySection.this.label.getColorText()[1], WorkflowLabelPropertySection.this.label.getColorText()[2]));
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.bgColorPreviewLabel)) {
                    WorkflowLabelPropertySection.this.bgColorPreviewLabel.setBackground(new Color(null, WorkflowLabelPropertySection.this.label.getColorBackground()[0], WorkflowLabelPropertySection.this.label.getColorBackground()[1], WorkflowLabelPropertySection.this.label.getColorBackground()[2]));
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.bgAlphaScale)) {
                    WorkflowLabelPropertySection.this.bgAlphaScale.setSelection(WorkflowLabelPropertySection.this.label.getAlphaDisplay());
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.bgAlphaValueText)) {
                    WorkflowLabelPropertySection.this.bgAlphaValueText.setText("" + (int)Math.ceil((double)WorkflowLabelPropertySection.this.label.getAlphaDisplay() / 2.55));
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.bgBorderButton)) {
                    WorkflowLabelPropertySection.this.bgBorderButton.setSelection(WorkflowLabelPropertySection.this.label.hasBorder());
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control[])WorkflowLabelPropertySection.this.labelPositionButtons)) {
                    WorkflowLabelPropertySection.this.updateLabelPositionSelection(WorkflowLabelPropertySection.this.label.getLabelPosition());
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control[])WorkflowLabelPropertySection.this.textAlignmentButtons)) {
                    WorkflowLabelPropertySection.this.updateAlignmentButtonsSelection(WorkflowLabelPropertySection.this.textAlignmentButtons, WorkflowLabelPropertySection.this.label.getTextAlignmentType());
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control[])WorkflowLabelPropertySection.this.headerAlignmentButtons)) {
                    WorkflowLabelPropertySection.this.updateAlignmentButtonsSelection(WorkflowLabelPropertySection.this.headerAlignmentButtons, WorkflowLabelPropertySection.this.label.getHeaderAlignmentType());
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.headerSizeSpinner)) {
                    WorkflowLabelPropertySection.this.headerSizeSpinner.setSelection(WorkflowLabelPropertySection.this.label.getHeaderTextSize());
                }
                if (WorkflowLabelPropertySection.this.isAccessible((Control)WorkflowLabelPropertySection.this.textSizeSpinner)) {
                    WorkflowLabelPropertySection.this.textSizeSpinner.setSelection(WorkflowLabelPropertySection.this.label.getTextSize());
                }
            }
        });
    }

    private boolean isAccessible(Control[] controls) {
        boolean accessible = true;
        for (Control c : Arrays.asList(controls)) {
            accessible &= this.isAccessible(c);
        }
        return accessible;
    }

    private boolean isAccessible(Control c) {
        return c != null && !c.isDisposed();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.updateContent();
    }

    @Override
    public void execute(WorkflowLabelCommand command) {
        command.setCommandStack(this.getCommandStack());
        command.setWorkflowLabel(this.label);
        command.initialize();
        if (command.canExecute()) {
            this.getCommandStack().execute((Command)new LabelCommandWrapper(command));
        }
    }

    private class AlphaValueListener
    implements ModifyListener {
        private AlphaValueListener() {
        }

        public void modifyText(ModifyEvent arg0) {
            String text = ((Text)arg0.getSource()).getText();
            try {
                int value = Integer.parseInt(text);
                if (value > 100) {
                    ((Text)arg0.getSource()).setText("100");
                } else if (value < 0) {
                    ((Text)arg0.getSource()).setText("0");
                } else {
                    WorkflowLabelPropertySection.this.bgAlphaScale.setSelection((int)(2.55 * (double)value));
                }
            }
            catch (NumberFormatException numberFormatException) {
                text = "";
            }
        }
    }

    private class AplhaSelectionListener
    implements SelectionListener {
        private AplhaSelectionListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            int oldValue = WorkflowLabelPropertySection.this.label.getAlphaDisplay();
            int newValue = WorkflowLabelPropertySection.this.bgAlphaScale.getSelection();
            if (newValue != oldValue) {
                if (WorkflowLabelPropertySection.this.editTransparencyCommand == null) {
                    WorkflowLabelPropertySection.this.editTransparencyCommand = WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.TRANSPARENCY, oldValue), new Value(Value.ValueType.TRANSPARENCY, newValue));
                } else {
                    WorkflowLabelPropertySection.this.editTransparencyCommand.setNewValue(new Value(Value.ValueType.TRANSPARENCY, newValue));
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }

    private class ColorMouseListener
    implements MouseListener {
        private Value.ValueType type;

        ColorMouseListener(Value.ValueType type) {
            this.type = type;
        }

        public void mouseUp(MouseEvent event) {
            int[] oldValue = null;
            oldValue = this.type.equals((Object)Value.ValueType.COLOR_BACKGROUND) ? WorkflowLabelPropertySection.this.label.getColorBackground() : (this.type.equals((Object)Value.ValueType.COLOR_TEXT) ? WorkflowLabelPropertySection.this.label.getColorText() : (this.type.equals((Object)Value.ValueType.COLOR_HEADER) ? WorkflowLabelPropertySection.this.label.getColorHeader() : new int[3]));
            int displayWidth = event.display.getBounds().width;
            int displayHeight = event.display.getBounds().height;
            Shell colorSelectorShell = new Shell(event.display);
            colorSelectorShell.setLocation(displayWidth / 2 - 50, displayHeight / 2 - 200);
            ColorSelector cs = new ColorSelector((Composite)colorSelectorShell);
            cs.setColorValue(new RGB(oldValue[0], oldValue[1], oldValue[2]));
            cs.open();
            int[] newValue = new int[]{cs.getColorValue().red, cs.getColorValue().green, cs.getColorValue().blue};
            if (!Arrays.equals(newValue, oldValue)) {
                WorkflowLabelPropertySection.this.editProperty(new Value(this.type, oldValue), new Value(this.type, newValue));
            }
            colorSelectorShell.dispose();
        }

        public void mouseDoubleClick(MouseEvent arg0) {
        }

        public void mouseDown(MouseEvent arg0) {
        }
    }

    protected class DefaultSynchronizer
    implements Synchronizer {
        protected DefaultSynchronizer() {
        }

        @Override
        public void handlePropertyChange(Value newValue) {
            StyledText control = null;
            switch (newValue.getType()) {
                case HEADER_TEXT: {
                    control = WorkflowLabelPropertySection.this.headerTextField;
                    break;
                }
                case TEXT: {
                    control = WorkflowLabelPropertySection.this.textfield;
                    break;
                }
                case COLOR_HEADER: {
                    control = WorkflowLabelPropertySection.this.headerColorPreviewLabel;
                    break;
                }
                case COLOR_TEXT: {
                    control = WorkflowLabelPropertySection.this.textColorPreviewLabel;
                    break;
                }
                case COLOR_BACKGROUND: {
                    control = WorkflowLabelPropertySection.this.bgColorPreviewLabel;
                    break;
                }
                case TRANSPARENCY: {
                    WorkflowLabelPropertySection.this.getUpdater().updateControl((Control)WorkflowLabelPropertySection.this.bgAlphaValueText, newValue);
                    control = WorkflowLabelPropertySection.this.bgAlphaScale;
                    break;
                }
                case BORDER: {
                    control = WorkflowLabelPropertySection.this.bgBorderButton;
                    break;
                }
                case HEADER_SIZE: {
                    control = WorkflowLabelPropertySection.this.headerSizeSpinner;
                    break;
                }
                case TEXT_SIZE: {
                    control = WorkflowLabelPropertySection.this.textSizeSpinner;
                    break;
                }
            }
            WorkflowLabelPropertySection.this.getUpdater().updateControl((Control)control, newValue);
        }
    }

    protected class DefaultUpdater
    implements Updater {
        protected DefaultUpdater() {
        }

        @Override
        public void updateControl(Control control, Value newValue) {
            if (control != null && control.isDisposed()) {
                return;
            }
            if (newValue != null) {
                switch (newValue.getType()) {
                    case HEADER_TEXT: {
                        if (!(control instanceof StyledText)) break;
                        StyledText styledTextControl = (StyledText)control;
                        styledTextControl.setText(newValue.getTextValue());
                        styledTextControl.setSelection(newValue.getTextValue().length());
                        break;
                    }
                    case TEXT: {
                        if (!(control instanceof StyledText)) break;
                        StyledText sytledTextControl = (StyledText)control;
                        int offset = sytledTextControl.getCaretOffset();
                        int scrollbarSel = sytledTextControl.getTopIndex();
                        sytledTextControl.setText(newValue.getTextValue());
                        if (offset > 0 && offset < newValue.getTextValue().length() - 1) {
                            sytledTextControl.setSelection(offset);
                            sytledTextControl.setTopIndex(scrollbarSel);
                            break;
                        }
                        sytledTextControl.setSelection(newValue.getTextValue().length());
                        break;
                    }
                    case COLOR_HEADER: {
                        this.refreshColorLabels(control, newValue);
                        break;
                    }
                    case COLOR_TEXT: {
                        this.refreshColorLabels(control, newValue);
                        break;
                    }
                    case COLOR_BACKGROUND: {
                        this.refreshColorLabels(control, newValue);
                        break;
                    }
                    case TRANSPARENCY: {
                        if (control instanceof Scale) {
                            Scale scaleControl = (Scale)control;
                            scaleControl.setSelection(newValue.getTransparencyValue());
                            break;
                        }
                        if (!(control instanceof Text)) break;
                        Text textControl = (Text)control;
                        textControl.setText("" + (int)Math.ceil((double)newValue.getTransparencyValue() / 2.55));
                        break;
                    }
                    case BORDER: {
                        if (!(control instanceof Button)) break;
                        Button buttonControl = (Button)control;
                        buttonControl.setSelection(newValue.getHasBorder());
                        break;
                    }
                    case HEADER_SIZE: {
                        if (!(control instanceof Spinner)) break;
                        Spinner spinner = (Spinner)control;
                        spinner.setSelection(newValue.getTextSize());
                        break;
                    }
                    case TEXT_SIZE: {
                        if (!(control instanceof Spinner)) break;
                        Spinner spinner = (Spinner)control;
                        spinner.setSelection(newValue.getTextSize());
                        break;
                    }
                    case LABEL_POSITION: {
                        if (WorkflowLabelPropertySection.this.labelPositionButtons[0].isDisposed()) break;
                        WorkflowLabelPropertySection.this.updateLabelPositionSelection(newValue.getLabelPosition());
                        break;
                    }
                    case HEADER_ALIGNMENT: {
                        if (WorkflowLabelPropertySection.this.headerAlignmentButtons[0].isDisposed()) break;
                        WorkflowLabelPropertySection.this.updateAlignmentButtonsSelection(WorkflowLabelPropertySection.this.headerAlignmentButtons, newValue.getTextAlignmentType());
                        break;
                    }
                    case TEXT_ALIGNMENT: {
                        if (WorkflowLabelPropertySection.this.textAlignmentButtons[0].isDisposed()) break;
                        WorkflowLabelPropertySection.this.updateAlignmentButtonsSelection(WorkflowLabelPropertySection.this.textAlignmentButtons, newValue.getTextAlignmentType());
                        break;
                    }
                }
            }
        }

        private void refreshColorLabels(Control control, Value newValue) {
            if (control instanceof Label) {
                Label labelControl = (Label)control;
                labelControl.setBackground(new Color(null, newValue.getColorValues()[0], newValue.getColorValues()[1], newValue.getColorValues()[2]));
            }
        }
    }

    protected final class EditValueCommand
    extends AbstractWorkflowLabelCommand {
        private final Value oldValue;
        private Value newValue;

        private EditValueCommand(Value oldValue, Value newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Value getOldValue() {
            return this.oldValue;
        }

        public Value getNewValue() {
            return this.newValue;
        }

        public void setNewValue(Value newValue) {
            this.newValue = newValue;
            this.execute2();
        }

        @Override
        protected void execute2() {
            switch (this.newValue.getType()) {
                case HEADER_TEXT: {
                    WorkflowLabelPropertySection.this.label.setHeaderText(this.newValue.getTextValue());
                    break;
                }
                case TEXT: {
                    WorkflowLabelPropertySection.this.label.setText(this.newValue.getTextValue());
                    break;
                }
                case COLOR_HEADER: {
                    WorkflowLabelPropertySection.this.label.setColorHeader(this.newValue.getColorValues());
                    break;
                }
                case COLOR_TEXT: {
                    WorkflowLabelPropertySection.this.label.setColorText(this.newValue.getColorValues());
                    break;
                }
                case COLOR_BACKGROUND: {
                    WorkflowLabelPropertySection.this.label.setColorBackground(this.newValue.getColorValues());
                    break;
                }
                case TRANSPARENCY: {
                    WorkflowLabelPropertySection.this.label.setAlpha(this.newValue.getTransparencyValue());
                    break;
                }
                case LABEL_POSITION: {
                    WorkflowLabelPropertySection.this.label.setLabelPosition(this.newValue.getLabelPosition());
                    break;
                }
                case TEXT_ALIGNMENT: {
                    WorkflowLabelPropertySection.this.label.setTextAlignmentType(this.newValue.getTextAlignmentType());
                    break;
                }
                case HEADER_ALIGNMENT: {
                    WorkflowLabelPropertySection.this.label.setHeaderAlignmentType(this.newValue.getTextAlignmentType());
                }
                case BORDER: {
                    WorkflowLabelPropertySection.this.label.setHasBorder(this.newValue.getHasBorder());
                    break;
                }
                case HEADER_SIZE: {
                    WorkflowLabelPropertySection.this.label.setHeaderTextSize(this.newValue.getTextSize());
                    break;
                }
                case TEXT_SIZE: {
                    WorkflowLabelPropertySection.this.label.setTextSize(this.newValue.getTextSize());
                    break;
                }
            }
            WorkflowLabelPropertySection.this.label.firePropertChangeEvent();
            WorkflowLabelPropertySection.this.label.firePropertyChange("de.rcenvironment.rce.component.workflow.WorkflowLabelCommand", (Object)this.newValue);
        }

        @Override
        protected void undo2() {
            switch (this.oldValue.getType()) {
                case HEADER_TEXT: {
                    WorkflowLabelPropertySection.this.label.setHeaderText(this.oldValue.getTextValue());
                    break;
                }
                case TEXT: {
                    WorkflowLabelPropertySection.this.label.setText(this.oldValue.getTextValue());
                    break;
                }
                case COLOR_HEADER: {
                    WorkflowLabelPropertySection.this.label.setColorHeader(this.oldValue.getColorValues());
                    break;
                }
                case COLOR_TEXT: {
                    WorkflowLabelPropertySection.this.label.setColorText(this.oldValue.getColorValues());
                    break;
                }
                case COLOR_BACKGROUND: {
                    WorkflowLabelPropertySection.this.label.setColorBackground(this.oldValue.getColorValues());
                    break;
                }
                case TRANSPARENCY: {
                    WorkflowLabelPropertySection.this.label.setAlpha(this.oldValue.getTransparencyValue());
                    break;
                }
                case LABEL_POSITION: {
                    WorkflowLabelPropertySection.this.label.setLabelPosition(this.oldValue.getLabelPosition());
                    break;
                }
                case TEXT_ALIGNMENT: {
                    WorkflowLabelPropertySection.this.label.setTextAlignmentType(this.oldValue.getTextAlignmentType());
                    break;
                }
                case HEADER_ALIGNMENT: {
                    WorkflowLabelPropertySection.this.label.setHeaderAlignmentType(this.oldValue.getTextAlignmentType());
                    break;
                }
                case BORDER: {
                    WorkflowLabelPropertySection.this.label.setHasBorder(this.oldValue.getHasBorder());
                    break;
                }
                case HEADER_SIZE: {
                    WorkflowLabelPropertySection.this.label.setHeaderTextSize(this.oldValue.getTextSize());
                    break;
                }
                case TEXT_SIZE: {
                    WorkflowLabelPropertySection.this.label.setTextSize(this.oldValue.getTextSize());
                    break;
                }
            }
            WorkflowLabelPropertySection.this.label.firePropertChangeEvent();
            WorkflowLabelPropertySection.this.label.firePropertyChange("de.rcenvironment.rce.component.workflow.WorkflowLabelCommand", (Object)this.oldValue);
        }
    }

    private static final class LabelCommandWrapper
    extends WorkflowPropertySection.CommandWrapper {
        private WorkflowLabelCommand command;

        LabelCommandWrapper(WorkflowLabelCommand command) {
            super(command);
            this.command = command;
        }
    }

    private class PositionSelectionListener
    implements SelectionListener {
        private WorkflowLabel.LabelPosition type;

        PositionSelectionListener(WorkflowLabel.LabelPosition type) {
            this.type = type;
        }

        public void widgetSelected(SelectionEvent event) {
            WorkflowLabel.LabelPosition oldValue = WorkflowLabelPropertySection.this.label.getLabelPosition();
            Button selectedButton = (Button)event.getSource();
            if (selectedButton.getSelection()) {
                if (!this.type.equals((Object)oldValue)) {
                    WorkflowLabelPropertySection.this.editProperty(new Value(Value.ValueType.LABEL_POSITION, oldValue), new Value(Value.ValueType.TEXT_ALIGNMENT, this.type));
                }
                if (OSFamily.isLinux()) {
                    WorkflowLabelPropertySection.this.textfield.setFocus();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }
    }

    public static interface Synchronizer {
        public void handlePropertyChange(Value var1);
    }

    private final class SynchronizerAdapter
    implements PropertyChangeListener {
        private SynchronizerAdapter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyNameValue = event.getPropertyName();
            if (propertyNameValue.equals("de.rcenvironment.rce.component.workflow.WorkflowLabelCommand")) {
                WorkflowLabelPropertySection.this.synchronizer.handlePropertyChange((Value)event.getNewValue());
            }
        }
    }

    private class TextAlignmentSelectionListener
    implements SelectionListener {
        private final WorkflowLabel.TextAlignmentType textAlignmentType;
        private final Value.ValueType valueType;

        TextAlignmentSelectionListener(Value.ValueType valueType, WorkflowLabel.TextAlignmentType textAlignmentType) {
            this.valueType = valueType;
            this.textAlignmentType = textAlignmentType;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            WorkflowLabel.TextAlignmentType oldValue = this.valueType == Value.ValueType.HEADER_ALIGNMENT ? WorkflowLabelPropertySection.this.label.getHeaderAlignmentType() : (this.valueType == Value.ValueType.TEXT_ALIGNMENT ? WorkflowLabelPropertySection.this.label.getTextAlignmentType() : WorkflowLabel.TextAlignmentType.LEFT);
            if (((Button)arg0.getSource()).getSelection()) {
                if (this.textAlignmentType != oldValue) {
                    WorkflowLabelPropertySection.this.editProperty(new Value(this.valueType, oldValue), new Value(this.valueType, this.textAlignmentType));
                }
                if (OSFamily.isLinux()) {
                    WorkflowLabelPropertySection.this.textfield.setFocus();
                }
            }
        }
    }

    private class TextKeyListener
    implements KeyListener {
        private TextKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.stateMask == 262144 && event.keyCode == 97) {
                WorkflowLabelPropertySection.this.textfield.setSelection(0);
                WorkflowLabelPropertySection.this.headerTextField.setSelection(0);
                Object src = event.getSource();
                if (src.equals(WorkflowLabelPropertySection.this.textfield)) {
                    WorkflowLabelPropertySection.this.textfield.selectAll();
                } else if (src.equals(WorkflowLabelPropertySection.this.headerTextField)) {
                    WorkflowLabelPropertySection.this.headerTextField.selectAll();
                }
            }
        }

        public void keyReleased(KeyEvent arg0) {
        }
    }

    protected static interface Updater {
        public void updateControl(Control var1, Value var2);
    }

    private static class Value {
        private ValueType type;
        private String textValue;
        private int[] colorValues;
        private int transparencyValue;
        private WorkflowLabel.LabelPosition labelPosition;
        private WorkflowLabel.TextAlignmentType textAlignmentType;
        private boolean hasBorder;
        private int textSize;

        Value(ValueType type, String value) {
            this.type = type;
            if (type == ValueType.TEXT || type == ValueType.HEADER_TEXT) {
                this.textValue = value;
            }
        }

        Value(ValueType type, int[] colorValues) {
            this.type = type;
            if (type == ValueType.COLOR_BACKGROUND || type == ValueType.COLOR_TEXT || type == ValueType.COLOR_HEADER) {
                this.colorValues = colorValues;
            }
        }

        Value(ValueType type, int value) {
            this.type = type;
            if (type == ValueType.TEXT_SIZE || type == ValueType.HEADER_SIZE) {
                this.textSize = value;
            } else if (type == ValueType.TRANSPARENCY) {
                this.transparencyValue = value;
            }
        }

        Value(ValueType type, WorkflowLabel.LabelPosition labelPosition) {
            this.type = ValueType.LABEL_POSITION;
            this.labelPosition = labelPosition;
        }

        Value(ValueType type, WorkflowLabel.TextAlignmentType textAlignmentType) {
            this.type = type;
            this.textAlignmentType = textAlignmentType;
        }

        Value(ValueType type, boolean border) {
            this.type = type;
            if (type == ValueType.BORDER) {
                this.hasBorder = border;
            }
        }

        public int[] getColorValues() {
            return this.colorValues;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public int getTransparencyValue() {
            return this.transparencyValue;
        }

        public WorkflowLabel.LabelPosition getLabelPosition() {
            return this.labelPosition;
        }

        public WorkflowLabel.TextAlignmentType getTextAlignmentType() {
            return this.textAlignmentType;
        }

        public boolean getHasBorder() {
            return this.hasBorder;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public ValueType getType() {
            return this.type;
        }

        private static enum ValueType {
            HEADER_TEXT,
            TEXT,
            COLOR_HEADER,
            COLOR_TEXT,
            COLOR_BACKGROUND,
            TRANSPARENCY,
            LABEL_POSITION,
            HEADER_ALIGNMENT,
            TEXT_ALIGNMENT,
            BORDER,
            HEADER_SIZE,
            TEXT_SIZE;

        }
    }
}

