/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.AbstractParsedCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.ListCommandParameter;
import de.rcenvironment.core.command.spi.NamedMultiParameter;
import de.rcenvironment.core.command.spi.NamedParameter;
import de.rcenvironment.core.command.spi.NamedSingleParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedMultiParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandModifierInfo {
    private static final String LIST_PARAMETER_SEPERATOR = ",";
    private List<AbstractCommandParameter> positionalParameters;
    private Set<CommandFlag> flags;
    private Set<NamedParameter> namedParameters;

    public CommandModifierInfo() {
        this.positionalParameters = new ArrayList<AbstractCommandParameter>();
        this.flags = new HashSet<CommandFlag>();
        this.namedParameters = new HashSet<NamedParameter>();
    }

    public CommandModifierInfo(List<AbstractCommandParameter> positionalParameters, Set<CommandFlag> flags, Set<NamedParameter> namedParameters) {
        this.positionalParameters = positionalParameters;
        this.flags = flags;
        this.namedParameters = namedParameters;
    }

    public CommandModifierInfo(AbstractCommandParameter[] positionalParameters, CommandFlag[] flags, NamedParameter[] namedParameters) {
        this.positionalParameters = Arrays.asList(positionalParameters);
        this.flags = new HashSet<CommandFlag>(Arrays.asList(flags));
        this.namedParameters = new HashSet<NamedParameter>(Arrays.asList(namedParameters));
    }

    public CommandModifierInfo(AbstractCommandParameter[] positionalParameters, CommandFlag[] flags) {
        this.positionalParameters = Arrays.asList(positionalParameters);
        this.flags = new HashSet<CommandFlag>(Arrays.asList(flags));
        this.namedParameters = new HashSet<NamedParameter>();
    }

    public CommandModifierInfo(CommandFlag[] flags, NamedParameter[] namedParameters) {
        this.positionalParameters = new ArrayList<AbstractCommandParameter>();
        this.flags = new HashSet<CommandFlag>(Arrays.asList(flags));
        this.namedParameters = new HashSet<NamedParameter>(Arrays.asList(namedParameters));
    }

    public CommandModifierInfo(NamedParameter[] namedParameters) {
        this.positionalParameters = new ArrayList<AbstractCommandParameter>();
        this.flags = new HashSet<CommandFlag>();
        this.namedParameters = new HashSet<NamedParameter>(Arrays.asList(namedParameters));
    }

    public CommandModifierInfo(AbstractCommandParameter[] positionalParameters, NamedParameter[] namedParameters) {
        this.positionalParameters = Arrays.asList(positionalParameters);
        this.flags = new HashSet<CommandFlag>();
        this.namedParameters = new HashSet<NamedParameter>(Arrays.asList(namedParameters));
    }

    public CommandModifierInfo(AbstractCommandParameter[] positionalParameters) {
        this.positionalParameters = Arrays.asList(positionalParameters);
        this.flags = new HashSet<CommandFlag>();
        this.namedParameters = new HashSet<NamedParameter>();
    }

    public CommandModifierInfo(CommandFlag[] flags) {
        this.positionalParameters = new ArrayList<AbstractCommandParameter>();
        this.flags = new HashSet<CommandFlag>(Arrays.asList(flags));
        this.namedParameters = new HashSet<NamedParameter>();
    }

    public boolean isEmpty() {
        return this.positionalParameters.isEmpty() && this.flags.isEmpty() && this.namedParameters.isEmpty();
    }

    public List<AbstractCommandParameter> getPositionals() {
        return this.positionalParameters;
    }

    public Set<CommandFlag> getFlags() {
        return this.flags;
    }

    public Set<NamedParameter> getNamedParameters() {
        return this.namedParameters;
    }

    public ParsedCommandModifiers parseModifiers(CommandContext context) throws CommandException {
        List<String> tokens = context.consumeRemainingTokens();
        if (tokens.size() != 0 && this.isEmpty()) {
            throw CommandException.syntaxError("This command has no flags nor parameters", context);
        }
        Map<String, AbstractParsedCommandParameter> parsedNamed = this.findNamedParameters(tokens, context);
        Set<CommandFlag> parsedFlags = this.findFlags(tokens);
        List<AbstractParsedCommandParameter> parsedPositionals = this.parsePositionalParameters(tokens, context);
        if (tokens.isEmpty()) {
            return new ParsedCommandModifiers(parsedPositionals, parsedFlags, parsedNamed);
        }
        throw CommandException.syntaxError("Not all tokens could be parsed", context);
    }

    private List<AbstractParsedCommandParameter> parsePositionalParameters(List<String> tokens, CommandContext context) throws CommandException {
        ArrayList<AbstractParsedCommandParameter> parsed = new ArrayList<AbstractParsedCommandParameter>();
        if (this.positionalParameters.size() != 0) {
            int i = 0;
            while (i < this.positionalParameters.size()) {
                if (tokens.size() == 0) {
                    throw CommandException.syntaxError("Not enough positional parameters", context);
                }
                AbstractCommandParameter parameter = this.positionalParameters.get(i);
                if (parameter instanceof ListCommandParameter) {
                    String combined = tokens.get(0);
                    while (tokens.get(0).endsWith(LIST_PARAMETER_SEPERATOR)) {
                        combined = String.valueOf(combined) + tokens.get(1);
                        tokens.remove(0);
                    }
                    tokens.remove(0);
                    parsed.add(parameter.parseToken(combined, context));
                } else {
                    parsed.add(parameter.parseToken(tokens.remove(0), context));
                }
                ++i;
            }
        }
        if (parsed.size() != this.positionalParameters.size()) {
            throw CommandException.wrongNumberOfParameters(context);
        }
        return parsed;
    }

    private Set<CommandFlag> findFlags(List<String> tokens) {
        HashSet<CommandFlag> foundFlags = new HashSet<CommandFlag>();
        block0: for (CommandFlag flag : this.flags) {
            int i = 0;
            while (i < tokens.size()) {
                if (flag.isFitting(tokens.get(i))) {
                    foundFlags.add(flag);
                    tokens.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        return foundFlags;
    }

    private Map<String, AbstractParsedCommandParameter> findNamedParameters(List<String> tokens, CommandContext context) throws CommandException {
        HashMap<String, AbstractParsedCommandParameter> parsedParameters = new HashMap<String, AbstractParsedCommandParameter>();
        for (NamedParameter named : this.namedParameters) {
            boolean found = false;
            int i = 0;
            while (i < tokens.size()) {
                if (named.getName().equalsIgnoreCase(tokens.get(i))) {
                    tokens.remove(i);
                    if (named instanceof NamedSingleParameter) {
                        found = true;
                        AbstractCommandParameter parameter = ((NamedSingleParameter)named).getParameterType();
                        if (parameter instanceof ListCommandParameter) {
                            String value = "";
                            while (tokens.get(i).endsWith(LIST_PARAMETER_SEPERATOR)) {
                                value = String.valueOf(value) + tokens.remove(i);
                            }
                            parsedParameters.put(named.getName(), parameter.parseToken(value, context));
                        } else {
                            parsedParameters.put(named.getName(), parameter.parseToken(tokens.get(i), context));
                            tokens.remove(i);
                        }
                    } else if (named instanceof NamedMultiParameter) {
                        NamedMultiParameter multi = (NamedMultiParameter)named;
                        AbstractCommandParameter[] parameters = multi.getParameterTypes();
                        AbstractParsedCommandParameter[] parsed = new AbstractParsedCommandParameter[parameters.length];
                        int index = 0;
                        while (index < parameters.length) {
                            String token = tokens.size() > i ? tokens.get(i) : "-";
                            if (!token.startsWith("-")) {
                                parsed[index] = parameters[index].parseToken(token, context);
                                tokens.remove(i);
                            } else {
                                if (index < multi.getMinParameters()) {
                                    throw CommandException.syntaxError(String.valueOf(named.getName()) + " needs at least " + multi.getMinParameters() + " values", context);
                                }
                                parsed[index] = parameters[index].standardValue();
                            }
                            ++index;
                        }
                        parsedParameters.put(named.getName(), new ParsedMultiParameter(parsed));
                    }
                }
                ++i;
            }
            if (found || !named.getParseWhenNotPresent()) continue;
            parsedParameters.put(named.getName(), named.getStandardValue());
        }
        return parsedParameters;
    }
}

