/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class ServerSideUplinkLowLevelProtocolWrapper
extends CommonUplinkLowLevelProtocolWrapper {
    public static final String ERROR_MESSAGE_CONNECTION_SETUP_FAILED = "Error during connection setup";

    public ServerSideUplinkLowLevelProtocolWrapper(InputStream inputStream, OutputStream outputStream, UplinkConnectionLowLevelEventHandler eventHandler, String logIdentity) {
        super(eventHandler, "server session protocol wrapper");
        this.dataInputStream = new DataInputStream(inputStream);
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    @Override
    public void runSession() {
        MessageBlock handshakeData;
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)"Expecting handshake init");
        }
        try {
            this.expectHandshakeInit();
        }
        catch (IOException e) {
            this.log.warn((Object)("Handshake init failed, closing incoming connection: " + e.toString()));
            return;
        }
        try {
            this.sendHandshakeInit();
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to send handshake init response, closing incoming connection: " + e.toString()));
            return;
        }
        try {
            handshakeData = this.expectHandshakeData();
        }
        catch (IOException e) {
            String errorMessage = e.toString();
            this.log.warn((Object)("Error while expecting handshake data, closing incoming connection: " + errorMessage));
            this.eventHandler.onNonProtocolError(e);
            this.attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType.INTERNAL_SERVER_ERROR, errorMessage);
            return;
        }
        catch (UplinkConnectionRefusedException e) {
            this.log.warn((Object)("Unexpected behavior: The client sent an error goodbye message instead of handshake data: " + e.getMessage()));
            this.eventHandler.onErrorGoodbyeMessage(e.getType(), e.getRawMessage());
            return;
        }
        try {
            MessageBlock responseData = this.processHandshakeDataAndGenerateResponse(handshakeData);
            this.sendHandshakeData(responseData);
        }
        catch (IOException e) {
            String errorMarker = LogUtils.logExceptionAsSingleLineAndAssignUniqueMarker((Log)this.log, (String)"Error while processing or responding to handshake data, closing incoming connection", (Throwable)e);
            this.attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType.INTERNAL_SERVER_ERROR, "Error during connection setup (internal error log marker " + errorMarker + ")");
            return;
        }
        catch (UplinkConnectionRefusedException e) {
            this.log.warn((Object)("Refusing connection: " + e.toString()));
            this.attemptToSendErrorGoodbyeMessage(e.getType(), "Connection refused: " + e.getRawMessage());
            return;
        }
        try {
            handshakeData = this.expectHandshakeData();
        }
        catch (IOException e) {
            String errorMessage = e.toString();
            this.log.info((Object)("Error while expecting handshake confirmation, closing incoming connection: " + errorMessage));
            this.eventHandler.onNonProtocolError(e);
            this.attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType.INTERNAL_SERVER_ERROR, errorMessage);
            return;
        }
        catch (UplinkConnectionRefusedException e) {
            this.log.debug((Object)("Received an error goodbye message instead of handshake data from a client: " + e.getMessage()));
            this.eventHandler.onErrorGoodbyeMessage(e.getType(), e.getRawMessage());
            return;
        }
        this.eventHandler.onHandshakeComplete();
        this.runMessageReceiveLoop();
    }

    private MessageBlock processHandshakeDataAndGenerateResponse(MessageBlock handshakeData) throws ProtocolException, UplinkConnectionRefusedException {
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)("Processing handshake data: " + new String(handshakeData.getData())));
        }
        Map<String, String> incomingData = this.messageConverter.decodeHandshakeData(handshakeData);
        HashMap<String, String> responseMap = new HashMap<String, String>();
        this.eventHandler.provideOrProcessHandshakeData(incomingData, responseMap);
        return this.messageConverter.encodeHandshakeData(responseMap);
    }

    @Override
    public void closeOutgoingMessageStream() {
        this.closeOutgoingDataStream();
    }
}

