/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.execution.api;

import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.FileDataSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;

public final class DataTransferUtils {
    private static final String SLASH = "/";

    private DataTransferUtils() {
    }

    public static void uploadDirectory(File directory, DirectoryUploadContext uploadContext, String remotePath) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            LogFactory.getLog(DataTransferUtils.class).warn((Object)("Attempted to upload " + directory + ", but it does not seem to be a directory"));
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                DataTransferUtils.uploadDirectory(file, uploadContext, String.valueOf(remotePath) + SLASH + file.getName());
            } else {
                byte[] fileContentBytes = Files.readAllBytes(file.toPath());
                uploadContext.provideFile(new FileDataSource(String.valueOf(remotePath) + SLASH + file.getName(), fileContentBytes.length, new ByteArrayInputStream(fileContentBytes)));
            }
            ++n2;
        }
    }

    public static void getDirectoryListing(File directory, List<String> listOfDirs, String remotePath) throws IOException {
        File[] files = directory.listFiles();
        if (files == null) {
            LogFactory.getLog(DataTransferUtils.class).warn((Object)("Attempted to upload " + directory + ", but it does not seem to be a directory"));
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                listOfDirs.add(String.valueOf(remotePath) + SLASH + file.getName());
                DataTransferUtils.getDirectoryListing(file, listOfDirs, String.valueOf(remotePath) + SLASH + file.getName());
            }
            ++n2;
        }
    }

    public static void receiveFile(FileDataSource dataSource, File rootDirectory) throws IOException {
        String relativePath = dataSource.getRelativePath();
        if (relativePath == null) {
            throw new IOException("Relative path is null");
        }
        File fileToWrite = new File(rootDirectory, relativePath);
        if (fileToWrite.getCanonicalPath().startsWith(rootDirectory.getCanonicalPath())) {
            fileToWrite.getParentFile().mkdirs();
            try (FileOutputStream fileStream = new FileOutputStream(fileToWrite);){
                IOUtils.copy((InputStream)dataSource.getStream(), (OutputStream)fileStream);
            }
            if (!dataSource.receivedCompletely()) {
                throw new IOException("Received incomplete file transfer for relative path " + relativePath);
            }
        } else {
            throw new IOException("Relative path " + relativePath + " points to a destination output the root directory.");
        }
        dataSource.getStream().close();
    }

    public static void receiveDirectoryListing(List<String> dirList, File rootDirectory) throws IOException {
        for (String relativePath : dirList) {
            if (relativePath == null) {
                throw new IOException("Relative path is null");
            }
            File dirToCreate = new File(rootDirectory, relativePath);
            if (dirToCreate.getCanonicalPath().startsWith(rootDirectory.getCanonicalPath())) {
                dirToCreate.mkdir();
                continue;
            }
            throw new IOException("Relative path " + relativePath + " points to a destination output the root directory.");
        }
    }
}

