/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.command;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.spi.AbstractInteractiveCommandConsole;
import de.rcenvironment.core.gui.command.CommandHandler;
import de.rcenvironment.core.gui.command.Messages;
import de.rcenvironment.core.gui.resources.api.FontManager;
import de.rcenvironment.core.gui.resources.api.FontSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardFonts;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class CommandConsoleViewer
extends ViewPart {
    private static final String RCEPROMPT = "rce>";
    private static final int RCEPROMPTLENGTH = "rce>".length();
    private static final Color PROMPT_COLOR_BLUE = Display.getCurrent().getSystemColor(9);
    private static final int MAXIMUM_PASTE_LENGTH = 10000;
    private int caretLinePosition;
    private int currentLine;
    private Action clearConsoleAction;
    private Action copyAction;
    private Action pasteAction;
    private StyledText styledtext;
    private CommandConsoleOutputAdapter textOutputReceiver;
    private CommandExecutionService commandExecutionService;
    private final String lineBreak = "\n";
    private final String platformIndependentLineBreak = System.lineSeparator();
    private int commandPosition = -1;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private CommandHandler commandService;
    private List<String> usedCommands;

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        parent.setLayout((Layout)gridLayout);
        GridData gridDataLabel = new GridData(768);
        GridData gridDataStyledText = new GridData(1808);
        Label label = new Label(parent, 2048);
        label.setText(Messages.defaultLabelText);
        label.setLayoutData((Object)gridDataLabel);
        this.styledtext = new StyledText(parent, 2816);
        this.styledtext.setLayoutData((Object)gridDataStyledText);
        this.styledtext.addKeyListener((KeyListener)new CommandKeyListener());
        this.styledtext.addTraverseListener((TraverseListener)new CommandTraverseListener());
        this.styledtext.addMouseListener((MouseListener)new CommandMouseListener());
        this.styledtext.addVerifyKeyListener((VerifyKeyListener)new CommandVerifyKeyListener());
        this.styledtext.setFont(FontManager.getInstance().getFont((FontSource)StandardFonts.CONSOLE_TEXT_FONT));
        this.styledtext.addModifyListener((ModifyListener)new CommandModifyListener());
        this.insertRCEPrompt();
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.registerServices();
        this.commandService = new CommandHandler();
        this.usedCommands = this.commandService.getUsedCommands();
        this.textOutputReceiver = new CommandConsoleOutputAdapter();
    }

    private void registerServices() {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.commandExecutionService = (CommandExecutionService)serviceRegistryAccess.getService(CommandExecutionService.class);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommandConsoleViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.styledtext);
        this.styledtext.setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearConsoleAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearConsoleAction);
    }

    private void makeActions() {
        this.clearConsoleAction = new ClearConsoleAction(Messages.clearConsoleActionContextMenuLabel);
        this.clearConsoleAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.CLEARCONSOLE_16));
        this.clearConsoleAction.setEnabled(false);
        this.copyAction = new CopyAction(Messages.copyActionContextMenuLabel);
        this.copyAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.COPY_16));
        this.pasteAction = new PasteAction(Messages.pasteActionContextMenuLabel);
        this.pasteAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PASTE_16));
    }

    public void setFocus() {
        this.styledtext.setFocus();
    }

    private void setStyledRange(int styledstart, int styledlength) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = styledstart;
        styleRange.length = styledlength;
        styleRange.foreground = PROMPT_COLOR_BLUE;
        this.styledtext.setStyleRange(styleRange);
    }

    private void displayUsedCommands() {
        ArrayList<String> usedCommandsToDisplay = new ArrayList<String>(this.usedCommands);
        Collections.reverse(usedCommandsToDisplay);
        for (String command : usedCommandsToDisplay) {
            this.insertTextWithLineBreak(command);
            this.selectNewLine(command.length());
        }
        this.insertRCEPrompt();
        this.increaseCurrentLine();
    }

    private void insertRCEPrompt() {
        this.insertText(RCEPROMPT);
        this.setCaretLinePosition(this.getCurrentCaretLocation() + RCEPROMPTLENGTH);
        this.setSelection(this.caretLinePosition);
        this.setStyledRange(this.caretLinePosition - RCEPROMPTLENGTH, RCEPROMPTLENGTH);
    }

    private void displayCommand(String command) {
        String line = this.getLineWithoutRCEPROMPT(this.currentLine);
        if (line.isEmpty()) {
            this.setSelection(this.caretLinePosition);
        } else {
            this.setSelectionRange(this.caretLinePosition, line.length());
        }
        this.insertText(command);
        this.setStyledRange(this.caretLinePosition, command.length());
        this.setSelection(this.caretLinePosition + command.length());
    }

    private void displayMessage(String message) {
        int selected = message.length();
        String line = this.getLine(this.currentLine);
        if (line.isEmpty()) {
            this.insertTextWithLineBreak(message);
            this.selectNewLine(selected);
        } else {
            int caretOffsetLine = this.getCurrentCaretLocation();
            this.setSelectionRange(this.caretLinePosition - RCEPROMPTLENGTH, line.length());
            this.insertTextWithLineBreak(message);
            int currentCaretLocation = this.getCurrentCaretLocation();
            this.insertText(line);
            this.setStyledRange(currentCaretLocation, line.length());
            this.selectLineAndUpdateCaretPosition(currentCaretLocation + RCEPROMPTLENGTH);
            this.setSelection(caretOffsetLine + selected + 1);
        }
    }

    private void displayCommands() {
        if (this.commandPosition + 1 < this.usedCommands.size()) {
            ++this.commandPosition;
            this.displayCommand(this.usedCommands.get(this.commandPosition));
        }
    }

    private void displayCommandsReverse() {
        if (this.commandPosition < this.usedCommands.size() && this.commandPosition > 0) {
            --this.commandPosition;
            this.displayCommand(this.usedCommands.get(this.commandPosition));
        }
    }

    private void resetCommandPosition() {
        this.commandPosition = -1;
    }

    private void setSelection(int start) {
        this.styledtext.setSelection(start);
    }

    private void setSelectionRange(int start, int length) {
        this.styledtext.setSelectionRange(start, length);
    }

    private void insertText(String text) {
        this.styledtext.insert(text);
    }

    private void insertTextWithLineBreak(String text) {
        this.styledtext.insert(String.valueOf(text) + "\n");
        this.increaseCurrentLine();
    }

    private void selectNewLine(int selection) {
        this.setSelection(this.getCurrentCaretLocation() + selection + 1);
    }

    private void selectLineAndUpdateCaretPosition(int selection) {
        this.setSelection(selection);
        this.setCaretLinePosition(this.getCurrentCaretLocation());
    }

    private void setCaretLinePosition(int caretLinePosition) {
        this.caretLinePosition = caretLinePosition;
    }

    private void increaseCurrentLine() {
        ++this.currentLine;
    }

    private int getCurrentCaretLocation() {
        return this.styledtext.getCaretOffset();
    }

    private String getLine(int line) {
        try {
            return this.styledtext.getLine(line);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)("Invalid line " + line + " requested; line count is " + this.styledtext.getLineCount()), (Throwable)e);
            return "";
        }
    }

    private String getLineWithoutRCEPROMPT(int line) {
        return this.getLine(line).replaceFirst(RCEPROMPT, "");
    }

    private void moveCaretToCommandLine() {
        String line = this.getLineWithoutRCEPROMPT(this.currentLine);
        this.setSelection(this.caretLinePosition + line.length());
    }

    private final class ClearConsoleAction
    extends Action {
        ClearConsoleAction(String clearConsoleActionContextMenuLabel) {
            super(clearConsoleActionContextMenuLabel);
        }

        public void run() {
            CommandConsoleViewer.this.currentLine = 0;
            CommandConsoleViewer.this.styledtext.selectAll();
            CommandConsoleViewer.this.insertText("");
            CommandConsoleViewer.this.insertRCEPrompt();
            CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.caretLinePosition);
            CommandConsoleViewer.this.clearConsoleAction.setEnabled(false);
        }
    }

    private class CommandConsoleOutputAdapter
    extends AbstractInteractiveCommandConsole {
        private final Display display;

        CommandConsoleOutputAdapter() {
            super(CommandConsoleViewer.this.commandExecutionService);
            this.display = Display.getDefault();
        }

        public void addOutput(String line) {
            if (this.display.isDisposed()) {
                return;
            }
            if (line.contains("\n")) {
                while (line.contains("\n")) {
                    this.display.asyncExec((Runnable)new DisplayText(line.substring(0, line.indexOf("\n"))));
                    line = line.substring(line.indexOf("\n") + 1);
                }
                if (!line.equals("")) {
                    this.display.asyncExec((Runnable)new DisplayText(line));
                }
            } else {
                this.display.asyncExec((Runnable)new DisplayText(line));
            }
        }
    }

    private class CommandKeyListener
    implements KeyListener {
        private CommandKeyListener() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if ((keyEvent.keyCode == 8 || keyEvent.keyCode == 127) && CommandConsoleViewer.this.getLineWithoutRCEPROMPT(0).isEmpty()) {
                CommandConsoleViewer.this.clearConsoleAction.setEnabled(false);
            }
            if (keyEvent.keyCode == 27) {
                CommandConsoleViewer.this.styledtext.setSelection(CommandConsoleViewer.this.styledtext.getCharCount() - CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine).length(), CommandConsoleViewer.this.styledtext.getCharCount());
                CommandConsoleViewer.this.insertText("");
                CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.caretLinePosition);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            String command = CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine);
            if ((keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) && keyEvent.character == '\r') {
                if (command.isEmpty()) {
                    if (CommandConsoleViewer.this.styledtext.getSelectionCount() == 0) {
                        CommandConsoleViewer.this.increaseCurrentLine();
                        CommandConsoleViewer.this.insertRCEPrompt();
                    }
                } else {
                    if (command.equals(Messages.historyUsedCommand)) {
                        CommandConsoleViewer.this.displayUsedCommands();
                        return;
                    }
                    if (command.equals("clear")) {
                        CommandConsoleViewer.this.clearConsoleAction.run();
                        return;
                    }
                    CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + command.length());
                    CommandConsoleViewer.this.resetCommandPosition();
                    CommandConsoleViewer.this.setCaretLinePosition(CommandConsoleViewer.this.caretLinePosition + command.length());
                    CommandConsoleViewer.this.increaseCurrentLine();
                    CommandConsoleViewer.this.insertRCEPrompt();
                    ConcurrencyUtils.getAsyncTaskService().execute((Runnable)new ExecuteCommand(command));
                }
            } else if (keyEvent.keyCode == 0x1000007) {
                CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.caretLinePosition);
            } else if (keyEvent.keyCode == 0x1000008) {
                CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.caretLinePosition + command.length());
            }
            if (!command.isEmpty() && CommandConsoleViewer.this.getCurrentCaretLocation() > CommandConsoleViewer.this.caretLinePosition) {
                CommandConsoleViewer.this.setStyledRange(CommandConsoleViewer.this.getCurrentCaretLocation() - 1, 1);
            }
        }
    }

    private class CommandModifyListener
    implements ModifyListener {
        private CommandModifyListener() {
        }

        private boolean containsContent() {
            int i = 0;
            while (i <= CommandConsoleViewer.this.currentLine) {
                if (!CommandConsoleViewer.this.getLineWithoutRCEPROMPT(i).isEmpty()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void modifyText(ModifyEvent arg0) {
            if (CommandConsoleViewer.this.clearConsoleAction != null && !CommandConsoleViewer.this.clearConsoleAction.isEnabled() && this.containsContent()) {
                CommandConsoleViewer.this.clearConsoleAction.setEnabled(true);
            }
        }
    }

    private class CommandMouseListener
    implements MouseListener {
        private CommandMouseListener() {
        }

        public void mouseDown(MouseEvent event) {
            int currentCaretLocation = CommandConsoleViewer.this.getCurrentCaretLocation();
            if (CommandConsoleViewer.this.caretLinePosition > currentCaretLocation) {
                CommandConsoleViewer.this.pasteAction.setEnabled(false);
            } else {
                CommandConsoleViewer.this.pasteAction.setEnabled(true);
            }
            if (!CommandConsoleViewer.this.styledtext.getSelectionText().isEmpty()) {
                CommandConsoleViewer.this.copyAction.setEnabled(true);
            } else {
                CommandConsoleViewer.this.copyAction.setEnabled(false);
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
        }

        public void mouseUp(MouseEvent event) {
        }
    }

    private class CommandTraverseListener
    implements TraverseListener {
        private CommandTraverseListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            switch (event.detail) {
                case 4: {
                    this.executeReturn(event);
                    break;
                }
                case 32: {
                    if (event.keyCode != 0x1000001) break;
                    this.disableEvent(event);
                    CommandConsoleViewer.this.displayCommands();
                    if (CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine).isEmpty()) break;
                    CommandConsoleViewer.this.clearConsoleAction.setEnabled(true);
                    break;
                }
                case 64: {
                    if (event.keyCode != 0x1000002) break;
                    this.disableEvent(event);
                    CommandConsoleViewer.this.displayCommandsReverse();
                    break;
                }
                case 16: {
                    if (event.keyCode != 9) break;
                    this.disableEvent(event);
                }
            }
        }

        private void disableEvent(TraverseEvent event) {
            event.doit = true;
            event.detail = 0;
        }

        private void executeReturn(TraverseEvent event) {
            String line = CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine);
            int currentCaretLocation = CommandConsoleViewer.this.getCurrentCaretLocation();
            if (currentCaretLocation < CommandConsoleViewer.this.caretLinePosition) {
                this.disableEvent(event);
            } else if (!line.isEmpty()) {
                CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + line.length());
            }
        }

        private void completeLine(String command, String completion) {
            String[] words = command.split(" ");
            String lastWord = words[words.length - 1];
            CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + command.length());
            if (completion.startsWith(lastWord)) {
                int lastWordLength = command.length() - (command.lastIndexOf(32) + 1);
                completion = completion.substring(lastWordLength);
            } else if (!command.endsWith(" ")) {
                completion = " " + completion;
            }
            CommandConsoleViewer.this.insertText(completion);
            CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + completion.length());
        }

        private void showCompletions(String command, String[] completions) {
            CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + command.length());
            String text = completions[0];
            int i = 1;
            while (i < completions.length) {
                text = String.valueOf(text) + "\t" + completions[i];
                ++i;
            }
            CommandConsoleViewer.this.insertTextWithLineBreak("\n" + text);
            CommandConsoleViewer.this.increaseCurrentLine();
            CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + text.length() + 2);
            CommandConsoleViewer.this.insertRCEPrompt();
            CommandConsoleViewer.this.insertText(command);
            CommandConsoleViewer.this.setSelection(CommandConsoleViewer.this.styledtext.getCaretOffset() + command.length());
        }
    }

    private class CommandVerifyKeyListener
    implements VerifyKeyListener {
        private final List<Integer> enabledEvents = new ArrayList<Integer>();

        private CommandVerifyKeyListener() {
            this.enabledEvents.add(0x1000003);
            this.enabledEvents.add(0x1000004);
            this.enabledEvents.add(0x1000005);
            this.enabledEvents.add(0x1000006);
            this.enabledEvents.add(0x1000007);
            this.enabledEvents.add(0x1000008);
        }

        public void verifyKey(VerifyEvent event) {
            int currentCaretLocation = CommandConsoleViewer.this.getCurrentCaretLocation();
            int selectionRangeStart = ((CommandConsoleViewer)CommandConsoleViewer.this).styledtext.getSelectionRange().x;
            boolean emptyLine = CommandConsoleViewer.this.getLine(CommandConsoleViewer.this.currentLine).isEmpty();
            if (emptyLine || CommandConsoleViewer.this.caretLinePosition > currentCaretLocation || CommandConsoleViewer.this.caretLinePosition > selectionRangeStart) {
                if (!this.enabledEvents.contains(event.keyCode)) {
                    if (event.stateMask == 0 && (event.keyCode >= 97 && event.keyCode <= 122 || event.keyCode >= 48 && event.keyCode <= 57)) {
                        CommandConsoleViewer.this.moveCaretToCommandLine();
                    } else {
                        event.doit = false;
                    }
                }
                if (event.stateMask == 262144 && event.keyCode == 99) {
                    event.doit = true;
                }
            } else if (event.keyCode == 8) {
                this.checkBackspace(event, currentCaretLocation);
            } else if (event.keyCode == 127) {
                this.checkDelete(event, currentCaretLocation);
            } else if (event.stateMask == 262144 && event.keyCode == 118 || event.stateMask == 131072 && event.keyCode == 0x1000009) {
                event.doit = false;
                CommandConsoleViewer.this.pasteAction.run();
            }
        }

        private void checkBackspace(VerifyEvent event, int caretOffset) {
            String line = CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine);
            event.doit = CommandConsoleViewer.this.caretLinePosition < caretOffset && !line.isEmpty();
        }

        private void checkDelete(VerifyEvent event, int caretOffset) {
            String line = CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine);
            event.doit = !line.isEmpty();
        }
    }

    private final class CopyAction
    extends Action {
        protected CopyAction(String text) {
            super(text);
        }

        public void run() {
            CommandConsoleViewer.this.styledtext.copy();
        }
    }

    private class DisplayText
    implements Runnable {
        private final String text;

        DisplayText(String text) {
            this.text = text;
        }

        @Override
        @TaskDescription(value="Display Text")
        public void run() {
            if (CommandConsoleViewer.this.styledtext.isDisposed()) {
                return;
            }
            if (this.text.equals(CommandConsoleViewer.RCEPROMPT)) {
                CommandConsoleViewer.this.insertRCEPrompt();
            } else {
                CommandConsoleViewer.this.displayMessage(this.text);
            }
        }
    }

    private class ExecuteCommand
    implements Runnable {
        private final String command;
        private final Display display = Display.getDefault();
        private int line;
        private volatile boolean writing;

        ExecuteCommand(String command) {
            this.command = command;
            this.writing = true;
        }

        @Override
        @TaskDescription(value="Execute Command")
        public void run() {
            CommandConsoleViewer.this.commandService.saveCommand(this.command);
            CommandConsoleViewer.this.commandService.addUsedCommand(this.command);
            List<String> tokens = this.getTokens();
            CommandConsoleViewer.this.commandExecutionService.asyncExecMultiCommand(tokens, (TextOutputReceiver)CommandConsoleViewer.this.textOutputReceiver, (Object)"command console");
        }

        private void waitWithDelay() {
            int sleepTime = 5;
            try {
                while (this.writing) {
                    Thread.sleep(sleepTime);
                    this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                block2: {
                                    if (CommandConsoleViewer.this.styledtext.isDisposed()) break block2;
                                    if (!ExecuteCommand.this.writing) break block3;
                                    CommandConsoleViewer commandConsoleViewer = CommandConsoleViewer.this;
                                    ExecuteCommand executeCommand = ExecuteCommand.this;
                                    int n = executeCommand.line;
                                    executeCommand.line = n + 1;
                                    if (!commandConsoleViewer.getLineWithoutRCEPROMPT(n).isEmpty()) break block3;
                                }
                                ExecuteCommand.this.writing = false;
                            }
                        }
                    });
                }
                this.display.asyncExec((Runnable)new DisplayText(CommandConsoleViewer.RCEPROMPT));
            }
            catch (InterruptedException e) {
                CommandConsoleViewer.this.log.error((Object)"Exception while waiting for console output", (Throwable)e);
            }
        }

        private void waitForExecToFinish(Future<CommandExecutionResult> asyncExecMultiCommand) {
            try {
                CommandExecutionResult commandExecutionResult = asyncExecMultiCommand.get();
                if (commandExecutionResult == CommandExecutionResult.DEFAULT || commandExecutionResult == CommandExecutionResult.ERROR) {
                    this.display.asyncExec((Runnable)new DisplayText(CommandConsoleViewer.RCEPROMPT));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                CommandConsoleViewer.this.log.error((Object)"Exception while waiting for console command to complete", (Throwable)e);
            }
        }

        private List<String> getTokens() {
            String[] arguments;
            LinkedList<String> tokens = new LinkedList<String>();
            String[] stringArray = arguments = this.command.split(" ");
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                tokens.add(argument);
                ++n2;
            }
            return tokens;
        }
    }

    private final class PasteAction
    extends Action {
        PasteAction(String text) {
            super(text);
        }

        public void run() {
            String content = ClipboardHelper.getContentAsStringOrNull();
            if (content == null) {
                return;
            }
            final int contentLength = content.length();
            if (contentLength < 10000) {
                if (content.contains(CommandConsoleViewer.this.platformIndependentLineBreak)) {
                    content = content.replaceAll(CommandConsoleViewer.this.platformIndependentLineBreak, " ");
                }
                ClipboardHelper.setContent((String)content);
                CommandConsoleViewer.this.styledtext.paste();
                String line = CommandConsoleViewer.this.getLineWithoutRCEPROMPT(CommandConsoleViewer.this.currentLine);
                CommandConsoleViewer.this.setStyledRange(CommandConsoleViewer.this.caretLinePosition, line.length());
                if (!line.isEmpty()) {
                    CommandConsoleViewer.this.clearConsoleAction.setEnabled(true);
                }
            } else {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String warningMessage = "The text could not be pasted because it is too long. Its length is " + contentLength + " characters but the maximum allowed length is " + 10000 + " characters.";
                        MessageDialog.open((int)1, null, (String)"Warning", (String)warningMessage, (int)0);
                    }
                });
            }
        }
    }
}

