/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.loader.execution.validator;

import de.rcenvironment.components.xml.loader.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import java.util.ArrayList;
import java.util.List;

public class XmlLoaderComponentValidator
extends AbstractComponentValidator {
    private static final String PROPERTY_XML_CONTENT = "xmlContent";

    public String getIdentifier() {
        return "de.rcenvironment.xmlloader";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        this.validateXMLContent(componentDescription, messages);
        return messages;
    }

    private void validateXMLContent(ComponentDescription componentDescription, List<ComponentValidationMessage> messages) {
        String xmlContent = this.getProperty(componentDescription, PROPERTY_XML_CONTENT);
        if (xmlContent == null || xmlContent.isEmpty()) {
            messages.add(new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, PROPERTY_XML_CONTENT, Messages.noXmlFileLoaded, Messages.noXmlFileLoadedLong));
        }
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        this.validateXMLContent(componentDescription, messages);
        return messages;
    }
}

