/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.api;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.IntegerParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.MultiStateCommandParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.monitoring.system.api.LocalSystemMonitoringAggregationService;
import de.rcenvironment.core.monitoring.system.api.model.AverageOfDoubles;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class SystemMonitoringCommandPlugin
implements CommandPlugin {
    private static final String ROOT_COMMAND = "sysmon";
    private static final String SUBCOMMAND_FETCH_LOCAL = "--local";
    private static final String SUBCOMMAND_FETCH_LOCAL_SHORT = "-l";
    private static final String SUBCOMMAND_FETCH_REMOTE = "--remote";
    private static final String SUBCOMMAND_FETCH_REMOTE_SHORT = "-r";
    private static final String SUBCOMMAND_API = "api";
    private static final String SPACE = " ";
    private static final String DEFAULT = "default";
    private static final String AVG_CPU_RAM = "avgcpu+ram";
    private static final int DEFAULT_FETCH_TIME_SPAN_VALUE_SEC = 10;
    private static final int DEFAULT_FETCH_TIME_LIMIT_VALUE_MSEC = 1000;
    private static final int SEC_TO_MSEC = 1000;
    private static final CommandFlag LOCAL_FLAG = new CommandFlag("-l", "--local", "local information");
    private static final CommandFlag REMOTE_FLAG = new CommandFlag("-r", "--remote", "remote information");
    private static final MultiStateCommandParameter API_PARAMETER = new MultiStateCommandParameter("<operation>", "operation to perform", new String[]{"default", "avgcpu+ram"});
    private static final IntegerParameter TIME_SPAN_PARAMETER = new IntegerParameter(Integer.valueOf(0), "<time span>", "time span of the monitoring in seconds");
    private static final IntegerParameter TIME_LIMIT_PARAMETER = new IntegerParameter(Integer.valueOf(0), "<time limit>", "time limit of the monitoring in seconds");
    private LocalSystemMonitoringAggregationService localSystemMonitoringAggregationService;
    private CommunicationService communicationService;
    private InstanceNodeSessionId localInstanceNodeSessionId;

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(ROOT_COMMAND, "Commands for system-monitoring", "basic system-monitoring information", this::performSysMain, new CommandModifierInfo(new CommandFlag[]{LOCAL_FLAG, REMOTE_FLAG}), new SubCommandDescription[]{new SubCommandDescription(SUBCOMMAND_API, "fetches system monitoring data from all reachable nodes in the network,and prints it in a parser-friendly format.", this::performSysApi, new CommandModifierInfo(new AbstractCommandParameter[]{API_PARAMETER, TIME_SPAN_PARAMETER, TIME_LIMIT_PARAMETER}))});
        return new MainCommandDescription[]{commands};
    }

    private void performSysMain(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        boolean local = modifiers.hasCommandFlag(SUBCOMMAND_FETCH_LOCAL);
        boolean remote = modifiers.hasCommandFlag(SUBCOMMAND_FETCH_REMOTE);
        if (local && remote) {
            throw CommandException.syntaxError((String)"Only one of the two flags \"--loacl\"/\"--remote\" can be entered", (CommandContext)context);
        }
        if (!local && !remote) {
            throw CommandException.syntaxError((String)"One of the two flags \"--loacl\"/\"--remote\" can be entered", (CommandContext)context);
        }
        if (local) {
            this.performPrintLocalSysMonData(context, 10000, 1000, true);
        } else {
            this.performCollectAndPrintSysMonData(context, 10000, 1000, true);
        }
    }

    private void performSysApi(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        int timeSpanSec = ((ParsedIntegerParameter)modifiers.getPositionalCommandParameter(1)).getResult();
        int timeLimitMsec = ((ParsedIntegerParameter)modifiers.getPositionalCommandParameter(2)).getResult();
        this.performCollectAndPrintSysMonData(context, timeSpanSec * 1000, timeLimitMsec, false);
    }

    public void bindLocalSystemMonitoringAggregationService(LocalSystemMonitoringAggregationService newInstance) {
        this.localSystemMonitoringAggregationService = newInstance;
    }

    public void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    public void bindPlatformService(PlatformService newInstance) {
        this.localInstanceNodeSessionId = newInstance.getLocalInstanceNodeSessionId();
    }

    private void performPrintLocalSysMonData(CommandContext context, int timeSpanMsec, int timeLimitMsec, boolean humanReadable) throws CommandException {
        HashSet<InstanceNodeSessionId> singleNodeIdSet = new HashSet<InstanceNodeSessionId>();
        singleNodeIdSet.add(this.localInstanceNodeSessionId);
        this.performCollectAndPrintSysMonData(context, singleNodeIdSet, timeSpanMsec, timeLimitMsec, humanReadable);
    }

    private void performCollectAndPrintSysMonData(CommandContext context, int timeSpanMsec, int timeLimitMsec, boolean humanReadable) throws CommandException {
        Set reachableInstanceNodes = this.communicationService.getReachableInstanceNodes();
        this.performCollectAndPrintSysMonData(context, reachableInstanceNodes, timeSpanMsec, timeLimitMsec, humanReadable);
    }

    private void performCollectAndPrintSysMonData(CommandContext context, Set<InstanceNodeSessionId> nodeIds, int timeSpanMsec, int timeLimitMsec, boolean humanReadable) throws CommandException {
        Map<InstanceNodeSessionId, SystemLoadInformation> resultMap;
        try {
            resultMap = this.localSystemMonitoringAggregationService.collectSystemMonitoringDataWithTimeLimit(nodeIds, timeSpanMsec, timeLimitMsec);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
        String formatString = humanReadable ? "%s - Average CPU load:%6.2f (%2d samples over %5d msec), Available RAM:%6d kiB" : "id=%s CpuAvg=%.2f n=%d t=%d FreeRam=%d";
        StringBuilder outputBuffer = new StringBuilder();
        for (Map.Entry<InstanceNodeSessionId, SystemLoadInformation> e : resultMap.entrySet()) {
            SystemLoadInformation data = e.getValue();
            AverageOfDoubles cpuLoadAvg = data.getCpuLoadAvg();
            String nodeIdString = e.getKey().getInstanceNodeSessionIdString();
            int cpuLoadAvgTimeSpan = cpuLoadAvg.getNumSamples() * 1000;
            double cpuAvgAsPercentage = cpuLoadAvg.getAverage() * 100.0;
            if (outputBuffer.length() != 0) {
                outputBuffer.append("\n");
            }
            outputBuffer.append(StringUtils.format((String)formatString, (Object[])new Object[]{nodeIdString, cpuAvgAsPercentage, cpuLoadAvg.getNumSamples(), cpuLoadAvgTimeSpan, data.getAvailableRam()}));
            if (!humanReadable) continue;
            outputBuffer.append(" (");
            outputBuffer.append(e.getKey().getAssociatedDisplayName());
            outputBuffer.append(")");
        }
        context.println((Object)outputBuffer.toString());
    }

    private int parseRequiredPositiveIntParameter(CommandContext context, String name) throws CommandException {
        int timespan;
        String parameter = context.consumeNextToken();
        if (parameter == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            timespan = Integer.parseInt(parameter);
            if (timespan <= 0) {
                throw CommandException.syntaxError((String)("The " + name + " parameter must be positive: " + parameter), (CommandContext)context);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw CommandException.syntaxError((String)("The " + name + " parameter must be an integer number: " + parameter), (CommandContext)context);
        }
        return timespan;
    }
}

