/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.update.internal;

import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.RemotablePersistentComponentDescriptionUpdateService;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentComponentDescriptionUpdateServiceImpl
implements RemotablePersistentComponentDescriptionUpdateService {
    private Map<String, PersistentComponentDescriptionUpdater> updaters = new HashMap<String, PersistentComponentDescriptionUpdater>();
    private Map<Boolean, Map<String, Integer>> versionsToUpdate = new HashMap<Boolean, Map<String, Integer>>();

    public PersistentComponentDescriptionUpdateServiceImpl() {
        this.versionsToUpdate.put(true, Collections.synchronizedMap(new HashMap()));
        this.versionsToUpdate.put(false, Collections.synchronizedMap(new HashMap()));
    }

    @Override
    @AllowRemoteAccess
    public int getFormatVersionsAffectedByUpdate(List<PersistentComponentDescription> descriptions, Boolean silent) throws RemoteOperationException {
        int updateAvailable = 0;
        if (descriptions != null) {
            for (PersistentComponentDescription description : descriptions) {
                PersistentComponentDescriptionUpdater updater = this.findFirstMatchingUpdater(description.getComponentIdentifier());
                if (this.versionsToUpdate.get(silent).containsKey(this.getVersionMapIdentifier(description))) {
                    updateAvailable |= this.versionsToUpdate.get(silent).get(this.getVersionMapIdentifier(description)).intValue();
                    continue;
                }
                if (updater == null) continue;
                int update = updater.getFormatVersionsAffectedByUpdate(description.getComponentVersion(), silent);
                updateAvailable |= update;
                this.versionsToUpdate.get(silent).put(this.getVersionMapIdentifier(description), update);
            }
        }
        return updateAvailable;
    }

    private String getVersionMapIdentifier(PersistentComponentDescription description) {
        return String.valueOf(description.getComponentIdentifier()) + description.getComponentVersion();
    }

    private boolean isUpdateNeeded(PersistentComponentDescription description, boolean silent, int formatVersion, PersistentComponentDescriptionUpdater updater) {
        if (!this.versionsToUpdate.get(silent).containsKey(this.getVersionMapIdentifier(description))) {
            this.versionsToUpdate.get(silent).put(this.getVersionMapIdentifier(description), updater.getFormatVersionsAffectedByUpdate(description.getComponentVersion(), silent));
        }
        return (this.versionsToUpdate.get(silent).get(this.getVersionMapIdentifier(description)) & formatVersion) == formatVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentComponentDescriptionUpdater findFirstMatchingUpdater(String compIdentifier) {
        Map<String, PersistentComponentDescriptionUpdater> map = this.updaters;
        synchronized (map) {
            for (String key : this.updaters.keySet()) {
                if (!compIdentifier.matches(key)) continue;
                return this.updaters.get(key);
            }
        }
        return null;
    }

    @Override
    @AllowRemoteAccess
    public List<PersistentComponentDescription> performComponentDescriptionUpdates(Integer formatVersion, List<PersistentComponentDescription> descriptions, Boolean silent) throws IOException, RemoteOperationException {
        ArrayList<PersistentComponentDescription> updatedDescriptions = new ArrayList<PersistentComponentDescription>();
        for (PersistentComponentDescription description : descriptions) {
            PersistentComponentDescriptionUpdater updater = this.findFirstMatchingUpdater(description.getComponentIdentifier());
            if (updater != null && this.isUpdateNeeded(description, silent, formatVersion, updater)) {
                updatedDescriptions.add(updater.performComponentDescriptionUpdate(formatVersion, description, silent));
                continue;
            }
            updatedDescriptions.add(description);
        }
        return updatedDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPersistentComponentDescriptionUpdater(PersistentComponentDescriptionUpdater updater) {
        String[] stringArray = updater.getComponentIdentifiersAffectedByUpdate();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            Map<String, PersistentComponentDescriptionUpdater> map = this.updaters;
            synchronized (map) {
                this.updaters.put(identifier, updater);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePersistentComponentDescriptionUpdater(PersistentComponentDescriptionUpdater updater) {
        Map<String, PersistentComponentDescriptionUpdater> map = this.updaters;
        synchronized (map) {
            this.updaters.remove(updater.getComponentIdentifiersAffectedByUpdate());
        }
    }
}

