/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.WorkflowHostSetListener;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.EndpointContentProvider;
import de.rcenvironment.core.gui.workflow.editor.connections.EndpointTreeViewer;
import de.rcenvironment.core.gui.workflow.view.properties.InputModel;
import de.rcenvironment.core.gui.workflow.view.properties.InputQueueDialogController;
import de.rcenvironment.core.gui.workflow.view.properties.Messages;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractInputSection
extends AbstractPropertySection {
    private static final long REFRESH_INTERVAL = 1000L;
    private static final int COLUMN_WIDTH_ONE = 250;
    private static final int COLUMN_WIDTH_THREE = 50;
    protected WorkflowExecutionInformation wfExeInfo;
    protected EndpointTreeViewer inputTreeViewer;
    private Composite parent;
    private List<TreeEditor> treeEditors = new ArrayList<TreeEditor>();
    private InputModel inputModel;
    private Display display;
    private ServiceRegistryPublisherAccess serviceRegistryAccess;
    private CountDownLatch modelInitializedLatch = new CountDownLatch(1);
    private ScheduledFuture<?> refreshFuture;

    public AbstractInputSection() {
        Job job = new Job("Opening inputs view"){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractInputSection.this.inputModel = InputModel.getInstance();
                AbstractInputSection.this.modelInitializedLatch.countDown();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.retrieveWorkflowInformation(part, selection);
        this.initializeTreeViewer(part, selection);
        this.inputTreeViewer.expandAll();
        this.setInputQueueButton(this.inputTreeViewer.getTree());
        this.refresh();
    }

    protected abstract void retrieveWorkflowInformation(IWorkbenchPart var1, ISelection var2);

    protected abstract void initializeTreeViewer(IWorkbenchPart var1, ISelection var2);

    public void createControls(Composite aParent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(this.parent, aTabbedPropertySheetPage);
        this.parent = aParent;
        this.display = this.parent.getShell().getDisplay();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.parent.setLayout((Layout)gridLayout);
        this.inputTreeViewer = new EndpointTreeViewer(this.parent, 65536);
        this.inputTreeViewer.setContentProvider((IContentProvider)new EndpointContentProvider(EndpointType.INPUT));
        Tree endpointTree = this.inputTreeViewer.getTree();
        endpointTree.setHeaderVisible(true);
        TreeColumn inputColumn = new TreeColumn(endpointTree, 16384);
        inputColumn.setText(Messages.inputs);
        inputColumn.setWidth(250);
        TreeColumn currentInputColumn = new TreeColumn(endpointTree, 0x1000000);
        currentInputColumn.setText(Messages.latestInput);
        currentInputColumn.setWidth(250);
        TreeColumn inputQueueColumn = new TreeColumn(endpointTree, 16384);
        inputQueueColumn.setText(Messages.inputQueue);
        inputQueueColumn.setWidth(50);
        endpointTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        endpointTree.setLinesVisible(true);
        this.registerWorkflowHostSetListener();
        this.scheduleRefreshTimer();
    }

    private void registerWorkflowHostSetListener() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        this.serviceRegistryAccess.registerService(WorkflowHostSetListener.class, (Object)new WorkflowHostSetListener(){

            public void onReachableWorkflowHostsChanged(Set<InstanceNodeSessionId> reachableWfHosts, Set<InstanceNodeSessionId> addedWfHosts, Set<InstanceNodeSessionId> removedWfHosts) {
                try {
                    AbstractInputSection.this.modelInitializedLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for input model creation to complete", e);
                }
                AbstractInputSection.this.inputModel.updateSubscriptions();
                AbstractInputSection.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).AbstractInputSection.this.inputTreeViewer != null && !(this).AbstractInputSection.this.inputTreeViewer.getTree().isDisposed()) {
                            (this).AbstractInputSection.this.inputTreeViewer.refresh();
                        }
                    }
                });
            }
        });
    }

    public void dispose() {
        if (this.refreshFuture != null) {
            this.refreshFuture.cancel(true);
        }
        if (this.serviceRegistryAccess != null) {
            this.serviceRegistryAccess.dispose();
        }
        super.dispose();
    }

    public void scheduleRefreshTimer() {
        this.refreshFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Refresh inputs processed by components", (Runnable)new RefreshTask(), 1000L);
    }

    public void cancelRefreshTimer() {
        this.refreshFuture.cancel(true);
    }

    public void refreshTable() {
        if (this.inputTreeViewer != null && this.inputTreeViewer.getTree() != null && !this.inputTreeViewer.getTree().isDisposed()) {
            this.inputTreeViewer.getControl().setRedraw(false);
            this.inputTreeViewer.refresh();
            this.inputTreeViewer.expandAll();
            this.inputTreeViewer.getControl().setRedraw(true);
            this.setInputQueueButton(this.inputTreeViewer.getTree());
            this.inputTreeViewer.getControl().redraw();
        }
    }

    private void setInputQueueButton(Tree tree) {
        for (TreeEditor treeEditor : this.treeEditors) {
            Control oldEditor = treeEditor.getEditor();
            if (oldEditor == null) continue;
            oldEditor.dispose();
        }
        this.treeEditors.clear();
        TreeItem[] treeItemArray = this.inputTreeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.setInputQueueButton(treeItem);
            ++n2;
        }
    }

    private void setInputQueueButton(TreeItem treeItem) {
        if (treeItem.getItemCount() > 0) {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childTreeItem = treeItemArray[n2];
                this.setInputQueueButton(childTreeItem);
                ++n2;
            }
        } else {
            TreeEditor treeEditor = new TreeEditor(this.inputTreeViewer.getTree());
            Button button = new Button((Composite)this.inputTreeViewer.getTree(), 8);
            button.setText("...");
            button.computeSize(-1, this.inputTreeViewer.getTree().getItemHeight());
            treeEditor.grabHorizontal = true;
            treeEditor.minimumHeight = button.getSize().y;
            treeEditor.minimumWidth = button.getSize().x;
            treeEditor.setEditor((Control)button, treeItem, 2);
            this.treeEditors.add(treeEditor);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(treeItem){
                private TreeItem item;
                {
                    this.item = treeItem;
                }

                public void widgetSelected(SelectionEvent event) {
                    AbstractInputSection.this.openInputDialog(this.item);
                }
            });
        }
    }

    protected abstract void openInputDialog(TreeItem var1);

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            if (AbstractInputSection.this.inputTreeViewer != null && !AbstractInputSection.this.inputTreeViewer.getTree().isDisposed()) {
                AbstractInputSection.this.inputTreeViewer.getTree().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractInputSection.this.inputModel != null) {
                            AbstractInputSection.this.refreshTable();
                            InputQueueDialogController inputQueueDialogController = InputQueueDialogController.getInstance();
                            if (inputQueueDialogController != null) {
                                inputQueueDialogController.redrawTable();
                            }
                        }
                    }
                });
            }
        }
    }
}

