/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.parts;

import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.model.api.ComponentImageContainerService;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentShape;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessageStore;
import de.rcenvironment.core.component.workflow.execution.impl.WorkflowExecutionInformationImpl;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.editor.commands.ConnectionDrawCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.ComponentPropertySource;
import de.rcenvironment.core.gui.workflow.editor.validator.WorkflowDescriptionValidationUtils;
import de.rcenvironment.core.gui.workflow.parts.ConnectionAnchorUtils;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import de.rcenvironment.core.gui.workflow.parts.Messages;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class WorkflowNodePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    public static final int SMALL_WORKFLOW_NODE_WIDTH = 41;
    public static final int WORKFLOW_NODE_WIDTH = 81;
    private static final int OFFSET_FACTOR = 2;
    private static final int MAX_LABELTEXT_SIZE = 30;
    private static final String LABEL_TEXT_SEPARATOR = "...";
    private static final int MAX_LABEL_WIDTH = 73;
    private static final Image ERROR_IMAGE = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16);
    private static final Image WARNING_IMAGE = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16);
    private static final Image LOCAL_IMAGE = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.LOCAL);
    private static final Image IMITATION_MODE_IMAGE = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.IMITATION_MODE);
    private static final Image DEPRECATED_IMAGE = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.DEPRECATED);
    protected final IFigure informationFigure = new ImageFigure(LOCAL_IMAGE);
    private final IFigure errorFigure;
    private final IFigure warningFigure;
    private final IFigure deprecatedFigure;
    private final ToolIntegrationContextRegistry toolIntegrationRegistry;
    private String currentLabel;
    private Image imageToDispose;

    public WorkflowNodePart() {
        this.informationFigure.setBounds(new Rectangle(62, 62, 16, 16));
        this.informationFigure.setToolTip((IFigure)new Label(Messages.localExecutionOnly));
        this.informationFigure.setVisible(false);
        this.errorFigure = new ImageFigure(ERROR_IMAGE);
        this.errorFigure.setBounds(new Rectangle(2, 2, 16, 16));
        this.errorFigure.setVisible(false);
        this.warningFigure = new ImageFigure(WARNING_IMAGE);
        this.warningFigure.setBounds(new Rectangle(62, 2, 16, 16));
        this.warningFigure.setVisible(false);
        this.deprecatedFigure = new ImageFigure(DEPRECATED_IMAGE);
        this.deprecatedFigure.setBounds(new Rectangle(23, 17, 32, 32));
        this.deprecatedFigure.setToolTip((IFigure)new Label(Messages.deprecated));
        this.deprecatedFigure.setVisible(false);
        this.currentLabel = "";
        this.imageToDispose = null;
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        this.toolIntegrationRegistry = (ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
    }

    public void activate() {
        super.activate();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                WorkflowDescriptionValidationUtils.validateComponent(WorkflowNodePart.this.getWorkflowNode(), false);
                WorkflowNodePart.this.updateValid();
            }
        });
        ((PropertiesChangeSupport)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        super.deactivate();
        if (this.imageToDispose != null) {
            this.imageToDispose.dispose();
        }
        ((PropertiesChangeSupport)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
    }

    private List<ComponentValidationMessage> getValidationMessages() {
        return ComponentValidationMessageStore.getInstance().getMessagesByComponentId(this.getWorkflowNode().getIdentifierAsObject().toString());
    }

    private String getValidationMessageText(ComponentValidationMessage.Type type) {
        StringBuilder builder = new StringBuilder();
        for (ComponentValidationMessage message : this.getValidationMessages()) {
            if (type != null && type != message.getType()) continue;
            String messageText = message.getAbsoluteMessage();
            if (messageText == null || messageText.isEmpty()) {
                String property = message.getProperty();
                String relativeMessage = message.getRelativeMessage();
                messageText = property == null || property.isEmpty() ? relativeMessage : StringUtils.format((String)"%s: %s", (Object[])new Object[]{property, relativeMessage});
            }
            builder.append("- ");
            builder.append(messageText);
            builder.append("\n\n");
        }
        return builder.toString().trim();
    }

    public void updateValid() {
        String errorText = this.getValidationMessageText(ComponentValidationMessage.Type.ERROR);
        this.errorFigure.setVisible(!errorText.isEmpty());
        this.errorFigure.setToolTip((IFigure)new Label(errorText));
        String warningText = this.getValidationMessageText(ComponentValidationMessage.Type.WARNING);
        this.warningFigure.setVisible(!warningText.isEmpty());
        this.warningFigure.setToolTip((IFigure)new Label(warningText));
        if (!this.getWorkflowNode().isEnabled()) {
            this.errorFigure.setVisible(false);
            this.warningFigure.setVisible(false);
        }
        this.refresh();
        this.refreshVisuals();
    }

    protected WorkflowNode getWorkflowNode() {
        return (WorkflowNode)this.getModel();
    }

    protected IFigure createFigure() {
        IFigure figure = this.createBaseFigure();
        ComponentInterface ci = ((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface();
        if (ci.getShape() == ComponentShape.CIRCLE) {
            this.errorFigure.setBounds(new Rectangle(3, 3, 16, 16));
            this.warningFigure.setBounds(new Rectangle(3, 3, 16, 16));
            this.informationFigure.setBounds(new Rectangle(22, 20, 16, 16));
        } else if (ci.getSize() == ComponentSize.SMALL) {
            this.warningFigure.setBounds(new Rectangle(22, 1, 16, 16));
            this.informationFigure.setBounds(new Rectangle(22, 22, 16, 16));
        }
        figure.add(this.errorFigure);
        figure.add(this.warningFigure);
        figure.add(this.informationFigure);
        figure.add(this.deprecatedFigure);
        return figure;
    }

    protected IFigure createBaseFigure() {
        Image image = null;
        ComponentInterface ci = ((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface();
        image = ci.getSize() == ComponentSize.SMALL ? ((ComponentImageContainerService)ServiceRegistry.createAccessFor((Object)this).getService(ComponentImageContainerService.class)).getComponentImageContainer(ci).getComponentIcon24() : ((ComponentImageContainerService)ServiceRegistry.createAccessFor((Object)this).getService(ComponentImageContainerService.class)).getComponentImageContainer(ci).getComponentIcon32();
        if (image == null) {
            image = ci.getIdentifierAndVersion().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_") ? (ci.getSize() == ComponentSize.SMALL ? ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_24_GREY) : ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_32_GREY)) : (ci.getSize() == ComponentSize.SMALL ? ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_24) : ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_32));
        }
        Color color = this.getColor(ci);
        if (ci.getSize() == ComponentSize.SMALL) {
            IconLabel iconLabel = new IconLabel(image, ci);
            iconLabel.setOpaque(true);
            iconLabel.setBorder(null);
            iconLabel.setBackgroundColor(color);
            return iconLabel;
        }
        String labelText = ((WorkflowNode)this.getModel()).getName();
        Label label = new Label(labelText, image);
        label.setTextPlacement(4);
        label.setBorder((Border)new LineBorder());
        label.setOpaque(true);
        label.setBackgroundColor(color);
        return label;
    }

    private Color getColor(ComponentInterface ci) {
        if (!this.getWorkflowNode().isEnabled()) {
            return ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_GREY);
        }
        if (ci.getColor() == null) {
            return ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_COLOR_2);
        }
        if (Boolean.valueOf(((WorkflowNode)this.getModel()).getConfigurationDescription().getConfigurationValue("isImitationMode")).booleanValue()) {
            return ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_IMITATION);
        }
        return ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_COLOR_1);
    }

    protected void setTooltipText() {
        this.getFigure().setToolTip((IFigure)new Label(this.generateTooltipText()));
    }

    protected String generateTooltipText() {
        WorkflowNode node = (WorkflowNode)this.getModel();
        String enabled = "enabled";
        if (!node.isEnabled()) {
            enabled = "disabled";
        } else if (node.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_")) {
            enabled = "not available";
        }
        if (Boolean.valueOf(node.getConfigurationDescription().getConfigurationValue("isImitationMode")).booleanValue()) {
            enabled = String.valueOf(enabled) + " (imitation mode)";
        }
        return String.valueOf(this.generateTooltipTextBase(node)) + ": " + enabled;
    }

    protected String generateTooltipTextBase(WorkflowNode node) {
        if (node.getComponentDescription().getVersion() != null && this.toolIntegrationRegistry.hasTIContextMatchingPrefix(node.getComponentDescription().getIdentifier())) {
            return StringUtils.format((String)"%s - %s (%s)", (Object[])new Object[]{node.getName(), node.getComponentDescription().getName(), node.getComponentDescription().getVersion()});
        }
        return StringUtils.format((String)"%s - %s", (Object[])new Object[]{node.getName(), node.getComponentDescription().getName()});
    }

    public void refreshVisuals() {
        Point loc = new Point(((WorkflowNode)this.getModel()).getX(), ((WorkflowNode)this.getModel()).getY());
        int width = 81;
        int height = 81;
        if (((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getSize() == ComponentSize.SMALL) {
            width = 41;
            height = 41;
        }
        Rectangle r = new Rectangle(loc, new Dimension(width, height));
        Label label = (Label)this.getFigure();
        String labelText = this.getWorkflowNode().getName();
        if (!this.currentLabel.equals(this.getWorkflowNode().getName())) {
            this.abbreviateLabel(label, labelText, 30);
        }
        this.currentLabel = labelText;
        this.setTooltipText();
        if (((WorkflowNode)this.getModel()).getComponentDescription().canOnlyBeExecutedLocally()) {
            ((ImageFigure)this.informationFigure).setImage(LOCAL_IMAGE);
            this.informationFigure.setToolTip((IFigure)new Label(Messages.localExecutionOnly));
            this.informationFigure.setVisible(true);
        } else if (Boolean.valueOf(((WorkflowNode)this.getModel()).getConfigurationDescription().getConfigurationValue("isImitationMode")).booleanValue()) {
            ((ImageFigure)this.informationFigure).setImage(IMITATION_MODE_IMAGE);
            this.informationFigure.setToolTip((IFigure)new Label(Messages.imitationMode));
            this.informationFigure.setVisible(true);
        } else {
            this.informationFigure.setVisible(false);
        }
        this.deprecatedFigure.setVisible(((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getIsDeprecated());
        this.getFigure().setBackgroundColor(this.getColor(((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface()));
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)label, (Object)r);
    }

    private String abbreviateLabel(Label label, String labelText, int currentLength) {
        label.setText(labelText);
        if (label.getFont() == null) {
            label.setFont(Display.getDefault().getSystemFont());
        }
        if (label.getTextBounds().width > 73) {
            String shorterLabelText = "";
            shorterLabelText = org.apache.commons.lang3.StringUtils.abbreviateMiddle((String)label.getText(), (String)LABEL_TEXT_SEPARATOR, (int)currentLength);
            label.setText(shorterLabelText);
            this.abbreviateLabel(label, shorterLabelText, --currentLength);
        }
        return label.getText();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        ((WorkflowNode)this.getModel()).setValid(false);
        if ("de.rcenvironment.rce.component.workflow.CommunicationNode".equals(prop) || "de.rcenvironment.props.n".equals(prop)) {
            this.refreshVisuals();
        }
    }

    public void refreshConnections() {
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        boolean isSmallComponent;
        if (connection != null && connection.getSource() != null && connection.getTarget() != null && connection.getSource().equals(connection.getTarget())) {
            return new ReconnectionSourceAnchor(this.getFigure());
        }
        if (((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getShape() == ComponentShape.CIRCLE) {
            return new EllipseAnchor(this.getFigure());
        }
        boolean hasInverseConnection = this.checkIfConnectionHasReverseConnectionInWorkflow(connection);
        boolean bl = isSmallComponent = ((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getSize() == ComponentSize.SMALL;
        if (hasInverseConnection && !isSmallComponent) {
            return new BidirectionalChopboxAnchor(this.getFigure(), connection, AnchorType.SOURCE);
        }
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getShape() == ComponentShape.CIRCLE) {
            return new EllipseAnchor(this.getFigure());
        }
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        boolean isSmallComponent;
        if (connection != null && connection.getSource() != null && connection.getTarget() != null && connection.getSource().equals(connection.getTarget())) {
            return new ReconnectionTargetAnchor(this.getFigure());
        }
        if (((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getShape() == ComponentShape.CIRCLE) {
            return new EllipseAnchor(this.getFigure());
        }
        boolean hasInverseConnection = this.checkIfConnectionHasReverseConnectionInWorkflow(connection);
        boolean bl = isSmallComponent = ((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getSize() == ComponentSize.SMALL;
        if (hasInverseConnection && !isSmallComponent) {
            return new BidirectionalChopboxAnchor(this.getFigure(), connection, AnchorType.TARGET);
        }
        return new ChopboxAnchor(this.getFigure());
    }

    private boolean checkIfConnectionHasReverseConnectionInWorkflow(ConnectionEditPart connection) {
        List connections = new ArrayList();
        if (this.getViewer().getContents().getModel() instanceof WorkflowDescription) {
            connections = ((WorkflowDescription)this.getViewer().getContents().getModel()).getConnections();
        } else if (this.getViewer().getContents().getModel() instanceof WorkflowExecutionInformationImpl) {
            connections = ((WorkflowExecutionInformationImpl)this.getViewer().getContents().getModel()).getWorkflowDescription().getConnections();
        }
        for (Connection connectionInWorkflow : connections) {
            if (!connectionInWorkflow.getSourceNode().equals((Object)((ConnectionWrapper)connection.getModel()).getTarget()) || !connectionInWorkflow.getTargetNode().equals((Object)((ConnectionWrapper)connection.getModel()).getSource())) continue;
            return true;
        }
        return false;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (((WorkflowNode)this.getModel()).getComponentDescription().getComponentInstallation().getComponentInterface().getShape() == ComponentShape.CIRCLE) {
            return new EllipseAnchor(this.getFigure());
        }
        return new ChopboxAnchor(this.getFigure());
    }

    protected List<ConnectionWrapper> getModelSourceConnections() {
        ArrayList<ConnectionWrapper> sourceConnections = new ArrayList<ConnectionWrapper>();
        for (ConnectionWrapper c : ((WorkflowPart)this.getParent()).getConnections()) {
            if (!c.getSource().equals(this.getModel())) continue;
            sourceConnections.add(c);
        }
        return sourceConnections;
    }

    protected List<ConnectionWrapper> getModelTargetConnections() {
        ArrayList<ConnectionWrapper> targetConnections = new ArrayList<ConnectionWrapper>();
        for (ConnectionWrapper c : ((WorkflowPart)this.getParent()).getConnections()) {
            if (!c.getTarget().equals(this.getModel())) continue;
            targetConnections.add(c);
        }
        return targetConnections;
    }

    public Object getAdapter(Class type) {
        if (type == SnapToHelper.class) {
            ArrayList<Object> helpers = new ArrayList<Object>();
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGeometry.isEnabled"))) {
                helpers.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (Boolean.TRUE.equals(this.getViewer().getProperty("SnapToGrid.isEnabled"))) {
                helpers.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (helpers.isEmpty()) {
                return null;
            }
            return new CompoundSnapToHelper(helpers.toArray(new SnapToHelper[0]));
        }
        if (type == IPropertySource.class && this.getModel() instanceof WorkflowNode) {
            return new ComponentPropertySource(this.getViewer().getEditDomain().getCommandStack(), (WorkflowNode)this.getModel());
        }
        return super.getAdapter(type);
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void createEditPolicies() {
        this.deactivateEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectEditPolicy());
    }

    private static enum AnchorType {
        SOURCE,
        TARGET;

    }

    private class BidirectionalChopboxAnchor
    extends ChopboxAnchor {
        private ConnectionEditPart connectionEditPart;
        private AnchorType type;

        BidirectionalChopboxAnchor(IFigure figure, ConnectionEditPart connection, AnchorType type) {
            super.setOwner(figure);
            this.connectionEditPart = connection;
            this.type = type;
        }

        protected Rectangle getBox() {
            ConnectionPart correspondingConnectionPart = this.findInverseConnectionPart(this.connectionEditPart);
            if (correspondingConnectionPart != null) {
                boolean draggingAtConnection;
                WorkflowNode targetNode = (WorkflowNode)this.connectionEditPart.getTarget().getModel();
                WorkflowNode sourceNode = (WorkflowNode)this.connectionEditPart.getSource().getModel();
                WorkflowDescription workflowDescription = null;
                if (WorkflowNodePart.this.getViewer().getContents().getModel() instanceof WorkflowDescription) {
                    workflowDescription = (WorkflowDescription)WorkflowNodePart.this.getViewer().getContents().getModel();
                } else if (WorkflowNodePart.this.getViewer().getContents().getModel() instanceof WorkflowExecutionInformationImpl) {
                    workflowDescription = ((WorkflowExecutionInformationImpl)WorkflowNodePart.this.getViewer().getContents().getModel()).getWorkflowDescription();
                }
                boolean hasBendpointsInAnyDirection = !ConnectionUtils.findAlreadyExistentBendpointsFromSourceToTarget(sourceNode, targetNode, workflowDescription).isEmpty();
                boolean bl = draggingAtConnection = this.connectionEditPart.getSelected() == 2 && WorkflowNodePart.this.getViewer().getControl().getData("DRAG_STATE_BENDPOINT") != null && (Boolean)WorkflowNodePart.this.getViewer().getControl().getData("DRAG_STATE_BENDPOINT") != false;
                if (!draggingAtConnection && !(hasBendpointsInAnyDirection |= !ConnectionUtils.findAlreadyExistentBendpointsFromSourceToTarget(targetNode, sourceNode, workflowDescription).isEmpty())) {
                    Rectangle referenceRectangle = this.getOwner().getBounds();
                    Point sourcePoint = new Point(sourceNode.getX(), sourceNode.getY());
                    Point targetPoint = new Point(targetNode.getX(), targetNode.getY());
                    int nodeWidth = this.determineSizeOfNode(this.connectionEditPart);
                    Orientation orientation = this.determineOrientationForAnchor(sourcePoint, targetPoint, nodeWidth);
                    if (this.type.equals((Object)AnchorType.TARGET)) {
                        switch (orientation) {
                            case NORTHWEST: {
                                return ConnectionAnchorUtils.getBottomRightRect(referenceRectangle);
                            }
                            case NORTH: {
                                return ConnectionAnchorUtils.getBottomLeftRect(referenceRectangle);
                            }
                            case NORTHEAST: {
                                return ConnectionAnchorUtils.getLeftLowerRect(referenceRectangle);
                            }
                            case WEST: {
                                return ConnectionAnchorUtils.getRightLowerRect(referenceRectangle);
                            }
                            case EAST: {
                                return ConnectionAnchorUtils.getLeftUpperRect(referenceRectangle);
                            }
                            case SOUTHWEST: {
                                return ConnectionAnchorUtils.getRightUpperRect(referenceRectangle);
                            }
                            case SOUTH: {
                                return ConnectionAnchorUtils.getTopRightRect(referenceRectangle);
                            }
                            case SOUTHEAST: {
                                return ConnectionAnchorUtils.getTopLeftRect(referenceRectangle);
                            }
                        }
                        return super.getBox();
                    }
                    if (this.type.equals((Object)AnchorType.SOURCE)) {
                        switch (orientation) {
                            case NORTHWEST: {
                                return ConnectionAnchorUtils.getLeftUpperRect(referenceRectangle);
                            }
                            case NORTH: {
                                return ConnectionAnchorUtils.getTopLeftRect(referenceRectangle);
                            }
                            case NORTHEAST: {
                                return ConnectionAnchorUtils.getTopRightRect(referenceRectangle);
                            }
                            case WEST: {
                                return ConnectionAnchorUtils.getLeftLowerRect(referenceRectangle);
                            }
                            case EAST: {
                                return ConnectionAnchorUtils.getRightUpperRect(referenceRectangle);
                            }
                            case SOUTHWEST: {
                                return ConnectionAnchorUtils.getBottomLeftRect(referenceRectangle);
                            }
                            case SOUTH: {
                                return ConnectionAnchorUtils.getBottomRightRect(referenceRectangle);
                            }
                            case SOUTHEAST: {
                                return ConnectionAnchorUtils.getRightLowerRect(referenceRectangle);
                            }
                        }
                        return super.getBox();
                    }
                }
            }
            return super.getBox();
        }

        private int determineSizeOfNode(ConnectionEditPart cPart) {
            int nodeWidth = 0;
            EditPart part = null;
            part = this.type.equals((Object)AnchorType.TARGET) ? cPart.getTarget() : cPart.getSource();
            if (part instanceof WorkflowNodePart) {
                WorkflowNodePart workflowNodePart = (WorkflowNodePart)part;
                nodeWidth = workflowNodePart.getFigure().getBounds().width;
            }
            return nodeWidth;
        }

        private ConnectionPart findInverseConnectionPart(ConnectionEditPart cPart) {
            ArrayList allConnections = new ArrayList();
            allConnections.addAll(WorkflowNodePart.this.getSourceConnections());
            allConnections.addAll(WorkflowNodePart.this.getTargetConnections());
            for (Object connection : allConnections) {
                if (!(connection instanceof ConnectionPart)) continue;
                ConnectionPart connectionPartCandidate = (ConnectionPart)connection;
                WorkflowNode connectionPartTempsSourceNode = (WorkflowNode)connectionPartCandidate.getSource().getModel();
                WorkflowNode connectionPartTempsTargetNode = (WorkflowNode)connectionPartCandidate.getTarget().getModel();
                WorkflowNode originalConnectionPartsTargetNode = (WorkflowNode)cPart.getTarget().getModel();
                WorkflowNode originalConnectionPartsSourceNode = (WorkflowNode)cPart.getSource().getModel();
                if (!connectionPartTempsSourceNode.getIdentifierAsObject().equals((Object)originalConnectionPartsTargetNode.getIdentifierAsObject()) || !connectionPartTempsTargetNode.getIdentifierAsObject().equals((Object)originalConnectionPartsSourceNode.getIdentifierAsObject())) continue;
                return connectionPartCandidate;
            }
            return null;
        }

        private Orientation determineOrientationForAnchor(Point sourcePoint, Point targetPoint, int nodeWidth) {
            Orientation orientation = Orientation.MIDDLE;
            int targetX = targetPoint.x;
            int targetY = targetPoint.y;
            int sourceX = sourcePoint.x;
            int sourceY = sourcePoint.y;
            if (targetY <= sourceY - 2 * nodeWidth) {
                if (targetX <= sourceX - 2 * nodeWidth) {
                    orientation = Orientation.NORTHWEST;
                } else if (targetX > sourceX - 2 * nodeWidth && targetX <= sourceX + 2 * nodeWidth) {
                    orientation = Orientation.NORTH;
                } else if (targetX > sourceX + 2 * nodeWidth) {
                    orientation = Orientation.NORTHEAST;
                }
            } else if (targetY > sourceY - 2 * nodeWidth && targetY <= sourceY + 2 * nodeWidth) {
                if (targetX <= sourceX - 2 * nodeWidth) {
                    orientation = Orientation.WEST;
                } else if (targetX > sourceX - 2 * nodeWidth && targetX <= sourceX + 2 * nodeWidth) {
                    if (targetY <= sourceY - nodeWidth) {
                        if (targetX <= sourceX - nodeWidth) {
                            orientation = Orientation.NORTHWEST;
                        } else if (targetX > sourceX - nodeWidth && targetX <= sourceX + nodeWidth) {
                            orientation = Orientation.NORTH;
                        } else if (targetX > sourceX + nodeWidth) {
                            orientation = Orientation.NORTHEAST;
                        }
                    } else if (targetY > sourceY - nodeWidth && targetY <= sourceY + nodeWidth) {
                        if (targetX <= sourceX - nodeWidth) {
                            orientation = Orientation.WEST;
                        } else if (targetX > sourceX - nodeWidth && targetX <= sourceX + nodeWidth) {
                            orientation = Orientation.MIDDLE;
                        } else if (targetX > sourceX + nodeWidth) {
                            orientation = Orientation.EAST;
                        }
                    } else if (targetY > sourceY + nodeWidth) {
                        if (targetX <= sourceX - nodeWidth) {
                            orientation = Orientation.SOUTHWEST;
                        } else if (targetX > sourceX - nodeWidth && targetX <= sourceX + nodeWidth) {
                            orientation = Orientation.SOUTH;
                        } else if (targetX > sourceX + nodeWidth) {
                            orientation = Orientation.SOUTHEAST;
                        }
                    }
                } else if (targetX > sourceX + 2 * nodeWidth) {
                    orientation = Orientation.EAST;
                }
            } else if (targetY > sourceY + 2 * nodeWidth) {
                if (targetX <= sourceX - 2 * nodeWidth) {
                    orientation = Orientation.SOUTHWEST;
                } else if (targetX > sourceX - 2 * nodeWidth && targetX <= sourceX + 2 * nodeWidth) {
                    orientation = Orientation.SOUTH;
                } else if (targetX > sourceX + 2 * nodeWidth) {
                    orientation = Orientation.SOUTHEAST;
                }
            }
            return orientation;
        }

        public boolean equals(Object object) {
            BidirectionalChopboxAnchor anchor;
            if (object == this) {
                return true;
            }
            return object instanceof BidirectionalChopboxAnchor && (anchor = (BidirectionalChopboxAnchor)((Object)object)).getOwner().equals(this.getOwner()) && anchor.connectionEditPart.equals(this.connectionEditPart) && anchor.type.equals((Object)this.type);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.getOwner().hashCode();
            hash = hash * 31 + this.connectionEditPart.hashCode();
            hash = hash * 31 + this.type.hashCode();
            return hash;
        }
    }

    class ConnectEditPolicy
    extends GraphicalNodeEditPolicy {
        ConnectEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            ConnectionDrawCommand cmd = (ConnectionDrawCommand)request.getStartCommand();
            cmd.setTarget((WorkflowNode)this.getHost().getModel());
            return cmd;
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            WorkflowNode source = (WorkflowNode)this.getHost().getModel();
            ConnectionDrawCommand cmd = new ConnectionDrawCommand((WorkflowDescription)WorkflowNodePart.this.getParent().getModel(), source);
            request.setStartCommand((Command)cmd);
            return cmd;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            return null;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            return null;
        }
    }

    private class IconLabel
    extends Label {
        private static final int OFFSET_SMALL_SQUARE_COMPONENT_ICON_X = 8;
        private static final int OFFSET_SMALL_SQUARE_COMPONENT_ICON_Y = 10;
        private static final int OFFSET_SMALL_CIRCLE_COMPONENT_ICON = 9;
        private final Image icon;
        private final ComponentInterface ci;

        IconLabel(Image icon, ComponentInterface ci) {
            this.icon = icon;
            this.ci = ci;
        }

        public void paintFigure(Graphics graphics) {
            int offsetY;
            int offsetX;
            if (this.ci.getShape() == ComponentShape.CIRCLE) {
                offsetX = 9;
                offsetY = 9;
                graphics.fillOval(this.getBounds());
                graphics.setAntialias(1);
                Rectangle b = this.getBounds().getCopy();
                --b.width;
                --b.height;
                graphics.drawOval(b);
                graphics.setAntialias(0);
            } else {
                offsetX = 8;
                offsetY = 10;
                graphics.fillRectangle(this.getBounds());
                Rectangle b = this.getBounds().getCopy();
                --b.width;
                --b.height;
                graphics.drawRectangle(b);
            }
            graphics.drawImage(this.icon, new Point(this.getLocation().x + offsetX, this.getLocation().y - 1 + offsetY));
        }
    }

    private static enum Orientation {
        NORTHWEST,
        NORTH,
        NORTHEAST,
        WEST,
        MIDDLE,
        EAST,
        SOUTHWEST,
        SOUTH,
        SOUTHEAST;

    }

    class ReconnectionSourceAnchor
    extends ChopboxAnchor {
        ReconnectionSourceAnchor(IFigure figure) {
            super.setOwner(figure);
        }

        protected Rectangle getBox() {
            int x = this.getOwner().getBounds().getCenter().x - 4;
            int y = this.getOwner().getBounds().getCenter().y - this.getOwner().getBounds().height / 2 - 1;
            return new Rectangle(new Point(x, y), new Point(x, y));
        }
    }

    class ReconnectionTargetAnchor
    extends ChopboxAnchor {
        ReconnectionTargetAnchor(IFigure figure) {
            super.setOwner(figure);
        }

        protected Rectangle getBox() {
            int x = this.getOwner().getBounds().getCenter().x - 4;
            int y = this.getOwner().getBounds().getCenter().y + this.getOwner().getBounds().height / 2 + 1;
            return new Rectangle(new Point(x, y), new Point(x, y));
        }
    }
}

