/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.IntegerParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedIntegerParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collection;

public class SshConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CMD_SSH = "ssh";
    private static final String DESC = " list\" to get the id)";
    private static final StringParameter ID_PARAMETER = new StringParameter(null, "<id>", "id for the ssh connection");
    private static final StringParameter DISPLAY_NAME_PRAMETER = new StringParameter(null, "<displayName>", "display name for the ssh connection");
    private static final StringParameter HOST_IP_PARAMETER = new StringParameter(null, "<host>", "host for the ssh connection");
    private static final IntegerParameter PORT_PARAMETER = new IntegerParameter(Integer.valueOf(0), "<port>", "port for the ssh connection");
    private static final StringParameter USERNAME_PARAMETER = new StringParameter(null, "<username>", "username for the ssh connection");
    private static final StringParameter KEYFILE_LOCATION_PARAMETER = new StringParameter(null, "<keyFileLocation>", "location of the key file");
    private SshConnectionService sshConnectionService;

    private void performAdd(CommandContext context) throws CommandException {
        String keyfileLocation;
        String username;
        int port;
        String host;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter displayNameParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        ParsedStringParameter hostIpParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(1);
        ParsedIntegerParameter portParameter = (ParsedIntegerParameter)modifiers.getPositionalCommandParameter(2);
        ParsedStringParameter usernameParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(3);
        ParsedStringParameter keyfileLocationParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(4);
        String connectionName = displayNameParameter.getResult();
        SshConnectionContext contextSSH = new SshConnectionContext(null, connectionName, null, host = hostIpParameter.getResult(), port = portParameter.getResult().intValue(), username = usernameParameter.getResult(), keyfileLocation = keyfileLocationParameter.getResult(), false, false, false, false);
        if (this.sshConnectionService.sshConnectionAlreadyExists(contextSSH)) {
            context.println((Object)StringUtils.format((String)"Connection setup to host '%s:%d' already exists.", (Object[])new Object[]{contextSSH.getDestinationHost(), contextSSH.getPort()}));
            return;
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Create new SSH Connection.", () -> {
            String id = this.sshConnectionService.addSshConnection(contextSSH);
            context.println((Object)("Added SSH connection setup, created id " + id));
        });
    }

    private void performList(CommandContext context) {
        Collection<SshConnectionSetup> setups = this.sshConnectionService.getAllSshConnectionSetups();
        for (SshConnectionSetup setup : setups) {
            context.println((Object)StringUtils.format((String)"%s: %s:%s username: %s, keyfile: %s (id: %s)", (Object[])new Object[]{setup.getDisplayName(), setup.getHost(), setup.getPort(), setup.getUsername(), setup.getKeyfileLocation(), setup.getId()}));
        }
    }

    private void performStart(CommandContext context) throws CommandException {
        String connectionId = ((ParsedStringParameter)context.getParsedModifiers().getPositionalCommandParameter(0)).getResult();
        ConcurrencyUtils.getAsyncTaskService().execute("Start SSH Connection.", () -> this.sshConnectionService.connectSession(connectionId));
    }

    private void performStop(CommandContext context) throws CommandException {
        String connectionId = ((ParsedStringParameter)context.getParsedModifiers().getPositionalCommandParameter(0)).getResult();
        this.sshConnectionService.disconnectSession(connectionId);
    }

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(CMD_SSH, "Commands for ssh", "Commands for ssh", this::performList, new SubCommandDescription[]{new SubCommandDescription("add", "add a new ssh connection", this::performAdd, new CommandModifierInfo(new AbstractCommandParameter[]{DISPLAY_NAME_PRAMETER, HOST_IP_PARAMETER, PORT_PARAMETER, USERNAME_PARAMETER, KEYFILE_LOCATION_PARAMETER})), new SubCommandDescription("list", "lists all ssh connections, including ids and connection states", this::performList), new SubCommandDescription("start", "starts/connects an ssh connection (use \" ssh list\" to get the id)", this::performStart, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER})), new SubCommandDescription("stop", "stops/disconnects an ssh connection (use \" ssh list\" to get the id)", this::performStop, new CommandModifierInfo(new AbstractCommandParameter[]{ID_PARAMETER}))});
        return new MainCommandDescription[]{commands};
    }

    public void bindSshConnectionSetupService(SshConnectionService newInstance) {
        this.sshConnectionService = newInstance;
    }
}

