/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.wizards.toolintegration.Messages;
import de.rcenvironment.core.gui.wizards.toolintegration.PathChooserButtonListener;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WizardToolConfigurationDialog
extends Dialog {
    private static final int VALIDATION_MESSAGE_HEIGHT_HINT = 55;
    private static final String STRING_INVALID_TOOL_DIRECTORY = "The chosen tool directory is not valid.";
    private static final String STRING_INVALID_WORKING_DIRECTORY = "Invalid path to working directory.";
    private static final String STRING_INVALID_VERSION = "The chosen version is not valid.\n%s.";
    private Text toolDirectoryText;
    private final Map<String, String> config;
    private final String title;
    private Text versionText;
    private Text rootWorkingDirText;
    private Button chooseToolDirPathButton;
    private Button chooseRootDirPathButton;
    private Button defaultTempDirButton;
    private Map<String, String> oldConfig;
    private final ToolIntegrationContext context;
    private Button limitInstancesButton;
    private Text limitInstancesText;
    private Label message;
    private Composite messageContainer;

    public WizardToolConfigurationDialog(Shell parentShell, String title, ToolIntegrationContext context) {
        super(parentShell);
        this.config = new HashMap<String, String>();
        this.config.put("limitInstallationInstances", "true");
        this.config.put("limitInstallationInstancesNumber", "10");
        this.title = title;
        this.context = context;
        this.setShellStyle(66576);
    }

    public WizardToolConfigurationDialog(Shell parentShell, String title, Map<String, String> config, ToolIntegrationContext context) {
        super(parentShell);
        this.config = config;
        this.oldConfig = new HashMap<String, String>();
        this.oldConfig.putAll(config);
        this.title = title;
        this.context = context;
        if (config.get("limitInstallationInstances") == null && config.get("limitInstalltionInstances") == null) {
            config.put("limitInstallationInstances", "false");
            config.put("limitInstallationInstancesNumber", "10");
        }
        this.setShellStyle(66576);
    }

    protected Point getInitialSize() {
        return new Point(600, super.getInitialSize().y);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1810);
        container.setLayoutData((Object)g);
        this.createPropertySettings(container);
        this.createMessageComposite(container);
        this.updateInitValues();
        return container;
    }

    private void updateInitValues() {
        String rwd;
        if (this.config.get("host") != null) {
            this.config.get("host");
        }
        if (this.config.get("toolDirectory") != null) {
            this.toolDirectoryText.setText(this.config.get("toolDirectory"));
        }
        if (this.config.get("version") != null) {
            this.versionText.setText(this.config.get("version"));
        }
        if ((rwd = this.config.get("rootWorkingDirectory")) == null) {
            this.defaultTempDirButton.setSelection(false);
            this.rootWorkingDirText.setEnabled(true);
            this.chooseRootDirPathButton.setEnabled(true);
        } else if (rwd.isEmpty()) {
            this.defaultTempDirButton.setSelection(true);
            this.rootWorkingDirText.setEnabled(false);
            this.chooseRootDirPathButton.setEnabled(false);
        } else {
            this.defaultTempDirButton.setSelection(false);
            this.rootWorkingDirText.setEnabled(true);
            this.rootWorkingDirText.setText(this.config.get("rootWorkingDirectory"));
            this.chooseRootDirPathButton.setEnabled(true);
        }
        String[] stringArray = this.context.getDisabledIntegrationKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if ("rootWorkingDirectory".equals(key)) {
                this.rootWorkingDirText.setEnabled(false);
                this.defaultTempDirButton.setEnabled(false);
                this.chooseRootDirPathButton.setEnabled(false);
            }
            ++n2;
        }
        if (this.config.get("limitInstallationInstances") != null) {
            this.setInstanceLimit("limitInstallationInstances");
        } else if (this.config.get("limitInstalltionInstances") != null) {
            this.setInstanceLimit("limitInstalltionInstances");
        } else {
            this.limitInstancesButton.setSelection(false);
            this.limitInstancesText.setText("");
        }
    }

    private void setInstanceLimit(String key) {
        if (Boolean.parseBoolean(this.config.get(key))) {
            this.limitInstancesButton.setSelection(true);
            this.limitInstancesText.setEnabled(true);
            this.limitInstancesText.setText(this.config.get("limitInstallationInstancesNumber"));
        } else {
            this.limitInstancesButton.setSelection(false);
            this.limitInstancesText.setEnabled(false);
            this.limitInstancesText.setText("");
        }
    }

    private void createMessageComposite(Composite parent) {
        this.messageContainer = new Composite(parent, 0);
        this.messageContainer.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        this.messageContainer.setLayoutData((Object)gridData);
        Label icon = new Label(this.messageContainer, 0);
        icon.setLayoutData((Object)new GridData(1, 1, false, true));
        icon.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16));
        this.message = new Label(this.messageContainer, 68);
        GridData messageGridData = new GridData(4, 4, true, true);
        messageGridData.heightHint = 55;
        this.message.setLayoutData((Object)messageGridData);
        this.message.setText("Validation Message");
    }

    private void setMessage(String text) {
        this.message.setText(text);
        this.messageContainer.setVisible(!this.message.getText().isEmpty());
    }

    protected void createPropertySettings(Composite parent) {
        Composite propertyContainer = new Composite(parent, 0);
        propertyContainer.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 4, true, true);
        propertyContainer.setLayoutData((Object)gridData);
        Label toolDirLabel = new Label(propertyContainer, 0);
        toolDirLabel.setText(Messages.toolDirectoryRequired);
        this.toolDirectoryText = new Text(propertyContainer, 2048);
        GridData toolDirGridData = new GridData(768);
        this.toolDirectoryText.setLayoutData((Object)toolDirGridData);
        this.chooseToolDirPathButton = new Button(propertyContainer, 8);
        this.chooseToolDirPathButton.setText("  ...  ");
        this.chooseToolDirPathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.toolDirectoryText, true, this.getShell()));
        Label versionLabel = new Label(propertyContainer, 0);
        versionLabel.setText(Messages.versionRequired);
        this.versionText = new Text(propertyContainer, 2048);
        GridData versionGridData = new GridData(768);
        versionGridData.horizontalSpan = 2;
        this.versionText.setLayoutData((Object)versionGridData);
        Label workingDirLabel = new Label(propertyContainer, 0);
        workingDirLabel.setText("Working directory (absolute): ");
        this.rootWorkingDirText = new Text(propertyContainer, 2048);
        GridData rootWorkingDirGridData = new GridData(768);
        this.rootWorkingDirText.setLayoutData((Object)rootWorkingDirGridData);
        this.chooseRootDirPathButton = new Button(propertyContainer, 8);
        this.chooseRootDirPathButton.setText("  ...  ");
        this.chooseRootDirPathButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.rootWorkingDirText, true, this.getShell()));
        new Label(propertyContainer, 0);
        this.defaultTempDirButton = new Button(propertyContainer, 32);
        GridData defaultTempDirData = new GridData(768);
        defaultTempDirData.horizontalSpan = 2;
        this.defaultTempDirButton.setText(Messages.rceTempUsed);
        this.defaultTempDirButton.setLayoutData((Object)defaultTempDirData);
        this.defaultTempDirButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.saveAllConfig();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.limitInstancesButton = new Button(propertyContainer, 32);
        this.limitInstancesButton.setText(Messages.limitExecutionInstances);
        this.limitInstancesText = new Text(propertyContainer, 2048);
        GridData limitInstancesGridData = new GridData(768);
        limitInstancesGridData.horizontalSpan = 2;
        this.limitInstancesText.setLayoutData((Object)limitInstancesGridData);
        this.limitInstancesText.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(this.limitInstancesText, 18));
        this.limitInstancesButton.setSelection(true);
        this.limitInstancesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.limitInstancesText.setEnabled(WizardToolConfigurationDialog.this.limitInstancesButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    protected void initializeBounds() {
        super.initializeBounds();
    }

    private void saveAllConfig() {
        this.config.put("host", "RCE");
        this.config.put("toolDirectory", this.toolDirectoryText.getText());
        this.config.put("version", this.versionText.getText());
        this.config.put("limitInstallationInstances", "" + this.limitInstancesButton.getSelection());
        if (this.limitInstancesButton.getSelection()) {
            this.config.put("limitInstallationInstancesNumber", this.limitInstancesText.getText());
        }
        this.config.remove("limitInstalltionInstances");
        if (this.defaultTempDirButton.getSelection()) {
            this.config.put("rootWorkingDirectory", "");
        } else {
            this.config.put("rootWorkingDirectory", this.rootWorkingDirText.getText());
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.validateInput();
        this.installListeners();
    }

    private void installListeners() {
        ModifyListener ml = arg0 -> {
            this.saveAllConfig();
            this.validateInput();
        };
        this.rootWorkingDirText.addModifyListener(ml);
        this.versionText.addModifyListener(ml);
        this.toolDirectoryText.addModifyListener(ml);
        this.limitInstancesText.addModifyListener(ml);
        this.limitInstancesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.saveAllConfig();
                WizardToolConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
        SelectionListener sl2 = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                WizardToolConfigurationDialog.this.rootWorkingDirText.setEnabled(!WizardToolConfigurationDialog.this.defaultTempDirButton.getSelection());
                WizardToolConfigurationDialog.this.chooseRootDirPathButton.setEnabled(!WizardToolConfigurationDialog.this.defaultTempDirButton.getSelection());
                WizardToolConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        };
        this.defaultTempDirButton.addSelectionListener(sl2);
    }

    protected void validateInput() {
        boolean isValidToolDirectory = false;
        boolean isValidVersion = false;
        boolean isValidWorkingDirectory = false;
        boolean isValidLimitation = false;
        this.setMessage("");
        Optional versionResult = ComponentIdRules.validateComponentVersionRules((String)this.versionText.getText());
        boolean bl = isValidToolDirectory = this.toolDirectoryText.getText() != null && !this.toolDirectoryText.getText().isEmpty();
        if (this.versionText.getText() != null && !this.versionText.getText().isEmpty()) {
            boolean bl2 = isValidVersion = !versionResult.isPresent();
        }
        isValidWorkingDirectory = this.defaultTempDirButton.getSelection() ? true : this.rootWorkingDirText.getText() != null && !this.rootWorkingDirText.getText().isEmpty();
        isValidLimitation = !this.limitInstancesButton.getSelection() ? true : this.limitInstancesText.getText().matches("\\d+");
        if (!isValidLimitation) {
            this.setMessage("Invalid limitation value.");
        }
        if (!isValidWorkingDirectory) {
            this.setMessage(STRING_INVALID_WORKING_DIRECTORY);
        }
        if (!isValidVersion) {
            this.setMessage(StringUtils.format((String)STRING_INVALID_VERSION, (Object[])new Object[]{((String)versionResult.get()).replaceAll("&", "&&")}));
        }
        if (!isValidToolDirectory) {
            this.setMessage(STRING_INVALID_TOOL_DIRECTORY);
        }
        this.getButton(0).setEnabled(isValidToolDirectory && isValidVersion && isValidWorkingDirectory && isValidLimitation);
    }

    public Map<String, String> getConfig() {
        return this.config;
    }
}

