/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.spi;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractParsedCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.ExecutableCommand;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.FileLoggingTextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.MultiTextOutputReceiver;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandParser {
    private static final String QUOTAION_MARK = "\"";
    private static final String HELP = "HELP";
    private static final String DEV = "DEV";
    private static final String DASH = "-";
    private static final String DETAILS_SHORT = "-d";
    private static final String DETAILS_LONG = "--details";
    private static final String DEV_LONG = "--dev";
    private static final String SAVETO = "saveto";
    private static final String MIRROR_SHORT = "-m";
    private static final String AUTO = "--auto";
    private static final CommandFlag DEV_FLAG = new CommandFlag("--dev", "--dev");
    private static final CommandFlag DETAILS_FLAG = new CommandFlag("-d", "--details");
    private Map<String, MainCommandDescription> registeredCommands = new HashMap<String, MainCommandDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCommands(MainCommandDescription[] commands) {
        Map<String, MainCommandDescription> map = this.registeredCommands;
        synchronized (map) {
            Arrays.stream(commands).forEach(command -> {
                MainCommandDescription mainCommandDescription = this.registeredCommands.put(command.getCommand(), (MainCommandDescription)command);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCommands(MainCommandDescription[] commands) {
        Map<String, MainCommandDescription> map = this.registeredCommands;
        synchronized (map) {
            Arrays.stream(commands).forEach(command -> {
                if (this.registeredCommands.containsKey(command.getCommand())) {
                    this.registeredCommands.remove(command.getCommand());
                }
            });
        }
    }

    public ExecutableCommand parseCommand(CommandContext context) throws CommandException {
        String firstToken = context.consumeNextToken();
        if (this.registeredCommands.containsKey(firstToken)) {
            MainCommandDescription mainCommand = this.registeredCommands.get(firstToken);
            if (HELP.equalsIgnoreCase(firstToken)) {
                context.setParsedModifiers(this.parseHelpCommand(context, false));
                return new ExecutableCommand(mainCommand.getHandler(), context);
            }
            if (DEV.equalsIgnoreCase(firstToken)) {
                context.setParsedModifiers(this.parseHelpCommand(context, true));
                return new ExecutableCommand(mainCommand.getHandler(), context);
            }
            if (SAVETO.equalsIgnoreCase(firstToken)) {
                return this.parseSavetoCommand(context);
            }
            String secondToken = context.peekNextToken();
            if (secondToken == null) {
                if (mainCommand.isExecutable()) {
                    ParsedCommandModifiers values = mainCommand.getModifiers().parseModifiers(context);
                    context.setParsedModifiers(values);
                    return new ExecutableCommand(mainCommand.getHandler(), context);
                }
                throw CommandException.syntaxError(QUOTAION_MARK + firstToken + "\" is not an executable command, a subcommand is needed", context);
            }
            if (mainCommand.hasSubCommand(secondToken)) {
                SubCommandDescription command = mainCommand.getSubCommand(context.consumeNextToken());
                ParsedCommandModifiers values = command.getModifiers().parseModifiers(context);
                context.setParsedModifiers(values);
                ExecutableCommand c = new ExecutableCommand(command.getHandler(), context);
                return c;
            }
            if (mainCommand.isExecutable()) {
                ParsedCommandModifiers values = mainCommand.getModifiers().parseModifiers(context);
                context.setParsedModifiers(values);
                ExecutableCommand c = new ExecutableCommand(mainCommand.getHandler(), context);
                return c;
            }
            throw CommandException.syntaxError(QUOTAION_MARK + secondToken + "\" is not a subcommand of \"" + firstToken + QUOTAION_MARK, context);
        }
        throw CommandException.unknownCommand(context);
    }

    private ParsedCommandModifiers parseHelpCommand(CommandContext context, boolean isDev) throws CommandException {
        ParsedCommandModifiers modifiers;
        List<String> parameters = context.consumeRemainingTokens();
        ArrayList<CommandFlag> cFlag = new ArrayList<CommandFlag>();
        if (isDev) {
            cFlag.add(DEV_FLAG);
        }
        if (parameters.size() > 0) {
            CommandFlag[] flags;
            AbstractParsedCommandParameter[] params;
            if (parameters.get(0).startsWith(DASH)) {
                int showIndex;
                params = new ParsedStringParameter[]{};
                int devIndex = parameters.indexOf(DEV_LONG);
                if (devIndex != -1 && !cFlag.contains(DEV_FLAG)) {
                    cFlag.add(DEV_FLAG);
                    parameters.remove(devIndex);
                }
                if ((showIndex = parameters.indexOf(DETAILS_SHORT)) == -1) {
                    showIndex = parameters.indexOf(DETAILS_LONG);
                }
                if (showIndex != -1) {
                    cFlag.add(DETAILS_FLAG);
                    parameters.remove(showIndex);
                }
                flags = cFlag.toArray(new CommandFlag[cFlag.size()]);
                if (parameters.size() > 0) {
                    throw CommandException.syntaxError("Flags cannot be followed by a specific command", context);
                }
            } else {
                int showIndex;
                params = new ParsedStringParameter[]{new ParsedStringParameter(parameters.get(0))};
                parameters.remove(0);
                int devIndex = parameters.indexOf(DEV_LONG);
                if (devIndex != -1) {
                    cFlag.add(DEV_FLAG);
                    parameters.remove(devIndex);
                }
                if ((showIndex = parameters.indexOf(DETAILS_SHORT)) == -1) {
                    showIndex = parameters.indexOf(DETAILS_LONG);
                }
                if (showIndex != -1) {
                    cFlag.add(DETAILS_FLAG);
                    parameters.remove(showIndex);
                }
                if (parameters.size() != 0) {
                    throw CommandException.syntaxError("Unknown flags entered", context);
                }
                flags = cFlag.toArray(new CommandFlag[cFlag.size()]);
            }
            modifiers = new ParsedCommandModifiers(params, flags, new HashMap<String, AbstractParsedCommandParameter>());
        } else {
            AbstractParsedCommandParameter[] params = new ParsedStringParameter[]{};
            CommandFlag[] flags = cFlag.toArray(new CommandFlag[cFlag.size()]);
            modifiers = new ParsedCommandModifiers(params, flags, new HashMap<String, AbstractParsedCommandParameter>());
        }
        return modifiers;
    }

    private ExecutableCommand parseSavetoCommand(CommandContext context) throws CommandException {
        FileLoggingTextOutputReceiver newReceiver;
        String token = context.consumeNextToken();
        boolean mirror = MIRROR_SHORT.equalsIgnoreCase(token);
        if (mirror) {
            token = context.consumeNextToken();
        }
        if (AUTO.equalsIgnoreCase(token)) {
            token = "cmd_" + System.currentTimeMillis() + ".txt";
        }
        File file = new File(token);
        Path path = file.toPath();
        FileLoggingTextOutputReceiver fileReciever = new FileLoggingTextOutputReceiver(path);
        fileReciever.onStart();
        TextOutputReceiver originalReceiver = context.getOutputReceiver();
        originalReceiver.addOutput(StringUtils.format((String)"Writing command output to file: %s", (Object[])new Object[]{path.toAbsolutePath().toString()}));
        if (mirror) {
            MultiTextOutputReceiver multiOutput = new MultiTextOutputReceiver();
            multiOutput.addTextOutputReceiver((TextOutputReceiver)fileReciever);
            multiOutput.addTextOutputReceiver(originalReceiver);
            newReceiver = multiOutput;
        } else {
            newReceiver = fileReciever;
        }
        CommandContext newContext = new CommandContext(context.consumeRemainingTokens(), (TextOutputReceiver)newReceiver, context.getInvokerInformation());
        try {
            ExecutableCommand command = this.parseCommand(newContext);
            return command;
        }
        catch (CommandException commandException) {
            throw CommandException.syntaxError("There was an error parseing the command to save", context);
        }
    }
}

