/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.internal.MultiCommandHandler;
import de.rcenvironment.core.command.internal.handlers.BuiltInCommandPlugin;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandParser;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.MultiStateCommandParameter;
import de.rcenvironment.core.command.spi.NamedMultiParameter;
import de.rcenvironment.core.command.spi.NamedParameter;
import de.rcenvironment.core.command.spi.NamedSingleParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CommandExecutionServiceImpl
implements CommandExecutionService {
    private static final String INDENT = "\t";
    private static final String NEWLINE_INDENT = "\n\t";
    private static final String OPTIONAL_OPEN = " [";
    private static final String OPTIONAL_CLOSE = "]";
    private static final String SEPERATOR = " - ";
    private final AsyncTaskService threadPool;
    private final Set<MainCommandDescription> cmdDesc = new HashSet<MainCommandDescription>();
    private ConfigurationService configurationService;
    private CommandParser parser = new CommandParser();

    public CommandExecutionServiceImpl() {
        this.threadPool = ConcurrencyUtils.getAsyncTaskService();
    }

    public void activate() {
        this.registerCommandPlugin(new BuiltInCommandPlugin());
    }

    public void registerCommandPlugin(CommandPlugin plugin) {
        this.parser.registerCommands(plugin.getCommands());
        MainCommandDescription[] mainCommandDescriptionArray = plugin.getCommands();
        int n = mainCommandDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MainCommandDescription desc = mainCommandDescriptionArray[n2];
            this.cmdDesc.add(desc);
            ++n2;
        }
    }

    public void unregisterCommandPlugin(CommandPlugin plugin) {
        MainCommandDescription[] mainCommandDescriptionArray = plugin.getCommands();
        int n = mainCommandDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            MainCommandDescription desc = mainCommandDescriptionArray[n2];
            this.cmdDesc.remove(desc);
            ++n2;
        }
    }

    public void bindConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    @Override
    public Future<CommandExecutionResult> asyncExecMultiCommand(List<String> tokens, TextOutputReceiver outputReceiver, Object initiator) {
        File profileOutput = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT);
        MultiCommandHandler multiCommandHandler = new MultiCommandHandler(tokens, outputReceiver, this.parser, profileOutput);
        multiCommandHandler.setInitiatorInformation(initiator);
        return this.threadPool.submit((Callable)multiCommandHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHelpText(ParsedCommandModifiers modifiers, TextOutputReceiver outputReceiver) {
        Set<MainCommandDescription> set = this.cmdDesc;
        synchronized (set) {
            ParsedStringParameter command = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
            boolean showDevCommands = modifiers.hasCommandFlag("--dev");
            boolean showCommandModifiers = modifiers.hasCommandFlag("--details");
            if (command == null) {
                if (showDevCommands) {
                    outputReceiver.addOutput("RCE Console Dev Commands:");
                } else {
                    outputReceiver.addOutput("RCE Console Commands:");
                }
                this.cmdDesc.stream().sorted((desc0, desc1) -> desc0.getCommand().compareTo(desc1.getCommand())).filter(desc -> desc.getIsDevelopercommand() == showDevCommands).forEach(desc -> outputReceiver.addOutput(INDENT + desc.getCommand() + ":\t" + desc.getCommandGroupDescription()));
                if (showDevCommands) {
                    outputReceiver.addOutput("For detailed information and subcommands type \"dev [command] [--details]\"");
                } else {
                    outputReceiver.addOutput("For detailed information and subcommands type \"help [command] [--details]\"");
                }
            } else {
                MainCommandDescription foundCommand = null;
                for (MainCommandDescription desc2 : this.cmdDesc) {
                    if (!desc2.getCommand().equalsIgnoreCase(command.getResult())) continue;
                    foundCommand = desc2;
                    break;
                }
                if (foundCommand == null) {
                    outputReceiver.addOutput("Specified command was not found");
                } else {
                    this.printMaincommandHelp(foundCommand, showCommandModifiers, outputReceiver);
                    SubCommandDescription[] fittigSubCommands = (SubCommandDescription[])Arrays.stream(foundCommand.getSubCommands()).filter(subcommand -> subcommand.getIsDevelopercommand() == showDevCommands).toArray(SubCommandDescription[]::new);
                    if (fittigSubCommands.length != 0) {
                        outputReceiver.addOutput(String.valueOf(foundCommand.getCommand()) + " subcommands:");
                        SubCommandDescription[] subCommandDescriptionArray = fittigSubCommands;
                        int n = fittigSubCommands.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SubCommandDescription subCommand = subCommandDescriptionArray[n2];
                            this.printSubcommandHelp(foundCommand.getCommand(), subCommand, showCommandModifiers, outputReceiver);
                            ++n2;
                        }
                    }
                }
            }
        }
    }

    private void printMaincommandHelp(MainCommandDescription command, boolean showModifiers, TextOutputReceiver outputReceiver) {
        if (!command.isExecutable()) {
            return;
        }
        String line = command.getCommand();
        CommandModifierInfo modifiers = command.getModifiers();
        int i = 0;
        while (i < modifiers.getPositionals().size()) {
            line = String.valueOf(line) + " " + modifiers.getPositionals().get(i).getName();
            ++i;
        }
        for (CommandFlag flag : modifiers.getFlags()) {
            line = String.valueOf(line) + OPTIONAL_OPEN + flag.getLongFlag() + OPTIONAL_CLOSE;
        }
        if (!modifiers.getNamedParameters().isEmpty() && modifiers.getNamedParameters().size() < 8) {
            for (NamedParameter named : modifiers.getNamedParameters()) {
                NamedParameter p;
                if (named instanceof NamedSingleParameter) {
                    p = (NamedSingleParameter)named;
                    line = String.valueOf(line) + OPTIONAL_OPEN + p.getName() + " " + ((NamedSingleParameter)p).getParameterType().getDescription() + OPTIONAL_CLOSE;
                    continue;
                }
                p = (NamedMultiParameter)named;
                line = String.valueOf(line) + OPTIONAL_OPEN + p.getName();
                AbstractCommandParameter[] abstractCommandParameterArray = ((NamedMultiParameter)p).getParameterTypes();
                int n = abstractCommandParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCommandParameter param = abstractCommandParameterArray[n2];
                    line = String.valueOf(line) + " " + param.getDescription();
                    ++n2;
                }
                line = String.valueOf(line) + OPTIONAL_CLOSE;
            }
        }
        line = String.valueOf(line) + NEWLINE_INDENT + command.getDescription();
        if (showModifiers) {
            i = 0;
            while (i < modifiers.getPositionals().size()) {
                line = String.valueOf(line) + NEWLINE_INDENT + modifiers.getPositionals().get(i).getName() + SEPERATOR + modifiers.getPositionals().get(i).getDescription();
                ++i;
            }
            for (CommandFlag flag : modifiers.getFlags()) {
                line = String.valueOf(line) + NEWLINE_INDENT + flag.getLongFlag() + SEPERATOR + flag.getInfotext();
            }
            for (NamedParameter param : modifiers.getNamedParameters()) {
                line = String.valueOf(line) + NEWLINE_INDENT + param.getName() + SEPERATOR + param.getInfotext();
            }
        }
        outputReceiver.addOutput(line);
    }

    private void printSubcommandHelp(String mainCommand, SubCommandDescription command, boolean showModifiers, TextOutputReceiver outputReceiver) {
        String line = String.valueOf(mainCommand) + " " + command.getCommand();
        CommandModifierInfo modifiers = command.getModifiers();
        int i = 0;
        while (i < modifiers.getPositionals().size()) {
            line = String.valueOf(line) + " " + modifiers.getPositionals().get(i).getName();
            ++i;
        }
        for (CommandFlag flag : modifiers.getFlags()) {
            line = String.valueOf(line) + OPTIONAL_OPEN + flag.getLongFlag() + OPTIONAL_CLOSE;
        }
        if (!modifiers.getNamedParameters().isEmpty() && modifiers.getNamedParameters().size() < 8) {
            for (NamedParameter named : modifiers.getNamedParameters()) {
                NamedParameter p;
                if (named instanceof NamedSingleParameter) {
                    p = (NamedSingleParameter)named;
                    line = String.valueOf(line) + OPTIONAL_OPEN + p.getName() + OPTIONAL_CLOSE;
                    continue;
                }
                p = (NamedMultiParameter)named;
                line = String.valueOf(line) + OPTIONAL_OPEN + p.getName() + OPTIONAL_CLOSE;
            }
        }
        line = String.valueOf(line) + NEWLINE_INDENT + command.getDescription();
        if (showModifiers) {
            i = 0;
            while (i < modifiers.getPositionals().size()) {
                line = String.valueOf(line) + NEWLINE_INDENT + modifiers.getPositionals().get(i).getName() + SEPERATOR + modifiers.getPositionals().get(i).getDescription();
                ++i;
            }
            for (CommandFlag flag : modifiers.getFlags()) {
                line = String.valueOf(line) + NEWLINE_INDENT + flag.getLongFlag() + SEPERATOR + flag.getInfotext();
            }
            for (NamedParameter param : modifiers.getNamedParameters()) {
                NamedSingleParameter single;
                line = String.valueOf(line) + NEWLINE_INDENT + param.getName() + SEPERATOR + param.getInfotext();
                if (!(param instanceof NamedSingleParameter) || !((single = (NamedSingleParameter)param).getParameterType() instanceof MultiStateCommandParameter)) continue;
                line = String.valueOf(line) + " values: " + ((MultiStateCommandParameter)single.getParameterType()).getFormattedStates();
            }
        }
        outputReceiver.addOutput(line);
    }

    @Override
    public String getHelpText(boolean addCommonPrefix, boolean showDevCommands) {
        CapturingTextOutReceiver capturingReceiver = new CapturingTextOutReceiver();
        ParsedCommandModifiers modifiers = new ParsedCommandModifiers();
        this.printHelpText(modifiers, (TextOutputReceiver)capturingReceiver);
        return capturingReceiver.getBufferedOutput();
    }

    @Override
    public CommandParser getParser() {
        return this.parser;
    }
}

