/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OSHISystemIntegrationAdapter
implements SystemIntegrationAdapter {
    private static final int WAITING_TIME_IN_MS = 1000;
    private static final double NANOSEC_TO_MSEC_FACTOR = 1000000.0;
    private static final long BYTES_TO_MIB_FACTOR = 0x100000L;
    private SystemInfo sysInfo;
    private CentralProcessor processor;
    private OperatingSystem os;
    private long cachedTotalSystemRam;
    private int selfJavaPid;
    private int selfLauncherPid;
    private volatile double totalCPUUsage = 0.0;
    private ConcurrentHashMap<Integer, Double> cpuUsagePerTask;
    private final Log log = LogFactory.getLog(this.getClass());

    public OSHISystemIntegrationAdapter() {
        this.sysInfo = new SystemInfo();
        this.processor = this.sysInfo.getHardware().getProcessor();
        this.os = this.sysInfo.getOperatingSystem();
        this.cachedTotalSystemRam = this.convertBytesToMiB(this.sysInfo.getHardware().getMemory().getTotal());
        this.selfJavaPid = this.sysInfo.getOperatingSystem().getProcessId();
        this.selfLauncherPid = this.sysInfo.getOperatingSystem().getProcess(this.selfJavaPid).getParentProcessID();
        this.cpuUsagePerTask = new ConcurrentHashMap();
    }

    @Override
    public boolean isProvidingActualSystemData() {
        return true;
    }

    @Override
    public long getCachedTotalSystemRam() {
        return this.cachedTotalSystemRam;
    }

    @Override
    public boolean areSelfPidsAndProcessStatesAvailable() {
        return true;
    }

    @Override
    public long getSelfJavaPid() {
        return this.selfJavaPid;
    }

    @Override
    public String getSelfJavaProcessName() {
        return this.os.getProcess(this.selfJavaPid).getName();
    }

    @Override
    public long getSelfLauncherPid() {
        return this.selfLauncherPid;
    }

    @Override
    public String getSelfLauncherProcessName() {
        return this.os.getProcess(this.selfLauncherPid).getName();
    }

    @Override
    public double getTotalCPUUsage() throws OperatingSystemException {
        ConcurrencyUtils.getAsyncTaskService().execute("Calculate total CPU usage", () -> {
            long[] prevTicks = this.processor.getSystemCpuLoadTicks();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.log.debug((Object)"Waiting was interrupted; probably because RCE was shutdown");
            }
            this.totalCPUUsage = this.processor.getSystemCpuLoadBetweenTicks(prevTicks);
        });
        return this.totalCPUUsage;
    }

    @Override
    public double getProcessCPUUsage(Long pid) throws OperatingSystemException {
        if (pid == null) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
        }
        Integer processId = Math.toIntExact(pid);
        ConcurrencyUtils.getAsyncTaskService().execute("Calculate CPU usage for pid " + processId, () -> this.updateCpuUsageForProcess(processId));
        return this.cpuUsagePerTask.getOrDefault(processId, 0.0);
    }

    private void updateCpuUsageForProcess(int processId) {
        int numberOfCpus = this.processor.getLogicalProcessorCount();
        OSProcess process = this.os.getProcess(processId);
        if (process == null) {
            this.cpuUsagePerTask.remove(processId);
            return;
        }
        long previousNanoTime = System.nanoTime();
        long previousProcessTime = process.getKernelTime() + process.getUserTime();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.log.debug((Object)"Waiting was interrupted; probably because RCE was shutdown", (Throwable)e);
            return;
        }
        process = this.os.getProcess(processId);
        if (process == null) {
            this.cpuUsagePerTask.remove(processId);
            return;
        }
        long currentNanoTime = System.nanoTime();
        long currentProcessTime = process.getKernelTime() + process.getUserTime();
        long processTimeDifference = currentProcessTime - previousProcessTime;
        double elapsedTime = (double)(currentNanoTime - previousNanoTime) / 1000000.0;
        this.cpuUsagePerTask.put(processId, (double)processTimeDifference / elapsedTime / (double)numberOfCpus);
    }

    @Override
    public double getReportedCPUIdle() throws OperatingSystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getTotalSystemRAM() throws OperatingSystemException {
        return this.getCachedTotalSystemRam();
    }

    @Override
    public long getProcessRAMUsage(Long pid) throws OperatingSystemException {
        if (pid != null) {
            OSProcess p = this.os.getProcess(Math.toIntExact(pid));
            if (p != null) {
                return p.getResidentSetSize();
            }
            return 0L;
        }
        throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
    }

    @Override
    public long getTotalUsedRAM() throws OperatingSystemException {
        return this.getCachedTotalSystemRam() - this.convertBytesToMiB(this.sysInfo.getHardware().getMemory().getAvailable());
    }

    @Override
    public long getFreeRAM() throws OperatingSystemException {
        return this.convertBytesToMiB(this.sysInfo.getHardware().getMemory().getAvailable());
    }

    @Override
    public double getTotalUsedRAMPercentage() throws OperatingSystemException {
        return (double)this.getTotalUsedRAM() / (double)this.getCachedTotalSystemRam();
    }

    @Override
    public double getProcessRAMPercentage(Long pid) throws OperatingSystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Long, String> getProcesses() throws OperatingSystemException {
        HashMap<Long, String> procMap = new HashMap<Long, String>();
        OSProcess[] oSProcessArray = this.sysInfo.getOperatingSystem().getProcesses();
        int n = oSProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            OSProcess process = oSProcessArray[n2];
            procMap.put(Integer.toUnsignedLong(process.getProcessID()), process.getName());
            ++n2;
        }
        return procMap;
    }

    @Override
    public Map<Long, String> getChildProcessesAndIds(Long ppid) throws OperatingSystemException {
        HashMap<Long, String> childMap = new HashMap<Long, String>();
        if (ppid != null) {
            for (ProcessInformation p : this.getFullChildProcessInformation(ppid)) {
                childMap.put(p.getPid(), p.getName());
            }
        }
        return childMap;
    }

    @Override
    public List<ProcessInformation> getFullChildProcessInformation(long pid) throws OperatingSystemException {
        ArrayList<ProcessInformation> children = new ArrayList<ProcessInformation>();
        OSProcess[] oSProcessArray = this.sysInfo.getOperatingSystem().getChildProcesses(Math.toIntExact(pid), 0, null);
        int n = oSProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            OSProcess process = oSProcessArray[n2];
            ProcessInformation p = new ProcessInformation(process.getProcessID(), process.getName(), this.getFullChildProcessInformation(process.getProcessID()), this.getProcessCPUUsage(Long.valueOf(process.getProcessID())), this.getProcessRAMUsage(Long.valueOf(process.getProcessID())));
            children.add(p);
            ++n2;
        }
        return children;
    }

    private long convertBytesToMiB(long valueInByte) {
        return valueInByte / 0x100000L;
    }
}

