/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.internal.RingBuffer;
import de.rcenvironment.core.monitoring.system.internal.SystemDataSnapshot;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import oshi.software.os.OSProcess;

public final class SystemMonitoringDataCollector {
    private static final int FULL_COLLECTIONS_WITHOUT_USAGE = 6;
    private AsyncTaskService asyncTaskService;
    private boolean isRunning;
    private RingBuffer<SystemDataSnapshot> ringBuffer;
    private Future<?> schedulingFuture;
    private final SystemIntegrationAdapter adapter;
    private final AtomicInteger fullCollectionCounter = new AtomicInteger(0);
    private final Log log = LogFactory.getLog(SystemMonitoringDataCollector.class);

    public SystemMonitoringDataCollector(SystemIntegrationAdapter adapter, AsyncTaskService taskService) {
        if (adapter == null || taskService == null) {
            throw new IllegalArgumentException("Constructor parameters must not be null");
        }
        this.adapter = adapter;
        this.asyncTaskService = taskService;
        this.isRunning = false;
    }

    public void startCollection(int itemNumber, int interval) {
        if (!this.isRunning) {
            this.schedulingFuture = this.asyncTaskService.scheduleAtFixedInterval("System Monitoring", this::collectData, (long)interval);
            this.log.debug((Object)"Scheduled system monitoring data collection");
            this.ringBuffer = new RingBuffer(itemNumber);
            this.isRunning = true;
        }
    }

    public void stopCollection() {
        if (this.isRunning) {
            this.schedulingFuture.cancel(true);
            this.log.debug((Object)"Canceled system monitoring data collection");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void resetPartialCollectionFallback() {
        this.fullCollectionCounter.set(6);
    }

    public RingBuffer<SystemDataSnapshot> getRingBuffer() {
        return this.ringBuffer;
    }

    private void collectData() {
        long timeStamp = System.currentTimeMillis();
        long[] totalCpuTicks = this.adapter.getSystemCpuLoadTicks();
        double totalCpuUsage = 0.0;
        if (this.ringBuffer.getLatestEntry().isPresent()) {
            totalCpuUsage = this.adapter.getSystemCpuLoadBetweenTicks(this.ringBuffer.getLatestEntry().get().getTotalCpuTicks());
        }
        long totalRamUsage = this.adapter.getTotalRamUsage();
        List<Object> allProcesses = new ArrayList();
        OSProcess rceProcess = null;
        Set<OSProcess> subProcesses = new HashSet<OSProcess>();
        if (this.fullCollectionCounter.get() > 0) {
            this.fullCollectionCounter.decrementAndGet();
            allProcesses = this.adapter.getAllProcesses();
            rceProcess = allProcesses.stream().filter(process -> process.getProcessID() == this.adapter.getSelfJavaPid()).findAny().get();
            subProcesses = this.getSubProcesses(rceProcess, allProcesses);
        }
        SystemDataSnapshot snapshot = new SystemDataSnapshot(timeStamp, totalCpuTicks, totalCpuUsage, totalRamUsage, rceProcess, subProcesses);
        this.ringBuffer.add(snapshot);
    }

    private Set<OSProcess> getSubProcesses(OSProcess rootProcess, List<OSProcess> allProcesses) {
        HashSet<OSProcess> setToReturn = new HashSet<OSProcess>();
        this.insertSubProcesses(rootProcess, allProcesses, setToReturn);
        setToReturn.remove(rootProcess);
        return setToReturn;
    }

    private void insertSubProcesses(OSProcess rootProcess, List<OSProcess> allProcesses, Set<OSProcess> targetSet) {
        List directChildren = allProcesses.stream().filter(process -> process.getParentProcessID() == rootProcess.getProcessID()).collect(Collectors.toList());
        for (OSProcess subProcess : directChildren) {
            this.insertSubProcesses(subProcess, allProcesses, targetSet);
        }
        targetSet.add(rootProcess);
    }
}

