/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.mail.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.mail.InvalidMailException;
import de.rcenvironment.core.mail.Mail;
import de.rcenvironment.core.mail.MailDispatchResult;
import de.rcenvironment.core.mail.MailDispatchResultListener;
import de.rcenvironment.core.mail.MailService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jodd.mail.EmailAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailCommandPlugin
implements CommandPlugin {
    private static final String PERM_FAILURE = "Unable to delivered the mail to the mail server. Most likely the SMTP server configuration is wrong: %s";
    private static final String CMD_MAIL = "mail";
    private Log log = LogFactory.getLog(MailCommandPlugin.class);
    private MailService mailService;

    protected void bindMailService(MailService service) {
        this.mailService = service;
    }

    public void execute(final CommandContext context) throws CommandException {
        Mail validatedMail;
        context.consumeExpectedToken(CMD_MAIL);
        if (!this.mailService.isConfigured()) {
            context.println((Object)"The SMTP mail server is not configured or invalid configured.");
            context.consumeRemainingTokens();
            return;
        }
        String recipient = context.consumeNextToken();
        if (recipient == null || !new EmailAddress(recipient).isValid()) {
            throw CommandException.syntaxError((String)"You need to specify a valid mail address as the recipient.", (CommandContext)context);
        }
        String subject = context.consumeNextToken();
        if (subject == null) {
            throw CommandException.syntaxError((String)"You need to specify a subject.", (CommandContext)context);
        }
        String body = context.consumeNextToken();
        if (body == null) {
            throw CommandException.syntaxError((String)"You need the message body.", (CommandContext)context);
        }
        context.consumeRemainingTokens();
        try {
            validatedMail = Mail.createMail(new String[]{recipient}, subject, body, null);
        }
        catch (InvalidMailException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
        Future<?> sendMailFuture = this.mailService.sendMail(validatedMail, new MailDispatchResultListener(){

            @Override
            public void receiveResult(MailDispatchResult result, String message) {
                switch (result) {
                    case SUCCESS: {
                        context.println((Object)"Successfully delivered the mail to the mail server.");
                        break;
                    }
                    case FAILURE: {
                        context.println((Object)StringUtils.format((String)MailCommandPlugin.PERM_FAILURE, (Object[])new Object[]{message}));
                        break;
                    }
                    case FAILURE_RETRY: {
                        context.println((Object)"Unable to delivered the mail to the mail server. Retrying...");
                        break;
                    }
                    default: {
                        MailCommandPlugin.this.log.warn((Object)"Received unexpected result from the mail service.");
                    }
                }
            }
        });
        try {
            sendMailFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.log.error((Object)e);
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_MAIL, "<recipient> \"<subject>\" \"<body>\"", false, "Sends an email.", new String[]{"<recipient> - The recipient to whom the mail should be addressed.", "\"<subject>\" - The subject of the mail.", "\"<body>\" - The mail body."}));
        return contributions;
    }
}

