/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.LanternaException;
import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.input.KeyMappingProfile;
import com.googlecode.lanterna.input.ScreenInfoCharacterPattern;
import com.googlecode.lanterna.terminal.TerminalPosition;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class InputDecoder {
    private final Reader source;
    private final Queue<Character> inputBuffer;
    private final Queue<Character> leftOverQueue;
    private final Set<CharacterPattern> bytePatterns;
    private final List<Character> currentMatching;
    private TerminalPosition lastReportedTerminalPosition;
    private boolean seenEOF;

    public InputDecoder(Reader source) {
        this.source = source;
        this.inputBuffer = new LinkedList<Character>();
        this.leftOverQueue = new LinkedList<Character>();
        this.bytePatterns = new HashSet<CharacterPattern>();
        this.currentMatching = new ArrayList<Character>();
        this.lastReportedTerminalPosition = null;
        this.seenEOF = false;
    }

    public InputDecoder(Reader source, KeyMappingProfile profile) {
        this(source);
        this.addProfile(profile);
    }

    public void addProfile(KeyMappingProfile profile) {
        for (CharacterPattern pattern : profile.getPatterns()) {
            this.bytePatterns.add(pattern);
        }
    }

    public Key getNextCharacter() {
        boolean canMatchWithOneMoreChar;
        if (System.getProperty("com.googlecode.lanterna.input.enable-new-decoder", "false").equals("true")) {
            try {
                return this.getNextCharacter2();
            }
            catch (IOException e) {
                throw new LanternaException(e);
            }
        }
        if (this.leftOverQueue.size() > 0) {
            Character first = this.leftOverQueue.poll();
            if (first.charValue() == '\u001b') {
                return new Key(Key.Kind.Escape);
            }
            return new Key(first.charValue());
        }
        try {
            while (this.source.ready()) {
                int readChar = this.source.read();
                if (readChar == -1) {
                    this.seenEOF = true;
                    break;
                }
                this.inputBuffer.add(Character.valueOf((char)readChar));
            }
        }
        catch (IOException e) {
            throw new LanternaException(e);
        }
        if (this.inputBuffer.size() == 0) {
            if (this.seenEOF && System.getProperty("com.googlecode.lanterna.input.enable-eof", "false").equals("true")) {
                return new Key(Key.Kind.EOF);
            }
            return null;
        }
        do {
            Character nextChar = this.inputBuffer.poll();
            canMatchWithOneMoreChar = false;
            if (nextChar == null) continue;
            this.currentMatching.add(nextChar);
            for (CharacterPattern pattern : this.bytePatterns) {
                if (!pattern.matches(this.currentMatching)) continue;
                if (pattern.isCompleteMatch(this.currentMatching)) {
                    Key result = pattern.getResult(this.currentMatching);
                    if (result.getKind() == Key.Kind.CursorLocation) {
                        this.lastReportedTerminalPosition = ScreenInfoCharacterPattern.getCursorPosition(this.currentMatching);
                    }
                    this.currentMatching.clear();
                    return result;
                }
                canMatchWithOneMoreChar = true;
            }
        } while (canMatchWithOneMoreChar);
        for (Character c : this.currentMatching) {
            this.leftOverQueue.add(c);
        }
        this.currentMatching.clear();
        Character first = this.leftOverQueue.poll();
        if (first.charValue() == '\u001b') {
            return new Key(Key.Kind.Escape);
        }
        return new Key(first.charValue());
    }

    public TerminalPosition getLastReportedTerminalPosition() {
        return this.lastReportedTerminalPosition;
    }

    private Key getNextCharacter2() throws IOException {
        while (this.source.ready()) {
            int readChar = this.source.read();
            if (readChar == -1) {
                return null;
            }
            this.currentMatching.add(Character.valueOf((char)readChar));
        }
        if (this.currentMatching.isEmpty()) {
            return null;
        }
        if (this.currentMatching.size() == 1 && this.currentMatching.get(0).charValue() == '\u001b') {
            this.currentMatching.clear();
            return new Key(Key.Kind.Escape);
        }
        Key bestMatch = null;
        int nrOfCharactersMatched = 0;
        for (int i = 0; i < this.currentMatching.size(); ++i) {
            List<Character> subList = this.currentMatching.subList(0, i + 1);
            Matching matching = this.getBestMatch(subList);
            if (bestMatch != null && matching.fullMatch == null && !matching.partialMatch) break;
            if (matching.fullMatch != null) {
                bestMatch = matching.fullMatch;
                nrOfCharactersMatched = i + 1;
                continue;
            }
            if (bestMatch != null || matching.partialMatch) continue;
            subList.clear();
            break;
        }
        if (bestMatch == null) {
            return null;
        }
        if (bestMatch.getKind() == Key.Kind.CursorLocation) {
            TerminalPosition cursorPosition = ScreenInfoCharacterPattern.getCursorPosition(this.currentMatching.subList(0, nrOfCharactersMatched));
            if (cursorPosition.getColumn() == 5 && cursorPosition.getRow() == 1) {
                bestMatch = new Key(Key.Kind.F3, true, false);
            } else {
                this.lastReportedTerminalPosition = cursorPosition;
            }
        }
        this.currentMatching.subList(0, nrOfCharactersMatched).clear();
        return bestMatch;
    }

    private Matching getBestMatch(List<Character> characterSequence) {
        boolean partialMatch = false;
        Key bestMatch = null;
        LinkedList<CharacterPattern> candidates = new LinkedList<CharacterPattern>(this.bytePatterns);
        for (int i = 0; i < characterSequence.size(); ++i) {
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                CharacterPattern pattern = (CharacterPattern)iterator.next();
                if (!pattern.matches(characterSequence)) {
                    iterator.remove();
                    continue;
                }
                partialMatch = true;
                if (!pattern.isCompleteMatch(characterSequence)) continue;
                bestMatch = pattern.getResult(characterSequence);
            }
        }
        return new Matching(partialMatch, bestMatch);
    }

    private static class Matching {
        boolean partialMatch;
        Key fullMatch;

        public Matching(boolean partialMatch, Key fullMatch) {
            this.partialMatch = partialMatch;
            this.fullMatch = fullMatch;
        }

        public String toString() {
            return "Matching{partialMatch=" + this.partialMatch + ", fullMatch=" + this.fullMatch + '}';
        }
    }
}

