/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.vampzeroinitializer.gui;

import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Component;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Discipline;
import de.rcenvironment.components.cpacs.vampzeroinitializer.gui.model.Parameter;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ToolspecificOutputWriter {
    private static final String NAME = "name";
    private XMLSupportService xmlSupport = (XMLSupportService)ServiceRegistry.createAccessFor((Object)this).getService(XMLSupportService.class);

    String createOutput(List<Component> components) {
        try {
            Document doc = this.xmlSupport.createDocument();
            Node componentsNode = this.xmlSupport.createElementTree(doc, "/cpacs/toolspecific/vampZero/components");
            for (Component component : components) {
                Node disciplinesNode = this.createNodes(doc, componentsNode, "component", "disciplines");
                this.createNodeAndValue(doc, disciplinesNode.getParentNode(), NAME, component.getName(), true);
                for (Discipline discipline : component.getDisciplines()) {
                    Node parametersNode = this.createNodes(doc, disciplinesNode, "discipline", "parameters");
                    this.createNodeAndValue(doc, parametersNode.getParentNode(), NAME, discipline.getName(), true);
                    for (Parameter parameter : discipline.getParameters()) {
                        Node parameterNode = this.createNodes(doc, parametersNode, "parameter");
                        this.createNodeAndValue(doc, parameterNode, NAME, parameter.getName(), new boolean[0]);
                        this.createNodeAndValue(doc, parameterNode, "description", parameter.getDescription(), new boolean[0]);
                        this.createNodeAndValue(doc, parameterNode, "value", parameter.getValue(), new boolean[0]);
                        this.createNodeAndValue(doc, parameterNode, "factor", parameter.getFactor(), new boolean[0]);
                    }
                }
            }
            return this.xmlSupport.writeXMLToString(doc);
        }
        catch (XMLException e) {
            LogFactory.getLog(ToolspecificOutputWriter.class).error((Object)("Error while creating output: " + e.toString()));
            return null;
        }
    }

    private Node createNodes(Document doc, Node parent, String ... names) {
        Element node = null;
        Node father = parent;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            node = doc.createElement(name);
            doc.importNode(node, false);
            father.appendChild(node);
            father = node;
            ++n2;
        }
        return node;
    }

    private void createNodeAndValue(Document doc, Node parent, String name, String value, boolean ... insertBefore) {
        Element node = doc.createElement(name);
        doc.importNode(node, false);
        if (insertBefore.length > 0 && insertBefore[0]) {
            parent.insertBefore(node, parent.getFirstChild());
        } else {
            parent.appendChild(node);
        }
        node.setTextContent(value);
    }
}

