/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.command.api;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.WorkflowGraph;
import de.rcenvironment.core.component.workflow.api.WorkflowConstants;
import de.rcenvironment.core.component.workflow.command.api.WorkflowExecutionDisplayService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationResults;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowVerificationService;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.datamanagement.MetaDataService;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.commons.WorkflowRun;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class WfCommandPlugin
implements CommandPlugin {
    private static final String WF_DETAILS_OUTPUT_TEXT = "        Execution Count: %s,  Average Time: %s msec, Max Time: %s msec, Total Time: %s msec";
    private static final String SELF_TEST_CASES_FILE_ENDING = ".cases";
    private static final String SELF_TEST_CASES_DIR = "cases/";
    private static final String SELF_TEST_WORKFLOW_DIR = "workflows/";
    private static final String SLASH = "/";
    private static final String ESCAPED_BACKSLASH = "\\\\";
    private static final String ASTERISK = "*";
    private static final String DELETE_COMMAND = "delete";
    private static final String BASEDIR_OPTION = "--basedir";
    private static final String STRING_DOT = ".";
    private static final int WORKFLOW_SUFFIX_NUMBER_MODULO = 100;
    private static final String WRONG_STATE_ERROR = "%s workflow not possible in current workflow state: %s";
    private static final String WORKFLOW_ID = "<id>";
    private static final String FAILURE_DIR_NAME = "failure";
    private static final AtomicInteger GLOBAL_WORKFLOW_SUFFIX_SEQUENCE_COUNTER = new AtomicInteger();
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private WorkflowExecutionDisplayService workflowExecutionDisplayService;
    private WorkflowVerificationService workflowVerificationService;
    private MetaDataService metaDataService;
    private Bundle bundle;
    private final Log log = LogFactory.getLog(this.getClass());

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription("wf", "", false, "short form of \"wf list\"", new String[0]));
        contributions.add(new CommandDescription("wf start", "[--dispose <onfinished|never|always>] [--delete <onfinished|never|always>] [--compact-output] [-p <JSON placeholder file>] <workflow file>", false, "starts a workflow from the given file and returns its workflow id if validation passed", new String[0]));
        contributions.add(new CommandDescription("wf run", "[--dispose <onfinished|never|always>] [--delete <onfinished|never|always>] [--compact-output] [-p <JSON placeholder file>] <workflow file>", false, "starts a workflow from the given file and waits for its completion", new String[0]));
        contributions.add(new CommandDescription("wf verify", "[--dispose <onexpected|never|always>] [--delete <onexpected|never|always>] [--pr <parallel runs>] [--sr <sequential runs>] [-p <JSON placeholder file>] ([--basedir <root directory for all subsequent files>] (<workflow filename>|\"*\")+ )+", false, "batch test the specified workflow files", new String[0]));
        contributions.add(new CommandDescription("wf list", "", false, "show workflow list", new String[0]));
        contributions.add(new CommandDescription("wf details", WORKFLOW_ID, false, "show details of a workflow", new String[0]));
        contributions.add(new CommandDescription("wf open", WORKFLOW_ID, false, "open a runtime viewer of a workflow. Requires GUI.", new String[0]));
        contributions.add(new CommandDescription("wf pause", WORKFLOW_ID, false, "pause a running workflow", new String[0]));
        contributions.add(new CommandDescription("wf resume", WORKFLOW_ID, false, "resume a paused workflow", new String[0]));
        contributions.add(new CommandDescription("wf cancel", WORKFLOW_ID, false, "cancel a running or paused workflow", new String[0]));
        contributions.add(new CommandDescription("wf delete", WORKFLOW_ID, false, "delete and dispose a finished, cancelled or failed workflow", new String[0]));
        contributions.add(new CommandDescription("wf self-test", "[--dispose <onexpected|never|always>] [--delete <onexpected|never|always>] [--pr <parallel runs>] [--sr <sequential runs>] [--python <python exe path; default: 'python'>] [--cases <comma-separated list of case files; default: 'core'>]", true, "batch test workflow files of the test workflow files bundle", new String[0]));
        contributions.add(new CommandDescription("wf list-self-test-cases", "", true, "list available test cases for wf self-test", new String[0]));
        contributions.add(new CommandDescription("wf check-self-test-cases", "", true, "check if all test workflows are part of at least one test case", new String[0]));
        contributions.add(new CommandDescription("wf graph", "<workflow file>", true, "prints .dot string representation of a workflow (can be used to create graph visualization with Graphviz)", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken("wf");
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            this.performWfList(context);
        } else if ("run".equals(subCmd)) {
            this.performWfRunOrStart(context, true);
        } else if ("start".equals(subCmd)) {
            this.performWfRunOrStart(context, false);
        } else if ("verify".equals(subCmd)) {
            this.performWfVerify(context);
        } else if ("pause".equals(subCmd)) {
            this.performWfPause(context);
        } else if ("resume".equals(subCmd)) {
            this.performWfResume(context);
        } else if ("cancel".equals(subCmd)) {
            this.performWfCancel(context);
        } else if ("dispose".equals(subCmd)) {
            this.performWfDisposeOrDelete(context, subCmd);
        } else if (DELETE_COMMAND.equals(subCmd)) {
            this.performWfDisposeOrDelete(context, subCmd);
        } else if ("list".equals(subCmd)) {
            this.performWfList(context);
        } else if ("details".equals(subCmd)) {
            this.performWfShowDetails(context);
        } else if ("open".equals(subCmd)) {
            this.performWfOpen(context);
        } else if ("self-test".equals(subCmd)) {
            this.performWfSelfTest(context);
        } else if ("list-self-test-cases".equals(subCmd)) {
            this.performWfListSelfTestCases(context);
        } else if ("check-self-test-cases".equals(subCmd)) {
            this.performWfCheckSelfTestCases(context);
        } else if ("graph".equals(subCmd)) {
            this.performWfGraph(context);
        } else {
            throw CommandException.unknownCommand((CommandContext)context);
        }
    }

    private File getWorkflowFile(CommandContext cmdCtx) throws CommandException {
        File wfFile;
        String additionalToken;
        String filename = cmdCtx.consumeNextToken();
        if (filename == null) {
            CommandException.missingFilename((CommandContext)cmdCtx);
        }
        if ((additionalToken = cmdCtx.consumeNextToken()) != null) {
            throw CommandException.syntaxError((String)("Expected end of command, but found another argument: " + additionalToken), (CommandContext)cmdCtx);
        }
        try {
            wfFile = WorkflowExecutionUtils.resolveWorkflowOrPlaceholderFileLocation((String)filename, (String)"Workflow file %s does not exist or it can not be read");
        }
        catch (FileNotFoundException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)cmdCtx);
        }
        return wfFile;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.bundle = context.getBundleContext().getBundle();
    }

    @Reference
    public void bindWorkflowExecutionService(HeadlessWorkflowExecutionService newInstance) {
        this.workflowExecutionService = newInstance;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    public void bindWorkflowExecutionDisplayService(WorkflowExecutionDisplayService newInstance) {
        this.workflowExecutionDisplayService = newInstance;
    }

    public void unbindWorkflowExecutionDisplayService(WorkflowExecutionDisplayService oldInstance) {
        this.workflowExecutionDisplayService = null;
    }

    @Reference
    public void bindMetaDataService(MetaDataService newInstance) {
        this.metaDataService = newInstance;
    }

    @Reference
    public void bindWorkflowVerificationService(WorkflowVerificationService service) {
        this.workflowVerificationService = service;
    }

    private void performWfRunOrStart(CommandContext cmdCtx, boolean waitForTermination) throws CommandException {
        File wfFile;
        String additionalToken;
        HeadlessWorkflowExecutionService.DisposalBehavior dispose = this.readOptionalDisposeParameter(cmdCtx);
        HeadlessWorkflowExecutionService.DeletionBehavior delete = this.readOptionalDeleteParameter(cmdCtx);
        boolean compactId = cmdCtx.consumeNextTokenIfEquals("--compact-output");
        File placeholdersFile = this.readOptionalPlaceholdersFileParameter(cmdCtx);
        String filename = cmdCtx.consumeNextToken();
        if (filename == null) {
            CommandException.missingFilename((CommandContext)cmdCtx);
        }
        if ((additionalToken = cmdCtx.consumeNextToken()) != null) {
            throw CommandException.syntaxError((String)("Expected end of command, but found another argument: " + additionalToken), (CommandContext)cmdCtx);
        }
        try {
            wfFile = WorkflowExecutionUtils.resolveWorkflowOrPlaceholderFileLocation((String)filename, (String)"Workflow file %s does not exist or it can not be read");
        }
        catch (FileNotFoundException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)cmdCtx);
        }
        if (this.workflowVerificationService.preValidateWorkflow(cmdCtx.getOutputReceiver(), wfFile, true)) {
            try {
                HeadlessWorkflowExecutionContextBuilder exeContextBuilder = new HeadlessWorkflowExecutionContextBuilder(wfFile).setLogDirectory(this.setupLogDirectoryForWfFile(wfFile));
                exeContextBuilder.setPlaceholdersFile(placeholdersFile);
                exeContextBuilder.setTextOutputReceiver(cmdCtx.getOutputReceiver(), compactId);
                exeContextBuilder.setDisposalBehavior(dispose);
                exeContextBuilder.setDeletionBehavior(delete);
                if (waitForTermination) {
                    this.workflowExecutionService.executeWorkflow(exeContextBuilder.buildExtended());
                }
                WorkflowExecutionInformation execInfo = this.workflowExecutionService.startHeadlessWorkflowExecution((HeadlessWorkflowExecutionContext)exeContextBuilder.buildExtended());
                cmdCtx.println((Object)("Workflow Id: " + execInfo.getWorkflowExecutionHandle().getIdentifier()));
            }
            catch (WorkflowExecutionException | IOException e) {
                this.log.error((Object)("Exception while executing workflow: " + wfFile.getAbsolutePath()), e);
                throw CommandException.executionError((String)ComponentUtils.createErrorLogMessage((Throwable)e), (CommandContext)cmdCtx);
            }
            catch (InvalidFilenameException e) {
                throw CommandException.executionError((String)ComponentUtils.createErrorLogMessage((Throwable)e), (CommandContext)cmdCtx);
            }
        } else {
            cmdCtx.getOutputReceiver().addOutput(StringUtils.format((String)"'%s' not executed due to validation errors (see log file for details) (full path: %s)", (Object[])new Object[]{wfFile.getName(), wfFile.getAbsolutePath()}));
        }
    }

    private void performWfVerify(CommandContext context) throws CommandException {
        HeadlessWorkflowExecutionService.DisposalBehavior dispose = this.readOptionalDisposeParameter(context);
        HeadlessWorkflowExecutionService.DeletionBehavior delete = this.readOptionalDeleteParameter(context);
        int parallelRuns = this.readOptionalParallelRunsParameter(context);
        int sequentialRuns = this.readOptionalSequentialRunsParameter(context);
        File placeholdersFile = this.readOptionalPlaceholdersFileParameter(context);
        List<File> wfFiles = this.parseWfVerifyCommand(context);
        if (wfFiles.isEmpty()) {
            throw CommandException.syntaxError((String)"at least one workflow file must be specified", (CommandContext)context);
        }
        Map<Boolean, List<File>> partitionedWfFiles = wfFiles.stream().collect(Collectors.partitioningBy(file -> !file.getParentFile().getName().equals(FAILURE_DIR_NAME)));
        File rootFolder = !partitionedWfFiles.get(true).isEmpty() ? partitionedWfFiles.get(true).get(0).getParentFile() : partitionedWfFiles.get(false).get(0).getParentFile().getParentFile();
        try {
            WorkflowVerificationResults wfVerifyResultVerification = this.workflowVerificationService.getVerificationBuilder().outputReceiver(context.getOutputReceiver()).workflowRootFile(rootFolder).addWorkflowsExpectedToSucceed((Collection)partitionedWfFiles.get(true)).addWorkflowsExpectedToFail((Collection)partitionedWfFiles.get(false)).placeholdersFile(placeholdersFile).logFileFactory(this::setupLogDirectoryForWfFile).numberOfParallelRuns(parallelRuns).numberOfSequentialRuns(sequentialRuns).disposalBehavior(dispose).deletionBehavior(delete).verify();
            context.println((Object)wfVerifyResultVerification.getVerificationReport());
        }
        catch (IOException e) {
            throw CommandException.executionError((String)("Failed to initialze expected workflow behavior: " + e.getMessage()), (CommandContext)context);
        }
    }

    private void performWfPause(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = context.consumeNextToken();
        if (executionId == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        WorkflowExecutionInformation wfExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wfExecInf != null) {
            try {
                if (wfExecInf.getWorkflowState().equals((Object)WorkflowState.RUNNING)) {
                    this.workflowExecutionService.pause(wfExecInf.getWorkflowExecutionHandle());
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Pausing", wfExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to pause workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfResume(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = context.consumeNextToken();
        if (executionId == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf != null) {
            try {
                if (wExecInf.getWorkflowState().equals((Object)WorkflowState.PAUSED)) {
                    this.workflowExecutionService.resume(wExecInf.getWorkflowExecutionHandle());
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Resuming", wExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to resume workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfCancel(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = context.consumeNextToken();
        if (executionId == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf != null) {
            try {
                if (wExecInf.getWorkflowState().equals((Object)WorkflowState.RUNNING) || wExecInf.getWorkflowState().equals((Object)WorkflowState.PAUSED)) {
                    this.workflowExecutionService.cancel(wExecInf.getWorkflowExecutionHandle());
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Canceling", wExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to cancel workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfDisposeOrDelete(CommandContext context, String token) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = context.consumeNextToken();
        if (executionId == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf != null) {
            try {
                if (WorkflowConstants.FINAL_WORKFLOW_STATES.contains(wExecInf.getWorkflowState())) {
                    if (token.equals(DELETE_COMMAND)) {
                        this.workflowExecutionService.deleteFromDataManagement(wExecInf.getWorkflowExecutionHandle());
                    }
                    this.workflowExecutionService.dispose(wExecInf.getWorkflowExecutionHandle());
                } else if (token.equals(DELETE_COMMAND)) {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Deleting", wExecInf.getWorkflowState()}));
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)WRONG_STATE_ERROR, (Object[])new Object[]{"Disposing", wExecInf.getWorkflowState()}));
                }
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to dispose workflow '%s'; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }

    private void performWfList(CommandContext context) {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        outputReceiver.addOutput("Fetching workflows...");
        ArrayList wfInfos = new ArrayList(this.workflowExecutionService.getWorkflowExecutionInformations(true));
        Collections.sort(wfInfos);
        StringBuilder outputBuilder = new StringBuilder();
        int total = 0;
        int running = 0;
        int paused = 0;
        int finished = 0;
        int cancelled = 0;
        int failed = 0;
        int resultsRejected = 0;
        int other = 0;
        for (WorkflowExecutionInformation wfInfo : wfInfos) {
            WorkflowState state = wfInfo.getWorkflowState();
            outputBuilder.append(StringUtils.format((String)" '%s' - %s [%s]\n", (Object[])new Object[]{wfInfo.getInstanceName(), state, wfInfo.getExecutionIdentifier()}));
            ++total;
            switch (state) {
                case RUNNING: {
                    ++running;
                    break;
                }
                case PAUSED: {
                    ++paused;
                    break;
                }
                case FINISHED: {
                    ++finished;
                    break;
                }
                case CANCELLED: {
                    ++cancelled;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
                case RESULTS_REJECTED: {
                    ++resultsRejected;
                    break;
                }
                default: {
                    ++other;
                }
            }
        }
        outputBuilder.append(StringUtils.format((String)" -- TOTAL COUNT: %d workflow(s): %d running, %d paused, %d finished, %d cancelled, %d failed, %d verification failed, %d other -- ", (Object[])new Object[]{total, running, paused, finished, cancelled, failed, resultsRejected, other}));
        outputReceiver.addOutput(outputBuilder.toString());
    }

    private void performWfShowDetails(CommandContext context) throws CommandException {
        WorkflowRun workflowRunData;
        String executionId = context.consumeNextToken();
        if (executionId == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        WorkflowExecutionInformation wExecInf = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wExecInf == null) {
            return;
        }
        Long wfDataManagementId = wExecInf.getWorkflowDataManagementId();
        LogicalNodeId wfControllerNodeId = wExecInf.getNodeId();
        ArrayList compExecInfos = new ArrayList(wExecInf.getComponentExecutionInformations());
        Collections.sort(compExecInfos, (p1, p2) -> p1.getInstanceName().compareTo(p2.getInstanceName()));
        try {
            workflowRunData = this.metaDataService.getWorkflowRun(wfDataManagementId, (NetworkDestination)wfControllerNodeId);
        }
        catch (CommunicationException communicationException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Failed to fetch run data of workflow #%s from %s", (Object[])new Object[]{wfDataManagementId, wfControllerNodeId}), (CommandContext)context);
        }
        if (workflowRunData == null) {
            throw CommandException.executionError((String)StringUtils.format((String)"No run data found for workflow #%s from %s. Maybe data have been already deleted.", (Object[])new Object[]{wfDataManagementId, wfControllerNodeId}), (CommandContext)context);
        }
        Map componentRunsByComponentInstance = workflowRunData.getComponentRuns();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd  HH:mm:ss");
        if (wExecInf != null) {
            outputReceiver.addOutput("Name: " + wExecInf.getInstanceName());
            outputReceiver.addOutput("Status: " + wExecInf.getWorkflowState());
            outputReceiver.addOutput("Controller: " + wExecInf.getWorkflowDescription().getControllerNode().getAssociatedDisplayName());
            outputReceiver.addOutput("Start: " + df.format(wExecInf.getStartTime()));
            outputReceiver.addOutput("Started from: " + wExecInf.getNodeIdStartedExecution().getAssociatedDisplayName());
            String additional = wExecInf.getAdditionalInformationProvidedAtStart();
            if (additional != null) {
                outputReceiver.addOutput("Additional Information: ");
                outputReceiver.addOutput(additional);
            }
            outputReceiver.addOutput("Components: ");
            for (ComponentExecutionInformation compExecInfo : compExecInfos) {
                Map.Entry<ComponentInstance, Set<ComponentRun>> entry = this.getComponentRuns(compExecInfo, componentRunsByComponentInstance);
                if (entry == null) {
                    outputReceiver.addOutput(StringUtils.format((String)"    %s: No run yet. Execution Count: 0", (Object[])new Object[]{compExecInfo.getInstanceName()}));
                    continue;
                }
                ComponentInstance componentInstance = entry.getKey();
                TreeSet componentRuns = new TreeSet(entry.getValue());
                if (((ComponentRun)componentRuns.first()).getRunCounter() == 0) {
                    componentRuns.remove(componentRuns.first());
                }
                if (((ComponentRun)componentRuns.last()).getRunCounter() == -1) {
                    componentRuns.remove(componentRuns.last());
                }
                if (componentRuns.isEmpty()) {
                    outputReceiver.addOutput(StringUtils.format((String)"    %s: No run yet. Execution Count: 0", (Object[])new Object[]{compExecInfo.getInstanceName()}));
                    continue;
                }
                long sum = 0L;
                long max = 0L;
                for (ComponentRun cRun : componentRuns) {
                    if (((ComponentRun)componentRuns.last()).getEndTime() == null) continue;
                    long diff = cRun.getEndTime() - cRun.getStartTime();
                    sum += diff;
                    if (diff <= max) continue;
                    max = diff;
                }
                int average = (int)(sum / (long)componentRuns.size());
                String componentInstanceName = componentInstance.getComponentInstanceName();
                if (((ComponentRun)componentRuns.last()).getEndTime() != null) {
                    String endTime = df.format(((ComponentRun)componentRuns.last()).getEndTime());
                    String message = componentInstance.getFinalState() == null ? StringUtils.format((String)"    %s: Waiting for Input since %s", (Object[])new Object[]{componentInstanceName, endTime}) : StringUtils.format((String)"    %s: %s at %s", (Object[])new Object[]{componentInstanceName, componentInstance.getFinalState(), endTime});
                    outputReceiver.addOutput(message);
                } else {
                    outputReceiver.addOutput(StringUtils.format((String)"    %s: started at %s", (Object[])new Object[]{componentInstanceName, df.format(((ComponentRun)componentRuns.first()).getStartTime())}));
                    outputReceiver.addOutput(StringUtils.format((String)"        Current Execution started at %s", (Object[])new Object[]{df.format(((ComponentRun)componentRuns.last()).getStartTime())}));
                }
                outputReceiver.addOutput(StringUtils.format((String)WF_DETAILS_OUTPUT_TEXT, (Object[])new Object[]{((ComponentRun)componentRuns.last()).getRunCounter(), average, max, sum}));
            }
        }
    }

    private Map.Entry<ComponentInstance, Set<ComponentRun>> getComponentRuns(ComponentExecutionInformation compExecInfo, Map<ComponentInstance, Set<ComponentRun>> componentRunsByComponentInstance) {
        for (Map.Entry<ComponentInstance, Set<ComponentRun>> entry : componentRunsByComponentInstance.entrySet()) {
            ComponentInstance componentInstance = entry.getKey();
            if (!componentInstance.getComponentInstanceName().equals(compExecInfo.getInstanceName())) continue;
            return entry;
        }
        return null;
    }

    private void performWfOpen(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        String executionId = context.consumeNextToken();
        if (executionId == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        WorkflowExecutionDisplayService displayService = this.workflowExecutionDisplayService;
        if (displayService == null || !displayService.hasGui()) {
            outputReceiver.addOutput("Could not display workflow execution, as no GUI is present.");
            return;
        }
        WorkflowExecutionInformation wfExecInfo = this.getWfExecInfFromExecutionId(executionId, outputReceiver);
        if (wfExecInfo == null) {
            return;
        }
        displayService.displayWorkflowExecution(wfExecInfo);
    }

    private String getSelfTestDirPath() {
        String path = "/src/main/resources/";
        if (this.bundle.findEntries(path, ASTERISK, false) == null) {
            path = SLASH;
        }
        return path;
    }

    private void performWfListSelfTestCases(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        for (String testCaseFileName : this.getTestCaseFileNamesWithoutEnding()) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream caseFileInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR + testCaseFileName + SELF_TEST_CASES_FILE_ENDING);){
                    outputReceiver.addOutput(StringUtils.format((String)"%s [%d]", (Object[])new Object[]{testCaseFileName, IOUtils.readLines((InputStream)caseFileInputStream).size()}));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw CommandException.executionError((String)("Failed to read test case file: " + testCaseFileName), (CommandContext)context);
            }
        }
    }

    private void performWfCheckSelfTestCases(CommandContext context) throws CommandException {
        TextOutputReceiver outputReceiver = context.getOutputReceiver();
        ArrayList<String> wfFileNamesWithoutEnding = new ArrayList<String>();
        Enumeration selfTestFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_WORKFLOW_DIR, "*.wf", true);
        while (selfTestFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFolderEntries.nextElement();
            String[] pathParts = entryURL.getPath().split(SLASH);
            wfFileNamesWithoutEnding.add(pathParts[pathParts.length - 1].replace(".wf", ""));
        }
        Enumeration selfTestFailureFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_WORKFLOW_DIR + FAILURE_DIR_NAME, "*.wf", true);
        while (selfTestFailureFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFailureFolderEntries.nextElement();
            String[] pathParts = entryURL.getPath().split(SLASH);
            wfFileNamesWithoutEnding.add(pathParts[pathParts.length - 1].replace(".wf", ""));
        }
        HashSet wfPartOfTestCase = new HashSet();
        for (String testCaseFileName : this.getTestCaseFileNamesWithoutEnding()) {
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (InputStream caseFileInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR + testCaseFileName + SELF_TEST_CASES_FILE_ENDING);){
                    wfPartOfTestCase.addAll(IOUtils.readLines((InputStream)caseFileInputStream));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw CommandException.executionError((String)("Failed to read test case file: " + testCaseFileName), (CommandContext)context);
            }
        }
        wfFileNamesWithoutEnding.removeAll(wfPartOfTestCase);
        if (wfFileNamesWithoutEnding.isEmpty()) {
            outputReceiver.addOutput("Ok: Every workflow file is considered by at least one test case");
        } else {
            outputReceiver.addOutput("Failed: Workflow file(s) are not considered by at least one test case: " + wfFileNamesWithoutEnding);
        }
    }

    private List<String> getTestCaseFileNamesWithoutEnding() {
        ArrayList<String> testCaseFileNamesWithoutEnding = new ArrayList<String>();
        Enumeration selfTestFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR, "*.cases", false);
        while (selfTestFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFolderEntries.nextElement();
            String[] pathParts = entryURL.getPath().split(SLASH);
            testCaseFileNamesWithoutEnding.add(pathParts[pathParts.length - 1].replace(SELF_TEST_CASES_FILE_ENDING, ""));
        }
        return testCaseFileNamesWithoutEnding;
    }

    private void performWfSelfTest(CommandContext context) throws CommandException {
        CommandContext syntheticContext;
        List<File> workflowFiles;
        String message;
        HeadlessWorkflowExecutionService.DisposalBehavior dispose = this.readOptionalDisposeParameter(context);
        HeadlessWorkflowExecutionService.DeletionBehavior delete = this.readOptionalDeleteParameter(context);
        int parallelRuns = this.readOptionalParallelRunsParameter(context);
        int sequentialRuns = this.readOptionalSequentialRunsParameter(context);
        String[] cases = this.getCasesParameter(context);
        String pythonPath = null;
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        File tempSelfTestWorkflowDir = null;
        File tempSelfTestWorkflowFailureDir = null;
        File tempPlaceholdersStuffDir = null;
        File placeholdersFile = null;
        try {
            tempSelfTestWorkflowDir = tempFileService.createManagedTempDir();
            tempSelfTestWorkflowFailureDir = new File(tempSelfTestWorkflowDir, FAILURE_DIR_NAME);
            tempPlaceholdersStuffDir = tempFileService.createManagedTempDir();
        }
        catch (IOException e) {
            message = "Failed to create temp directory required for self-test workflow execution";
            this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
        }
        if (Arrays.asList(cases).contains("with-python")) {
            try {
                pythonPath = this.getAndCheckPythonPath(context, tempSelfTestWorkflowDir);
            }
            catch (IOException e) {
                message = "Failed to check command to be used to invoke Python";
                this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
            }
        }
        try {
            this.copyWorkflowsForSelfTest(tempFileService, tempSelfTestWorkflowDir, tempSelfTestWorkflowFailureDir, cases);
        }
        catch (IOException e) {
            message = "Failed to copy workflow files from self-test folder to temp directory: " + e.getMessage();
            this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
        }
        try {
            placeholdersFile = this.generatePlaceholdersRelatedFiles(tempPlaceholdersStuffDir, pythonPath);
        }
        catch (IOException e) {
            message = "Failed to create placeholders-related files required for self-test workflow execution";
            this.handleWfSelfTestExecutionError(context, tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir, e, message);
        }
        ArrayList<String> newTokens = new ArrayList<String>();
        newTokens.add(BASEDIR_OPTION);
        newTokens.add(tempSelfTestWorkflowDir.getAbsolutePath());
        newTokens.add(ASTERISK);
        if (tempSelfTestWorkflowFailureDir.exists()) {
            newTokens.add(BASEDIR_OPTION);
            newTokens.add(tempSelfTestWorkflowFailureDir.getAbsolutePath());
            newTokens.add(ASTERISK);
        }
        if ((workflowFiles = this.parseWfVerifyCommand(syntheticContext = new CommandContext(newTokens, context.getOutputReceiver(), context.getInvokerInformation()))).isEmpty()) {
            throw CommandException.syntaxError((String)"at least one workflow file must be specified", (CommandContext)context);
        }
        Map<Boolean, List<File>> partitionedWfFiles = workflowFiles.stream().collect(Collectors.partitioningBy(file -> !file.getParentFile().getName().equals(FAILURE_DIR_NAME)));
        File rootFolder = !partitionedWfFiles.get(true).isEmpty() ? partitionedWfFiles.get(true).get(0).getParentFile() : partitionedWfFiles.get(false).get(0).getParentFile().getParentFile();
        try {
            WorkflowVerificationResults wfVerifyResultVerification = this.workflowVerificationService.getVerificationBuilder().outputReceiver(context.getOutputReceiver()).workflowRootFile(rootFolder).addWorkflowsExpectedToSucceed((Collection)partitionedWfFiles.get(true)).addWorkflowsExpectedToFail((Collection)partitionedWfFiles.get(false)).placeholdersFile(placeholdersFile).logFileFactory(this::setupLogDirectoryForWfFile).numberOfParallelRuns(parallelRuns).numberOfSequentialRuns(sequentialRuns).disposalBehavior(dispose).deletionBehavior(delete).verify();
            context.println((Object)wfVerifyResultVerification.getVerificationReport());
            if (!delete.equals((Object)HeadlessWorkflowExecutionService.DeletionBehavior.Never) && (wfVerifyResultVerification.isVerified() || delete.equals((Object)HeadlessWorkflowExecutionService.DeletionBehavior.Always))) {
                this.disposeTempDirsCreatedForSelfTest(tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir);
            } else if (delete.equals((Object)HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected)) {
                for (File file2 : wfVerifyResultVerification.getWorkflowRelatedFilesToDelete()) {
                    try {
                        tempFileService.disposeManagedTempDirOrFile(file2);
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Failed to delete workflow file after execution: " + file2), (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw CommandException.executionError((String)("Failed to initialze expected workflow behavior: " + e.getMessage()), (CommandContext)context);
        }
    }

    private String getAndCheckPythonPath(CommandContext context, File workDir) throws CommandException, IOException {
        String pythonPath = this.getPythonPathParameter(context);
        LocalApacheCommandLineExecutor executor = new LocalApacheCommandLineExecutor(workDir);
        executor.start(String.valueOf(pythonPath) + " --version");
        try {
            if (executor.waitForTermination() != 0) {
                throw CommandException.executionError((String)("Command to invoke Python invalid: " + pythonPath), (CommandContext)context);
            }
        }
        catch (InterruptedException e) {
            throw CommandException.executionError((String)("Interupted when checking command to invoke Python: " + e.getMessage()), (CommandContext)context);
        }
        Throwable throwable = null;
        Object var6_8 = null;
        try (InputStream stdErrStream = executor.getStderr();){
            context.getOutputReceiver().addOutput("Using: " + IOUtils.toString((InputStream)stdErrStream));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return pythonPath;
    }

    private void handleWfSelfTestExecutionError(CommandContext context, TempFileService tempFileService, File tempSelfTestWorkflowDir, File tempPlaceholdersStuffDir, IOException e, String message) throws CommandException {
        this.log.error((Object)message, (Throwable)e);
        this.disposeTempDirsCreatedForSelfTest(tempFileService, tempSelfTestWorkflowDir, tempPlaceholdersStuffDir);
        throw CommandException.executionError((String)message, (CommandContext)context);
    }

    private void disposeTempDirsCreatedForSelfTest(TempFileService tempFileService, File tempSelfTestWorkflowDir, File tempPlaceholdersStuffDir) {
        if (tempSelfTestWorkflowDir != null) {
            try {
                tempFileService.disposeManagedTempDirOrFile(tempSelfTestWorkflowDir);
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to dispose temp directory created for self-test workflow execution: " + tempSelfTestWorkflowDir), (Throwable)e);
            }
        }
        if (tempPlaceholdersStuffDir != null) {
            try {
                tempFileService.disposeManagedTempDirOrFile(tempPlaceholdersStuffDir);
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to dispose temp directory created for self-test workflow execution: " + tempPlaceholdersStuffDir), (Throwable)e);
            }
        }
    }

    private List<String> getWorkflowsForSelfTest(String[] cases) throws IOException {
        ArrayList<String> wfs = new ArrayList<String>();
        String[] stringArray = cases;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            String caseName = stringArray[n2];
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream caseInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_CASES_DIR + caseName + SELF_TEST_CASES_FILE_ENDING);){
                if (caseInputStream == null) {
                    throw new IOException("Case unknown: " + caseName);
                }
                wfs.addAll(IOUtils.readLines((InputStream)caseInputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
        return wfs;
    }

    private void copyWorkflowsForSelfTest(TempFileService tempFileService, File tempSelfTestWorkflowDir, File tempSelfTestWorkflowFailureDir, String[] cases) throws IOException {
        tempSelfTestWorkflowFailureDir.mkdir();
        List<String> wfsForSelfTest = this.getWorkflowsForSelfTest(cases);
        Enumeration selfTestFolderEntries = this.bundle.findEntries(String.valueOf(this.getSelfTestDirPath()) + SELF_TEST_WORKFLOW_DIR, ASTERISK, true);
        while (selfTestFolderEntries.hasMoreElements()) {
            URL entryURL = (URL)selfTestFolderEntries.nextElement();
            String entryRawPath = entryURL.getPath();
            if (entryRawPath.endsWith(SLASH)) {
                if (entryRawPath.endsWith("failure/")) continue;
                throw new IOException("Unexpected directory in self-test directory: " + entryRawPath);
            }
            String[] pathParts = entryRawPath.split(SLASH);
            String selfTestFileName = pathParts[pathParts.length - 1];
            this.validateFileInSelfTestDirectory(selfTestFileName);
            String selfTestFileNameWithoutEnding = selfTestFileName.replace(".wf", "");
            if (selfTestFileName.endsWith(".wf") && !wfsForSelfTest.contains(selfTestFileNameWithoutEnding)) continue;
            wfsForSelfTest.remove(selfTestFileNameWithoutEnding);
            File targetFile = pathParts.length > 1 && pathParts[pathParts.length - 2].equals(FAILURE_DIR_NAME) ? new File(tempSelfTestWorkflowFailureDir, selfTestFileName) : new File(tempSelfTestWorkflowDir, selfTestFileName);
            Throwable throwable = null;
            Object var14_15 = null;
            try {
                InputStream entryInputStream = entryURL.openStream();
                try {
                    try (FileWriter targetTempFileWriter = new FileWriter(targetFile);){
                        IOUtils.copy((InputStream)entryInputStream, (Writer)targetTempFileWriter, (Charset)StandardCharsets.UTF_8);
                    }
                    if (entryInputStream == null) continue;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                    throw throwable;
                }
                entryInputStream.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.validateSelfTestData(wfsForSelfTest, tempSelfTestWorkflowFailureDir);
    }

    private void validateFileInSelfTestDirectory(String selfTestFileName) throws IOException {
        if (!(selfTestFileName.endsWith(".wf") || selfTestFileName.endsWith(".log.expected") || selfTestFileName.endsWith(".log.prohibited"))) {
            throw new IOException("Unexpected file in self-test directory: " + selfTestFileName);
        }
    }

    private void validateSelfTestData(List<String> wfsForSelfTestNotUsed, File tempSelfTestWorkflowFailureDir) throws IOException {
        if (!wfsForSelfTestNotUsed.isEmpty()) {
            throw new IOException("A test case contains workflow file(s) that do(es)n't exist: " + wfsForSelfTestNotUsed);
        }
        this.validateExpectedLogExistsForWorkflowsExpectedToFail(tempSelfTestWorkflowFailureDir);
    }

    private void validateExpectedLogExistsForWorkflowsExpectedToFail(File tempSelfTestWorkflowFailureDir) throws IOException {
        File[] fileArray = tempSelfTestWorkflowFailureDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".wf") && !new File(tempSelfTestWorkflowFailureDir, String.valueOf(file.getName().replaceAll(".wf", "")) + ".log.expected").exists()) {
                throw new IOException("File with expected log is missing for workflow expected to fail: " + file);
            }
            ++n2;
        }
    }

    private File generatePlaceholdersRelatedFiles(File tempPlaceholdersStuffDir, String pythonPath) throws IOException {
        InputStream placeholdersTemplateInputStream = this.getClass().getResourceAsStream(String.valueOf(this.getSelfTestDirPath()) + "placeholders/placeholders_template.json");
        Random radom = new Random();
        File placeholdersFile = new File(tempPlaceholdersStuffDir, "placeholders.json");
        File testInputFile = new File(tempPlaceholdersStuffDir, "test-input.text");
        FileUtils.write((File)testInputFile, (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        File testInputDir = new File(tempPlaceholdersStuffDir, "test-input-dir");
        testInputDir.mkdir();
        FileUtils.write((File)new File(testInputDir, "test-file-1"), (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        FileUtils.write((File)new File(testInputDir, "test-file-2"), (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        FileUtils.write((File)new File(testInputDir, "test-file-3"), (CharSequence)RandomStringUtils.random((int)radom.nextInt(1000)));
        File testTargetRootDir = new File(tempPlaceholdersStuffDir, "test-target-dir");
        testTargetRootDir.mkdir();
        File testMemFile1 = new File(tempPlaceholdersStuffDir, "test-mem-1");
        File testMemFile2 = new File(tempPlaceholdersStuffDir, "test-mem-2");
        File testMemFile3 = new File(tempPlaceholdersStuffDir, "test-mem-3");
        FileUtils.write((File)placeholdersFile, (CharSequence)StringUtils.format((String)IOUtils.toString((InputStream)placeholdersTemplateInputStream), (Object[])new Object[]{pythonPath, testInputFile.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testInputDir.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testTargetRootDir.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testMemFile1.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testMemFile2.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH), testMemFile3.getAbsolutePath().replaceAll(ESCAPED_BACKSLASH, SLASH)}));
        return placeholdersFile;
    }

    private List<File> parseWfVerifyCommand(CommandContext context) throws CommandException {
        String token;
        if (!context.hasRemainingTokens()) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        ArrayList<File> wfFiles = new ArrayList<File>();
        String lastBaseDirOption = null;
        File lastBaseDir = null;
        while ((token = context.consumeNextToken()) != null) {
            if (BASEDIR_OPTION.equals(token)) {
                lastBaseDirOption = context.consumeNextToken();
                if (lastBaseDirOption == null) {
                    throw CommandException.syntaxError((String)"--basedir option specified without a value", (CommandContext)context);
                }
                lastBaseDir = new File(lastBaseDirOption);
                if (lastBaseDir.isDirectory()) continue;
                throw CommandException.executionError((String)("Specified --basedir is not a valid directory: " + lastBaseDir.getAbsolutePath()), (CommandContext)context);
            }
            if (ASTERISK.equals(token)) {
                if (lastBaseDir == null) {
                    throw CommandException.executionError((String)"The \"*\" wildcard requires a previous --basedir", (CommandContext)context);
                }
                int count = 0;
                String[] stringArray = lastBaseDir.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    if (filename.endsWith(".wf") && !filename.endsWith("_backup.wf")) {
                        File wfFile = new File(lastBaseDir, filename);
                        this.checkWfFileExists(context, wfFile);
                        wfFiles.add(wfFile);
                        ++count;
                    }
                    ++n2;
                }
                context.println((Object)("Added " + count + " non-backup workflow file(s) from " + lastBaseDir.getAbsolutePath()));
                continue;
            }
            File wfFile = lastBaseDir != null ? new File(lastBaseDir, token) : new File(token);
            this.checkWfFileExists(context, wfFile);
            wfFiles.add(wfFile);
        }
        return wfFiles;
    }

    private Integer readOptionalParallelRunsParameter(CommandContext context) throws CommandException {
        return this.readOptionalRunsParameter(context, "--pr");
    }

    private Integer readOptionalSequentialRunsParameter(CommandContext context) throws CommandException {
        return this.readOptionalRunsParameter(context, "--sr");
    }

    private Integer readOptionalRunsParameter(CommandContext context, String parameter) throws CommandException {
        int numberOfRuns = 1;
        if (context.consumeNextTokenIfEquals(parameter)) {
            String number = context.consumeNextToken();
            if (number == null) {
                throw CommandException.syntaxError((String)"Missing number of runs", (CommandContext)context);
            }
            try {
                numberOfRuns = Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }
        return numberOfRuns;
    }

    private HeadlessWorkflowExecutionService.DisposalBehavior readOptionalDisposeParameter(CommandContext context) throws CommandException {
        if (context.consumeNextTokenIfEquals("--dispose")) {
            String dispose = context.consumeNextToken();
            try {
                if (HeadlessWorkflowExecutionService.DisposalBehavior.Always.name().equalsIgnoreCase(dispose)) {
                    return HeadlessWorkflowExecutionService.DisposalBehavior.Always;
                }
                if (HeadlessWorkflowExecutionService.DisposalBehavior.Never.name().equalsIgnoreCase(dispose)) {
                    return HeadlessWorkflowExecutionService.DisposalBehavior.Never;
                }
                if ("onfinish".equalsIgnoreCase(dispose) || HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected.name().equalsIgnoreCase(dispose)) {
                    return HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected;
                }
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                throw CommandException.syntaxError((String)("Invalid dispose behavior: " + dispose), (CommandContext)context);
            }
        }
        return HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected;
    }

    private String getPythonPathParameter(CommandContext context) {
        if (context.consumeNextTokenIfEquals("--python")) {
            return context.consumeNextToken().replaceAll(ESCAPED_BACKSLASH, SLASH);
        }
        return "python";
    }

    private String[] getCasesParameter(CommandContext context) {
        if (context.consumeNextTokenIfEquals("--cases")) {
            return context.consumeNextToken().split(",");
        }
        return new String[]{"core"};
    }

    private HeadlessWorkflowExecutionService.DeletionBehavior readOptionalDeleteParameter(CommandContext context) throws CommandException {
        if (context.consumeNextTokenIfEquals("--delete")) {
            String delete = context.consumeNextToken();
            try {
                if (HeadlessWorkflowExecutionService.DeletionBehavior.Always.name().equalsIgnoreCase(delete)) {
                    return HeadlessWorkflowExecutionService.DeletionBehavior.Always;
                }
                if (HeadlessWorkflowExecutionService.DeletionBehavior.Never.name().equalsIgnoreCase(delete)) {
                    return HeadlessWorkflowExecutionService.DeletionBehavior.Never;
                }
                if ("onfinish".equalsIgnoreCase(delete) || HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected.name().equalsIgnoreCase(delete)) {
                    return HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected;
                }
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                throw CommandException.syntaxError((String)("Invalid delete behavior: " + delete), (CommandContext)context);
            }
        }
        return HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected;
    }

    private File readOptionalPlaceholdersFileParameter(CommandContext context) throws CommandException {
        File placeholdersFile = null;
        if (context.consumeNextTokenIfEquals("-p")) {
            String placeholdersFilename = context.consumeNextToken();
            if (placeholdersFilename == null) {
                throw CommandException.syntaxError((String)"Missing placeholder filename", (CommandContext)context);
            }
            try {
                placeholdersFile = WorkflowExecutionUtils.resolveWorkflowOrPlaceholderFileLocation((String)placeholdersFilename, (String)"Placeholder file %s does not exist or it can not be read");
            }
            catch (FileNotFoundException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }
        return placeholdersFile;
    }

    private void checkWfFileExists(CommandContext context, File wfFile) throws CommandException {
        if (!wfFile.isFile()) {
            throw CommandException.executionError((String)("Specified workflow file does not exist: " + wfFile.getAbsolutePath()), (CommandContext)context);
        }
    }

    private File setupLogDirectoryForWfFile(File wfFile) throws IOException {
        if (!wfFile.isFile()) {
            throw new IOException("The workflow file \"" + wfFile.getAbsolutePath() + "\" does not exist or it cannot be opened");
        }
        File parentDir = wfFile.getParentFile();
        if (!parentDir.isDirectory()) {
            throw new IOException("Consistency error: parent directory is not a directory: " + parentDir.getAbsolutePath());
        }
        long millis = new GregorianCalendar().getTimeInMillis();
        String folderName = wfFile.getName();
        if (folderName.contains(STRING_DOT)) {
            folderName = folderName.substring(0, folderName.lastIndexOf(STRING_DOT));
        }
        int suffixNumber = GLOBAL_WORKFLOW_SUFFIX_SEQUENCE_COUNTER.incrementAndGet() % 100;
        Timestamp ts = new Timestamp(millis);
        folderName = "logs/" + folderName + "_" + ts.toString().replace('.', '-').replace(' ', '_').replace(':', '-') + "_" + suffixNumber;
        File logDir = new File(parentDir, folderName);
        logDir.mkdirs();
        if (!logDir.isDirectory()) {
            throw new IOException("Failed to create log directory" + logDir.getAbsolutePath());
        }
        return logDir;
    }

    private WorkflowExecutionInformation getWfExecInfFromExecutionId(String executionId, TextOutputReceiver outputReceiver) {
        WorkflowExecutionInformation wExecInf = null;
        Set wis = this.workflowExecutionService.getWorkflowExecutionInformations();
        for (WorkflowExecutionInformation workflow : wis) {
            if (!workflow.getExecutionIdentifier().equals(executionId)) continue;
            wExecInf = workflow;
            break;
        }
        if (wExecInf == null) {
            outputReceiver.addOutput("Workflow with id '" + executionId + "' not found");
        }
        return wExecInf;
    }

    private void performWfGraph(final CommandContext cmdCtx) throws CommandException {
        WorkflowDescription wfDesc;
        File wfFile = this.getWorkflowFile(cmdCtx);
        try {
            wfDesc = this.workflowExecutionService.loadWorkflowDescriptionFromFile(wfFile, new WorkflowDescriptionLoaderCallback(){

                public void onWorkflowFileParsingPartlyFailed(String backupFilename) {
                    cmdCtx.getOutputReceiver().addOutput("Workflow partly invalid, some parts are removed; backup file: " + backupFilename);
                }

                public void onSilentWorkflowFileUpdated(String message) {
                    cmdCtx.getOutputReceiver().addOutput("Workflow updated (silent update): " + message);
                }

                public void onNonSilentWorkflowFileUpdated(String message, String backupFilename) {
                    cmdCtx.getOutputReceiver().addOutput("Workflow updated: " + message + "; backup file: " + backupFilename);
                }

                public boolean arePartlyParsedWorkflowConsiderValid() {
                    return false;
                }
            });
        }
        catch (WorkflowFileException e) {
            throw CommandException.executionError((String)("Failed to load workflow: " + e.getMessage()), (CommandContext)cmdCtx);
        }
        if (WorkflowExecutionUtils.hasMissingWorkflowNode((List)wfDesc.getWorkflowNodes())) {
            throw CommandException.executionError((String)"Workflow has missing components", (CommandContext)cmdCtx);
        }
        try {
            WorkflowGraph workflowGraph = this.createWorkflowGraph(wfDesc);
            if (workflowGraph == null) {
                throw CommandException.executionError((String)("The wf graph command is not implemented yet. See " + this.getClass().getTypeName() + " for more informations."), (CommandContext)cmdCtx);
            }
            cmdCtx.getOutputReceiver().addOutput(workflowGraph.toDotScript());
        }
        catch (WorkflowExecutionException e) {
            throw CommandException.executionError((String)("Failed to create workflow graph: " + e.getMessage()), (CommandContext)cmdCtx);
        }
    }

    private WorkflowGraph createWorkflowGraph(WorkflowDescription workflowDescription) throws WorkflowExecutionException {
        return null;
    }
}

