/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.cluster.internal;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import de.rcenvironment.core.utils.cluster.ClusterJobStateChangeListener;
import de.rcenvironment.core.utils.cluster.ClusterService;
import de.rcenvironment.core.utils.ssh.jsch.JschSessionFactory;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchCommandLineExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractClusterService
implements ClusterService {
    protected static final String REMOTE_WORK_DIR = "~";
    protected SshSessionConfiguration sshConfiguration;
    protected Map<String, String> pathsToQueuingSystemCommands;
    protected Session jschSession;
    protected volatile long latestFetch = 0L;
    protected Map<String, ClusterJobInformation> latestFetchedJobInformation;
    protected Map<String, ClusterJobInformation.ClusterJobState> lastClusterJobStates = new HashMap<String, ClusterJobInformation.ClusterJobState>();
    protected final Map<String, ClusterJobStateChangeListener> listeners = new HashMap<String, ClusterJobStateChangeListener>();
    protected Timer fetchInformationTimer;

    public AbstractClusterService() {
    }

    public AbstractClusterService(SshSessionConfiguration sshConfiguration, Map<String, String> pathsToQueuingSystemCommands) {
        this.sshConfiguration = sshConfiguration;
        this.pathsToQueuingSystemCommands = pathsToQueuingSystemCommands;
    }

    public void setPathsToQueuingSystemCommands(Map<String, String> pathsToQueuingSystemCommands) {
        this.pathsToQueuingSystemCommands = pathsToQueuingSystemCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureJschSessionEstablished() throws IOException {
        AbstractClusterService abstractClusterService = this;
        synchronized (abstractClusterService) {
            if (this.jschSession == null || !this.jschSession.isConnected()) {
                try {
                    this.jschSession = JschSessionFactory.setupSession((String)this.sshConfiguration.getDestinationHost(), (int)this.sshConfiguration.getPort(), (String)this.sshConfiguration.getSshAuthUser(), null, (String)this.sshConfiguration.getSshAuthPhrase(), null);
                }
                catch (JSchException e) {
                    throw new IOException("Establishing connection to cluster failed: " + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
                }
                catch (SshParameterException e) {
                    throw new IOException("Establishing connection to cluster failed" + ExceptionUtils.getRootCauseMessage((Throwable)e), e);
                }
            }
        }
    }

    protected String buildMainCommand(String command) {
        if (this.pathsToQueuingSystemCommands.get(command) != null) {
            command = String.valueOf(this.pathsToQueuingSystemCommands.get(command)) + command;
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClusterJobStateChangeListener(String jobId, ClusterJobStateChangeListener listener) {
        Map<String, ClusterJobStateChangeListener> map = this.listeners;
        synchronized (map) {
            this.listeners.put(jobId, listener);
            if (this.fetchInformationTimer == null) {
                this.fetchInformationTimer = new Timer("Fetch Cluster Job Information Timer", true);
                TimerTask fetchInformationTimerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (AbstractClusterService.this.latestFetchedJobInformation == null || new Date().getTime() - AbstractClusterService.this.latestFetch > 61000L) {
                            try {
                                AbstractClusterService.this.fetchClusterJobInformation();
                            }
                            catch (IOException e) {
                                AbstractClusterService.this.fetchInformationTimer.cancel();
                                AbstractClusterService.this.fetchInformationTimer = null;
                                AbstractClusterService.this.jschSession = null;
                                AbstractClusterService.this.notifyClusterJobStateChangeListenerAboutFetchingFailure();
                                throw new RuntimeException("Fetching cluster job information failed", e);
                            }
                        }
                        AbstractClusterService.this.notifyClusterJobStateChangeListener();
                    }
                };
                this.fetchInformationTimer.schedule(fetchInformationTimerTask, 60000L, 60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClusterJobStateChangeListener() {
        HashSet<String> listenersToRemove = new HashSet<String>();
        Map<String, ClusterJobStateChangeListener> map = this.listeners;
        synchronized (map) {
            for (String jobId : this.listeners.keySet()) {
                ClusterJobInformation.ClusterJobState lastState = this.lastClusterJobStates.get(jobId);
                if (this.latestFetchedJobInformation.containsKey(jobId)) {
                    ClusterJobInformation.ClusterJobState latestState = this.latestFetchedJobInformation.get(jobId).getJobState();
                    if (!(lastState != null && lastState.equals((Object)latestState) || this.listeners.get(jobId).onClusterJobStateChanged(latestState))) {
                        listenersToRemove.add(jobId);
                    }
                    lastState = latestState;
                    continue;
                }
                if (this.listeners.get(jobId).onClusterJobStateChanged(ClusterJobInformation.ClusterJobState.Unknown)) continue;
                listenersToRemove.add(jobId);
            }
            for (String jobId : listenersToRemove) {
                this.listeners.remove(jobId);
            }
            if (this.listeners.isEmpty()) {
                this.fetchInformationTimer.cancel();
                this.fetchInformationTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClusterJobStateChangeListenerAboutFetchingFailure() {
        Map<String, ClusterJobStateChangeListener> map = this.listeners;
        synchronized (map) {
            for (ClusterJobStateChangeListener listener : this.listeners.values()) {
                listener.onClusterJobStateChanged(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String executesCommand(Session ajschSession, String command, String remoteWorkDir) throws IOException {
        JSchCommandLineExecutor commandLineExecutor = new JSchCommandLineExecutor(ajschSession, remoteWorkDir);
        commandLineExecutor.start(command);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            InputStream stdoutStream = commandLineExecutor.getStdout();
            try {
                String string;
                block17: {
                    InputStream stderrStream = commandLineExecutor.getStderr();
                    try {
                        String stdout;
                        try {
                            commandLineExecutor.waitForTermination();
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e);
                        }
                        String stderr = IOUtils.toString((InputStream)stderrStream);
                        if (stderr != null && !stderr.isEmpty()) {
                            throw new IOException(stderr);
                        }
                        string = stdout = IOUtils.toString((InputStream)stdoutStream);
                        return string;
                    }
                    finally {
                        if (stderrStream == null) break block17;
                        stderrStream.close();
                    }
                }
                if (stdoutStream != null) {
                    stdoutStream.close();
                }
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stdoutStream == null) throw throwable;
                stdoutStream.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

