/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor;

import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.executor.AbstractCommandLineExecutor;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalCommandLineExecutor
extends AbstractCommandLineExecutor
implements CommandLineExecutor {
    private static final String[] LINUX_SHELL_TOKENS = new String[]{"/bin/sh", "-c", "[command]"};
    private static final String[] WINDOWS_SHELL_TOKENS = new String[]{"cmd.exe", "/c", "[command]"};
    private File workDir;
    private Process process;
    private Log log = LogFactory.getLog(this.getClass());

    public LocalCommandLineExecutor(File workDirPath) throws IOException {
        this.workDir = workDirPath;
    }

    @Override
    public void start(String commandString) throws IOException {
        this.start(commandString, null);
    }

    @Override
    public void start(String commandString, InputStream stdinStream) throws IOException {
        String[] commandTokens;
        if (!this.workDir.isDirectory()) {
            this.workDir.mkdirs();
            if (!this.workDir.isDirectory()) {
                throw new IOException("Failed to create provided work directory " + this.workDir.getAbsolutePath());
            }
        }
        Set entries = this.env.entrySet();
        String[] envArray = new String[entries.size()];
        int pos = 0;
        for (Map.Entry entry : entries) {
            envArray[pos++] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
        }
        if (OS.isFamilyWindows()) {
            commandTokens = Arrays.copyOf(WINDOWS_SHELL_TOKENS, WINDOWS_SHELL_TOKENS.length);
            commandTokens[LocalCommandLineExecutor.WINDOWS_SHELL_TOKENS.length - 1] = commandString;
        } else {
            commandTokens = Arrays.copyOf(LINUX_SHELL_TOKENS, LINUX_SHELL_TOKENS.length);
            commandTokens[LocalCommandLineExecutor.LINUX_SHELL_TOKENS.length - 1] = commandString;
        }
        this.process = Runtime.getRuntime().exec(commandTokens, envArray, this.workDir);
        if (stdinStream != null) {
            OutputStream stdin = this.process.getOutputStream();
            ConcurrencyUtils.getAsyncTaskService().execute("LocalCommandLineExecutor input stream pipe", () -> {
                try {
                    IOUtils.copy((InputStream)stdinStream, (OutputStream)stdin);
                    stdin.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error writing STDIN stream", (Throwable)e);
                }
            });
        }
    }

    @Override
    public String getWorkDirPath() {
        return this.workDir.getAbsolutePath();
    }

    @Override
    public InputStream getStdout() {
        return this.process.getInputStream();
    }

    @Override
    public InputStream getStderr() {
        return this.process.getErrorStream();
    }

    @Override
    public int waitForTermination() throws IOException, InterruptedException {
        return this.process.waitFor();
    }

    @Override
    public void uploadFileToWorkdir(File localFile, String remoteLocation) throws IOException {
        File targetFile = new File(this.workDir, remoteLocation);
        this.log.debug((Object)("Local copy from " + localFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath()));
        FileUtils.copyFile((File)localFile, (File)targetFile);
    }

    @Override
    public void downloadFileFromWorkdir(String remoteLocation, File localFile) throws IOException {
        FileUtils.copyFile((File)new File(this.workDir, remoteLocation), (File)localFile);
    }

    @Override
    public void downloadWorkdir(File localDir) throws IOException {
        FileUtils.copyDirectory((File)this.workDir, (File)localDir);
    }

    @Override
    public void remoteCopy(String remoteSource, String remoteTarget) throws IOException {
        FileUtils.copyFile((File)new File(remoteSource), (File)new File(remoteTarget));
    }

    @Override
    public void uploadDirectoryToWorkdir(File localDirectory, String remoteLocation) throws IOException {
        File targetDirectory = new File(this.workDir, remoteLocation);
        targetDirectory.mkdirs();
        FileUtils.copyDirectory((File)localDirectory, (File)targetDirectory);
    }

    @Override
    public void downloadDirectoryFromWorkdir(String remoteLocation, File localDirectory) throws IOException {
        FileUtils.copyDirectory((File)new File(this.workDir, remoteLocation), (File)localDirectory);
    }

    @Override
    public void downloadFile(String remoteLocation, File localFile) throws IOException {
        FileUtils.copyFile((File)new File(remoteLocation), (File)localFile);
    }

    @Override
    public void downloadDirectory(String remoteLocation, File localDirectory) throws IOException {
        FileUtils.copyDirectory((File)new File(remoteLocation), (File)localDirectory);
    }

    @Override
    public void uploadFile(File localFile, String remoteLocation) throws IOException {
        FileUtils.copyFile((File)localFile, (File)new File(remoteLocation));
    }

    @Override
    public void uploadDirectory(File localDirectory, String remoteLocation) throws IOException {
        FileUtils.copyDirectory((File)localDirectory, (File)new File(remoteLocation));
    }
}

