/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function.internal;

import com.fasterxml.jackson.databind.ObjectWriter;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.ShortTextTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.workflow.execution.SynchronousWorkflowExecutionService;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunction;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionException;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionInputs;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionResult;
import de.rcenvironment.core.workflow.execution.function.internal.FileUtils;
import de.rcenvironment.core.workflow.execution.function.internal.WorkflowEditor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.LogFactory;

class WorkflowFunctionImpl
implements WorkflowFunction {
    private WorkflowDescription workflowDescription;
    private EndpointAdapters endpointAdapters;
    private ComponentContext componentContext;
    private LogicalNodeId idOfStartingNode;
    private String workflowExecutionName;
    private WorkflowEditor.Factory workflowEditorFactory = new WorkflowEditor.Factory();
    private TypedDatumSerializer typedDatumSerializer;
    private ComponentDataManagementService componentDataManagementService;
    private SynchronousWorkflowExecutionService synchronousWorkflowExecutionService;
    private FileUtils fileUtils;

    WorkflowFunctionImpl() {
    }

    @Override
    public WorkflowFunctionResult execute(WorkflowFunctionInputs inputs) throws WorkflowFunctionException {
        File inputDirectory = this.createInputDirectory();
        this.logCreationOfInputDirectory(inputDirectory);
        File outputDirectory = this.createOutputDirectory();
        this.logCreationOfOutputDirectory(outputDirectory);
        this.workflowEditorFactory.setInputDirectory(inputDirectory).setOutputDirectory(outputDirectory);
        WorkflowDescription augmentedWorkflowDescription = this.augmentWorkflowWithEndpointAdapterComponents();
        this.writeWorkflowInputsToFile(inputDirectory, inputs);
        boolean workflowExecutionSucceeded = this.executeWorkflow(augmentedWorkflowDescription);
        if (!workflowExecutionSucceeded) {
            return WorkflowFunctionResult.buildFailure();
        }
        return this.createWorkflowFunctionResultFromOutput(outputDirectory);
    }

    private WorkflowFunctionResult createWorkflowFunctionResultFromOutput(File outputDirectory) throws WorkflowFunctionException {
        if (!this.endpointAdapters.containsOutputAdapters()) {
            return WorkflowFunctionResult.successBuilder().build();
        }
        Map<String, String> outputValueMap = this.readOutputValueMap(outputDirectory);
        LogFactory.getLog(this.getClass()).debug((Object)StringUtils.format((String)"Read output values '%s'", (Object[])new Object[]{outputValueMap}));
        return this.createWorkflowFunctionResultFromOutputMap(outputValueMap);
    }

    private boolean executeWorkflow(WorkflowDescription augmentedWorkflowDescription) throws WorkflowFunctionException {
        boolean workflowExecutionSucceeded;
        WorkflowExecutionContext workflowExecutionContext = new WorkflowExecutionContextBuilder(augmentedWorkflowDescription).setInstanceName(this.workflowExecutionName).setNodeIdentifierStartedExecution(this.idOfStartingNode).build();
        try {
            workflowExecutionSucceeded = this.synchronousWorkflowExecutionService.executeWorkflow(workflowExecutionContext);
        }
        catch (ComponentException e) {
            throw new WorkflowFunctionException("Could not execute underlying workflow synchronously", e);
        }
        return workflowExecutionSucceeded;
    }

    private WorkflowFunctionResult createWorkflowFunctionResultFromOutputMap(Map<String, String> outputValueMap) throws WorkflowFunctionException {
        WorkflowFunctionResult.Builder resultBuilder = WorkflowFunctionResult.successBuilder();
        for (Map.Entry<String, String> output : outputValueMap.entrySet()) {
            DataType outputDataType = this.endpointAdapters.getByExternalEndpointName(output.getKey()).getDataType();
            TypedDatum replacementDatum = outputDataType.equals((Object)DataType.FileReference) ? this.copyOutputfileIntoLocalDataManagement(output.getValue()) : (outputDataType.equals((Object)DataType.DirectoryReference) ? this.copyOutputDirectoryIntoLocalDataManagement(resultBuilder, output) : this.typedDatumSerializer.deserialize(output.getValue().toString()));
            resultBuilder.addResult(output.getKey(), replacementDatum);
        }
        WorkflowFunctionResult result = resultBuilder.build();
        return result;
    }

    private TypedDatum copyOutputDirectoryIntoLocalDataManagement(WorkflowFunctionResult.Builder resultBuilder, Map.Entry<String, String> output) throws WorkflowFunctionException {
        ShortTextTD directoryPath = (ShortTextTD)this.typedDatumSerializer.deserialize(output.getValue());
        try {
            File dirToLoad = new File(directoryPath.getShortTextValue());
            DirectoryReferenceTD replacementDatum = this.componentDataManagementService.createDirectoryReferenceTDFromLocalDirectory(this.componentContext, dirToLoad, dirToLoad.getName());
            LogFactory.getLog(this.getClass()).info((Object)StringUtils.format((String)"Read directory at '%s' into datamanagement", (Object[])new Object[]{dirToLoad.getAbsolutePath()}));
            return replacementDatum;
        }
        catch (IOException e) {
            throw new WorkflowFunctionException("Could not store directory into local data management", e);
        }
    }

    private TypedDatum copyOutputfileIntoLocalDataManagement(String path) throws WorkflowFunctionException {
        ShortTextTD filePath = (ShortTextTD)this.typedDatumSerializer.deserialize(path);
        try {
            File fileToLoad = new File(filePath.getShortTextValue());
            FileReferenceTD replacementDatum = this.componentDataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, fileToLoad, fileToLoad.getName());
            LogFactory.getLog(this.getClass()).info((Object)StringUtils.format((String)"Read file at '%s' into datamanagement", (Object[])new Object[]{fileToLoad.getAbsolutePath()}));
            return replacementDatum;
        }
        catch (IOException e) {
            throw new WorkflowFunctionException("Could not store file into local data management", e);
        }
    }

    protected Map<String, String> readOutputValueMap(File outputDirectory) throws WorkflowFunctionException {
        Map outputValueMap;
        File outputConfiguration = this.fileUtils.createFile(outputDirectory, "outputs.json");
        try {
            outputValueMap = (Map)this.fileUtils.getObjectMapper().readValue(outputConfiguration, Map.class);
        }
        catch (IOException e) {
            throw new WorkflowFunctionException(StringUtils.format((String)"Could not read output values from file '%s'", (Object[])new Object[]{outputConfiguration}), e);
        }
        return outputValueMap;
    }

    protected WorkflowDescription augmentWorkflowWithEndpointAdapterComponents() {
        WorkflowEditor editor = this.workflowEditorFactory.buildFromWorkflowDescription(this.workflowDescription);
        for (EndpointAdapter endpointAdapterDefinition : this.endpointAdapters) {
            if (endpointAdapterDefinition.isInputAdapter()) {
                editor.addInputAdapter(endpointAdapterDefinition);
                continue;
            }
            if (!endpointAdapterDefinition.isOutputAdapter()) continue;
            editor.addOutputAdapter(endpointAdapterDefinition);
        }
        return editor.getResult();
    }

    protected File createOutputDirectory() throws WorkflowFunctionException {
        File outputDirectory;
        try {
            outputDirectory = this.fileUtils.createTempDir("outputdirectory");
        }
        catch (IOException e) {
            throw new WorkflowFunctionException("Could not create temporary output directory", e);
        }
        return outputDirectory;
    }

    protected File createInputDirectory() throws WorkflowFunctionException {
        File inputDirectory;
        try {
            inputDirectory = this.fileUtils.createTempDir("inputdirectory");
        }
        catch (IOException e) {
            throw new WorkflowFunctionException("Could not create temporary input directory", e);
        }
        return inputDirectory;
    }

    protected void writeWorkflowInputsToFile(File inputDirectory, WorkflowFunctionInputs inputs) throws WorkflowFunctionException {
        HashMap<String, String> inputsMap = new HashMap<String, String>();
        for (String inputName : inputs.getInputNames()) {
            inputsMap.put(inputName, this.typedDatumSerializer.serialize(inputs.getValueByName(inputName)));
        }
        File inputsFile = this.createInputsFile(inputDirectory);
        ObjectWriter writer = this.fileUtils.getObjectWriter();
        try {
            writer.writeValue(inputsFile, inputsMap);
        }
        catch (IOException e) {
            throw new WorkflowFunctionException("Could not write inputs file", e);
        }
    }

    protected File createInputsFile(File inputDirectory) {
        return this.fileUtils.createFile(inputDirectory, "inputs.json");
    }

    protected void logCreationOfInputDirectory(File inputDirectory) {
        LogFactory.getLog(this.getClass()).debug((Object)StringUtils.format((String)"Created temporary inputs directory at '%s'", (Object[])new Object[]{inputDirectory.getAbsolutePath()}));
    }

    protected void logCreationOfOutputDirectory(File outputDirectory) {
        LogFactory.getLog(this.getClass()).debug((Object)StringUtils.format((String)"Created temporary outputs directory at '%s'", (Object[])new Object[]{outputDirectory.getAbsolutePath()}));
    }

    public static class Builder
    implements WorkflowFunction.Builder {
        private final WorkflowFunctionImpl product = new WorkflowFunctionImpl();
        private String internalName;
        private String externalName;
        private String callingWorkflowName;

        @Override
        public Builder withWorkflowDescription(WorkflowDescription descriptionParam) {
            this.product.workflowDescription = descriptionParam;
            return this;
        }

        @Override
        public Builder withEndpointAdapters(EndpointAdapters endpointAdapterDefinitionsMap) {
            this.product.endpointAdapters = endpointAdapterDefinitionsMap;
            return this;
        }

        @Override
        public Builder withInternalName(String internalNameParam) {
            this.internalName = internalNameParam;
            return this;
        }

        @Override
        public Builder withExternalName(String externalNameParam) {
            this.externalName = externalNameParam;
            return this;
        }

        @Override
        public Builder withCallingWorkflowName(String callingWorkflowNameParam) {
            this.callingWorkflowName = callingWorkflowNameParam;
            return this;
        }

        @Override
        public Builder setComponentContext(ComponentContext context) {
            this.product.componentContext = context;
            return this;
        }

        public Builder bindComponentDataManagementService(ComponentDataManagementService service) {
            this.product.componentDataManagementService = service;
            return this;
        }

        public Builder bindPlatformService(PlatformService service) {
            this.product.idOfStartingNode = service.getLocalDefaultLogicalNodeId();
            return this;
        }

        public Builder bindTypedDatumSerializer(TypedDatumSerializer serializer) {
            this.product.typedDatumSerializer = serializer;
            return this;
        }

        public Builder bindWorkflowExecutionService(SynchronousWorkflowExecutionService service) {
            this.product.synchronousWorkflowExecutionService = service;
            return this;
        }

        public Builder bindFileUtils(FileUtils utils) {
            this.product.fileUtils = utils;
            return this;
        }

        @Override
        public WorkflowFunction build() {
            Objects.requireNonNull(this.product.workflowDescription, "No WorkflowDescription given for construction of WorkflowFunction");
            if (this.product.endpointAdapters == null) {
                this.product.endpointAdapters = new EndpointAdapters.Builder().build();
            }
            this.product.workflowExecutionName = StringUtils.format((String)"%s running as component '%s' of workflow '%s'", (Object[])new Object[]{this.internalName, this.externalName, this.callingWorkflowName});
            return this.product;
        }
    }
}

