/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.ImageCanvas;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImageMergeViewer
extends ContentMergeViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.ImageMergeViewerResources";
    private Object fLeftImage;
    private Object fRightImage;
    private ImageCanvas fAncestor;
    private ImageCanvas fLeft;
    private ImageCanvas fRight;

    public ImageMergeViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(styles, ResourceBundle.getBundle(BUNDLE_NAME), mp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.image_compare_view_context");
        this.buildControl(parent);
        String title = Utilities.getString(this.getResourceBundle(), "title");
        this.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)title);
    }

    @Override
    protected void updateContent(Object ancestor, Object left, Object right) {
        ImageMergeViewer.setInput(this.fAncestor, ancestor);
        this.fLeftImage = left;
        ImageMergeViewer.setInput(this.fLeft, left);
        this.fRightImage = right;
        ImageMergeViewer.setInput(this.fRight, right);
    }

    @Override
    protected byte[] getContents(boolean left) {
        return null;
    }

    @Override
    public void createControls(Composite composite) {
        this.fAncestor = new ImageCanvas(composite, 524288);
        this.fLeft = new ImageCanvas(composite, 524288);
        this.fRight = new ImageCanvas(composite, 524288);
    }

    private static void setInput(ImageCanvas canvas, Object input) {
        if (canvas != null) {
            InputStream stream = null;
            try {
                IStreamContentAccessor sca;
                if (input instanceof IStreamContentAccessor && (sca = (IStreamContentAccessor)input) != null) {
                    try {
                        stream = sca.getContents();
                    }
                    catch (CoreException coreException) {}
                }
                Image image = null;
                Display display = canvas.getDisplay();
                if (stream != null) {
                    try {
                        image = new Image((Device)display, stream);
                    }
                    catch (SWTException sWTException) {}
                }
                canvas.setImage(image);
                if (image != null) {
                    canvas.setBackground(display.getSystemColor(25));
                } else {
                    canvas.setBackground(null);
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.fAncestor.setVisible(true);
            this.fAncestor.setBounds(x, y, width, height);
        } else {
            this.fAncestor.setVisible(false);
        }
    }

    @Override
    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.setBounds(x, y, width1, height);
        this.fRight.setBounds(x + width1 + centerWidth, y, width2, height);
    }

    @Override
    protected void copy(boolean leftToRight) {
        if (leftToRight) {
            this.fRightImage = this.fLeftImage;
            ImageMergeViewer.setInput(this.fRight, this.fRightImage);
            this.setRightDirty(true);
        } else {
            this.fLeftImage = this.fRightImage;
            ImageMergeViewer.setInput(this.fLeft, this.fLeftImage);
            this.setLeftDirty(true);
        }
    }
}

