/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractListBox;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.List;

public class CheckBoxList
extends AbstractListBox {
    private final List<Boolean> itemStatus = new ArrayList<Boolean>();

    public CheckBoxList() {
        this(null);
    }

    public CheckBoxList(TerminalSize preferredSize) {
        super(preferredSize);
    }

    @Override
    public void clearItems() {
        this.itemStatus.clear();
        super.clearItems();
    }

    @Override
    public void addItem(Object object) {
        this.itemStatus.add(Boolean.FALSE);
        super.addItem(object);
    }

    public Boolean isChecked(Object object) {
        if (this.indexOf(object) == -1) {
            return null;
        }
        return this.itemStatus.get(this.indexOf(object));
    }

    public Boolean isChecked(int index) {
        if (index < 0 || index >= this.itemStatus.size()) {
            return null;
        }
        return this.itemStatus.get(index);
    }

    public void setChecked(Object object, boolean checked) {
        if (this.indexOf(object) == -1) {
            return;
        }
        this.itemStatus.set(this.indexOf(object), checked);
    }

    @Override
    protected Interactable.Result unhandledKeyboardEvent(Key key) {
        if (this.getSelectedIndex() == -1) {
            return Interactable.Result.EVENT_NOT_HANDLED;
        }
        if (key.getKind() == Key.Kind.Enter || key.getCharacter() == ' ') {
            if (this.itemStatus.get(this.getSelectedIndex()).booleanValue()) {
                this.itemStatus.set(this.getSelectedIndex(), Boolean.FALSE);
            } else {
                this.itemStatus.set(this.getSelectedIndex(), Boolean.TRUE);
            }
            return Interactable.Result.EVENT_HANDLED;
        }
        return Interactable.Result.EVENT_NOT_HANDLED;
    }

    @Override
    protected int getHotSpotPositionOnLine(int selectedIndex) {
        return 1;
    }

    @Override
    protected String createItemString(int index) {
        String check = " ";
        if (this.itemStatus.get(index).booleanValue()) {
            check = "x";
        }
        String text = this.getItemAt(index).toString();
        return "[" + check + "] " + text;
    }

    @Override
    protected Theme.Definition getListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.TEXTBOX_FOCUSED);
    }

    @Override
    protected Theme.Definition getSelectedListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.TEXTBOX_FOCUSED);
    }
}

