/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cluster.gui.properties;

import de.rcenvironment.components.cluster.common.ClusterComponentConstants;
import de.rcenvironment.components.cluster.gui.properties.Messages;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.incubator.WidgetGroupFactory;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.executor.properties.HostSection;
import de.rcenvironment.core.utils.cluster.ClusterQueuingSystem;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ClusterHostSection
extends HostSection {
    private static final String QSUB = "qsub";
    private static final String QSTAT = "qstat";
    private static final String SHOWQ = "showq";
    private final WorkflowNodePropertySection.Updater updater = this.createUpdater();
    private Combo queuingSystemCombo;
    private Text qsubPathText;
    private Text qstatPathText;
    private Text showqPathText;
    private Label showQPathLabel;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section queuingSystemSection = factory.createSection(parent, 320);
        queuingSystemSection.setText(Messages.configureQueuingSystem);
        Composite queuingSystemParent = factory.createFlatFormComposite((Composite)queuingSystemSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        queuingSystemParent.setLayout((Layout)layout);
        Label queuingSystemLabel = new Label(queuingSystemParent, 0);
        queuingSystemLabel.setText(Messages.queueingSystemLabel);
        GridData gridData = new GridData();
        gridData.widthHint = 220;
        this.queuingSystemCombo = new Combo(queuingSystemParent, 12);
        this.queuingSystemCombo.setLayoutData((Object)gridData);
        ClusterQueuingSystem[] clusterQueuingSystemArray = ClusterQueuingSystem.values();
        int n = clusterQueuingSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterQueuingSystem system = clusterQueuingSystemArray[n2];
            this.queuingSystemCombo.add(system.name());
            ++n2;
        }
        this.qsubPathText = WidgetGroupFactory.addLabelAndTextfieldForPropertyToComposite((Composite)queuingSystemParent, (String)"Path 'qsub' (optional)", (String)"pathToQueuingSystemCommands", (int)220, (int)0).text;
        this.qstatPathText = WidgetGroupFactory.addLabelAndTextfieldForPropertyToComposite((Composite)queuingSystemParent, (String)"Path 'qstat' (optional)", (String)"pathToQueuingSystemCommands", (int)220, (int)0).text;
        WidgetGroupFactory.LabelAndTextForProperty labelAndText = WidgetGroupFactory.addLabelAndTextfieldForPropertyToComposite((Composite)queuingSystemParent, (String)"Path 'showq' (optional)", (String)"pathToQueuingSystemCommands", (int)220, (int)0);
        this.showQPathLabel = labelAndText.label;
        this.showqPathText = labelAndText.text;
        this.queuingSystemCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ClusterHostSection.this.setProperty("queuingSystem", ClusterHostSection.this.queuingSystemCombo.getItem(ClusterHostSection.this.queuingSystemCombo.getSelectionIndex()));
                ClusterHostSection.this.enableShowqWidgets(ClusterHostSection.this.queuingSystemCombo.getSelectionIndex() == 1);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        queuingSystemSection.setClient((Control)queuingSystemParent);
    }

    private void enableShowqWidgets(boolean enable) {
        this.showQPathLabel.setEnabled(enable);
        this.showqPathText.setEnabled(enable);
    }

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        this.queuingSystemCombo.select(this.queuingSystemCombo.indexOf(this.getProperty("queuingSystem")));
        this.enableShowqWidgets(this.queuingSystemCombo.getSelectionIndex() == 1);
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new PropertyController();
    }

    protected WorkflowNodePropertySection.Updater createUpdater() {
        return new PropertyUpdater();
    }

    protected WorkflowNodePropertySection.Synchronizer createSynchronizer() {
        return new PropertySynchronizer();
    }

    private class PropertyController
    extends WorkflowNodePropertySection.DefaultController {
        private PropertyController() {
            super((WorkflowNodePropertySection)ClusterHostSection.this);
        }

        public void modifyText(ModifyEvent event) {
            Object source = event.getSource();
            if (source == ClusterHostSection.this.qsubPathText) {
                this.controls(ClusterHostSection.this.qsubPathText, ClusterHostSection.QSUB);
            } else if (source == ClusterHostSection.this.qstatPathText) {
                this.controls(ClusterHostSection.this.qstatPathText, ClusterHostSection.QSTAT);
            } else if (source == ClusterHostSection.this.showqPathText) {
                this.controls(ClusterHostSection.this.showqPathText, ClusterHostSection.SHOWQ);
            } else {
                super.modifyText(event);
            }
        }

        private void controls(Text text, String command) {
            String oldProp = this.getProperty("pathToQueuingSystemCommands");
            Map paths = ClusterComponentConstants.extractPathsToQueuingSystemCommands((String)oldProp);
            String textContent = text.getText();
            if (!textContent.equals(paths.get(command))) {
                if (this.editCommand == null || !this.editCommand.isEditable()) {
                    this.editCommand = this.editProperty("pathToQueuingSystemCommands");
                }
                if (textContent.isEmpty()) {
                    paths.remove(command);
                } else {
                    if (!textContent.endsWith("/")) {
                        textContent = String.valueOf(textContent) + "/";
                    }
                    paths.put(command, textContent);
                }
                this.editCommand.setNewValue(ClusterComponentConstants.getCommandsPathsAsPropertyString((Map)paths));
            }
        }
    }

    private class PropertySynchronizer
    extends WorkflowNodePropertySection.DefaultSynchronizer {
        private PropertySynchronizer() {
            super((WorkflowNodePropertySection)ClusterHostSection.this);
        }

        protected void handlePropertyChange(Control control, String key, String newValue, String oldValue) {
            ClusterHostSection.this.updater.updateControl(control, key, newValue, oldValue);
        }
    }

    protected class PropertyUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected PropertyUpdater() {
            super((WorkflowNodePropertySection)ClusterHostSection.this);
        }

        public void initializeControl(Control control, String propertyName, String value) {
            this.updateControl(control, propertyName, value, null);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            if (newValue != oldValue && propertyName.equals("pathToQueuingSystemCommands")) {
                Map paths = ClusterComponentConstants.extractPathsToQueuingSystemCommands((String)newValue);
                if (paths.containsKey(ClusterHostSection.QSUB) && !ClusterHostSection.this.qsubPathText.getText().equals(paths.get(ClusterHostSection.QSUB))) {
                    ClusterHostSection.this.qsubPathText.setText(this.valueOrDefault((String)paths.get(ClusterHostSection.QSUB), ""));
                }
                if (paths.containsKey(ClusterHostSection.QSTAT) && !ClusterHostSection.this.qstatPathText.getText().equals(paths.get(ClusterHostSection.QSTAT))) {
                    ClusterHostSection.this.qstatPathText.setText(this.valueOrDefault((String)paths.get(ClusterHostSection.QSTAT), ""));
                }
                if (paths.containsKey(ClusterHostSection.SHOWQ) && !ClusterHostSection.this.showqPathText.getText().equals(paths.get(ClusterHostSection.SHOWQ))) {
                    ClusterHostSection.this.showqPathText.setText(this.valueOrDefault((String)paths.get(ClusterHostSection.SHOWQ), ""));
                }
            } else {
                super.updateControl(control, propertyName, newValue, oldValue);
            }
        }
    }
}

