/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette;

import de.rcenvironment.core.component.api.ComponentGroupPathRules;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupNameValidator {
    protected static final Pattern GROUP_NAME_VALID_CHARACTERS_REGEXP = Pattern.compile("[^a-zA-Z0-9 _\\.,\\-\\+\\(\\)]");
    protected static final String INVALID_GROUP_NAME_CHARSET_ERROR_MESSAGE = "Invalid character at position %d (\"%s\") - only characters a-z, A-Z, digits, spaces, and _.,-+() are allowed.";
    protected static final Pattern VALID_GROUP_NAME_LAST_CHARACTER_REGEXP = Pattern.compile(".*[^ ]$");
    protected static final String VALID_GROUP_NAME_LAST_CHARACTER_ERROR_MESSAGE = "Spaces are allowed, but cannot be the last character.";
    private List<PaletteTreeNode> currentGroups;
    private boolean isTopLevelGroup;

    public GroupNameValidator(List<PaletteTreeNode> currentGroups, boolean isTopLevelGroup) {
        this.currentGroups = currentGroups;
        this.isTopLevelGroup = isTopLevelGroup;
    }

    public Optional<String> valdiateText(String text) {
        Optional commonValidationError = ComponentGroupPathRules.validateCommonRules((String)text);
        if (commonValidationError.isPresent()) {
            return commonValidationError;
        }
        Matcher invalidCharMatcher = GROUP_NAME_VALID_CHARACTERS_REGEXP.matcher(text);
        if (invalidCharMatcher.find()) {
            return Optional.of(StringUtils.format((String)INVALID_GROUP_NAME_CHARSET_ERROR_MESSAGE, (Object[])new Object[]{invalidCharMatcher.start(0) + 1, invalidCharMatcher.group(0)}));
        }
        if (!VALID_GROUP_NAME_LAST_CHARACTER_REGEXP.matcher(text).matches()) {
            return Optional.of(VALID_GROUP_NAME_LAST_CHARACTER_ERROR_MESSAGE);
        }
        if (this.isTopLevelGroup && ToolType.getTopLevelGroupNames().contains(text)) {
            return Optional.of(StringUtils.format((String)"The group names '%s' are not allowed as top level groups.", (Object[])new Object[]{String.join((CharSequence)", ", ToolType.getTopLevelGroupNames())}));
        }
        if (this.currentGroups.stream().anyMatch(node -> node.getNodeName().equals(text))) {
            return Optional.of("A group with this name already exists.\nThe group may be empty and therefore not displayed.");
        }
        return Optional.empty();
    }
}

