/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlockWithMetadata;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConfiguration;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConstants;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StreamConnectionEndpoint;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CommonUplinkLowLevelProtocolWrapper {
    private static final int HANDSHAKE_MESSAGE_WAIT_CHECK_INTERVAL = 100;
    protected final StreamConnectionEndpoint connectionEndpoint;
    protected final DataInputStream dataInputStream;
    protected final DataOutputStream dataOutputStream;
    protected final UplinkConnectionLowLevelEventHandler eventHandler;
    protected final ObjectMapper jsonMapper;
    protected final UplinkProtocolMessageConverter messageConverter;
    protected final String logPrefix;
    protected final boolean verboseLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"uplink.lowlevel");
    protected final Log log = LogFactory.getLog(this.getClass());

    public CommonUplinkLowLevelProtocolWrapper(StreamConnectionEndpoint connectionEndpoint, UplinkConnectionLowLevelEventHandler eventHandler, String logIdentity) {
        this.connectionEndpoint = connectionEndpoint;
        this.dataInputStream = new DataInputStream(connectionEndpoint.getInputStream());
        this.dataOutputStream = new DataOutputStream(connectionEndpoint.getOutputStream());
        this.eventHandler = eventHandler;
        this.jsonMapper = JsonUtils.getDefaultObjectMapper();
        this.messageConverter = new UplinkProtocolMessageConverter(logIdentity);
        this.logPrefix = "[" + logIdentity + "] ";
    }

    public void runSession() {
        try {
            this.runHandshakeSequence();
            this.eventHandler.onHandshakeComplete();
            this.runMessageReceiveLoop();
        }
        catch (UplinkConnectionRefusedException e) {
            if (e.shouldAttemptToSendErrorGoodbye()) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Uplink handshake failed or connection refused; attempting to send error message \"" + e.getRawMessage() + "\""));
                this.attemptToSendErrorGoodbyeMessage(e.getType(), e.getRawMessage());
            } else {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Uplink handshake failed or connection refused: " + e.getRawMessage()));
            }
            this.eventHandler.onHandshakeFailedOrConnectionRefused(e);
        }
        this.terminateSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessageBlock(long channelId, MessageBlock messageBlock) throws IOException {
        byte[] data = messageBlock.getData();
        DataOutputStream dataOutputStream = this.dataOutputStream;
        synchronized (dataOutputStream) {
            if (this.verboseLoggingEnabled) {
                this.log.debug((Object)StringUtils.format((String)"%sSending a message of type %s to channel %d, payload size %d bytes", (Object[])new Object[]{this.logPrefix, messageBlock.getType(), channelId, data.length}));
            }
            this.dataOutputStream.writeLong(channelId);
            this.dataOutputStream.writeInt(data.length);
            this.dataOutputStream.writeByte(messageBlock.getType().getCode());
            this.dataOutputStream.write(data);
            this.dataOutputStream.flush();
        }
    }

    public final void sendMessageBlock(long channelId, int type, byte[] data) throws IOException {
        this.sendMessageBlock(channelId, new MessageBlock(type, data));
    }

    protected byte[] readExpectedBytesWithTimeout(int expectedLength, int timeoutMsec, int recheckInterval) throws IOException, TimeoutException {
        byte[] expectedBytes = new byte[expectedLength];
        long startTime = System.currentTimeMillis();
        while (this.dataInputStream.available() < expectedLength) {
            if (System.currentTimeMillis() < startTime + (long)timeoutMsec) {
                try {
                    Thread.sleep(recheckInterval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new ProtocolException("Interrupted while waiting for " + expectedLength + " bytes of data");
                }
            }
            throw new TimeoutException("Expected " + expectedLength + " bytes of data, but did not receive them within " + timeoutMsec + " msec");
        }
        this.dataInputStream.readFully(expectedBytes);
        return expectedBytes;
    }

    protected void sendHandshakeInit() throws IOException {
        byte[] initBytes = "INIT v0 ".getBytes(UplinkProtocolConstants.DEFAULT_CHARSET);
        if (initBytes.length != 8) {
            throw new ProtocolException("Handshake array length does not match the expected byte count");
        }
        this.dataOutputStream.write(initBytes);
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Sent handshake init (" + initBytes.length + " bytes)"));
        }
    }

    protected void expectHandshakeInit() throws IOException, TimeoutException {
        byte[] expectedHandshakeInitBytes = this.readExpectedBytesWithTimeout(8, UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout(), 100);
        String reveivedHeader = new String(expectedHandshakeInitBytes, UplinkProtocolConstants.DEFAULT_CHARSET);
        if (!reveivedHeader.equals("INIT v0 ")) {
            throw new ProtocolException("Received invalid handshake init: " + reveivedHeader);
        }
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received expected handshake init (" + expectedHandshakeInitBytes.length + " bytes)"));
        }
    }

    protected void sendHandshakeData(MessageBlock responseData) throws IOException {
        this.sendMessageBlock(0L, responseData);
        this.dataOutputStream.flush();
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Sent handshake data '" + new String(responseData.getData(), UplinkProtocolConstants.DEFAULT_CHARSET) + "'"));
        }
    }

    protected void sendHandshakeConfirmation() throws IOException {
        this.sendMessageBlock(0L, new MessageBlock(MessageType.HANDSHAKE));
        this.dataOutputStream.flush();
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Sent handshake confirmation"));
        }
    }

    protected MessageBlock expectHandshakeData() throws UplinkConnectionRefusedException, TimeoutException, IOException {
        MessageBlockWithMetadata messageBlock;
        try {
            messageBlock = this.readChannelIdAndMessageBlockWithTimeout(UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout());
        }
        catch (TimeoutException timeoutException) {
            throw new TimeoutException("The remote side did not send their Uplink handshake response within " + UplinkProtocolConfiguration.getCurrent().getHandshakeResponseTimeout() + " msec");
        }
        catch (IOException e) {
            throw new IOException("Error receiving the remote side's handshake response: " + e.getMessage());
        }
        if (messageBlock.getChannelId() != 0L) {
            throw new ProtocolException("Unexpected handshake channel id: " + messageBlock.getChannelId());
        }
        if (messageBlock.getType() == MessageType.GOODBYE) {
            String errorMessage = this.extractGoodbyeErrorMessage(messageBlock, true);
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.typeOfWrappedErrorMessage(errorMessage), UplinkProtocolErrorType.unwrapErrorMessage(errorMessage), false);
        }
        if (messageBlock.getType() != MessageType.HANDSHAKE) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.PROTOCOL_VIOLATION, "Expected handshake data, but received message type " + (Object)((Object)messageBlock.getType()) + " instead", true);
        }
        if (this.verboseLoggingEnabled) {
            if (messageBlock.getDataLength() == 0) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received handshake confirmation"));
            } else {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received handshake data '" + new String(messageBlock.getData(), UplinkProtocolConstants.DEFAULT_CHARSET) + "'"));
            }
        }
        return messageBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MessageBlockWithMetadata readMessageBlock() throws IOException {
        DataInputStream dataInputStream = this.dataInputStream;
        synchronized (dataInputStream) {
            long channelId = this.dataInputStream.readLong();
            int blockSize = this.dataInputStream.readInt();
            if (blockSize < 0 || blockSize > 262144) {
                throw new ProtocolException(StringUtils.format((String)"Incoming message block announced a size of %d (valid range: 0-%d)", (Object[])new Object[]{blockSize, 262144}));
            }
            byte type = this.dataInputStream.readByte();
            byte[] data = new byte[blockSize];
            this.dataInputStream.readFully(data);
            return new MessageBlockWithMetadata(type, data, channelId, MessageBlockPriority.DEFAULT);
        }
    }

    protected final MessageBlockWithMetadata readChannelIdAndMessageBlockWithTimeout(int timeoutMsec) throws IOException, TimeoutException {
        CompletableFuture messageFuture = new CompletableFuture();
        ConcurrencyUtils.getAsyncTaskService().execute("Uplink: Read message block with timeout", () -> {
            try {
                messageFuture.complete(this.readMessageBlock());
            }
            catch (IOException e) {
                messageFuture.completeExceptionally(e);
            }
        });
        try {
            return (MessageBlockWithMetadata)messageFuture.get(timeoutMsec, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted while waiting for an incoming message");
        }
        catch (ExecutionException e) {
            throw new IOException("Error while waiting for an incoming message: " + e.getMessage());
        }
    }

    public final void terminateSession() {
        this.connectionEndpoint.close();
    }

    public final boolean attemptToSendRegularGoodbyeMessage() {
        try {
            this.sendMessageBlock(0L, 127, new byte[0]);
            return true;
        }
        catch (ProtocolException e) {
            throw new RuntimeException("Internal error: Failed to construct shutdown message", e);
        }
        catch (IOException iOException) {
            this.log.debug((Object)"Failed to send regular 'goodbye' message; most likely, the connection has already failed");
            return false;
        }
    }

    public final void attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType type, String rawMessage) {
        String wrappedMessage = type.wrapErrorMessage(rawMessage);
        try {
            this.sendMessageBlock(0L, this.messageConverter.encodeErrorGoodbyeMessage(wrappedMessage));
        }
        catch (IOException e) {
            this.log.debug((Object)StringUtils.format((String)"%sFailed to send a 'goodbye' error message; this is often a best-effort attempt, so this can typically be ignored (message body: %s; error while sending: %s)", (Object[])new Object[]{this.logPrefix, wrappedMessage, e.toString()}));
        }
    }

    protected abstract void runHandshakeSequence() throws UplinkConnectionRefusedException;

    protected final void runMessageReceiveLoop() {
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)(String.valueOf(this.logPrefix) + "Running message dispatch loop"));
        }
        boolean expectingFurtherMessages = true;
        while (true) {
            try {
                while (true) {
                    if (this.receiveNextMessage()) {
                        continue;
                    }
                    expectingFurtherMessages = false;
                }
            }
            catch (IOException e) {
                boolean exceptionMatchesClosedConnection;
                boolean bl = exceptionMatchesClosedConnection = e instanceof EOFException || e instanceof SocketException;
                if (exceptionMatchesClosedConnection) {
                    if (e.getClass() != EOFException.class && e.getMessage() == null) {
                        this.log.debug((Object)StringUtils.format((String)"%sCategorizing stream read exception as 'end of stream' event: %s", (Object[])new Object[]{this.logPrefix, e.toString()}));
                    }
                    this.eventHandler.onIncomingStreamClosedOrEOF();
                } else {
                    if (expectingFurtherMessages) {
                        String errorMarker = LogUtils.logExceptionAsSingleLineAndAssignUniqueMarker((Log)this.log, (String)(String.valueOf(this.logPrefix) + "Error while receiving a message, closing the connection"), (Throwable)e);
                        this.eventHandler.onStreamReadError(e);
                        this.attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType.INTERNAL_SERVER_ERROR, "Closing the connection after an error (internal error log marker " + errorMarker + ")");
                        continue;
                    }
                    this.log.error((Object)(String.valueOf(this.logPrefix) + "Not expecting further messages, but encountered a non-EOF exception; " + "still considering the stream as closed/broken as a fallback: " + e.toString()));
                    this.eventHandler.onIncomingStreamClosedOrEOF();
                }
                return;
            }
            break;
        }
    }

    private boolean receiveNextMessage() throws IOException {
        MessageBlockWithMetadata message = this.readMessageBlock();
        long channelId = message.getChannelId();
        if (message.getType() == MessageType.GOODBYE) {
            if (message.getDataLength() == 0) {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received regular 'goodbye' message, expecting end of stream next"));
                this.eventHandler.onRegularGoodbyeMessage();
            } else {
                this.log.debug((Object)(String.valueOf(this.logPrefix) + "Received error 'goodbye' message, expecting end of stream next"));
                String errorMessage = this.extractGoodbyeErrorMessage(message, false);
                this.eventHandler.onErrorGoodbyeMessage(UplinkProtocolErrorType.typeOfWrappedErrorMessage(errorMessage), UplinkProtocolErrorType.unwrapErrorMessage(errorMessage));
            }
            return false;
        }
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)StringUtils.format((String)"%sReceived message of type %s for channel %d, payload size %d bytes", (Object[])new Object[]{this.logPrefix, message.getType(), channelId, message.getDataLength()}));
        }
        this.eventHandler.onMessageBlock(channelId, message);
        return true;
    }

    private String extractGoodbyeErrorMessage(MessageBlock message, boolean replaceEmptyOrMissingMessage) {
        String errorMessage;
        if (message.getDataLength() == 0 && replaceEmptyOrMissingMessage) {
            return "E99: <no error message available>";
        }
        try {
            errorMessage = new String(message.getData());
        }
        catch (RuntimeException runtimeException) {
            errorMessage = "Failed to decode the error string attached to a 'goodbye' message; byte length: " + message.getDataLength();
        }
        return errorMessage;
    }
}

